/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.ConcurrentSkipListMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.http.annotations.JUnitHttpServer;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.poller.Parameter;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.mock.MockMonitoredService;
import org.opennms.netmgt.poller.mock.MonitorTestUtils;
import org.opennms.netmgt.poller.monitors.TcpMonitor;
import org.opennms.netmgt.utils.DnsUtils;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.opennms.test.mock.MockUtil;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/emptyContext.xml"})
@JUnitConfigurationEnvironment
public class TcpMonitorTest {
    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
    }

    @Test
    public void testExternalServerConnection() throws UnknownHostException {
        ConcurrentSkipListMap<String, String> m = new ConcurrentSkipListMap<String, String>();
        Parameter p = new Parameter();
        TcpMonitor monitor = new TcpMonitor();
        MockMonitoredService svc = MonitorTestUtils.getMonitoredService((int)99, (String)"www.opennms.org", (InetAddress)DnsUtils.resolveHostname((String)"www.opennms.org"), (String)"TCP");
        p.setKey("port");
        p.setValue("3020");
        m.put(p.getKey(), p.getValue());
        p.setKey("retry");
        p.setValue("1");
        m.put(p.getKey(), p.getValue());
        p.setKey("timeout");
        p.setValue("500");
        m.put(p.getKey(), p.getValue());
        PollStatus status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)2L, (long)status.getStatusCode());
        Assert.assertNotNull((Object)status.getReason());
    }

    @Test
    @JUnitHttpServer(port=10342)
    public void testLocalhostConnection() throws UnknownHostException {
        ConcurrentSkipListMap<String, String> m = new ConcurrentSkipListMap<String, String>();
        Parameter p = new Parameter();
        TcpMonitor monitor = new TcpMonitor();
        MockMonitoredService svc = MonitorTestUtils.getMonitoredService((int)3, (String)"localhost", (InetAddress)DnsUtils.resolveHostname((String)"localhost"), (String)"TCP");
        p.setKey("port");
        p.setValue("10342");
        m.put(p.getKey(), p.getValue());
        p.setKey("retry");
        p.setValue("1");
        m.put(p.getKey(), p.getValue());
        p.setKey("timeout");
        p.setValue("500");
        m.put(p.getKey(), p.getValue());
        PollStatus status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)1L, (long)status.getStatusCode());
        Assert.assertNull((Object)status.getReason());
    }

    @Test
    @JUnitHttpServer(port=10342)
    public void testLocalhostIPv6Connection() throws UnknownHostException {
        if (Boolean.getBoolean("skipIpv6Tests")) {
            return;
        }
        ConcurrentSkipListMap<String, String> m = new ConcurrentSkipListMap<String, String>();
        Parameter p = new Parameter();
        TcpMonitor monitor = new TcpMonitor();
        MockMonitoredService svc = MonitorTestUtils.getMonitoredService((int)3, (String)"::1", (InetAddress)InetAddressUtils.addr((String)"::1"), (String)"TCP");
        p.setKey("port");
        p.setValue("10342");
        m.put(p.getKey(), p.getValue());
        p.setKey("retry");
        p.setValue("1");
        m.put(p.getKey(), p.getValue());
        p.setKey("timeout");
        p.setValue("500");
        m.put(p.getKey(), p.getValue());
        PollStatus status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)1L, (long)status.getStatusCode());
        Assert.assertNull((Object)status.getReason());
    }
}

