/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.regex.PatternSyntaxException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.mock.MockMonitoredService;
import org.opennms.netmgt.poller.monitors.SshMonitor;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/emptyContext.xml"})
@JUnitConfigurationEnvironment
public class SshMonitorTest {
    @Test
    public void testPoll() throws UnknownHostException {
        SshMonitor sm = new SshMonitor();
        MockMonitoredService svc = new MockMonitoredService(1, "Router", InetAddressUtils.addr((String)"127.0.0.1"), "SSH");
        HashMap parms = new HashMap();
        PollStatus ps = sm.poll((MonitoredService)svc, parms);
        Assert.assertTrue((boolean)ps.isUp());
        Assert.assertFalse((boolean)ps.isDown());
    }

    @Test
    public void testPollWithMatch() throws UnknownHostException {
        SshMonitor sm = new SshMonitor();
        MockMonitoredService svc = new MockMonitoredService(1, "Router", InetAddressUtils.addr((String)"127.0.0.1"), "SSH");
        HashMap<String, String> parms = new HashMap<String, String>();
        parms.put("match", "SSH");
        PollStatus ps = sm.poll((MonitoredService)svc, parms);
        Assert.assertTrue((boolean)ps.isUp());
        Assert.assertFalse((boolean)ps.isDown());
    }

    @Test
    public void testPollWithStarBanner() throws UnknownHostException {
        SshMonitor sm = new SshMonitor();
        MockMonitoredService svc = new MockMonitoredService(1, "Router", InetAddressUtils.addr((String)"127.0.0.1"), "SSH");
        HashMap<String, String> parms = new HashMap<String, String>();
        parms.put("banner", "*");
        PollStatus ps = sm.poll((MonitoredService)svc, parms);
        Assert.assertTrue((boolean)ps.isUp());
        Assert.assertFalse((boolean)ps.isDown());
    }

    @Test
    public void testPollWithRegexpBanner() throws UnknownHostException {
        SshMonitor sm = new SshMonitor();
        MockMonitoredService svc = new MockMonitoredService(1, "Router", InetAddressUtils.addr((String)"127.0.0.1"), "SSH");
        HashMap<String, String> parms = new HashMap<String, String>();
        parms.put("banner", "^SSH");
        PollStatus ps = sm.poll((MonitoredService)svc, parms);
        Assert.assertTrue((boolean)ps.isUp());
        Assert.assertFalse((boolean)ps.isDown());
    }

    @Test
    public void testPollWithBannerOpenSSH() throws UnknownHostException {
        SshMonitor sm = new SshMonitor();
        MockMonitoredService svc = new MockMonitoredService(1, "Router", InetAddressUtils.addr((String)"127.0.0.1"), "SSH");
        HashMap<String, String> parms = new HashMap<String, String>();
        parms.put("banner", "OpenSSH");
        PollStatus ps = sm.poll((MonitoredService)svc, parms);
        Assert.assertTrue((boolean)ps.isUp());
        Assert.assertFalse((boolean)ps.isDown());
    }

    @Test
    public void testPollWithBannerMissing() throws UnknownHostException {
        SshMonitor sm = new SshMonitor();
        MockMonitoredService svc = new MockMonitoredService(1, "Router", InetAddressUtils.addr((String)"127.0.0.1"), "SSH");
        HashMap<String, String> parms = new HashMap<String, String>();
        parms.put("banner", "OpenNMS");
        PollStatus ps = sm.poll((MonitoredService)svc, parms);
        Assert.assertTrue((boolean)ps.isDown());
        Assert.assertFalse((boolean)ps.isUp());
    }

    @Test
    public void testPollWithBannerOpenSSHRegexp() throws UnknownHostException {
        SshMonitor sm = new SshMonitor();
        MockMonitoredService svc = new MockMonitoredService(1, "Router", InetAddressUtils.addr((String)"127.0.0.1"), "SSH");
        HashMap<String, String> parms = new HashMap<String, String>();
        parms.put("banner", "^SSH\\-2\\.0\\-OpenSSH_\\d+\\.\\d+.*$");
        PollStatus ps = sm.poll((MonitoredService)svc, parms);
        Assert.assertTrue((boolean)ps.isUp());
        Assert.assertFalse((boolean)ps.isDown());
    }

    @Test
    public void testPollWithInvalidRegexpBanner() throws UnknownHostException, PatternSyntaxException {
        SshMonitor sm = new SshMonitor();
        MockMonitoredService svc = new MockMonitoredService(1, "Router", InetAddressUtils.addr((String)"127.0.0.1"), "SSH");
        HashMap<String, String> parms = new HashMap<String, String>();
        parms.put("banner", "^SSH\\-2\\.0\\-OpenSSH_\\d+\\.\\d+\\g$");
        PollStatus ps = sm.poll((MonitoredService)svc, parms);
        Assert.assertTrue((boolean)ps.isUnavailable());
    }

    @Test
    public void testPollWithInvalidRegexpMatch() throws UnknownHostException, PatternSyntaxException {
        SshMonitor sm = new SshMonitor();
        MockMonitoredService svc = new MockMonitoredService(1, "Router", InetAddressUtils.addr((String)"127.0.0.1"), "SSH");
        HashMap<String, String> parms = new HashMap<String, String>();
        parms.put("banner", "^SSH\\-2\\.0\\-OpenSSH_\\d+\\.\\d+\\g$");
        PollStatus ps = sm.poll((MonitoredService)svc, parms);
        Assert.assertTrue((boolean)ps.isUnavailable());
    }

    @Test
    public void testPollWithInvalidHost() throws UnknownHostException {
        SshMonitor sm = new SshMonitor();
        MockMonitoredService svc = new MockMonitoredService(1, "Router", InetAddressUtils.UNPINGABLE_ADDRESS, "SSH");
        HashMap parms = new HashMap();
        PollStatus ps = sm.poll((MonitoredService)svc, parms);
        Assert.assertTrue((boolean)ps.isUnavailable());
    }

    @Test
    public void testPollWithNoIpAddress() throws UnknownHostException {
        SshMonitor sm = new SshMonitor();
        MockMonitoredService svc = new MockMonitoredService(1, "Router", null, "SSH");
        HashMap<String, String> parms = new HashMap<String, String>();
        parms.put("banner", "OpenNMS");
        PollStatus ps = sm.poll((MonitoredService)svc, parms);
        Assert.assertTrue((boolean)ps.isDown());
        Assert.assertFalse((boolean)ps.isUp());
    }
}

