/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.mock.MockMonitoredService;
import org.opennms.netmgt.poller.monitors.NetScalerGroupHealthMonitor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-proxy-snmp.xml"})
@JUnitSnmpAgent(port=9161, host="127.0.0.1", resource="classpath:org/opennms/netmgt/snmp/netscaler-health.properties")
public class NetScalerGroupHealthMonitorTest
implements InitializingBean {
    static final int TEST_SNMP_PORT = 9161;
    static final String TEST_IP_ADDRESS = "127.0.0.1";
    @Autowired
    private SnmpPeerFactory m_snmpPeerFactory;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
        SnmpPeerFactory.setInstance((SnmpPeerFactory)this.m_snmpPeerFactory);
    }

    @After
    public void tearDown() throws Exception {
        MockLogAppender.assertNoWarningsOrGreater();
    }

    @Test
    public void testAvailable() throws Exception {
        NetScalerGroupHealthMonitor monitor = new NetScalerGroupHealthMonitor();
        PollStatus status = monitor.poll(this.createMonitor(), this.createBasicParams());
        Assert.assertTrue((boolean)status.isAvailable());
    }

    @Test
    public void testUnavailable() throws Exception {
        NetScalerGroupHealthMonitor monitor = new NetScalerGroupHealthMonitor();
        Map<String, Object> parameters = this.createBasicParams();
        parameters.put("group-health", 70);
        PollStatus status = monitor.poll(this.createMonitor(), parameters);
        Assert.assertFalse((boolean)status.isAvailable());
    }

    private Map<String, Object> createBasicParams() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("group-name", "p_d_wf-iis_http_s_grp");
        return parameters;
    }

    private MonitoredService createMonitor() throws UnknownHostException {
        MockMonitoredService svc = new MockMonitoredService(1, "test-server", InetAddressUtils.getInetAddress((String)TEST_IP_ADDRESS), "NetScaler-TEST");
        return svc;
    }
}

