/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Service;
import org.opennms.netmgt.dao.mock.EventAnticipator;
import org.opennms.netmgt.dao.mock.MockEventIpcManager;
import org.opennms.netmgt.mock.IfKey;
import org.opennms.netmgt.mock.MockContainer;
import org.opennms.netmgt.mock.MockElement;
import org.opennms.netmgt.mock.MockEventUtil;
import org.opennms.netmgt.mock.MockInterface;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.mock.MockNode;
import org.opennms.netmgt.mock.MockPollerConfig;
import org.opennms.netmgt.mock.MockQueryManager;
import org.opennms.netmgt.mock.MockService;
import org.opennms.netmgt.mock.MockVisitor;
import org.opennms.netmgt.mock.MockVisitorAdapter;
import org.opennms.netmgt.mock.PollAnticipator;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.model.events.EventUtils;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.poller.mock.MockMonitoredService;
import org.opennms.netmgt.xml.event.Event;

public class MockNetworkTest
extends TestCase {
    private StatusChecker m_downChecker;
    private MockNetwork m_network;
    private StatusChecker m_upChecker;
    private MockPollerConfig m_pollerConfig;
    private MockEventIpcManager m_eventMgr;

    private void anticipateServiceEvents(final EventAnticipator anticipator, MockElement element, final String uei) {
        MockVisitorAdapter eventSetter = new MockVisitorAdapter(){

            public void visitService(MockService svc) {
                Event event = MockEventUtil.createServiceEvent((String)"Test", (String)uei, (MockService)svc, null);
                anticipator.anticipateEvent(event);
            }
        };
        element.visit((MockVisitor)eventSetter);
    }

    protected void setUp() throws Exception {
        this.m_network = new MockNetwork();
        this.m_network.setCriticalService("ICMP");
        this.m_network.addNode(1, "Router");
        this.m_network.addInterface("192.168.1.1");
        this.m_network.addService("ICMP");
        this.m_network.addService("SMTP");
        this.m_network.addInterface("192.168.1.2");
        this.m_network.addService("ICMP");
        this.m_network.addService("SMTP");
        this.m_network.addNode(2, "Server");
        this.m_network.addInterface("192.168.1.3");
        this.m_network.addService("ICMP");
        this.m_network.addService("HTTP");
        this.m_network.addInterface("192.168.1.2");
        this.m_network.addNode(3, "IPv6Server");
        this.m_network.addInterface("fe80:0000:0000:0000:0000:0000:0000:00ff");
        this.m_network.addService("ICMP");
        this.m_network.addService("HTTP");
        this.m_network.addService("DNS");
        this.m_eventMgr = new MockEventIpcManager();
        this.m_pollerConfig = new MockPollerConfig(this.m_network);
        this.m_pollerConfig.addPackage("TestPackage");
        this.m_pollerConfig.addDowntime(1000L, 0L, -1L, false);
        this.m_pollerConfig.setDefaultPollInterval(1000L);
        this.m_pollerConfig.populatePackage(this.m_network);
        this.m_pollerConfig.setPollInterval("ICMP", 500L);
        this.m_upChecker = new StatusChecker(PollStatus.up());
        this.m_downChecker = new StatusChecker(PollStatus.down());
    }

    protected void tearDown() throws Exception {
    }

    public void testCreateInterfaces() {
        MockNode router = this.m_network.getNode(1);
        MockInterface iface = this.m_network.getInterface(1, "192.168.1.1");
        MockNetworkTest.assertEquals((String)"192.168.1.1", (String)iface.getIpAddr());
        MockNetworkTest.assertEquals((Object)router, (Object)iface.getNode());
        MockInterface iface2 = this.m_network.getInterface(1, "192.168.1.2");
        MockNetworkTest.assertEquals((String)"192.168.1.2", (String)iface2.getIpAddr());
        MockNetworkTest.assertEquals((Object)router, (Object)iface2.getNode());
        MockNode server = this.m_network.getNode(2);
        MockInterface iface3 = this.m_network.getInterface(2, "192.168.1.3");
        MockNetworkTest.assertEquals((int)server.getNodeId(), (int)iface3.getNode().getNodeId());
        MockNetworkTest.assertEquals((Object)server, (Object)iface3.getNode());
        MockNode ipv6 = this.m_network.getNode(3);
        MockInterface iface4 = this.m_network.getInterface(3, "fe80:0000:0000:0000:0000:0000:0000:00ff");
        MockNetworkTest.assertEquals((int)ipv6.getNodeId(), (int)iface4.getNode().getNodeId());
        MockNetworkTest.assertEquals((Object)ipv6, (Object)iface4.getNode());
    }

    public void testCreateNodes() {
        MockNode router = this.m_network.getNode(1);
        MockNetworkTest.assertEquals((int)1, (int)router.getNodeId());
        MockNetworkTest.assertEquals((String)"Router", (String)router.getLabel());
        MockNetworkTest.assertEquals((int)2, (int)router.getMembers().size());
        MockNode server = this.m_network.getNode(2);
        MockNetworkTest.assertEquals((int)2, (int)server.getNodeId());
        MockNetworkTest.assertEquals((String)"Server", (String)server.getLabel());
        MockNetworkTest.assertEquals((int)2, (int)server.getMembers().size());
        MockNode ipv6 = this.m_network.getNode(3);
        MockNetworkTest.assertEquals((int)3, (int)ipv6.getNodeId());
        MockNetworkTest.assertEquals((String)"IPv6Server", (String)ipv6.getLabel());
        MockNetworkTest.assertEquals((int)1, (int)ipv6.getMembers().size());
    }

    public void testCreateServices() {
        MockInterface rtrIface = this.m_network.getInterface(1, "192.168.1.2");
        MockInterface svrIface = this.m_network.getInterface(2, "192.168.1.3");
        MockService icmpSvc = this.m_network.getService(1, "192.168.1.2", "ICMP");
        MockService icmpSvc2 = this.m_network.getService(1, "192.168.1.1", "ICMP");
        MockService httpSvc = this.m_network.getService(2, "192.168.1.3", "HTTP");
        MockNetworkTest.assertEquals((String)"ICMP", (String)icmpSvc.getSvcName());
        MockNetworkTest.assertEquals((Object)rtrIface, (Object)icmpSvc.getInterface());
        MockNetworkTest.assertEquals((String)"HTTP", (String)httpSvc.getSvcName());
        MockNetworkTest.assertEquals((Object)svrIface, (Object)httpSvc.getInterface());
        MockNetworkTest.assertTrue((icmpSvc.getId() == icmpSvc2.getId() ? 1 : 0) != 0);
        MockNetworkTest.assertFalse((icmpSvc.getId() == httpSvc.getId() ? 1 : 0) != 0);
    }

    public void testEventListeners() {
        Event sentEvent = MockEventUtil.createEvent((String)"Test", (String)"uei.opennms.org/nodes/nodeGainedService", (int)1, (String)"192.168.1.1", (String)"NEW", null);
        Event sentEvent2 = MockEventUtil.createEvent((String)"Test", (String)"uei.opennms.org/nodes/nodeRegainedService", (int)1, (String)"192.168.1.1", (String)"NEW", null);
        class MockListener
        implements EventListener {
            private Event receivedEvent;

            MockListener() {
            }

            public String getName() {
                return "MockListener";
            }

            public Event getReceivedEvent() {
                return this.receivedEvent;
            }

            public void onEvent(Event event) {
                System.err.println("onEvent: " + event.getUei());
                this.receivedEvent = event;
            }

            public void reset() {
                this.receivedEvent = null;
            }
        }
        MockListener listener = new MockListener();
        this.m_eventMgr.addEventListener((EventListener)listener, "uei.opennms.org/nodes/nodeGainedService");
        this.m_eventMgr.sendEventToListeners(sentEvent);
        MockNetworkTest.assertTrue((boolean)EventUtils.eventsMatch((Event)sentEvent, (Event)listener.getReceivedEvent()));
        listener.reset();
        this.m_eventMgr.sendEventToListeners(sentEvent2);
        MockNetworkTest.assertFalse((boolean)EventUtils.eventsMatch((Event)sentEvent2, (Event)listener.getReceivedEvent()));
    }

    public void testEventMgr() {
        MockNetworkTest.assertNotNull((Object)this.m_eventMgr);
    }

    public void testEventProcessing() {
        this.testEventProcessing((MockElement)this.m_network.getService(2, "192.168.1.3", "ICMP"));
        this.testEventProcessing((MockElement)this.m_network.getNode(2));
        this.testEventProcessing((MockElement)this.m_network.getInterface(1, "192.168.1.2"));
    }

    private void testEventProcessing(MockElement element) {
        this.m_pollerConfig.setNodeOutageProcessingEnabled(false);
        EventAnticipator anticipator = this.m_eventMgr.getEventAnticipator();
        String nlsUei = "uei.opennms.org/nodes/nodeLostService";
        String nrsUei = "uei.opennms.org/nodes/nodeRegainedService";
        this.anticipateServiceEvents(anticipator, element, nlsUei);
        element.bringDown();
        MockNetworkTest.assertFalse((0 == anticipator.waitForAnticipated(0L).size() ? 1 : 0) != 0);
        anticipator.reset();
        this.anticipateServiceEvents(anticipator, element, nrsUei);
        element.bringUp();
        MockNetworkTest.assertFalse((0 == anticipator.waitForAnticipated(0L).size() ? 1 : 0) != 0);
        anticipator.reset();
        this.anticipateServiceEvents(anticipator, element, nlsUei);
        element.bringDown();
        MockVisitorAdapter lostSvcSender = new MockVisitorAdapter(){

            public void visitService(MockService svc) {
                Event event = MockEventUtil.createEvent((String)"Test", (String)"uei.opennms.org/nodes/nodeLostService", (int)svc.getNodeId(), (String)svc.getIpAddr(), (String)svc.getSvcName(), (String)String.valueOf(2));
                MockNetworkTest.this.m_eventMgr.sendNow(event);
            }
        };
        element.visit((MockVisitor)lostSvcSender);
        MockNetworkTest.assertEquals((int)0, (int)anticipator.waitForAnticipated(0L).size());
        anticipator.reset();
        this.anticipateServiceEvents(anticipator, element, nrsUei);
        element.bringUp();
        MockVisitorAdapter gainedSvcSender = new MockVisitorAdapter(){

            public void visitService(MockService svc) {
                Event event = MockEventUtil.createEvent((String)"Test", (String)"uei.opennms.org/nodes/nodeRegainedService", (int)svc.getNodeId(), (String)svc.getIpAddr(), (String)svc.getSvcName(), null);
                MockNetworkTest.this.m_eventMgr.sendNow(event);
            }
        };
        element.visit((MockVisitor)gainedSvcSender);
        this.m_eventMgr.finishProcessingEvents();
        MockNetworkTest.assertEquals((int)0, (int)anticipator.waitForAnticipated(0L).size());
        MockNetworkTest.assertEquals((int)0, (int)anticipator.unanticipatedEvents().size());
        MockNode node = this.m_network.getNode(1);
        Event nodeEvent = MockEventUtil.createNodeDownEvent((String)"Test", (MockNode)node);
        anticipator.reset();
        this.m_eventMgr.sendNow(nodeEvent);
        this.m_eventMgr.finishProcessingEvents();
        MockNetworkTest.assertEquals((int)0, (int)anticipator.waitForAnticipated(0L).size());
        MockNetworkTest.assertEquals((int)1, (int)anticipator.unanticipatedEvents().size());
    }

    public void testInvalidPoll() throws UnknownHostException {
        this.m_network.resetInvalidPollCount();
        MockMonitoredService svc = new MockMonitoredService(99, "InvalidNode", InetAddressUtils.addr((String)"1.1.1.1"), "ICMP");
        ServiceMonitor monitor = this.m_pollerConfig.getServiceMonitor("ICMP");
        monitor.poll((MonitoredService)svc, new HashMap());
        MockNetworkTest.assertEquals((int)1, (int)this.m_network.getInvalidPollCount());
    }

    public void testLookupNotThere() {
        MockNetworkTest.assertNotNull((Object)this.m_network.getService(1, "192.168.1.1", "ICMP"));
        MockNetworkTest.assertNotNull((Object)this.m_network.getService(3, "fe80:0000:0000:0000:0000:0000:0000:00ff", "ICMP"));
        MockNetworkTest.assertNotNull((Object)this.m_network.getService(3, "fe80:0000:0000:0000:0000:0000:0000:00ff", "HTTP"));
        MockNetworkTest.assertNotNull((Object)this.m_network.getService(3, "fe80:0000:0000:0000:0000:0000:0000:00ff", "DNS"));
        MockNetworkTest.assertNull((Object)this.m_network.getService(7, "192.168.1.1", "ICMP"));
        MockNetworkTest.assertNull((Object)this.m_network.getService(1, "192.168.1.175", "ICMP"));
        MockNetworkTest.assertNull((Object)this.m_network.getService(1, "192.168.1.1", "ICMG"));
        MockNetworkTest.assertNull((Object)this.m_network.getService(3, "fe80:0000:0000:0000:0000:0000:0000:00ff", "DHCP"));
    }

    public void testPollerConfig() {
        this.m_pollerConfig.setNodeOutageProcessingEnabled(true);
        this.m_pollerConfig.setPollInterval("HTTP", 750L);
        this.m_pollerConfig.setPollerThreads(5);
        this.m_pollerConfig.setCriticalService("YAHOO");
        MockPollerConfig pollerConfig = this.m_pollerConfig;
        MockNetworkTest.assertTrue((boolean)pollerConfig.isNodeOutageProcessingEnabled());
        Enumeration pkgs = pollerConfig.enumeratePackage();
        MockNetworkTest.assertNotNull((Object)pkgs);
        int pkgCount = 0;
        Package pkg = null;
        while (pkgs.hasMoreElements()) {
            pkg = (Package)pkgs.nextElement();
            ++pkgCount;
        }
        MockNetworkTest.assertTrue((pkgCount > 0 ? 1 : 0) != 0);
        MockNetworkTest.assertTrue((boolean)pollerConfig.isInterfaceInPackage("192.168.1.1", pkg));
        for (Service svc : pkg.getServices()) {
            if ("ICMP".equals(svc.getName())) {
                MockNetworkTest.assertEquals((Object)500L, (Object)svc.getInterval());
                continue;
            }
            if ("HTTP".equals(svc.getName())) {
                MockNetworkTest.assertEquals((Object)750L, (Object)svc.getInterval());
                continue;
            }
            MockNetworkTest.assertEquals((Object)1000L, (Object)svc.getInterval());
        }
        MockNetworkTest.assertEquals((int)5, (int)pollerConfig.getThreads());
        MockNetworkTest.assertEquals((String)"YAHOO", (String)pollerConfig.getCriticalService());
        MockNetworkTest.assertNotNull((Object)pollerConfig.getServiceMonitor("SMTP"));
    }

    public void testPollOutageConfig() {
        MockPollerConfig pollOutagesConfig = this.m_pollerConfig;
        MockNetworkTest.assertNotNull((Object)((Object)pollOutagesConfig));
    }

    public void testPollStatus() {
        MockNode node = this.m_network.getNode(1);
        MockInterface iface = this.m_network.getInterface(1, "192.168.1.2");
        MockNetworkTest.assertEquals((Object)PollStatus.up(), (Object)node.getPollStatus());
        MockNetworkTest.assertEquals((Object)PollStatus.up(), (Object)iface.getPollStatus());
        node.bringDown();
        MockNetworkTest.assertEquals((Object)PollStatus.down(), (Object)node.getPollStatus());
        MockNetworkTest.assertEquals((Object)PollStatus.down(), (Object)iface.getPollStatus());
        iface.bringUp();
        MockNetworkTest.assertEquals((Object)PollStatus.up(), (Object)node.getPollStatus());
        MockNetworkTest.assertEquals((Object)PollStatus.up(), (Object)iface.getPollStatus());
        node.bringUp();
        MockNetworkTest.assertEquals((Object)PollStatus.up(), (Object)node.getPollStatus());
        MockNetworkTest.assertEquals((Object)PollStatus.up(), (Object)iface.getPollStatus());
    }

    public void testQueryManager() throws Exception {
        MockQueryManager queryManager = new MockQueryManager(this.m_network);
        MockNetworkTest.assertNotNull((Object)queryManager);
        MockNetworkTest.assertTrue((boolean)queryManager.activeServiceExists("Test", 1, "192.168.1.1", "ICMP"));
        MockNetworkTest.assertFalse((boolean)queryManager.activeServiceExists("Test", 1, "192.168.1.17", "ICMP"));
        MockInterface iface = this.m_network.getInterface(1, "192.168.1.2");
        Collection<MockService> expectedSvcs = this.getServicesForInterface(iface);
        List<Integer> svcs = queryManager.getActiveServiceIdsForInterface("192.168.1.2");
        for (MockService svc : expectedSvcs) {
            MockNetworkTest.assertTrue((boolean)svcs.contains(svc.getId()));
        }
        List<IfKey> ifKeys = queryManager.getInterfacesWithService("HTTP");
        MockInterface httpIf = this.m_network.getInterface(2, "192.168.1.3");
        MockNetworkTest.assertEquals((int)2, (int)ifKeys.size());
        IfKey key = ifKeys.get(0);
        MockNetworkTest.assertEquals((int)httpIf.getNode().getNodeId(), (int)key.getNodeId());
        MockNetworkTest.assertEquals((String)httpIf.getIpAddr(), (String)key.getIpAddr());
        int findNodeId = queryManager.getNodeIDForInterface("192.168.1.3");
        MockNetworkTest.assertEquals((int)httpIf.getNode().getNodeId(), (int)findNodeId);
        MockNetworkTest.assertEquals((String)"Router", (String)queryManager.getNodeLabel(1));
        MockNetworkTest.assertEquals((int)2, (int)queryManager.getServiceCountForInterface("192.168.1.1"));
    }

    private Collection<MockService> getServicesForInterface(MockInterface iface) {
        return iface.getServices();
    }

    public void testRemove() {
        MockNetworkTest.assertNotNull((Object)this.m_network.getService(1, "192.168.1.1", "SMTP"));
        this.m_network.removeService(this.m_network.getService(1, "192.168.1.1", "SMTP"));
        MockNetworkTest.assertNull((Object)this.m_network.getService(1, "192.168.1.1", "SMTP"));
        MockNetworkTest.assertNotNull((Object)this.m_network.getInterface(1, "192.168.1.1"));
        this.m_network.removeInterface(this.m_network.getInterface(1, "192.168.1.1"));
        MockNetworkTest.assertNull((Object)this.m_network.getInterface(1, "192.168.1.1"));
        MockNetworkTest.assertNull((Object)this.m_network.getService(1, "192.168.1.1", "ICMP"));
        MockNetworkTest.assertNotNull((Object)this.m_network.getNode(1));
        this.m_network.removeNode(this.m_network.getNode(1));
        MockNetworkTest.assertNull((Object)this.m_network.getNode(1));
        MockNetworkTest.assertNull((Object)this.m_network.getInterface(1, "192.168.1.2"));
        MockInterface iface = this.m_network.getInterface(2, "192.168.1.3");
        MockNetworkTest.assertNotNull((Object)iface);
        this.m_network.removeElement((MockElement)iface);
        MockNetworkTest.assertNull((Object)this.m_network.getInterface(2, "192.168.1.3"));
    }

    public void testScheduledOutages() {
        long now = System.currentTimeMillis();
        long tenMinutes = 600000L;
        this.m_pollerConfig.addScheduledOutage("outage1", now - tenMinutes, now + tenMinutes, "192.168.1.1");
        this.m_pollerConfig.addScheduledOutage("outage2", now - tenMinutes, now, "192.168.1.2");
        this.m_pollerConfig.addScheduledOutage("outage3", now - tenMinutes, now, 1);
        this.m_pollerConfig.addScheduledOutage("outage4", now - tenMinutes, now, 2);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Package pkg = this.m_pollerConfig.getPackage("TestPackage");
        MockNetworkTest.assertNotNull((Object)pkg);
        List outages = pkg.getOutageCalendars();
        MockNetworkTest.assertTrue((boolean)outages.contains("outage1"));
        MockNetworkTest.assertTrue((boolean)outages.contains("outage2"));
        MockNetworkTest.assertTrue((boolean)this.m_pollerConfig.isInterfaceInOutage("192.168.1.1", "outage1"));
        MockNetworkTest.assertFalse((boolean)this.m_pollerConfig.isInterfaceInOutage("192.168.1.2", "outage1"));
        MockNetworkTest.assertTrue((boolean)this.m_pollerConfig.isInterfaceInOutage("192.168.1.2", "outage2"));
        MockNetworkTest.assertFalse((boolean)this.m_pollerConfig.isInterfaceInOutage("192.168.1.1", "outage2"));
        MockNetworkTest.assertTrue((boolean)this.m_pollerConfig.isCurTimeInOutage("outage1"));
        MockNetworkTest.assertFalse((boolean)this.m_pollerConfig.isCurTimeInOutage("outage2"));
        MockNetworkTest.assertFalse((boolean)this.m_pollerConfig.isNodeIdInOutage(1L, "outage1"));
        MockNetworkTest.assertTrue((boolean)this.m_pollerConfig.isNodeIdInOutage(1L, "outage3"));
        MockNetworkTest.assertFalse((boolean)this.m_pollerConfig.isNodeIdInOutage(1L, "outage4"));
    }

    private void testServicePoll(MockElement element) throws UnknownHostException {
        element.resetPollCount();
        this.m_downChecker.resetServiceCount();
        element.bringDown();
        element.visit((MockVisitor)this.m_downChecker);
        MockNetworkTest.assertEquals((int)this.m_downChecker.getServiceCount(), (int)element.getPollCount());
        element.resetPollCount();
        this.m_upChecker.resetServiceCount();
        element.bringUp();
        element.visit((MockVisitor)this.m_upChecker);
        MockNetworkTest.assertEquals((int)this.m_upChecker.getServiceCount(), (int)element.getPollCount());
    }

    public void testSetPollStatus() throws Exception {
        this.testServicePoll((MockElement)this.m_network.getService(1, "192.168.1.1", "SMTP"));
        this.testServicePoll((MockElement)this.m_network.getService(1, "192.168.1.1", "ICMP"));
        this.testServicePoll((MockElement)this.m_network.getService(1, "192.168.1.2", "SMTP"));
        this.testServicePoll((MockElement)this.m_network.getService(2, "192.168.1.3", "HTTP"));
        this.testServicePoll((MockElement)this.m_network.getInterface(1, "192.168.1.1"));
        this.testServicePoll((MockElement)this.m_network.getNode(2));
    }

    public void testVisitor() {
        ElementCounter counter = new ElementCounter();
        this.m_network.visit((MockVisitor)counter);
        MockNetworkTest.assertEquals((int)1, (int)counter.getNetworkCount());
        MockNetworkTest.assertEquals((int)3, (int)counter.getNodeCount());
        MockNetworkTest.assertEquals((int)5, (int)counter.getInterfaceCount());
        MockNetworkTest.assertEquals((int)9, (int)counter.getServiceCount());
        MockNetworkTest.assertEquals((int)9, (int)counter.getContainerCount());
        MockNetworkTest.assertEquals((int)18, (int)counter.getElementCount());
    }

    public void testWaitForEvent() throws Throwable {
        MockNode node = this.m_network.getNode(1);
        Event event1 = MockEventUtil.createNodeDownEvent((String)"Test", (MockNode)node);
        final Event event2 = MockEventUtil.createNodeDownEvent((String)"Test", (MockNode)node);
        final Event event3 = MockEventUtil.createNodeDownEvent((String)"Test", (MockNode)this.m_network.getNode(2));
        EventAnticipator anticipator = this.m_eventMgr.getEventAnticipator();
        anticipator.anticipateEvent(event1);
        anticipator.anticipateEvent(event3);
        class EventSender
        extends Thread {
            Throwable m_t = null;

            EventSender() {
            }

            public void assertSuccess() throws Throwable {
                if (this.m_t != null) {
                    throw this.m_t;
                }
            }

            @Override
            public void run() {
                try {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    MockNetworkTest.this.m_eventMgr.sendNow(event2);
                    MockNetworkTest.this.m_eventMgr.sendNow(event2);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    MockNetworkTest.this.m_eventMgr.sendNow(event3);
                }
                catch (Throwable t) {
                    this.m_t = t;
                }
            }
        }
        EventSender eventSender = new EventSender();
        eventSender.start();
        eventSender.assertSuccess();
        MockNetworkTest.assertEquals((int)1, (int)anticipator.waitForAnticipated(1500L).size());
        MockNetworkTest.assertEquals((int)0, (int)anticipator.waitForAnticipated(1000L).size());
        MockNetworkTest.assertEquals((int)1, (int)anticipator.unanticipatedEvents().size());
    }

    public void testWaitForPoll() throws Throwable {
        PollAnticipator anticipator = new PollAnticipator();
        final MockService smtpService = this.m_network.getService(1, "192.168.1.1", "SMTP");
        smtpService.resetPollCount();
        smtpService.addAnticipator(anticipator);
        final MockService icmpService = this.m_network.getService(2, "192.168.1.3", "ICMP");
        icmpService.resetPollCount();
        icmpService.addAnticipator(anticipator);
        final MockInterface iface = this.m_network.getInterface(1, "192.168.1.2");
        iface.resetPollCount();
        iface.addAnticipator(anticipator);
        anticipator.anticipateAllServices((MockElement)smtpService);
        anticipator.anticipateAllServices((MockElement)icmpService);
        anticipator.anticipateAllServices((MockElement)iface);
        this.m_upChecker.resetServiceCount();
        smtpService.visit((MockVisitor)this.m_upChecker);
        icmpService.visit((MockVisitor)this.m_upChecker);
        iface.visit((MockVisitor)this.m_upChecker);
        icmpService.visit((MockVisitor)this.m_upChecker);
        MockNetworkTest.assertEquals((int)0, (int)anticipator.waitForAnticipated(0L).size());
        MockNetworkTest.assertEquals((int)1, (int)anticipator.unanticipatedPolls().size());
        anticipator.reset();
        anticipator.anticipateAllServices((MockElement)smtpService);
        anticipator.anticipateAllServices((MockElement)icmpService);
        anticipator.anticipateAllServices((MockElement)iface);
        anticipator.anticipateAllServices((MockElement)icmpService);
        smtpService.bringDown();
        icmpService.bringDown();
        iface.bringDown();
        this.m_downChecker.resetServiceCount();
        class PollerThread
        extends Thread {
            Throwable m_t = null;

            PollerThread() {
            }

            public void assertSuccess() throws Throwable {
                if (this.m_t != null) {
                    throw this.m_t;
                }
            }

            @Override
            public void run() {
                try {
                    smtpService.visit((MockVisitor)MockNetworkTest.this.m_downChecker);
                    icmpService.visit((MockVisitor)MockNetworkTest.this.m_downChecker);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    iface.visit((MockVisitor)MockNetworkTest.this.m_downChecker);
                    icmpService.visit((MockVisitor)MockNetworkTest.this.m_downChecker);
                }
                catch (Throwable t) {
                    this.m_t = t;
                }
            }
        }
        PollerThread pollerThread = new PollerThread();
        pollerThread.start();
        MockNetworkTest.assertEquals((int)0, (int)anticipator.waitForAnticipated(3000L).size());
        MockNetworkTest.assertEquals((int)0, (int)anticipator.unanticipatedPolls().size());
        pollerThread.assertSuccess();
        MockNetworkTest.assertEquals((int)this.m_upChecker.getServiceCount(), (int)this.m_downChecker.getServiceCount());
    }

    class StatusChecker
    extends MockVisitorAdapter {
        PollStatus m_expectedStatus;
        int m_serviceCount = 0;

        public StatusChecker(PollStatus status) {
            this.m_expectedStatus = status;
        }

        public int getServiceCount() {
            return this.m_serviceCount;
        }

        public void resetServiceCount() {
            this.m_serviceCount = 0;
        }

        public void setExpectedStatus(PollStatus status) {
            this.m_expectedStatus = status;
        }

        public void visitService(MockService service) {
            ++this.m_serviceCount;
            ServiceMonitor monitor = MockNetworkTest.this.m_pollerConfig.getServiceMonitor(service.getSvcName());
            PollStatus pollResult = monitor.poll((MonitoredService)service, new HashMap());
            Assert.assertEquals((Object)this.m_expectedStatus, (Object)pollResult);
        }
    }

    static class ElementCounter
    implements MockVisitor {
        private int containerCount = 0;
        private int elementCount = 0;
        private int interfaceCount = 0;
        private int networkCount = 0;
        private int nodeCount = 0;
        private int serviceCount = 0;

        ElementCounter() {
        }

        public int getContainerCount() {
            return this.containerCount;
        }

        public int getElementCount() {
            return this.elementCount;
        }

        public int getInterfaceCount() {
            return this.interfaceCount;
        }

        public int getNetworkCount() {
            return this.networkCount;
        }

        public int getNodeCount() {
            return this.nodeCount;
        }

        public int getServiceCount() {
            return this.serviceCount;
        }

        public void visitContainer(MockContainer<?, ?> c) {
            ++this.containerCount;
        }

        public void visitElement(MockElement e) {
            ++this.elementCount;
        }

        public void visitInterface(MockInterface i) {
            ++this.interfaceCount;
        }

        public void visitNetwork(MockNetwork n) {
            ++this.networkCount;
        }

        public void visitNode(MockNode n) {
            ++this.nodeCount;
        }

        public void visitService(MockService s) {
            ++this.serviceCount;
        }
    }
}

