/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import junit.framework.TestCase;
import org.opennms.netmgt.config.CategoryFactory;
import org.opennms.netmgt.config.categories.CatFactory;
import org.opennms.netmgt.config.categories.Category;
import org.opennms.netmgt.mock.MockCategoryFactory;

public class MockCategoryFactoryTest
extends TestCase {
    protected MockCategoryFactory m_mockCatFactory;
    protected CatFactory m_catFactory;
    private static final String CATLABEL = "Network Interfaces";
    private static final String CATRULE = "(isICMP | isSNMP) & (ipaddr != \"0.0.0.0\")";
    private static final String EFFECTIVE_RULE = "(ipaddr IPLIKE *.*.*.*) & ((isICMP | isSNMP) & (ipaddr != \"0.0.0.0\"))";
    private static final String CATCOMMENT = "This is a very simple category";
    private static final String MOCK_CATEGORY_CONFIG = "<catinfo> <header>  <rev>1.3</rev>  <created>Wednesday, February 6, 2002 10:10:00 AM EST</created>  <mstation>checkers</mstation> </header> <categorygroup>  <name>WebConsole</name>  <comment>Service Level Availability by Functional Group</comment>  <common>   <rule><![CDATA[ipaddr IPLIKE *.*.*.*]]></rule>  </common>  <categories>   <category>    <label><![CDATA[Network Interfaces]]></label>    <comment>This is a very simple category</comment>    <normal>99</normal>    <warning>97</warning>    <service>ICMP</service>    <service>SNMP</service>    <rule><![CDATA[(isICMP | isSNMP) & (ipaddr != \"0.0.0.0\")]]></rule>   </category>  </categories> </categorygroup></catinfo>";

    protected void setUp() throws Exception {
        super.setUp();
        this.m_mockCatFactory = new MockCategoryFactory(MOCK_CATEGORY_CONFIG);
        CategoryFactory.setInstance((CatFactory)this.m_mockCatFactory);
        this.m_catFactory = CategoryFactory.getInstance();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetCategory() {
        Category category = this.m_catFactory.getCategory(CATLABEL);
        MockCategoryFactoryTest.assertEquals((double)99.0, (double)category.getNormal(), (double)0.0);
        MockCategoryFactoryTest.assertEquals((double)97.0, (double)category.getWarning(), (double)0.0);
        MockCategoryFactoryTest.assertEquals((String)CATCOMMENT, (String)category.getComment());
        MockCategoryFactoryTest.assertEquals((String)CATRULE, (String)category.getRule());
        MockCategoryFactoryTest.assertEquals((String)"ICMP", (String)category.getService(0));
        MockCategoryFactoryTest.assertEquals((String)"SNMP", (String)category.getService(1));
    }

    public void testGetEffectiveRule() {
        MockCategoryFactoryTest.assertEquals((String)EFFECTIVE_RULE, (String)this.m_catFactory.getEffectiveRule(CATLABEL));
    }
}

