/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.io.IOException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgents;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.linkd.Package;
import org.opennms.netmgt.linkd.AtInterface;
import org.opennms.netmgt.linkd.HibernateEventWriter;
import org.opennms.netmgt.linkd.LinkableNode;
import org.opennms.netmgt.linkd.Nms7467NetworkBuilder;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsAtInterface;
import org.opennms.netmgt.model.OnmsIpRouteInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsStpInterface;
import org.opennms.netmgt.model.OnmsStpNode;
import org.springframework.transaction.annotation.Transactional;

public class Nms7467Test
extends Nms7467NetworkBuilder {
    @Test
    public void testDefaultConfiguration() throws MarshalException, ValidationException, IOException {
        Assert.assertEquals((long)5L, (long)this.m_linkdConfig.getThreads());
        Assert.assertEquals((long)3600000L, (long)this.m_linkdConfig.getInitialSleepTime());
        Assert.assertEquals((long)18000000L, (long)this.m_linkdConfig.getSnmpPollInterval());
        Assert.assertEquals((long)1800000L, (long)this.m_linkdConfig.getDiscoveryLinkInterval());
        Assert.assertEquals((Object)false, (Object)this.m_linkdConfig.isAutoDiscoveryEnabled());
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.isVlanDiscoveryEnabled());
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.useCdpDiscovery());
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.useIpRouteDiscovery());
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.useBridgeDiscovery());
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.useOspfDiscovery());
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.useLldpDiscovery());
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.useIsIsDiscovery());
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.saveRouteTable());
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.saveStpNodeTable());
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.saveStpInterfaceTable());
        Assert.assertEquals((Object)false, (Object)this.m_linkdConfig.forceIpRouteDiscoveryOnEthernet());
        Enumeration iter = this.m_linkdConfig.enumeratePackage();
        Package example1 = (Package)iter.nextElement();
        Assert.assertEquals((Object)false, (Object)iter.hasMoreElements());
        Assert.assertEquals((Object)"example1", (Object)example1.getName());
        Assert.assertEquals((Object)false, (Object)example1.hasAutoDiscovery());
        Assert.assertEquals((Object)false, (Object)example1.hasDiscovery_link_interval());
        Assert.assertEquals((Object)false, (Object)example1.hasEnableVlanDiscovery());
        Assert.assertEquals((Object)false, (Object)example1.hasForceIpRouteDiscoveryOnEthernet());
        Assert.assertEquals((Object)false, (Object)example1.hasSaveRouteTable());
        Assert.assertEquals((Object)false, (Object)example1.hasSaveStpInterfaceTable());
        Assert.assertEquals((Object)false, (Object)example1.hasSaveStpNodeTable());
        Assert.assertEquals((Object)false, (Object)example1.hasSnmp_poll_interval());
        Assert.assertEquals((Object)false, (Object)example1.hasUseBridgeDiscovery());
        Assert.assertEquals((Object)false, (Object)example1.hasUseCdpDiscovery());
        Assert.assertEquals((Object)false, (Object)example1.hasUseIpRouteDiscovery());
        Assert.assertEquals((Object)false, (Object)example1.hasUseIsisDiscovery());
        Assert.assertEquals((Object)false, (Object)this.m_linkdConfig.isInterfaceInPackage(InetAddressUtils.addr((String)"172.20.1.1"), example1));
        this.m_nodeDao.save((Object)this.getCiscoC870());
        this.m_nodeDao.save((Object)this.getCiscoWsC2948());
        this.m_nodeDao.flush();
        this.m_linkdConfig.update();
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.isInterfaceInPackage(InetAddressUtils.addr((String)"172.20.1.1"), example1));
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.isInterfaceInPackage(InetAddressUtils.addr((String)"172.20.1.7"), example1));
        OnmsNode ciscorouter = this.m_nodeDao.findByForeignId("linkd", "mrmakay.internal.opennms.com");
        OnmsNode ciscows = this.m_nodeDao.findByForeignId("linkd", "ciscoswitch");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(ciscorouter.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(ciscows.getId().intValue()));
        LinkableNode lciscorouter = this.m_linkd.removeNode("example1", InetAddressUtils.addr((String)"172.20.1.1"));
        Assert.assertNotNull((Object)lciscorouter);
        Assert.assertEquals((long)ciscorouter.getId().intValue(), (long)lciscorouter.getNodeId());
        Assert.assertEquals((long)1L, (long)this.m_linkd.getActivePackages().size());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.20.1.7", port=161, resource="classpath:linkd/nms7467/172.20.1.7-walk.txt"), @JUnitSnmpAgent(host="172.20.1.1", port=161, resource="classpath:linkd/nms7467/172.20.1.1-walk.txt"), @JUnitSnmpAgent(host="172.20.1.28", port=161, resource="classpath:linkd/nms7467/172.20.1.28-walk.txt"), @JUnitSnmpAgent(host="172.20.1.8", port=161, resource="classpath:linkd/nms7467/172.20.1.8-walk.txt"), @JUnitSnmpAgent(host="172.20.1.14", port=161, resource="classpath:linkd/nms7467/172.20.1.14-walk.txt")})
    public void testAllTogether() throws Exception {
        Package example1 = this.m_linkdConfig.getPackage("example1");
        example1.setUseLldpDiscovery(false);
        example1.setUseOspfDiscovery(false);
        example1.setUseIsisDiscovery(false);
        example1.setUseIpRouteDiscovery(false);
        example1.setForceIpRouteDiscoveryOnEthernet(false);
        example1.setSaveRouteTable(true);
        example1.setUseCdpDiscovery(true);
        this.m_nodeDao.save((Object)this.getCiscoC870());
        this.m_nodeDao.save((Object)this.getCiscoWsC2948());
        this.m_nodeDao.save((Object)this.getNetGearSw108());
        this.m_nodeDao.save((Object)this.getDarwin108());
        this.m_nodeDao.save((Object)this.getLinuxUbuntu());
        this.m_nodeDao.save((Object)this.getNodeWithoutSnmp("mrgarrison.internal.opennms.com", "172.20.1.5"));
        this.m_nodeDao.save((Object)this.getNodeWithoutSnmp("workstation", "172.20.1.101"));
        this.m_nodeDao.flush();
        OnmsNode ciscorouter = this.m_nodeDao.findByForeignId("linkd", "mrmakay.internal.opennms.com");
        OnmsNode ciscows = this.m_nodeDao.findByForeignId("linkd", "ciscoswitch");
        OnmsNode ngsw108 = this.m_nodeDao.findByForeignId("linkd", "ng108switch");
        OnmsNode mac = this.m_nodeDao.findByForeignId("linkd", "mac");
        OnmsNode linux = this.m_nodeDao.findByForeignId("linkd", "linuxubuntu");
        OnmsNode ciscoap = this.m_nodeDao.findByForeignId("linkd", "mrgarrison.internal.opennms.com");
        OnmsNode workstation = this.m_nodeDao.findByForeignId("linkd", "workstation");
        Assert.assertEquals((long)7L, (long)this.m_nodeDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(ciscows.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(ciscorouter.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(ngsw108.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(mac.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(linux.getId().intValue()));
        Assert.assertTrue((!this.m_linkd.scheduleNodeCollection(ciscoap.getId().intValue()) ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkd.scheduleNodeCollection(workstation.getId().intValue()) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(ciscorouter.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(ciscows.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(ngsw108.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(mac.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(linux.getId().intValue()));
        Collection linkables = this.m_linkd.getLinkableNodesOnPackage("example1");
        Assert.assertEquals((long)5L, (long)linkables.size());
        for (OnmsAtInterface onmsat : this.m_atInterfaceDao.findAll()) {
            this.printAtInterface(onmsat);
        }
        Assert.assertEquals((long)0L, (long)this.m_dataLinkInterfaceDao.countAll());
        Assert.assertEquals((long)5L, (long)this.m_linkd.getLinkableNodesOnPackage("example1").size());
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        for (DataLinkInterface link : this.m_dataLinkInterfaceDao.findAll()) {
            this.printLink(link);
        }
        Assert.assertEquals((long)8L, (long)this.m_dataLinkInterfaceDao.countAll());
        DataLinkInterface mactongsw108link = (DataLinkInterface)this.m_dataLinkInterfaceDao.findByNodeIdAndIfIndex(mac.getId(), Integer.valueOf(4)).iterator().next();
        Assert.assertEquals((Object)mac.getId(), (Object)mactongsw108link.getNode().getId());
        Assert.assertEquals((long)4L, (long)mactongsw108link.getIfIndex().intValue());
        Assert.assertEquals((Object)ngsw108.getId(), (Object)mactongsw108link.getNodeParentId());
        Assert.assertEquals((long)1L, (long)mactongsw108link.getParentIfIndex().intValue());
        DataLinkInterface ngsw108linktociscows = (DataLinkInterface)this.m_dataLinkInterfaceDao.findByNodeIdAndIfIndex(ngsw108.getId(), Integer.valueOf(8)).iterator().next();
        Assert.assertEquals((Object)ngsw108.getId(), (Object)ngsw108linktociscows.getNode().getId());
        Assert.assertEquals((long)8L, (long)ngsw108linktociscows.getIfIndex().intValue());
        Assert.assertEquals((Object)ciscows.getId(), (Object)ngsw108linktociscows.getNodeParentId());
        Assert.assertEquals((long)9L, (long)ngsw108linktociscows.getParentIfIndex().intValue());
        DataLinkInterface ciscorouterlinktociscows2 = (DataLinkInterface)this.m_dataLinkInterfaceDao.findByNodeIdAndIfIndex(ciscows.getId(), Integer.valueOf(52)).iterator().next();
        Assert.assertEquals((Object)ciscows.getId(), (Object)ciscorouterlinktociscows2.getNode().getId());
        Assert.assertEquals((long)52L, (long)ciscorouterlinktociscows2.getIfIndex().intValue());
        Assert.assertEquals((Object)ciscorouter.getId(), (Object)ciscorouterlinktociscows2.getNodeParentId());
        Assert.assertEquals((long)3L, (long)ciscorouterlinktociscows2.getParentIfIndex().intValue());
        DataLinkInterface linuxubuntulinktociscows = (DataLinkInterface)this.m_dataLinkInterfaceDao.findByNodeIdAndIfIndex(linux.getId(), Integer.valueOf(4)).iterator().next();
        Assert.assertEquals((Object)linux.getId(), (Object)linuxubuntulinktociscows.getNode().getId());
        Assert.assertEquals((long)4L, (long)linuxubuntulinktociscows.getIfIndex().intValue());
        Assert.assertEquals((Object)ciscows.getId(), (Object)linuxubuntulinktociscows.getNodeParentId());
        Assert.assertEquals((long)11L, (long)linuxubuntulinktociscows.getParentIfIndex().intValue());
        DataLinkInterface workstationlinktociscows = (DataLinkInterface)this.m_dataLinkInterfaceDao.findByNodeIdAndIfIndex(workstation.getId(), Integer.valueOf(-1)).iterator().next();
        Assert.assertEquals((Object)workstation.getId(), (Object)workstationlinktociscows.getNode().getId());
        Assert.assertEquals((long)-1L, (long)workstationlinktociscows.getIfIndex().intValue());
        Assert.assertEquals((Object)ciscows.getId(), (Object)workstationlinktociscows.getNodeParentId());
        Assert.assertEquals((long)47L, (long)workstationlinktociscows.getParentIfIndex().intValue());
        DataLinkInterface ciscoaplinktociscows = (DataLinkInterface)this.m_dataLinkInterfaceDao.findByNodeIdAndIfIndex(ciscoap.getId(), Integer.valueOf(-1)).iterator().next();
        Assert.assertEquals((Object)ciscoap.getId(), (Object)ciscoaplinktociscows.getNode().getId());
        Assert.assertEquals((long)-1L, (long)ciscoaplinktociscows.getIfIndex().intValue());
        Assert.assertEquals((Object)ciscows.getId(), (Object)ciscoaplinktociscows.getNodeParentId());
        Assert.assertEquals((long)47L, (long)ciscoaplinktociscows.getParentIfIndex().intValue());
        Thread.sleep(5000L);
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(ciscorouter.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(ciscows.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(ngsw108.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(mac.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(linux.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        Assert.assertEquals((long)8L, (long)this.m_dataLinkInterfaceDao.countAll());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.20.1.7", port=161, resource="classpath:linkd/nms7467/172.20.1.7-walk.txt")})
    public void testCiscoWsC2948Collection() throws Exception {
        this.m_nodeDao.save((Object)this.getCiscoWsC2948());
        this.m_nodeDao.flush();
        Package example1 = this.m_linkdConfig.getPackage("example1");
        example1.setUseLldpDiscovery(false);
        example1.setUseOspfDiscovery(false);
        example1.setUseIsisDiscovery(false);
        example1.setForceIpRouteDiscoveryOnEthernet(true);
        OnmsNode ciscosw = this.m_nodeDao.findByForeignId("linkd", "ciscoswitch");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(ciscosw.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(ciscosw.getId().intValue()));
        Assert.assertEquals((long)1L, (long)this.m_linkd.getLinkableNodesOnPackage("example1").size());
        LinkableNode linkNode = (LinkableNode)this.m_linkd.getLinkableNodesOnPackage("example1").iterator().next();
        Assert.assertTrue((linkNode != null ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)linkNode.getRouteInterfaces().size());
        Assert.assertEquals((long)2L, (long)this.m_ipRouteInterfaceDao.countAll());
        Assert.assertEquals((long)5L, (long)this.m_vlanDao.countAll());
        String packageName = this.m_linkdConfig.getFirstPackageMatch(InetAddressUtils.addr((String)"172.20.1.7")).getName();
        Assert.assertEquals((Object)"example1", (Object)packageName);
        Assert.assertEquals((long)1L, (long)linkNode.getBridgeIdentifiers().size());
        Assert.assertEquals((Object)"0002baaacc00", (Object)linkNode.getBridgeIdentifier(Integer.valueOf(1)));
        Assert.assertEquals((long)50L, (long)((List)linkNode.getStpInterfaces().get(1)).size());
        Assert.assertEquals((String)"No cdp interface because no other node is there", (long)0L, (long)linkNode.getCdpInterfaces().size());
        for (OnmsStpInterface stpiface : (List)linkNode.getStpInterfaces().get(1)) {
            Assert.assertTrue((String)"should have a valid ifindex", (stpiface.getIfIndex() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"should have a valid bridgeport", (stpiface.getBridgePort() > 0 ? 1 : 0) != 0);
        }
        List atInterfaces = this.m_linkd.getAtInterfaces(packageName, "0002baaacffe");
        Assert.assertNotNull((Object)atInterfaces);
        Assert.assertEquals((long)1L, (long)atInterfaces.size());
        AtInterface at = (AtInterface)atInterfaces.get(0);
        Assert.assertEquals((Object)"172.20.1.7", (Object)at.getIpAddress().getHostAddress());
        Assert.assertEquals((long)3L, (long)at.getIfIndex().intValue());
        Criteria criteria = new Criteria(OnmsIpRouteInterface.class);
        criteria.setAliases(Arrays.asList(new Alias("node", "node", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new EqRestriction("node.id", (Object)ciscosw.getId()));
        Assert.assertEquals((long)2L, (long)this.m_ipRouteInterfaceDao.findMatching(criteria).size());
        Assert.assertEquals((long)0L, (long)this.m_atInterfaceDao.findAll().size());
        Assert.assertEquals((long)5L, (long)this.m_vlanDao.findAll().size());
        Assert.assertEquals((long)1L, (long)this.m_stpNodeDao.countAll());
        OnmsStpNode stpnode = this.m_stpNodeDao.findByNodeAndVlan(ciscosw.getId(), Integer.valueOf(1));
        Assert.assertTrue((boolean)"0002baaacc00".equals(stpnode.getBaseBridgeAddress()));
        Assert.assertEquals((long)50L, (long)stpnode.getBaseNumPorts().intValue());
        Assert.assertEquals((Object)OnmsStpNode.BridgeBaseType.TRANSPARENT_ONLY, (Object)stpnode.getBaseType());
        Assert.assertEquals((Object)OnmsStpNode.StpProtocolSpecification.IEEE8021D, (Object)stpnode.getStpProtocolSpecification());
        Assert.assertEquals((long)50L, (long)this.m_stpInterfaceDao.findAll().size());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.20.1.1", port=161, resource="classpath:linkd/nms7467/172.20.1.1-walk.txt")})
    public void testCiscoC870Collection() throws Exception {
        this.m_nodeDao.save((Object)this.getCiscoC870());
        this.m_nodeDao.flush();
        Package example1 = this.m_linkdConfig.getPackage("example1");
        example1.setUseLldpDiscovery(false);
        example1.setUseOspfDiscovery(false);
        example1.setUseIsisDiscovery(false);
        OnmsNode ciscorouter = this.m_nodeDao.findByForeignId("linkd", "mrmakay.internal.opennms.com");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(ciscorouter.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(ciscorouter.getId().intValue()));
        Assert.assertEquals((long)1L, (long)this.m_linkd.getLinkableNodesOnPackage("example1").size());
        LinkableNode linkNode = (LinkableNode)this.m_linkd.getLinkableNodesOnPackage("example1").iterator().next();
        Assert.assertTrue((linkNode != null ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)linkNode.getRouteInterfaces().size());
        Assert.assertEquals((long)0L, (long)this.m_vlanDao.countAll());
        String packageName = this.m_linkdConfig.getFirstPackageMatch(InetAddressUtils.addr((String)"172.20.1.1")).getName();
        Assert.assertEquals((Object)"example1", (Object)packageName);
        Assert.assertEquals((long)1L, (long)linkNode.getBridgeIdentifiers().size());
        Assert.assertEquals((Object)"00000c83d9a8", (Object)linkNode.getBridgeIdentifier(Integer.valueOf(1)));
        Assert.assertEquals((long)1L, (long)((List)linkNode.getStpInterfaces().get(1)).size());
        Assert.assertEquals((String)"No cdp interface because no other node is there", (long)0L, (long)linkNode.getCdpInterfaces().size());
        for (OnmsStpInterface stpiface : (List)linkNode.getStpInterfaces().get(1)) {
            Assert.assertTrue((String)"should have a valid ifindex", (stpiface.getIfIndex() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"should have a valid bridgeport", (stpiface.getBridgePort() > 0 ? 1 : 0) != 0);
        }
        Set macAddresses = this.m_linkd.getMacAddressesOnPackage(packageName);
        Assert.assertEquals((long)2L, (long)macAddresses.size());
        List ats = this.m_linkd.getAtInterfaces(packageName, "001f6cd034e7");
        Assert.assertNotNull((Object)ats);
        Assert.assertEquals((long)3L, (long)ats.size());
        for (AtInterface at : ats) {
            if (at.getIpAddress().getHostAddress().equals("172.20.1.1")) {
                Assert.assertEquals((long)12L, (long)at.getIfIndex().intValue());
                continue;
            }
            if (at.getIpAddress().getHostAddress().equals("172.20.2.1")) {
                Assert.assertEquals((long)13L, (long)at.getIfIndex().intValue());
                continue;
            }
            if (at.getIpAddress().getHostAddress().equals("10.255.255.2")) {
                Assert.assertEquals((long)12L, (long)at.getIfIndex().intValue());
                continue;
            }
            Assert.assertTrue((String)("ip: " + at.getIpAddress().getHostAddress() + "does not match any known ip address"), (boolean)false);
        }
        ats = this.m_linkd.getAtInterfaces(packageName, "00000c03b09e");
        Assert.assertEquals((long)1L, (long)ats.size());
        for (AtInterface at : ats) {
            if (at.getIpAddress().getHostAddress().equals("65.41.39.146")) {
                Assert.assertEquals((long)14L, (long)at.getIfIndex().intValue());
                continue;
            }
            Assert.assertTrue((String)("ip: " + at.getIpAddress().getHostAddress() + "does not match any known ip address"), (boolean)false);
        }
        Assert.assertEquals((long)4L, (long)this.m_atInterfaceDao.countAll());
        Criteria criteria = new Criteria(OnmsIpRouteInterface.class);
        criteria.setAliases(Arrays.asList(new Alias("node", "node", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new EqRestriction("node.id", (Object)ciscorouter.getId()));
        List iproutes = this.m_ipRouteInterfaceDao.findMatching(criteria);
        for (OnmsIpRouteInterface iproute : iproutes) {
            System.out.println(iproute.getRouteDest() + "/" + iproute.getRouteMask() + "/" + iproute.getRouteNextHop() + "/" + iproute.getRouteIfIndex());
        }
        Assert.assertEquals((long)7L, (long)iproutes.size());
        Assert.assertEquals((long)0L, (long)this.m_vlanDao.findAll().size());
        Assert.assertEquals((long)1L, (long)this.m_stpNodeDao.countAll());
        OnmsStpNode stpnode = this.m_stpNodeDao.findByNodeAndVlan(ciscorouter.getId(), Integer.valueOf(1));
        Assert.assertTrue((boolean)"00000c83d9a8".equals(stpnode.getBaseBridgeAddress()));
        Assert.assertEquals((long)1L, (long)stpnode.getBaseNumPorts().intValue());
        Assert.assertEquals((Object)OnmsStpNode.BridgeBaseType.SRT, (Object)stpnode.getBaseType());
        Assert.assertEquals((Object)OnmsStpNode.StpProtocolSpecification.IEEE8021D, (Object)stpnode.getStpProtocolSpecification());
        Assert.assertEquals((long)1L, (long)this.m_stpInterfaceDao.findAll().size());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.20.1.8", port=161, resource="classpath:linkd/nms7467/172.20.1.8-walk.txt")})
    public void testNetGearSw108Collection() throws Exception {
        this.m_nodeDao.save((Object)this.getNetGearSw108());
        this.m_nodeDao.flush();
        OnmsNode ngsw108 = this.m_nodeDao.findByForeignId("linkd", "ng108switch");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(ngsw108.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(ngsw108.getId().intValue()));
        Assert.assertEquals((long)1L, (long)this.m_linkd.getLinkableNodesOnPackage("example1").size());
        LinkableNode linkNode = (LinkableNode)this.m_linkd.getLinkableNodesOnPackage("example1").iterator().next();
        Assert.assertTrue((linkNode != null ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)linkNode.getRouteInterfaces().size());
        Assert.assertEquals((long)0L, (long)this.m_vlanDao.countAll());
        String packageName = this.m_linkdConfig.getFirstPackageMatch(InetAddressUtils.addr((String)"172.20.1.8")).getName();
        Assert.assertEquals((Object)"example1", (Object)packageName);
        Assert.assertEquals((long)1L, (long)linkNode.getBridgeIdentifiers().size());
        Assert.assertEquals((Object)"00223ff00b7b", (Object)linkNode.getBridgeIdentifier(Integer.valueOf(1)));
        Assert.assertEquals((long)8L, (long)((List)linkNode.getStpInterfaces().get(1)).size());
        Assert.assertEquals((String)"cdp not supported", (long)0L, (long)linkNode.getCdpInterfaces().size());
        for (OnmsStpInterface stpiface : (List)linkNode.getStpInterfaces().get(1)) {
            Assert.assertTrue((String)"should have a valid ifindex", (stpiface.getIfIndex() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"should have a valid bridgeport", (stpiface.getBridgePort() > 0 ? 1 : 0) != 0);
        }
        Set macAddresses = this.m_linkd.getMacAddressesOnPackage(packageName);
        Assert.assertNotNull((Object)macAddresses);
        Assert.assertEquals((long)1L, (long)macAddresses.size());
        List ats = this.m_linkd.getAtInterfaces(packageName, "00223ff00b7b");
        for (AtInterface at : ats) {
            if (at.getIpAddress().getHostAddress().equals("172.20.1.8")) {
                Assert.assertTrue((at.getIfIndex() == -1 ? 1 : 0) != 0);
                continue;
            }
            Assert.fail((String)("ip: " + at.getIpAddress().getHostAddress() + "does not match any known ip address"));
        }
        Assert.assertEquals((long)1L, (long)this.m_atInterfaceDao.findAll().size());
        Criteria criteria = new Criteria(OnmsIpRouteInterface.class);
        criteria.setAliases(Arrays.asList(new Alias("node", "node", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new EqRestriction("node.id", (Object)ngsw108.getId()));
        List iproutes = this.m_ipRouteInterfaceDao.findMatching(criteria);
        for (OnmsIpRouteInterface iproute : iproutes) {
            System.out.println(iproute.getRouteDest() + "/" + iproute.getRouteMask() + "/" + iproute.getRouteNextHop() + "/" + iproute.getRouteIfIndex());
        }
        Assert.assertEquals((long)0L, (long)iproutes.size());
        Assert.assertEquals((long)0L, (long)this.m_vlanDao.findAll().size());
        Assert.assertEquals((long)1L, (long)this.m_stpNodeDao.countAll());
        OnmsStpNode stpnode = this.m_stpNodeDao.findByNodeAndVlan(ngsw108.getId(), Integer.valueOf(1));
        Assert.assertTrue((boolean)"00223ff00b7b".equals(stpnode.getBaseBridgeAddress()));
        Assert.assertEquals((long)8L, (long)stpnode.getBaseNumPorts().intValue());
        Assert.assertEquals((Object)OnmsStpNode.BridgeBaseType.TRANSPARENT_ONLY, (Object)stpnode.getBaseType());
        Assert.assertEquals((Object)OnmsStpNode.StpProtocolSpecification.IEEE8021D, (Object)stpnode.getStpProtocolSpecification());
        Assert.assertEquals((long)8L, (long)this.m_stpInterfaceDao.findAll().size());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.20.1.14", port=161, resource="classpath:linkd/nms7467/172.20.1.14-walk.txt")})
    public void testLinuxUbuntuCollection() throws Exception {
        this.m_nodeDao.save((Object)this.getLinuxUbuntu());
        this.m_nodeDao.flush();
        OnmsNode linux = this.m_nodeDao.findByForeignId("linkd", "linuxubuntu");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(linux.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(linux.getId().intValue()));
        Assert.assertEquals((long)1L, (long)this.m_linkd.getLinkableNodesOnPackage("example1").size());
        LinkableNode linkNode = (LinkableNode)this.m_linkd.getLinkableNodesOnPackage("example1").iterator().next();
        Assert.assertTrue((linkNode != null ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)linkNode.getRouteInterfaces().size());
        Assert.assertEquals((long)0L, (long)this.m_vlanDao.countAll());
        String packageName = this.m_linkdConfig.getFirstPackageMatch(InetAddressUtils.addr((String)"172.20.1.14")).getName();
        Assert.assertEquals((Object)"example1", (Object)packageName);
        Assert.assertEquals((Object)false, (Object)linkNode.isBridgeNode());
        Assert.assertEquals((long)0L, (long)linkNode.getBridgeIdentifiers().size());
        Assert.assertEquals((String)"cdp not supported", (long)0L, (long)linkNode.getCdpInterfaces().size());
        Set macAddresses = this.m_linkd.getMacAddressesOnPackage(packageName);
        Assert.assertNotNull((Object)macAddresses);
        Assert.assertEquals((long)1L, (long)macAddresses.size());
        List ats = this.m_linkd.getAtInterfaces(packageName, "406186e28b53");
        Assert.assertEquals((String)"should have saved 1 ip to mac", (long)1L, (long)ats.size());
        for (AtInterface at : ats) {
            if (at.getIpAddress().getHostAddress().equals("172.20.1.14")) {
                Assert.assertTrue((at.getIfIndex() == 4 ? 1 : 0) != 0);
                continue;
            }
            Assert.assertTrue((String)("ip: " + at.getIpAddress().getHostAddress() + "does not match any known ip address"), (boolean)false);
        }
        Assert.assertEquals((long)0L, (long)this.m_atInterfaceDao.findAll().size());
        Criteria criteria = new Criteria(OnmsIpRouteInterface.class);
        criteria.setAliases(Arrays.asList(new Alias("node", "node", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new EqRestriction("node.id", (Object)linux.getId()));
        List iproutes = this.m_ipRouteInterfaceDao.findMatching(criteria);
        for (OnmsIpRouteInterface iproute : iproutes) {
            System.out.println(iproute.getRouteDest() + "/" + iproute.getRouteMask() + "/" + iproute.getRouteNextHop() + "/" + iproute.getRouteIfIndex());
        }
        Assert.assertEquals((long)4L, (long)iproutes.size());
        Assert.assertEquals((long)0L, (long)this.m_vlanDao.findAll().size());
        Assert.assertEquals((long)0L, (long)this.m_stpNodeDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_stpInterfaceDao.findAll().size());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.20.1.28", port=161, resource="classpath:linkd/nms7467/172.20.1.28-walk.txt")})
    public void testDarwin108Collection() throws Exception {
        this.m_nodeDao.save((Object)this.getDarwin108());
        this.m_nodeDao.flush();
        Package example1 = this.m_linkdConfig.getPackage("example1");
        example1.setUseLldpDiscovery(false);
        example1.setUseOspfDiscovery(false);
        example1.setUseIsisDiscovery(false);
        this.m_linkdConfig.update();
        OnmsNode mac = this.m_nodeDao.findByForeignId("linkd", "mac");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(mac.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(mac.getId().intValue()));
        Assert.assertEquals((long)1L, (long)this.m_linkd.getLinkableNodesOnPackage("example1").size());
        LinkableNode linkNode = (LinkableNode)this.m_linkd.getLinkableNodesOnPackage("example1").iterator().next();
        Assert.assertTrue((linkNode != null ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)linkNode.getRouteInterfaces().size());
        Assert.assertEquals((long)0L, (long)this.m_vlanDao.countAll());
        String packageName = this.m_linkdConfig.getFirstPackageMatch(InetAddressUtils.addr((String)"172.20.1.28")).getName();
        Assert.assertEquals((Object)"example1", (Object)packageName);
        Assert.assertEquals((Object)false, (Object)linkNode.isBridgeNode());
        Assert.assertEquals((long)0L, (long)linkNode.getBridgeIdentifiers().size());
        Assert.assertEquals((String)"cdp not supported", (long)0L, (long)linkNode.getCdpInterfaces().size());
        Set macAddresses = this.m_linkd.getMacAddressesOnPackage(packageName);
        Assert.assertNotNull((Object)macAddresses);
        Assert.assertEquals((long)1L, (long)macAddresses.size());
        List ats = this.m_linkd.getAtInterfaces(packageName, "0026b0ed8fb8");
        Assert.assertNotNull((Object)ats);
        Assert.assertEquals((String)"should have saved 1 ip to mac", (long)1L, (long)ats.size());
        for (AtInterface at : ats) {
            if (at.getIpAddress().getHostAddress().equals("172.20.1.28")) {
                Assert.assertTrue((at.getIfIndex() == 4 ? 1 : 0) != 0);
                continue;
            }
            Assert.assertTrue((String)("ip: " + at.getIpAddress().getHostAddress() + "does not match any known ip address"), (boolean)false);
        }
        Assert.assertEquals((long)0L, (long)this.m_atInterfaceDao.findAll().size());
        Criteria criteria = new Criteria(OnmsIpRouteInterface.class);
        criteria.setAliases(Arrays.asList(new Alias("node", "node", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new EqRestriction("node.id", (Object)mac.getId()));
        List iproutes = this.m_ipRouteInterfaceDao.findMatching(criteria);
        for (OnmsIpRouteInterface iproute : iproutes) {
            System.out.println(iproute.getRouteDest() + "/" + iproute.getRouteMask() + "/" + iproute.getRouteNextHop() + "/" + iproute.getRouteIfIndex());
        }
        Assert.assertEquals((long)20L, (long)iproutes.size());
        Assert.assertEquals((long)0L, (long)this.m_vlanDao.findAll().size());
        Assert.assertEquals((long)0L, (long)this.m_stpNodeDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_stpInterfaceDao.findAll().size());
    }

    @Test
    public void testWorkStation() throws Exception {
        this.m_nodeDao.save((Object)this.getNodeWithoutSnmp("workstation", "172.20.1.101"));
        this.m_nodeDao.flush();
        OnmsNode workstation = this.m_nodeDao.findByForeignId("linkd", "workstation");
        Assert.assertTrue((!this.m_linkd.scheduleNodeCollection(workstation.getId().intValue()) ? 1 : 0) != 0);
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.20.1.28", port=161, resource="classpath:linkd/nms7467/172.20.1.28-walk.txt"), @JUnitSnmpAgent(host="172.20.1.8", port=161, resource="classpath:linkd/nms7467/172.20.1.8-walk.txt")})
    public void testLinkDarwinNetgear() throws Exception {
        this.m_nodeDao.save((Object)this.getNetGearSw108());
        this.m_nodeDao.save((Object)this.getDarwin108());
        this.m_nodeDao.flush();
        OnmsNode mac = this.m_nodeDao.findByForeignId("linkd", "mac");
        OnmsNode ngsw108 = this.m_nodeDao.findByForeignId("linkd", "ng108switch");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(mac.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(ngsw108.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(mac.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(ngsw108.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_dataLinkInterfaceDao.countAll());
        String macpackageName = this.m_linkdConfig.getFirstPackageMatch(InetAddressUtils.addr((String)"172.20.1.28")).getName();
        String ngsw108packageName = this.m_linkdConfig.getFirstPackageMatch(InetAddressUtils.addr((String)"172.20.1.8")).getName();
        Assert.assertEquals((Object)"example1", (Object)macpackageName);
        Assert.assertEquals((Object)"example1", (Object)ngsw108packageName);
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        List links = this.m_dataLinkInterfaceDao.findAll();
        Assert.assertEquals((long)1L, (long)links.size());
        DataLinkInterface mactongsw108link = (DataLinkInterface)links.get(0);
        Assert.assertEquals((Object)mac.getId(), (Object)mactongsw108link.getNode().getId());
        Assert.assertEquals((long)4L, (long)mactongsw108link.getIfIndex().intValue());
        Assert.assertEquals((Object)ngsw108.getId(), (Object)mactongsw108link.getNodeParentId());
        Assert.assertEquals((long)1L, (long)mactongsw108link.getParentIfIndex().intValue());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.20.1.7", port=161, resource="classpath:linkd/nms7467/172.20.1.7-walk.txt"), @JUnitSnmpAgent(host="172.20.1.8", port=161, resource="classpath:linkd/nms7467/172.20.1.8-walk.txt")})
    public void testLinkNetgearCiscoWs() throws Exception {
        Package example1 = this.m_linkdConfig.getPackage("example1");
        example1.setForceIpRouteDiscoveryOnEthernet(false);
        this.m_nodeDao.save((Object)this.getNetGearSw108());
        this.m_nodeDao.save((Object)this.getCiscoWsC2948());
        this.m_nodeDao.flush();
        OnmsNode ngsw108 = this.m_nodeDao.findByForeignId("linkd", "ng108switch");
        OnmsNode ciscows = this.m_nodeDao.findByForeignId("linkd", "ciscoswitch");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(ciscows.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(ngsw108.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(ciscows.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(ngsw108.getId().intValue()));
        String ciscowspackageName = this.m_linkdConfig.getFirstPackageMatch(InetAddressUtils.addr((String)"172.20.1.7")).getName();
        String ngsw108packageName = this.m_linkdConfig.getFirstPackageMatch(InetAddressUtils.addr((String)"172.20.1.8")).getName();
        Assert.assertEquals((long)0L, (long)this.m_dataLinkInterfaceDao.countAll());
        Assert.assertEquals((Object)"example1", (Object)ciscowspackageName);
        Assert.assertEquals((Object)"example1", (Object)ngsw108packageName);
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        List links = this.m_dataLinkInterfaceDao.findAll();
        for (DataLinkInterface link : links) {
            this.printLink(link);
        }
        Assert.assertEquals((long)1L, (long)links.size());
        DataLinkInterface ngsw108linktociscows = (DataLinkInterface)links.get(0);
        Assert.assertEquals((Object)ngsw108.getId(), (Object)ngsw108linktociscows.getNode().getId());
        Assert.assertEquals((long)8L, (long)ngsw108linktociscows.getIfIndex().intValue());
        Assert.assertEquals((Object)ciscows.getId(), (Object)ngsw108linktociscows.getNodeParentId());
        Assert.assertEquals((long)9L, (long)ngsw108linktociscows.getParentIfIndex().intValue());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.20.1.7", port=161, resource="classpath:linkd/nms7467/172.20.1.7-walk.txt"), @JUnitSnmpAgent(host="172.20.1.14", port=161, resource="classpath:linkd/nms7467/172.20.1.14-walk.txt")})
    public void testLinuxUbuntuCiscoWs() throws Exception {
        this.m_nodeDao.save((Object)this.getLinuxUbuntu());
        this.m_nodeDao.save((Object)this.getCiscoWsC2948());
        this.m_nodeDao.flush();
        OnmsNode linuxubuntu = this.m_nodeDao.findByForeignId("linkd", "linuxubuntu");
        OnmsNode ciscows = this.m_nodeDao.findByForeignId("linkd", "ciscoswitch");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(ciscows.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(linuxubuntu.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(ciscows.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(linuxubuntu.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_dataLinkInterfaceDao.countAll());
        String ciscowspackageName = this.m_linkdConfig.getFirstPackageMatch(InetAddressUtils.addr((String)"172.20.1.7")).getName();
        String linuxubuntupackageName = this.m_linkdConfig.getFirstPackageMatch(InetAddressUtils.addr((String)"172.20.1.14")).getName();
        Assert.assertEquals((Object)"example1", (Object)ciscowspackageName);
        Assert.assertEquals((Object)"example1", (Object)linuxubuntupackageName);
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        List links = this.m_dataLinkInterfaceDao.findAll();
        Assert.assertEquals((long)1L, (long)links.size());
        DataLinkInterface linuxubuntulinktociscows = (DataLinkInterface)links.get(0);
        Assert.assertEquals((Object)linuxubuntu.getId(), (Object)linuxubuntulinktociscows.getNode().getId());
        Assert.assertEquals((long)4L, (long)linuxubuntulinktociscows.getIfIndex().intValue());
        Assert.assertEquals((Object)ciscows.getId(), (Object)linuxubuntulinktociscows.getNodeParentId());
        Assert.assertEquals((long)11L, (long)linuxubuntulinktociscows.getParentIfIndex().intValue());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.20.1.7", port=161, resource="classpath:linkd/nms7467/172.20.1.7-walk.txt")})
    public void testWorkstationCiscoWs() throws Exception {
        this.m_nodeDao.save((Object)this.getNodeWithoutSnmp("workstation", "172.20.1.101"));
        this.m_nodeDao.save((Object)this.getCiscoWsC2948());
        this.m_nodeDao.flush();
        OnmsNode workstation = this.m_nodeDao.findByForeignId("linkd", "workstation");
        OnmsNode ciscows = this.m_nodeDao.findByForeignId("linkd", "ciscoswitch");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(ciscows.getId().intValue()));
        Assert.assertTrue((!this.m_linkd.scheduleNodeCollection(workstation.getId().intValue()) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(ciscows.getId().intValue()));
        Assert.assertEquals((long)1L, (long)this.m_linkd.getLinkableNodesOnPackage("example1").size());
        LinkableNode linkNode = (LinkableNode)this.m_linkd.getLinkableNodesOnPackage("example1").iterator().next();
        Assert.assertTrue((linkNode != null ? 1 : 0) != 0);
        Set macAddresses = this.m_linkd.getMacAddressesOnPackage("example1");
        Assert.assertEquals((long)2L, (long)macAddresses.size());
        List ats = this.m_linkd.getAtInterfaces("example1", "60334b0817a8");
        Assert.assertEquals((long)1L, (long)ats.size());
        Assert.assertEquals((long)0L, (long)this.m_dataLinkInterfaceDao.countAll());
        String ciscowspackageName = this.m_linkdConfig.getFirstPackageMatch(InetAddressUtils.addr((String)"172.20.1.7")).getName();
        Assert.assertEquals((Object)"example1", (Object)ciscowspackageName);
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        List links = this.m_dataLinkInterfaceDao.findAll();
        Assert.assertEquals((long)1L, (long)links.size());
        DataLinkInterface workstationlinktociscows = (DataLinkInterface)links.get(0);
        Assert.assertEquals((Object)workstation.getId(), (Object)workstationlinktociscows.getNode().getId());
        Assert.assertEquals((long)-1L, (long)workstationlinktociscows.getIfIndex().intValue());
        Assert.assertEquals((Object)ciscows.getId(), (Object)workstationlinktociscows.getNodeParentId());
        Assert.assertEquals((long)47L, (long)workstationlinktociscows.getParentIfIndex().intValue());
    }

    @Test
    public void testGetNodeidFromIp() throws UnknownHostException, SQLException {
        this.m_nodeDao.save((Object)this.getCiscoC870());
        this.m_nodeDao.flush();
        HibernateEventWriter db = (HibernateEventWriter)this.m_linkd.getQueryManager();
        OnmsNode node = (OnmsNode)db.getNodeidFromIp(InetAddressUtils.addr((String)"172.20.1.1")).get(0);
        Assert.assertEquals((Object)this.m_nodeDao.findByForeignId("linkd", "mrmakay.internal.opennms.com").getId(), (Object)node.getId());
    }

    @Test
    @Transactional
    public void testGetIfIndexByName() throws SQLException {
        this.m_nodeDao.save((Object)this.getCiscoC870());
        this.m_nodeDao.save((Object)this.getCiscoWsC2948());
        this.m_nodeDao.flush();
        OnmsNode ciscorouter = this.m_nodeDao.findByForeignId("linkd", "mrmakay.internal.opennms.com");
        Assert.assertEquals((Object)"FastEthernet2", (Object)ciscorouter.getSnmpInterfaceWithIfIndex(3).getIfDescr());
        OnmsNode ciscosw = this.m_nodeDao.findByForeignId("linkd", "ciscoswitch");
        Assert.assertEquals((Object)"2/44", (Object)ciscosw.getSnmpInterfaceWithIfIndex(52).getIfName());
        HibernateEventWriter db = (HibernateEventWriter)this.m_linkd.getQueryManager();
        Assert.assertEquals((long)3L, (long)db.getIfIndexByName(ciscorouter.getId().intValue(), "FastEthernet2"));
        Assert.assertEquals((long)52L, (long)db.getIfIndexByName(ciscosw.getId().intValue(), "2/44"));
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.20.1.7", port=161, resource="classpath:linkd/nms7467/172.20.1.7-walk.txt"), @JUnitSnmpAgent(host="172.20.1.1", port=161, resource="classpath:linkd/nms7467/172.20.1.1-walk.txt")})
    public void testCiscoRouterCiscoWsUsingCdp() throws Exception {
        Package example1 = this.m_linkdConfig.getPackage("example1");
        example1.setUseLldpDiscovery(false);
        example1.setUseOspfDiscovery(false);
        example1.setUseIpRouteDiscovery(false);
        example1.setUseBridgeDiscovery(false);
        example1.setUseIsisDiscovery(false);
        example1.setUseCdpDiscovery(true);
        example1.setSaveRouteTable(false);
        example1.setSaveStpNodeTable(false);
        example1.setSaveStpInterfaceTable(false);
        example1.setEnableVlanDiscovery(false);
        this.m_nodeDao.save((Object)this.getCiscoC870());
        this.m_nodeDao.save((Object)this.getCiscoWsC2948());
        this.m_nodeDao.flush();
        Assert.assertEquals((long)2L, (long)this.m_nodeDao.countAll());
        OnmsNode ciscorouter = this.m_nodeDao.findByForeignId("linkd", "mrmakay.internal.opennms.com");
        OnmsNode ciscows = this.m_nodeDao.findByForeignId("linkd", "ciscoswitch");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(ciscows.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(ciscorouter.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(ciscows.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(ciscorouter.getId().intValue()));
        Collection linkables = this.m_linkd.getLinkableNodesOnPackage("example1");
        Assert.assertEquals((long)2L, (long)linkables.size());
        for (LinkableNode lnode : linkables) {
            Assert.assertEquals((Object)true, (Object)lnode.hasCdpInterfaces());
            Assert.assertEquals((long)1L, (long)lnode.getCdpInterfaces().size());
        }
        Assert.assertEquals((long)0L, (long)this.m_dataLinkInterfaceDao.countAll());
        Assert.assertEquals((long)2L, (long)this.m_linkd.getLinkableNodesOnPackage("example1").size());
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        List links = this.m_dataLinkInterfaceDao.findAll();
        Assert.assertEquals((long)1L, (long)links.size());
        DataLinkInterface link = (DataLinkInterface)links.get(0);
        this.printLink(link);
        Assert.assertEquals((Object)ciscows.getId(), (Object)link.getNode().getId());
        Assert.assertEquals((long)52L, (long)link.getIfIndex().intValue());
        Assert.assertEquals((Object)ciscorouter.getId(), (Object)link.getNodeParentId());
        Assert.assertEquals((long)3L, (long)link.getParentIfIndex().intValue());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.20.1.7", port=161, resource="classpath:linkd/nms7467/172.20.1.7-walk.txt")})
    public void testCiscoAccessPointCiscoWsUsingCdp() throws Exception {
        Package example1 = this.m_linkdConfig.getPackage("example1");
        example1.setUseLldpDiscovery(false);
        example1.setUseOspfDiscovery(false);
        example1.setUseIpRouteDiscovery(false);
        example1.setUseBridgeDiscovery(false);
        example1.setUseIsisDiscovery(false);
        example1.setUseCdpDiscovery(true);
        example1.setSaveRouteTable(false);
        example1.setSaveStpNodeTable(false);
        example1.setSaveStpInterfaceTable(false);
        example1.setEnableVlanDiscovery(false);
        this.m_nodeDao.save((Object)this.getCiscoWsC2948());
        this.m_nodeDao.save((Object)this.getNodeWithoutSnmp("mrgarrison.internal.opennms.com", "172.20.1.5"));
        this.m_nodeDao.flush();
        Assert.assertEquals((long)2L, (long)this.m_nodeDao.countAll());
        OnmsNode ciscoap = this.m_nodeDao.findByForeignId("linkd", "mrgarrison.internal.opennms.com");
        OnmsNode ciscows = this.m_nodeDao.findByForeignId("linkd", "ciscoswitch");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(ciscows.getId().intValue()));
        Assert.assertTrue((!this.m_linkd.scheduleNodeCollection(ciscoap.getId().intValue()) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(ciscows.getId().intValue()));
        Collection linkables = this.m_linkd.getLinkableNodesOnPackage("example1");
        Assert.assertEquals((long)1L, (long)linkables.size());
        for (LinkableNode lnode : linkables) {
            if (ciscows.getId().intValue() == lnode.getNodeId()) {
                Assert.assertEquals((Object)true, (Object)lnode.hasCdpInterfaces());
                Assert.assertEquals((long)2L, (long)lnode.getCdpInterfaces().size());
                continue;
            }
            Assert.assertTrue((String)"Found node not added!!!!!", (boolean)false);
        }
        Assert.assertEquals((long)0L, (long)this.m_dataLinkInterfaceDao.countAll());
        Assert.assertEquals((long)1L, (long)this.m_linkd.getLinkableNodesOnPackage("example1").size());
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        List links = this.m_dataLinkInterfaceDao.findAll();
        Assert.assertEquals((long)1L, (long)links.size());
        DataLinkInterface ciscoaplinktociscows = (DataLinkInterface)links.get(0);
        Assert.assertEquals((Object)ciscoap.getId(), (Object)ciscoaplinktociscows.getNode().getId());
        Assert.assertEquals((long)-1L, (long)ciscoaplinktociscows.getIfIndex().intValue());
        Assert.assertEquals((Object)ciscows.getId(), (Object)ciscoaplinktociscows.getNodeParentId());
        Assert.assertEquals((long)47L, (long)ciscoaplinktociscows.getParentIfIndex().intValue());
    }
}

