/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgents;
import org.opennms.netmgt.capsd.Capsd;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.linkd.Nms7467NetworkBuilder;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-capsd.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "classpath:/META-INF/opennms/capsdTest.xml", "classpath:/META-INF/opennms/applicationContext-proxy-snmp.xml"})
@JUnitConfigurationEnvironment(systemProperties={"org.opennms.provisiond.enableDiscovery=false"})
@JUnitTemporaryDatabase
public class Nms7467CapsdIntegrationTest
implements InitializingBean {
    @Autowired
    private IpInterfaceDao m_interfaceDao;
    @Autowired
    private Capsd m_capsd;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() throws Exception {
        Assert.assertTrue((String)"Capsd must not be null", (this.m_capsd != null ? 1 : 0) != 0);
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.20.1.7", port=161, resource="classpath:linkd/nms7467/172.20.1.7-walk.txt")})
    @Transactional
    public final void testCiscoWSC2948CapsdCollection() throws MarshalException, ValidationException, IOException {
        this.m_capsd.init();
        this.m_capsd.start();
        this.m_capsd.scanSuspectInterface("172.20.1.7");
        List ips = this.m_interfaceDao.findByIpAddress("172.20.1.7");
        Assert.assertTrue((String)"Has only one ip interface", (ips.size() == 1 ? 1 : 0) != 0);
        OnmsIpInterface ip = (OnmsIpInterface)ips.get(0);
        Assert.assertTrue((String)("The ifindex" + ip.getIfIndex() + " is not equal to 3"), (ip.getIfIndex() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)"The snmp interface is null", (ip.getSnmpInterface() != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"The mac address is null", (ip.getSnmpInterface().getPhysAddr() != null ? 1 : 0) != 0);
        Assert.assertTrue((String)("The mac address: " + ip.getSnmpInterface().getPhysAddr() + ",  is not corresponding to 0002baaacffe"), (boolean)ip.getSnmpInterface().getPhysAddr().equals("0002baaacffe"));
        for (OnmsSnmpInterface snmpinterface : ip.getNode().getSnmpInterfaces()) {
            Assert.assertTrue((String)"The mac address is null", (snmpinterface.getPhysAddr() != null ? 1 : 0) != 0);
            Assert.assertTrue((String)"The mac must be valid", (snmpinterface.getPhysAddr().length() == 12 ? 1 : 0) != 0);
            Assert.assertTrue((String)("The mac for ifindex" + snmpinterface.getIfIndex() + " must correspond: " + snmpinterface.getPhysAddr()), (boolean)snmpinterface.getPhysAddr().equals(Nms7467NetworkBuilder.CISCO_WS_C2948_IF_MAC_MAP.get(snmpinterface.getIfIndex())));
        }
        this.m_capsd.stop();
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.20.1.8", port=161, resource="classpath:linkd/nms7467/172.20.1.8-walk.txt")})
    @Transactional
    public final void testNETGEARSW108CapsdCollection() throws MarshalException, ValidationException, IOException {
        this.m_capsd.init();
        this.m_capsd.start();
        this.m_capsd.scanSuspectInterface("172.20.1.8");
        List ips = this.m_interfaceDao.findByIpAddress("172.20.1.8");
        Assert.assertTrue((String)"Has only one ip interface", (ips.size() == 1 ? 1 : 0) != 0);
        OnmsIpInterface ip = (OnmsIpInterface)ips.get(0);
        Assert.assertTrue((String)("The ifindex " + ip.getIfIndex() + " is not equal to 1"), (ip.getIfIndex() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"The snmp interface is null", (ip.getSnmpInterface() != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"The mac address is null", (ip.getSnmpInterface().getPhysAddr() != null ? 1 : 0) != 0);
        Assert.assertTrue((String)("The mac address: " + ip.getSnmpInterface().getPhysAddr() + ",  is not corresponding to 00223ff00b7c"), (boolean)ip.getSnmpInterface().getPhysAddr().equals("00223ff00b7c"));
        for (OnmsSnmpInterface snmpinterface : ip.getNode().getSnmpInterfaces()) {
            Assert.assertTrue((String)"The mac address is null", (snmpinterface.getPhysAddr() != null ? 1 : 0) != 0);
            Assert.assertTrue((String)"The mac must be valid", (snmpinterface.getPhysAddr().length() == 12 ? 1 : 0) != 0);
            Assert.assertTrue((String)"The mac for ifindex must correspond", (boolean)snmpinterface.getPhysAddr().equals(Nms7467NetworkBuilder.NETGEAR_SW_108_IF_MAC_MAP.get(snmpinterface.getIfIndex())));
        }
        this.m_capsd.stop();
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.255.255.2", port=161, resource="classpath:linkd/nms7467/172.20.1.1-walk.txt")})
    @Transactional
    public final void testCISCO870CapsdCollection() throws MarshalException, ValidationException, IOException {
        this.m_capsd.init();
        this.m_capsd.start();
        this.m_capsd.scanSuspectInterface("10.255.255.2");
        OnmsIpInterface ipmain = (OnmsIpInterface)this.m_interfaceDao.findByIpAddress("10.255.255.2").get(0);
        Assert.assertTrue((String)"should have a master not null ip interface ", (ipmain != null ? 1 : 0) != 0);
        Set ifs = ipmain.getNode().getIpInterfaces();
        Assert.assertTrue((String)("Should have 4 ip interface. Found: " + ifs.size()), (ifs.size() == 4 ? 1 : 0) != 0);
        for (OnmsIpInterface ipinterface : ifs) {
            Assert.assertTrue((String)("The ifindex should not be null for ipaddress: " + ipinterface.getIpHostName()), (ipinterface.getIfIndex() != null ? 1 : 0) != 0);
            Assert.assertTrue((String)("The ifindex is not corresponding: found: " + ipinterface.getIfIndex() + " should be: " + Nms7467NetworkBuilder.CISCO_C870_IP_IF_MAP.get(ipinterface.getIpAddress())), (ipinterface.getIfIndex().intValue() == Nms7467NetworkBuilder.CISCO_C870_IP_IF_MAP.get(ipinterface.getIpAddress()).intValue() ? 1 : 0) != 0);
            Assert.assertTrue((String)"The snmp interface is null", (ipinterface.getSnmpInterface() != null ? 1 : 0) != 0);
            Assert.assertTrue((String)"The mac address is null", (ipinterface.getSnmpInterface().getPhysAddr() != null ? 1 : 0) != 0);
            Assert.assertTrue((String)"The mac address is not corresponding", (boolean)ipinterface.getSnmpInterface().getPhysAddr().equals(Nms7467NetworkBuilder.CISCO_C870_IF_MAC_MAP.get(ipinterface.getIfIndex())));
        }
        Assert.assertTrue((String)"Has 16 snmp interface", (ipmain.getNode().getSnmpInterfaces().size() == 16 ? 1 : 0) != 0);
        this.m_capsd.stop();
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.20.1.14", port=161, resource="classpath:linkd/nms7467/172.20.1.14-walk.txt")})
    @Transactional
    public final void testLINUXUBUNTUCapsdCollection() throws MarshalException, ValidationException, IOException {
        this.m_capsd.init();
        this.m_capsd.start();
        this.m_capsd.scanSuspectInterface("172.20.1.14");
        OnmsIpInterface ipmain = (OnmsIpInterface)this.m_interfaceDao.findByIpAddress("172.20.1.14").get(0);
        Assert.assertTrue((String)"Should have 1 ip master interface", (ipmain != null ? 1 : 0) != 0);
        Set ifs = ipmain.getNode().getIpInterfaces();
        Assert.assertTrue((String)"should have 2 ipinterface", (ifs.size() == 2 ? 1 : 0) != 0);
        for (OnmsIpInterface ip : ifs) {
            Assert.assertTrue((String)"The if index should not be null", (ip.getIfIndex() != null ? 1 : 0) != 0);
            Assert.assertTrue((String)"The ifindex is not corresponding: ", (ip.getIfIndex().intValue() == Nms7467NetworkBuilder.LINUX_UBUNTU_IP_IF_MAP.get(ip.getIpAddress()).intValue() ? 1 : 0) != 0);
            Assert.assertTrue((String)"The snmp interface is null", (ip.getSnmpInterface() != null ? 1 : 0) != 0);
            Assert.assertTrue((String)"The mac address is null", (ip.getSnmpInterface().getPhysAddr() != null ? 1 : 0) != 0);
            Assert.assertTrue((String)"The mac address is not corresponding", (boolean)ip.getSnmpInterface().getPhysAddr().equals(Nms7467NetworkBuilder.LINUX_UBUNTU_IF_MAC_MAP.get(ip.getIfIndex())));
        }
        Set snmpifs = ipmain.getNode().getSnmpInterfaces();
        Assert.assertTrue((String)("Has 6 snmp interface. Found: " + snmpifs.size()), (snmpifs.size() == 6 ? 1 : 0) != 0);
        for (OnmsSnmpInterface snmpinterface : snmpifs) {
            if (snmpinterface.getIfIndex() == 1) {
                Assert.assertTrue((String)"The mac address is not null for ifindex 1", (snmpinterface.getPhysAddr() == null ? 1 : 0) != 0);
                continue;
            }
            Assert.assertTrue((String)"The mac must be valid", (snmpinterface.getPhysAddr().length() == 12 ? 1 : 0) != 0);
            Assert.assertTrue((String)"The mac for ifindex must correspond", (boolean)snmpinterface.getPhysAddr().equals(Nms7467NetworkBuilder.LINUX_UBUNTU_IF_MAC_MAP.get(snmpinterface.getIfIndex())));
        }
        this.m_capsd.stop();
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.20.1.28", port=161, resource="classpath:linkd/nms7467/172.20.1.28-walk.txt")})
    @Transactional
    public final void testDARWIN108CapsdCollection() throws MarshalException, ValidationException, IOException {
        this.m_capsd.init();
        this.m_capsd.start();
        this.m_capsd.scanSuspectInterface("172.20.1.28");
        List ips = this.m_interfaceDao.findByIpAddress("172.20.1.28");
        Assert.assertTrue((String)"Has one ip primary interface", (ips.size() == 1 ? 1 : 0) != 0);
        OnmsIpInterface ip = (OnmsIpInterface)ips.get(0);
        Assert.assertTrue((String)"ipinterface is not null", (ip != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"has ifindex", (ip.getIfIndex() != null ? 1 : 0) != 0);
        Assert.assertTrue((String)("The ifindex" + ip.getIfIndex() + " is not equal to 4"), (ip.getIfIndex() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((String)"The snmp interface is null", (ip.getSnmpInterface() != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"The mac address is null", (ip.getSnmpInterface().getPhysAddr() != null ? 1 : 0) != 0);
        Assert.assertTrue((String)("The mac address: " + ip.getSnmpInterface().getPhysAddr() + ",  is not corresponding to 0026b0ed8fb8"), (boolean)ip.getSnmpInterface().getPhysAddr().equals("0026b0ed8fb8"));
        for (OnmsSnmpInterface snmpinterface : ip.getNode().getSnmpInterfaces()) {
            if (snmpinterface.getIfIndex() <= 3) {
                Assert.assertTrue((String)("The mac address is not null for ifindex " + snmpinterface.getIfIndex()), (snmpinterface.getPhysAddr() == null ? 1 : 0) != 0);
                continue;
            }
            Assert.assertTrue((String)"The mac address is null", (snmpinterface.getPhysAddr() != null ? 1 : 0) != 0);
            Assert.assertTrue((String)"The mac must be valid", (snmpinterface.getPhysAddr().length() == 12 ? 1 : 0) != 0);
            Assert.assertTrue((String)("The mac for ifindex must correspond: " + snmpinterface.getPhysAddr()), (boolean)snmpinterface.getPhysAddr().equals(Nms7467NetworkBuilder.DARWIN_10_8_IF_MAC_MAP.get(snmpinterface.getIfIndex())));
        }
        this.m_capsd.stop();
    }
}

