/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgents;
import org.opennms.netmgt.config.linkd.Package;
import org.opennms.netmgt.linkd.Nms4930NetworkBuilder;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsNode;

public class Nms4930Test
extends Nms4930NetworkBuilder {
    @Before
    public void setUpNetwork4005() throws Exception {
        this.buildNetwork4930();
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.1.1.2", port=161, resource="classpath:linkd/nms4930/dlink_DES-3026.properties"), @JUnitSnmpAgent(host="10.1.2.2", port=161, resource="classpath:linkd/nms4930/dlink_DGS-3612G.properties")})
    public void testNms4930Network() throws Exception {
        Package example1 = this.m_linkdConfig.getPackage("example1");
        example1.setUseLldpDiscovery(false);
        example1.setUseOspfDiscovery(false);
        example1.setUseCdpDiscovery(false);
        example1.setUseIpRouteDiscovery(false);
        example1.setUseBridgeDiscovery(true);
        example1.setUseIsisDiscovery(false);
        example1.setSaveRouteTable(false);
        example1.setEnableVlanDiscovery(false);
        OnmsNode cisco1 = this.m_nodeDao.findByForeignId("linkd", "cisco1");
        OnmsNode cisco2 = this.m_nodeDao.findByForeignId("linkd", "cisco2");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        List ifaces = this.m_dataLinkInterfaceDao.findAll();
        for (DataLinkInterface link : ifaces) {
            this.printLink(link);
        }
        Assert.assertEquals((String)"we should have found no links", (long)0L, (long)ifaces.size());
    }
}

