/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgents;
import org.opennms.netmgt.config.linkd.Package;
import org.opennms.netmgt.linkd.Nms4005NetworkBuilder;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsNode;

public class Nms4005Test
extends Nms4005NetworkBuilder {
    @Before
    public void setUpForceIpRouteOnEthernet() throws Exception {
        for (Package pkg : Collections.list(this.m_linkdConfig.enumeratePackage())) {
            pkg.setForceIpRouteDiscoveryOnEthernet(true);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.1.1.2", port=161, resource="classpath:linkd/nms4005/10.1.1.2-walk.txt"), @JUnitSnmpAgent(host="10.1.2.2", port=161, resource="classpath:linkd/nms4005/10.1.2.2-walk.txt"), @JUnitSnmpAgent(host="10.1.3.2", port=161, resource="classpath:linkd/nms4005/10.1.3.2-walk.txt"), @JUnitSnmpAgent(host="10.1.4.2", port=161, resource="classpath:linkd/nms4005/10.1.4.2-walk.txt")})
    public void testNms4005Network() throws Exception {
        this.m_nodeDao.save((Object)this.getR1());
        this.m_nodeDao.save((Object)this.getR2());
        this.m_nodeDao.save((Object)this.getR3());
        this.m_nodeDao.save((Object)this.getR4());
        OnmsNode cisco1 = this.m_nodeDao.findByForeignId("linkd", "R1");
        OnmsNode cisco2 = this.m_nodeDao.findByForeignId("linkd", "R2");
        OnmsNode cisco3 = this.m_nodeDao.findByForeignId("linkd", "R3");
        OnmsNode cisco4 = this.m_nodeDao.findByForeignId("linkd", "R4");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco3.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco4.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco3.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco4.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        List ifaces = this.m_dataLinkInterfaceDao.findAll();
        for (DataLinkInterface link : ifaces) {
            this.printLink(link);
        }
        Assert.assertEquals((String)"we should have found 4 data links", (long)4L, (long)ifaces.size());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco3.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco4.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        Assert.assertEquals((String)"we should have found 4 data links", (long)4L, (long)ifaces.size());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.1.1.2", port=161, resource="classpath:linkd/nms4005/10.1.1.2-walk.txt"), @JUnitSnmpAgent(host="10.1.2.2", port=161, resource="classpath:linkd/nms4005/10.1.2.2-walk.txt"), @JUnitSnmpAgent(host="10.1.3.2", port=161, resource="classpath:linkd/nms4005/10.1.3.2-walk.txt"), @JUnitSnmpAgent(host="10.1.4.2", port=161, resource="classpath:linkd/nms4005/10.1.4.2-walk.txt")})
    public void testNms4005NetworkWithThreads() throws Exception {
        Thread thread2;
        this.m_nodeDao.save((Object)this.getR1());
        this.m_nodeDao.save((Object)this.getR2());
        this.m_nodeDao.save((Object)this.getR3());
        this.m_nodeDao.save((Object)this.getR4());
        final OnmsNode cisco1 = this.m_nodeDao.findByForeignId("linkd", "R1");
        final OnmsNode cisco2 = this.m_nodeDao.findByForeignId("linkd", "R2");
        final OnmsNode cisco3 = this.m_nodeDao.findByForeignId("linkd", "R3");
        final OnmsNode cisco4 = this.m_nodeDao.findByForeignId("linkd", "R4");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco3.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco4.getId().intValue()));
        int NUMBER_OF_THREADS = 20;
        ArrayList<Thread> waitForMe = new ArrayList<Thread>();
        for (int i = 0; i < 20; ++i) {
            thread2 = new Thread("NMS-4005-Test-Thread-" + i){

                @Override
                public void run() {
                    Assert.assertTrue((boolean)Nms4005Test.this.m_linkd.runSingleSnmpCollection(cisco1.getId().intValue()));
                }
            };
            thread2.start();
            waitForMe.add(thread2);
        }
        for (Thread thread2 : waitForMe) {
            thread2.join();
        }
        waitForMe.clear();
        for (int i = 0; i < 20; ++i) {
            thread2 = new Thread("NMS-4005-Test-Thread-" + i){

                @Override
                public void run() {
                    Assert.assertTrue((boolean)Nms4005Test.this.m_linkd.runSingleSnmpCollection(cisco2.getId().intValue()));
                }
            };
            thread2.start();
            waitForMe.add(thread2);
        }
        for (Thread thread2 : waitForMe) {
            thread2.join();
        }
        waitForMe.clear();
        for (int i = 0; i < 20; ++i) {
            thread2 = new Thread("NMS-4005-Test-Thread-" + i){

                @Override
                public void run() {
                    Assert.assertTrue((boolean)Nms4005Test.this.m_linkd.runSingleSnmpCollection(cisco3.getId().intValue()));
                }
            };
            thread2.start();
            waitForMe.add(thread2);
        }
        for (Thread thread2 : waitForMe) {
            thread2.join();
        }
        waitForMe.clear();
        for (int i = 0; i < 20; ++i) {
            thread2 = new Thread("NMS-4005-Test-Thread-" + i){

                @Override
                public void run() {
                    Assert.assertTrue((boolean)Nms4005Test.this.m_linkd.runSingleSnmpCollection(cisco4.getId().intValue()));
                }
            };
            thread2.start();
            waitForMe.add(thread2);
        }
        for (Thread thread2 : waitForMe) {
            thread2.join();
        }
        waitForMe.clear();
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        List ifaces = this.m_dataLinkInterfaceDao.findAll();
        for (DataLinkInterface link : ifaces) {
            this.printLink(link);
        }
        Assert.assertEquals((String)"we should have found 4 data links", (long)4L, (long)ifaces.size());
    }
}

