/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgents;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.config.linkd.Package;
import org.opennms.netmgt.linkd.LinkableNode;
import org.opennms.netmgt.linkd.Nms17216NetworkBuilder;
import org.opennms.netmgt.linkd.snmp.CdpCacheTable;
import org.opennms.netmgt.linkd.snmp.CdpCacheTableEntry;
import org.opennms.netmgt.linkd.snmp.CdpInterfaceTable;
import org.opennms.netmgt.linkd.snmp.CdpInterfaceTableEntry;
import org.opennms.netmgt.linkd.snmp.CiscoVlanTable;
import org.opennms.netmgt.linkd.snmp.CiscoVlanTableEntry;
import org.opennms.netmgt.linkd.snmp.LldpLocTable;
import org.opennms.netmgt.linkd.snmp.LldpLocTableEntry;
import org.opennms.netmgt.linkd.snmp.LldpLocalGroup;
import org.opennms.netmgt.linkd.snmp.LldpRemTable;
import org.opennms.netmgt.linkd.snmp.LldpRemTableEntry;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpStore;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpWalker;

public class Nms17216Test
extends Nms17216NetworkBuilder {
    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.1", port=161, resource="classpath:linkd/nms17216/switch1-walk.txt")})
    public void testSwitch1CdpCacheTableCollection() throws Exception {
        String name = "cdpCacheTable";
        CdpCacheTable m_cdpCacheTable = new CdpCacheTable(InetAddressUtils.addr((String)"172.16.10.1"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_cdpCacheTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.10.1"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertEquals((long)5L, (long)m_cdpCacheTable.size());
        for (CdpCacheTableEntry cdpCacheTableEntry : m_cdpCacheTable) {
            this.printCdpRow(cdpCacheTableEntry);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.2", port=161, resource="classpath:linkd/nms17216/switch2-walk.txt")})
    public void testSwitch2CdpCacheTableCollection() throws Exception {
        String name = "cdpCacheTable";
        CdpCacheTable m_cdpCacheTable = new CdpCacheTable(InetAddressUtils.addr((String)"172.16.10.2"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_cdpCacheTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.10.2"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertEquals((long)6L, (long)m_cdpCacheTable.size());
        for (CdpCacheTableEntry cdpCacheTableEntry : m_cdpCacheTable) {
            this.printCdpRow(cdpCacheTableEntry);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.3", port=161, resource="classpath:linkd/nms17216/switch3-walk.txt")})
    public void testSwitch3CdpCacheTableCollection() throws Exception {
        String name = "cdpCacheTable";
        CdpCacheTable m_cdpCacheTable = new CdpCacheTable(InetAddressUtils.addr((String)"172.16.10.3"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_cdpCacheTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.10.3"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertEquals((long)4L, (long)m_cdpCacheTable.size());
        for (CdpCacheTableEntry cdpCacheTableEntry : m_cdpCacheTable) {
            this.printCdpRow(cdpCacheTableEntry);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.50.2", port=161, resource="classpath:linkd/nms17216/switch4-walk.txt")})
    public void testSwitch4CdpCacheTableCollection() throws Exception {
        String name = "cdpCacheTable";
        CdpCacheTable m_cdpCacheTable = new CdpCacheTable(InetAddressUtils.addr((String)"172.16.50.2"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_cdpCacheTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.50.2"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)m_cdpCacheTable.size());
        for (CdpCacheTableEntry cdpCacheTableEntry : m_cdpCacheTable) {
            this.printCdpRow(cdpCacheTableEntry);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.4", port=161, resource="classpath:linkd/nms17216/switch5-walk.txt")})
    public void testSwitch5CdpCacheTableCollection() throws Exception {
        String name = "cdpCacheTable";
        CdpCacheTable m_cdpCacheTable = new CdpCacheTable(InetAddressUtils.addr((String)"172.16.10.4"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_cdpCacheTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.10.4"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertEquals((long)2L, (long)m_cdpCacheTable.size());
        for (CdpCacheTableEntry cdpCacheTableEntry : m_cdpCacheTable) {
            this.printCdpRow(cdpCacheTableEntry);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.168.100.245", port=161, resource="classpath:linkd/nms17216/router1-walk.txt")})
    public void testRouter1CdpCacheTableCollection() throws Exception {
        String name = "cdpCacheTable";
        CdpCacheTable m_cdpCacheTable = new CdpCacheTable(InetAddressUtils.addr((String)"192.168.100.245"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_cdpCacheTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"192.168.100.245"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertEquals((long)2L, (long)m_cdpCacheTable.size());
        for (CdpCacheTableEntry cdpCacheTableEntry : m_cdpCacheTable) {
            this.printCdpRow(cdpCacheTableEntry);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.168.100.241", port=161, resource="classpath:linkd/nms17216/router2-walk.txt")})
    public void testRouter2CdpCacheTableCollection() throws Exception {
        String name = "cdpCacheTable";
        CdpCacheTable m_cdpCacheTable = new CdpCacheTable(InetAddressUtils.addr((String)"192.168.100.241"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_cdpCacheTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"192.168.100.241"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertEquals((long)2L, (long)m_cdpCacheTable.size());
        for (CdpCacheTableEntry cdpCacheTableEntry : m_cdpCacheTable) {
            this.printCdpRow(cdpCacheTableEntry);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.50.1", port=161, resource="classpath:linkd/nms17216/router3-walk.txt")})
    public void testRouter3CdpCacheTableCollection() throws Exception {
        String name = "cdpCacheTable";
        CdpCacheTable m_cdpCacheTable = new CdpCacheTable(InetAddressUtils.addr((String)"172.16.50.1"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_cdpCacheTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.50.1"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertEquals((long)3L, (long)m_cdpCacheTable.size());
        for (CdpCacheTableEntry cdpCacheTableEntry : m_cdpCacheTable) {
            this.printCdpRow(cdpCacheTableEntry);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.10.10.1", port=161, resource="classpath:linkd/nms17216/router4-walk.txt")})
    public void testRouter4CdpCacheTableCollection() throws Exception {
        String name = "cdpCacheTable";
        CdpCacheTable m_cdpCacheTable = new CdpCacheTable(InetAddressUtils.addr((String)"10.10.10.1"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_cdpCacheTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"10.10.10.1"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)m_cdpCacheTable.size());
        for (CdpCacheTableEntry cdpCacheTableEntry : m_cdpCacheTable) {
            this.printCdpRow(cdpCacheTableEntry);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.1", port=161, resource="classpath:linkd/nms17216/switch1-walk.txt")})
    public void testSwicth1CiscoVlanTableCollection() throws Exception {
        String name = "vlanTable";
        CiscoVlanTable m_vlan = new CiscoVlanTable(InetAddressUtils.addr((String)"172.16.10.1"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_vlan};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.10.1"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        for (SnmpStore store : m_vlan) {
            CiscoVlanTableEntry ent = (CiscoVlanTableEntry)store;
            System.out.println("VLAN-----Start");
            System.out.println("vlan index: " + ent.getVlanIndex());
            System.out.println("vlan name: " + ent.getVlanName());
            System.out.println("vlan type: " + ent.getVlanType());
            System.out.println("vlan status: " + ent.getVlanStatus());
            System.out.println("VLAN-----End");
        }
        Assert.assertEquals((long)10L, (long)m_vlan.size());
        Assert.assertEquals((long)6L, (long)m_vlan.getVlansForSnmpCollection().size());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.1", port=161, resource="classpath:linkd/nms17216/switch1-walk.txt")})
    public void testSwitch1CdpInterfaceTableCollection() throws Exception {
        String name = "cdpInterfaceTable";
        CdpInterfaceTable m_cdpinterface = new CdpInterfaceTable(InetAddressUtils.addr((String)"172.16.10.1"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_cdpinterface};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.10.1"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Iterator i$ = m_cdpinterface.iterator();
        while (i$.hasNext()) {
            CdpInterfaceTableEntry store;
            CdpInterfaceTableEntry ent = store = (CdpInterfaceTableEntry)i$.next();
            System.out.println("-----Cdp Interface----");
            System.out.println("cdpInterfaceIfIndex: " + ent.getCdpInterfaceIfIndex());
            System.out.println("cdpInterfaceIfName: " + ent.getCdpInterfaceName());
            System.out.println("");
        }
        Assert.assertEquals((long)28L, (long)m_cdpinterface.size());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.1", port=161, resource="classpath:linkd/nms17216/switch1-walk.txt")})
    public void testSwitch1LldpLocalBaseCollection() throws Exception {
        String name = "lldpLocGroup";
        LldpLocalGroup m_lLldpLocalGroup = new LldpLocalGroup(InetAddressUtils.addr((String)"172.16.10.1"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lLldpLocalGroup};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.10.1"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertEquals((long)4L, (long)m_lLldpLocalGroup.getLldpLocChassisidSubType().intValue());
        Assert.assertEquals((Object)"0016c8bd4d80", (Object)m_lLldpLocalGroup.getLldpLocChassisid());
        Assert.assertEquals((Object)"Switch1", (Object)m_lLldpLocalGroup.getLldpLocSysname());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.2", port=161, resource="classpath:linkd/nms17216/switch2-walk.txt")})
    public void testSwitch2LldpLocalBaseCollection() throws Exception {
        String name = "lldpLocGroup";
        LldpLocalGroup m_lLldpLocalGroup = new LldpLocalGroup(InetAddressUtils.addr((String)"172.16.10.2"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lLldpLocalGroup};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.10.2"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertEquals((long)4L, (long)m_lLldpLocalGroup.getLldpLocChassisidSubType().intValue());
        Assert.assertEquals((Object)"0016c894aa80", (Object)m_lLldpLocalGroup.getLldpLocChassisid());
        Assert.assertEquals((Object)"Switch2", (Object)m_lLldpLocalGroup.getLldpLocSysname());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.3", port=161, resource="classpath:linkd/nms17216/switch3-walk.txt")})
    public void testSwitch3LldpLocalBaseCollection() throws Exception {
        String name = "lldpLocGroup";
        LldpLocalGroup m_lLldpLocalGroup = new LldpLocalGroup(InetAddressUtils.addr((String)"172.16.10.3"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lLldpLocalGroup};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.10.3"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertEquals((long)4L, (long)m_lLldpLocalGroup.getLldpLocChassisidSubType().intValue());
        Assert.assertEquals((Object)"f4ea67ebdc00", (Object)m_lLldpLocalGroup.getLldpLocChassisid());
        Assert.assertEquals((Object)"Switch3", (Object)m_lLldpLocalGroup.getLldpLocSysname());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.50.2", port=161, resource="classpath:linkd/nms17216/switch4-walk.txt")})
    public void testSwitch4LldpLocalBaseCollection() throws Exception {
        String name = "lldpLocGroup";
        LldpLocalGroup m_lLldpLocalGroup = new LldpLocalGroup(InetAddressUtils.addr((String)"172.16.50.2"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lLldpLocalGroup};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.50.2"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertEquals((long)4L, (long)m_lLldpLocalGroup.getLldpLocChassisidSubType().intValue());
        Assert.assertEquals((Object)"a4187504e400", (Object)m_lLldpLocalGroup.getLldpLocChassisid());
        Assert.assertEquals((Object)"Switch4", (Object)m_lLldpLocalGroup.getLldpLocSysname());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.4", port=161, resource="classpath:linkd/nms17216/switch5-walk.txt")})
    public void testSwitch5LldpLocalBaseCollection() throws Exception {
        String name = "lldpLocGroup";
        LldpLocalGroup m_lLldpLocalGroup = new LldpLocalGroup(InetAddressUtils.addr((String)"172.16.10.4"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lLldpLocalGroup};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.10.4"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertEquals((long)4L, (long)m_lLldpLocalGroup.getLldpLocChassisidSubType().intValue());
        Assert.assertEquals((Object)"f4ea67f82980", (Object)m_lLldpLocalGroup.getLldpLocChassisid());
        Assert.assertEquals((Object)"Switch5", (Object)m_lLldpLocalGroup.getLldpLocSysname());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.1", port=161, resource="classpath:linkd/nms17216/switch1-walk.txt")})
    public void testSwitch1LldpRemTableCollection() throws Exception {
        String name = "lldpRemTable";
        LldpRemTable m_lldpRemTable = new LldpRemTable(InetAddressUtils.addr((String)"172.16.10.1"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lldpRemTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.10.1"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            Assert.assertEquals((Object)false, (Object)true);
        }
        Collection lldpTableEntryCollection = m_lldpRemTable.getEntries();
        Assert.assertEquals((long)4L, (long)lldpTableEntryCollection.size());
        for (LldpRemTableEntry lldpRemTableEntry : lldpTableEntryCollection) {
            this.checkSwitch1Row(lldpRemTableEntry);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.2", port=161, resource="classpath:linkd/nms17216/switch2-walk.txt")})
    public void testSwitch2LldpRemTableCollection() throws Exception {
        String name = "lldpRemTable";
        LldpRemTable m_lldpRemTable = new LldpRemTable(InetAddressUtils.addr((String)"172.16.10.2"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lldpRemTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.10.2"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            Assert.assertEquals((Object)false, (Object)true);
        }
        Collection lldpTableEntryCollection = m_lldpRemTable.getEntries();
        Assert.assertEquals((long)6L, (long)lldpTableEntryCollection.size());
        for (LldpRemTableEntry lldpRemTableEntry : lldpTableEntryCollection) {
            this.checkSwitch2Row(lldpRemTableEntry);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.3", port=161, resource="classpath:linkd/nms17216/switch3-walk.txt")})
    public void testSwitch3LldpRemTableCollection() throws Exception {
        String name = "lldpRemTable";
        LldpRemTable m_lldpRemTable = new LldpRemTable(InetAddressUtils.addr((String)"172.16.10.3"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lldpRemTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.10.3"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            Assert.assertEquals((Object)false, (Object)true);
        }
        Collection lldpTableEntryCollection = m_lldpRemTable.getEntries();
        Assert.assertEquals((long)2L, (long)lldpTableEntryCollection.size());
        for (LldpRemTableEntry lldpRemTableEntry : lldpTableEntryCollection) {
            this.checkSwitch3Row(lldpRemTableEntry);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.50.2", port=161, resource="classpath:linkd/nms17216/switch4-walk.txt")})
    public void testSwitch4LldpRemTableCollection() throws Exception {
        String name = "lldpRemTable";
        LldpRemTable m_lldpRemTable = new LldpRemTable(InetAddressUtils.addr((String)"172.16.50.2"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lldpRemTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.50.2"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            Assert.assertEquals((Object)false, (Object)true);
        }
        Collection lldpTableEntryCollection = m_lldpRemTable.getEntries();
        Assert.assertEquals((long)0L, (long)lldpTableEntryCollection.size());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.4", port=161, resource="classpath:linkd/nms17216/switch5-walk.txt")})
    public void testSwitch5LldpRemTableCollection() throws Exception {
        String name = "lldpRemTable";
        LldpRemTable m_lldpRemTable = new LldpRemTable(InetAddressUtils.addr((String)"172.16.10.4"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lldpRemTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.10.4"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            Assert.assertEquals((Object)false, (Object)true);
        }
        Collection lldpTableEntryCollection = m_lldpRemTable.getEntries();
        Assert.assertEquals((long)0L, (long)lldpTableEntryCollection.size());
    }

    private void checkSwitch1Row(LldpRemTableEntry lldpRemTableEntry) {
        Integer lldpRemLocalPortNum = lldpRemTableEntry.getLldpRemLocalPortNum();
        String lldpRemSysname = lldpRemTableEntry.getLldpRemSysname();
        String lldpRemChassiid = lldpRemTableEntry.getLldpRemChassiid();
        Integer lldpRemChassisidSubtype = lldpRemTableEntry.getLldpRemChassisidSubtype();
        String lldpRemPortid = lldpRemTableEntry.getLldpRemPortid();
        Integer lldpRemPortidSubtype = lldpRemTableEntry.getLldpRemPortidSubtype();
        this.printLldpRemRow(lldpRemLocalPortNum, lldpRemSysname, lldpRemChassiid, lldpRemChassisidSubtype, lldpRemPortid, lldpRemPortidSubtype);
        Assert.assertEquals((long)4L, (long)lldpRemChassisidSubtype.intValue());
        Assert.assertEquals((long)5L, (long)lldpRemPortidSubtype.intValue());
        if (lldpRemLocalPortNum == 9) {
            Assert.assertEquals((Object)"Switch2", (Object)lldpRemSysname);
            Assert.assertEquals((Object)"0016c894aa80", (Object)lldpRemChassiid);
            Assert.assertEquals((Object)"Gi0/1", (Object)lldpRemPortid);
        } else if (lldpRemLocalPortNum == 10) {
            Assert.assertEquals((Object)"Switch2", (Object)lldpRemSysname);
            Assert.assertEquals((Object)"0016c894aa80", (Object)lldpRemChassiid);
            Assert.assertEquals((Object)"Gi0/2", (Object)lldpRemPortid);
        } else if (lldpRemLocalPortNum == 11) {
            Assert.assertEquals((Object)"Switch2", (Object)lldpRemSysname);
            Assert.assertEquals((Object)"0016c894aa80", (Object)lldpRemChassiid);
            Assert.assertEquals((Object)"Gi0/3", (Object)lldpRemPortid);
        } else if (lldpRemLocalPortNum == 12) {
            Assert.assertEquals((Object)"Switch2", (Object)lldpRemSysname);
            Assert.assertEquals((Object)"0016c894aa80", (Object)lldpRemChassiid);
            Assert.assertEquals((Object)"Gi0/4", (Object)lldpRemPortid);
        } else {
            Assert.assertEquals((Object)false, (Object)true);
        }
    }

    private void checkSwitch2Row(LldpRemTableEntry lldpRemTableEntry) {
        Integer lldpRemLocalPortNum = lldpRemTableEntry.getLldpRemLocalPortNum();
        String lldpRemSysname = lldpRemTableEntry.getLldpRemSysname();
        String lldpRemChassiid = lldpRemTableEntry.getLldpRemChassiid();
        Integer lldpRemChassisidSubtype = lldpRemTableEntry.getLldpRemChassisidSubtype();
        String lldpRemPortid = lldpRemTableEntry.getLldpRemPortid();
        Integer lldpRemPortidSubtype = lldpRemTableEntry.getLldpRemPortidSubtype();
        this.printLldpRemRow(lldpRemLocalPortNum, lldpRemSysname, lldpRemChassiid, lldpRemChassisidSubtype, lldpRemPortid, lldpRemPortidSubtype);
        Assert.assertEquals((long)4L, (long)lldpRemChassisidSubtype.intValue());
        Assert.assertEquals((long)5L, (long)lldpRemPortidSubtype.intValue());
        if (lldpRemLocalPortNum == 1) {
            Assert.assertEquals((Object)"Switch1", (Object)lldpRemSysname);
            Assert.assertEquals((Object)"0016c8bd4d80", (Object)lldpRemChassiid);
            Assert.assertEquals((Object)"Gi0/9", (Object)lldpRemPortid);
        } else if (lldpRemLocalPortNum == 2) {
            Assert.assertEquals((Object)"Switch1", (Object)lldpRemSysname);
            Assert.assertEquals((Object)"0016c8bd4d80", (Object)lldpRemChassiid);
            Assert.assertEquals((Object)"Gi0/10", (Object)lldpRemPortid);
        } else if (lldpRemLocalPortNum == 3) {
            Assert.assertEquals((Object)"Switch1", (Object)lldpRemSysname);
            Assert.assertEquals((Object)"0016c8bd4d80", (Object)lldpRemChassiid);
            Assert.assertEquals((Object)"Gi0/11", (Object)lldpRemPortid);
        } else if (lldpRemLocalPortNum == 4) {
            Assert.assertEquals((Object)"Switch1", (Object)lldpRemSysname);
            Assert.assertEquals((Object)"0016c8bd4d80", (Object)lldpRemChassiid);
            Assert.assertEquals((Object)"Gi0/12", (Object)lldpRemPortid);
        } else if (lldpRemLocalPortNum == 19) {
            Assert.assertEquals((Object)"Switch3", (Object)lldpRemSysname);
            Assert.assertEquals((Object)"f4ea67ebdc00", (Object)lldpRemChassiid);
            Assert.assertEquals((Object)"Fa0/19", (Object)lldpRemPortid);
        } else if (lldpRemLocalPortNum == 20) {
            Assert.assertEquals((Object)"Switch3", (Object)lldpRemSysname);
            Assert.assertEquals((Object)"f4ea67ebdc00", (Object)lldpRemChassiid);
            Assert.assertEquals((Object)"Fa0/20", (Object)lldpRemPortid);
        } else {
            Assert.assertEquals((Object)false, (Object)true);
        }
    }

    private void checkSwitch3Row(LldpRemTableEntry lldpRemTableEntry) {
        Integer lldpRemLocalPortNum = lldpRemTableEntry.getLldpRemLocalPortNum();
        String lldpRemSysname = lldpRemTableEntry.getLldpRemSysname();
        String lldpRemChassiid = lldpRemTableEntry.getLldpRemChassiid();
        Integer lldpRemChassisidSubtype = lldpRemTableEntry.getLldpRemChassisidSubtype();
        String lldpRemPortid = lldpRemTableEntry.getLldpRemPortid();
        Integer lldpRemPortidSubtype = lldpRemTableEntry.getLldpRemPortidSubtype();
        this.printLldpRemRow(lldpRemLocalPortNum, lldpRemSysname, lldpRemChassiid, lldpRemChassisidSubtype, lldpRemPortid, lldpRemPortidSubtype);
        Assert.assertEquals((long)4L, (long)lldpRemChassisidSubtype.intValue());
        Assert.assertEquals((long)5L, (long)lldpRemPortidSubtype.intValue());
        if (lldpRemLocalPortNum == 19) {
            Assert.assertEquals((Object)"Switch2", (Object)lldpRemSysname);
            Assert.assertEquals((Object)"0016c894aa80", (Object)lldpRemChassiid);
            Assert.assertEquals((Object)"Gi0/19", (Object)lldpRemPortid);
        } else if (lldpRemLocalPortNum == 20) {
            Assert.assertEquals((Object)"Switch2", (Object)lldpRemSysname);
            Assert.assertEquals((Object)"0016c894aa80", (Object)lldpRemChassiid);
            Assert.assertEquals((Object)"Gi0/20", (Object)lldpRemPortid);
        } else {
            Assert.assertEquals((Object)false, (Object)true);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.1", port=161, resource="classpath:linkd/nms17216/switch1-walk.txt")})
    public void testSwitch1LldpLocTableCollection() throws Exception {
        String name = "lldpLocTable";
        LldpLocTable m_lldpLocTable = new LldpLocTable(InetAddressUtils.addr((String)"172.16.10.1"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lldpLocTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.10.1"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            Assert.assertEquals((Object)false, (Object)true);
        }
        Collection lldpTableEntryCollection = m_lldpLocTable.getEntries();
        Assert.assertEquals((long)30L, (long)lldpTableEntryCollection.size());
        for (LldpLocTableEntry lldpLocTableEntry : lldpTableEntryCollection) {
            this.checkSwitch1Row(lldpLocTableEntry);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.2", port=161, resource="classpath:linkd/nms17216/switch2-walk.txt")})
    public void testSwitch2LldpLocTableCollection() throws Exception {
        String name = "lldpLocTable";
        LldpLocTable m_lldpLocTable = new LldpLocTable(InetAddressUtils.addr((String)"172.16.10.2"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lldpLocTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.10.2"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            Assert.assertEquals((Object)false, (Object)true);
        }
        Collection lldpTableEntryCollection = m_lldpLocTable.getEntries();
        Assert.assertEquals((long)27L, (long)lldpTableEntryCollection.size());
        for (LldpLocTableEntry lldpLocTableEntry : lldpTableEntryCollection) {
            this.checkSwitch2Row(lldpLocTableEntry);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.3", port=161, resource="classpath:linkd/nms17216/switch3-walk.txt")})
    public void testSwitch3LldpLocTableCollection() throws Exception {
        String name = "lldpLocTable";
        LldpLocTable m_lldpLocTable = new LldpLocTable(InetAddressUtils.addr((String)"172.16.10.3"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lldpLocTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.10.3"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            Assert.assertEquals((Object)false, (Object)true);
        }
        Collection lldpTableEntryCollection = m_lldpLocTable.getEntries();
        Assert.assertEquals((long)28L, (long)lldpTableEntryCollection.size());
        for (LldpLocTableEntry lldpLocTableEntry : lldpTableEntryCollection) {
            this.checkSwitch3Row(lldpLocTableEntry);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.50.2", port=161, resource="classpath:linkd/nms17216/switch4-walk.txt")})
    public void testSwitch4LldpLocTableCollection() throws Exception {
        String name = "lldpLocTable";
        LldpLocTable m_lldpLocTable = new LldpLocTable(InetAddressUtils.addr((String)"172.16.50.2"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lldpLocTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.50.2"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            Assert.assertEquals((Object)false, (Object)true);
        }
        Collection lldpTableEntryCollection = m_lldpLocTable.getEntries();
        Assert.assertEquals((long)27L, (long)lldpTableEntryCollection.size());
        for (LldpLocTableEntry lldpLocTableEntry : lldpTableEntryCollection) {
            this.checkSwitch4Row(lldpLocTableEntry);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.4", port=161, resource="classpath:linkd/nms17216/switch5-walk.txt")})
    public void testSwitch5LldpLocTableCollection() throws Exception {
        String name = "lldpLocTable";
        LldpLocTable m_lldpLocTable = new LldpLocTable(InetAddressUtils.addr((String)"172.16.10.4"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lldpLocTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.10.4"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            Assert.assertEquals((Object)false, (Object)true);
        }
        Collection lldpTableEntryCollection = m_lldpLocTable.getEntries();
        Assert.assertEquals((long)27L, (long)lldpTableEntryCollection.size());
        for (LldpLocTableEntry lldpLocTableEntry : lldpTableEntryCollection) {
            this.checkSwitch5Row(lldpLocTableEntry);
        }
    }

    private void checkSwitch1Row(LldpLocTableEntry lldpLocTableEntry) {
        Integer lldpLocPortNum = lldpLocTableEntry.getLldpLocPortNum();
        String lldpLocPortid = lldpLocTableEntry.getLldpLocPortid();
        Integer lldpLocPortidSubtype = lldpLocTableEntry.getLldpLocPortIdSubtype();
        this.printLldpLocRow(lldpLocPortNum, lldpLocPortidSubtype, lldpLocPortid);
        Assert.assertEquals((long)5L, (long)lldpLocPortidSubtype.intValue());
        if (lldpLocPortNum >= 1 && lldpLocPortNum <= 28) {
            Assert.assertEquals((Object)("Gi0/" + lldpLocPortNum), (Object)lldpLocPortid);
        } else if (lldpLocPortNum == 64) {
            Assert.assertEquals((Object)"Po1", (Object)lldpLocPortid);
        } else if (lldpLocPortNum == 448) {
            Assert.assertEquals((Object)"St1", (Object)lldpLocPortid);
        } else {
            Assert.assertEquals((Object)true, (Object)false);
        }
    }

    private void checkSwitch2Row(LldpLocTableEntry lldpLocTableEntry) {
        Integer lldpLocPortNum = lldpLocTableEntry.getLldpLocPortNum();
        String lldpLocPortid = lldpLocTableEntry.getLldpLocPortid();
        Integer lldpLocPortidSubtype = lldpLocTableEntry.getLldpLocPortIdSubtype();
        this.printLldpLocRow(lldpLocPortNum, lldpLocPortidSubtype, lldpLocPortid);
        Assert.assertEquals((long)5L, (long)lldpLocPortidSubtype.intValue());
        if (lldpLocPortNum >= 1 && lldpLocPortNum <= 24) {
            Assert.assertEquals((Object)("Gi0/" + lldpLocPortNum), (Object)lldpLocPortid);
        } else if (lldpLocPortNum == 64) {
            Assert.assertEquals((Object)"Po1", (Object)lldpLocPortid);
        } else if (lldpLocPortNum == 72) {
            Assert.assertEquals((Object)"Po2", (Object)lldpLocPortid);
        } else if (lldpLocPortNum == 112) {
            Assert.assertEquals((Object)"St1", (Object)lldpLocPortid);
        } else {
            Assert.assertEquals((Object)true, (Object)false);
        }
    }

    private void checkSwitch3Row(LldpLocTableEntry lldpLocTableEntry) {
        Integer lldpLocPortNum = lldpLocTableEntry.getLldpLocPortNum();
        String lldpLocPortid = lldpLocTableEntry.getLldpLocPortid();
        Integer lldpLocPortidSubtype = lldpLocTableEntry.getLldpLocPortIdSubtype();
        this.printLldpLocRow(lldpLocPortNum, lldpLocPortidSubtype, lldpLocPortid);
        Assert.assertEquals((long)5L, (long)lldpLocPortidSubtype.intValue());
        if (lldpLocPortNum >= 1 && lldpLocPortNum <= 24) {
            Assert.assertEquals((Object)("Fa0/" + lldpLocPortNum), (Object)lldpLocPortid);
        } else if (lldpLocPortNum == 25) {
            Assert.assertEquals((Object)"Gi0/1", (Object)lldpLocPortid);
        } else if (lldpLocPortNum == 26) {
            Assert.assertEquals((Object)"Gi0/2", (Object)lldpLocPortid);
        } else if (lldpLocPortNum == 56) {
            Assert.assertEquals((Object)"Po1", (Object)lldpLocPortid);
        } else if (lldpLocPortNum == 104) {
            Assert.assertEquals((Object)"St1", (Object)lldpLocPortid);
        } else {
            Assert.assertEquals((Object)true, (Object)false);
        }
    }

    private void checkSwitch4Row(LldpLocTableEntry lldpLocTableEntry) {
        Integer lldpLocPortNum = lldpLocTableEntry.getLldpLocPortNum();
        String lldpLocPortid = lldpLocTableEntry.getLldpLocPortid();
        Integer lldpLocPortidSubtype = lldpLocTableEntry.getLldpLocPortIdSubtype();
        this.printLldpLocRow(lldpLocPortNum, lldpLocPortidSubtype, lldpLocPortid);
        Assert.assertEquals((long)5L, (long)lldpLocPortidSubtype.intValue());
        if (lldpLocPortNum >= 1 && lldpLocPortNum <= 24) {
            Assert.assertEquals((Object)("Fa0/" + lldpLocPortNum), (Object)lldpLocPortid);
        } else if (lldpLocPortNum == 25) {
            Assert.assertEquals((Object)"Gi0/1", (Object)lldpLocPortid);
        } else if (lldpLocPortNum == 26) {
            Assert.assertEquals((Object)"Gi0/2", (Object)lldpLocPortid);
        } else if (lldpLocPortNum == 104) {
            Assert.assertEquals((Object)"St1", (Object)lldpLocPortid);
        } else {
            Assert.assertEquals((Object)true, (Object)false);
        }
    }

    private void checkSwitch5Row(LldpLocTableEntry lldpLocTableEntry) {
        this.checkSwitch4Row(lldpLocTableEntry);
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.1", port=161, resource="classpath:linkd/nms17216/switch1-walk.txt"), @JUnitSnmpAgent(host="172.16.10.2", port=161, resource="classpath:linkd/nms17216/switch2-walk.txt"), @JUnitSnmpAgent(host="172.16.10.3", port=161, resource="classpath:linkd/nms17216/switch3-walk.txt"), @JUnitSnmpAgent(host="172.16.50.2", port=161, resource="classpath:linkd/nms17216/switch4-walk.txt"), @JUnitSnmpAgent(host="172.16.10.4", port=161, resource="classpath:linkd/nms17216/switch5-walk.txt"), @JUnitSnmpAgent(host="192.168.100.245", port=161, resource="classpath:linkd/nms17216/router1-walk.txt"), @JUnitSnmpAgent(host="192.168.100.241", port=161, resource="classpath:linkd/nms17216/router2-walk.txt"), @JUnitSnmpAgent(host="172.16.50.1", port=161, resource="classpath:linkd/nms17216/router3-walk.txt"), @JUnitSnmpAgent(host="10.10.10.1", port=161, resource="classpath:linkd/nms17216/router4-walk.txt")})
    public void testNetwork17216Links() throws Exception {
        this.m_nodeDao.save((Object)this.getSwitch1());
        this.m_nodeDao.save((Object)this.getSwitch2());
        this.m_nodeDao.save((Object)this.getSwitch3());
        this.m_nodeDao.save((Object)this.getSwitch4());
        this.m_nodeDao.save((Object)this.getSwitch5());
        this.m_nodeDao.save((Object)this.getRouter1());
        this.m_nodeDao.save((Object)this.getRouter2());
        this.m_nodeDao.save((Object)this.getRouter3());
        this.m_nodeDao.save((Object)this.getRouter4());
        this.m_nodeDao.flush();
        Package example1 = this.m_linkdConfig.getPackage("example1");
        Assert.assertEquals((Object)false, (Object)example1.hasForceIpRouteDiscoveryOnEthernet());
        example1.setUseBridgeDiscovery(false);
        example1.setUseIpRouteDiscovery(false);
        example1.setEnableVlanDiscovery(false);
        example1.setUseOspfDiscovery(false);
        example1.setUseIsisDiscovery(false);
        OnmsNode switch1 = this.m_nodeDao.findByForeignId("linkd", "Switch1");
        OnmsNode switch2 = this.m_nodeDao.findByForeignId("linkd", "Switch2");
        OnmsNode switch3 = this.m_nodeDao.findByForeignId("linkd", "Switch3");
        OnmsNode switch4 = this.m_nodeDao.findByForeignId("linkd", "Switch4");
        OnmsNode switch5 = this.m_nodeDao.findByForeignId("linkd", "Switch5");
        OnmsNode router1 = this.m_nodeDao.findByForeignId("linkd", "Router1");
        OnmsNode router2 = this.m_nodeDao.findByForeignId("linkd", "Router2");
        OnmsNode router3 = this.m_nodeDao.findByForeignId("linkd", "Router3");
        OnmsNode router4 = this.m_nodeDao.findByForeignId("linkd", "Router4");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switch1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switch2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switch3.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switch4.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switch5.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(router1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(router2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(router3.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(router4.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switch1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switch2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switch3.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switch4.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switch5.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(router1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(router2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(router3.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(router4.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_dataLinkInterfaceDao.countAll());
        Collection nodes = this.m_linkd.getLinkableNodesOnPackage("example1");
        Assert.assertEquals((long)9L, (long)nodes.size());
        block11: for (LinkableNode node : nodes) {
            switch (node.getNodeId()) {
                case 1: {
                    Assert.assertEquals((long)5L, (long)node.getCdpInterfaces().size());
                    Assert.assertEquals((Object)"Switch1", (Object)node.getCdpDeviceId());
                    continue block11;
                }
                case 2: {
                    Assert.assertEquals((long)6L, (long)node.getCdpInterfaces().size());
                    Assert.assertEquals((Object)"Switch2", (Object)node.getCdpDeviceId());
                    continue block11;
                }
                case 3: {
                    Assert.assertEquals((long)4L, (long)node.getCdpInterfaces().size());
                    Assert.assertEquals((Object)"Switch3", (Object)node.getCdpDeviceId());
                    continue block11;
                }
                case 4: {
                    Assert.assertEquals((long)1L, (long)node.getCdpInterfaces().size());
                    Assert.assertEquals((Object)"Switch4", (Object)node.getCdpDeviceId());
                    continue block11;
                }
                case 5: {
                    Assert.assertEquals((long)2L, (long)node.getCdpInterfaces().size());
                    Assert.assertEquals((Object)"Switch5", (Object)node.getCdpDeviceId());
                    continue block11;
                }
                case 6: {
                    Assert.assertEquals((long)2L, (long)node.getCdpInterfaces().size());
                    Assert.assertEquals((Object)"Router1", (Object)node.getCdpDeviceId());
                    continue block11;
                }
                case 7: {
                    Assert.assertEquals((long)2L, (long)node.getCdpInterfaces().size());
                    Assert.assertEquals((Object)"Router2", (Object)node.getCdpDeviceId());
                    continue block11;
                }
                case 8: {
                    Assert.assertEquals((long)3L, (long)node.getCdpInterfaces().size());
                    Assert.assertEquals((Object)"Router3", (Object)node.getCdpDeviceId());
                    continue block11;
                }
                case 9: {
                    Assert.assertEquals((long)1L, (long)node.getCdpInterfaces().size());
                    Assert.assertEquals((Object)"Router4", (Object)node.getCdpDeviceId());
                    continue block11;
                }
            }
            Assert.assertEquals((long)-1L, (long)node.getNodeId());
        }
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        Assert.assertEquals((long)19L, (long)this.m_dataLinkInterfaceDao.countAll());
        List datalinkinterfaces = this.m_dataLinkInterfaceDao.findAll();
        int start = this.getStartPoint(datalinkinterfaces);
        for (DataLinkInterface datalinkinterface : datalinkinterfaces) {
            Integer linkid = datalinkinterface.getId();
            if (linkid == start) {
                this.checkLink(switch2, switch1, 10101, 10109, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.lldp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 11) {
                this.checkLink(switch2, switch1, 10101, 10109, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.cdp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 1) {
                this.checkLink(switch2, switch1, 10102, 10110, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.lldp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 12) {
                this.checkLink(switch2, switch1, 10102, 10110, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.cdp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 2) {
                this.checkLink(switch2, switch1, 10103, 10111, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.lldp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 13) {
                this.checkLink(switch2, switch1, 10103, 10111, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.cdp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 3) {
                this.checkLink(switch2, switch1, 10104, 10112, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.lldp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 14) {
                this.checkLink(switch2, switch1, 10104, 10112, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.cdp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 4) {
                this.checkLink(switch3, switch2, 10019, 10119, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.lldp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 15) {
                this.checkLink(switch3, switch2, 10019, 10119, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.cdp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 5) {
                this.checkLink(switch3, switch2, 10020, 10120, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.lldp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 16) {
                this.checkLink(switch3, switch2, 10020, 10120, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.cdp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 6) {
                this.checkLink(router4, router3, 3, 8, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.cdp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 7) {
                this.checkLink(router2, router1, 12, 13, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.cdp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 8) {
                this.checkLink(router3, router2, 13, 13, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.cdp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 9) {
                this.checkLink(router3, switch4, 9, 10001, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.cdp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 10) {
                this.checkLink(router1, switch1, 7, 10101, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.cdp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 17) {
                this.checkLink(switch5, switch3, 10001, 10023, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.cdp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 18) {
                this.checkLink(switch5, switch3, 10013, 10024, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.cdp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            this.checkLink(switch1, switch1, -1, -1, datalinkinterface);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.1", port=161, resource="classpath:linkd/nms17216/switch1-walk.txt"), @JUnitSnmpAgent(host="172.16.10.2", port=161, resource="classpath:linkd/nms17216/switch2-walk.txt"), @JUnitSnmpAgent(host="172.16.10.3", port=161, resource="classpath:linkd/nms17216/switch3-walk.txt")})
    public void testNetwork17216LldpLinks() throws Exception {
        this.m_nodeDao.save((Object)this.getSwitch1());
        this.m_nodeDao.save((Object)this.getSwitch2());
        this.m_nodeDao.save((Object)this.getSwitch3());
        this.m_nodeDao.flush();
        Package example1 = this.m_linkdConfig.getPackage("example1");
        Assert.assertEquals((Object)false, (Object)example1.hasForceIpRouteDiscoveryOnEthernet());
        example1.setUseBridgeDiscovery(false);
        example1.setUseCdpDiscovery(false);
        example1.setUseIpRouteDiscovery(false);
        example1.setEnableVlanDiscovery(false);
        example1.setUseOspfDiscovery(false);
        example1.setUseIsisDiscovery(false);
        OnmsNode switch1 = this.m_nodeDao.findByForeignId("linkd", "Switch1");
        OnmsNode switch2 = this.m_nodeDao.findByForeignId("linkd", "Switch2");
        OnmsNode switch3 = this.m_nodeDao.findByForeignId("linkd", "Switch3");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switch1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switch2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switch3.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switch1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switch2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switch3.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_dataLinkInterfaceDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        Assert.assertEquals((long)6L, (long)this.m_dataLinkInterfaceDao.countAll());
        List links = this.m_dataLinkInterfaceDao.findAll();
        int startid = this.getStartPoint(links);
        for (DataLinkInterface link : links) {
            Integer linkid = link.getId();
            if (linkid == startid) {
                this.checkLink(switch2, switch1, 10101, 10109, link);
                continue;
            }
            if (linkid == startid + 1) {
                this.checkLink(switch2, switch1, 10102, 10110, link);
                continue;
            }
            if (linkid == startid + 2) {
                this.checkLink(switch2, switch1, 10103, 10111, link);
                continue;
            }
            if (linkid == startid + 3) {
                this.checkLink(switch2, switch1, 10104, 10112, link);
                continue;
            }
            if (linkid == startid + 4) {
                this.checkLink(switch3, switch2, 10019, 10119, link);
                continue;
            }
            if (linkid == startid + 5) {
                this.checkLink(switch3, switch2, 10020, 10120, link);
                continue;
            }
            this.checkLink(switch1, switch1, -1, -1, link);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.50.2", port=161, resource="classpath:linkd/nms17216/switch4-walk.txt"), @JUnitSnmpAgent(host="172.16.50.1", port=161, resource="classpath:linkd/nms17216/router3-walk.txt")})
    public void testNetwork17216Switch4Router4CdpLinks() throws Exception {
        this.m_nodeDao.save((Object)this.getSwitch4());
        this.m_nodeDao.save((Object)this.getRouter3());
        this.m_nodeDao.flush();
        Package example1 = this.m_linkdConfig.getPackage("example1");
        Assert.assertEquals((Object)false, (Object)example1.hasForceIpRouteDiscoveryOnEthernet());
        example1.setUseLldpDiscovery(false);
        example1.setUseBridgeDiscovery(false);
        example1.setUseOspfDiscovery(false);
        example1.setUseIpRouteDiscovery(false);
        example1.setUseCdpDiscovery(true);
        example1.setEnableVlanDiscovery(false);
        example1.setSaveRouteTable(false);
        example1.setSaveStpInterfaceTable(false);
        example1.setSaveStpNodeTable(false);
        example1.setUseIsisDiscovery(false);
        OnmsNode switch4 = this.m_nodeDao.findByForeignId("linkd", "Switch4");
        OnmsNode router3 = this.m_nodeDao.findByForeignId("linkd", "Router3");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switch4.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(router3.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switch4.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(router3.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_dataLinkInterfaceDao.countAll());
        Collection nodes = this.m_linkd.getLinkableNodesOnPackage("example1");
        Assert.assertEquals((long)2L, (long)nodes.size());
        for (LinkableNode node : nodes) {
            Assert.assertEquals((long)1L, (long)node.getCdpInterfaces().size());
        }
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        Assert.assertEquals((long)1L, (long)this.m_dataLinkInterfaceDao.countAll());
        List datalinkinterfaces = this.m_dataLinkInterfaceDao.findAll();
        for (DataLinkInterface datalinkinterface : datalinkinterfaces) {
            this.checkLink(router3, switch4, 9, 10001, datalinkinterface);
        }
    }
}

