/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgents;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.config.linkd.Package;
import org.opennms.netmgt.linkd.HibernateEventWriter;
import org.opennms.netmgt.linkd.Nms1055NetworkBuilder;
import org.opennms.netmgt.linkd.snmp.Dot1dBaseGroup;
import org.opennms.netmgt.linkd.snmp.LldpLocTable;
import org.opennms.netmgt.linkd.snmp.LldpLocTableEntry;
import org.opennms.netmgt.linkd.snmp.LldpLocalGroup;
import org.opennms.netmgt.linkd.snmp.LldpRemTable;
import org.opennms.netmgt.linkd.snmp.LldpRemTableEntry;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpWalker;

public class Nms1055Test
extends Nms1055NetworkBuilder {
    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.155.69.16", port=161, resource="classpath:linkd/nms1055/penrose-mx480_10.155.69.16.txt")})
    public void testPenroseLldpLocalBaseCollection() throws Exception {
        String name = "lldpLocGroup";
        LldpLocalGroup m_lLldpLocalGroup = new LldpLocalGroup(InetAddressUtils.addr((String)"10.155.69.16"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lLldpLocalGroup};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"10.155.69.16"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertEquals((long)4L, (long)m_lLldpLocalGroup.getLldpLocChassisidSubType().intValue());
        Assert.assertEquals((Object)"80711f8fafc0", (Object)m_lLldpLocalGroup.getLldpLocChassisid());
        Assert.assertEquals((Object)"penrose-mx480", (Object)m_lLldpLocalGroup.getLldpLocSysname());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.155.69.17", port=161, resource="classpath:linkd/nms1055/delaware_10.155.69.17.txt")})
    public void testDelawareLldpLocalBaseCollection() throws Exception {
        String name = "lldpLocGroup";
        LldpLocalGroup m_lLldpLocalGroup = new LldpLocalGroup(InetAddressUtils.addr((String)"10.155.69.17"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lLldpLocalGroup};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"10.155.69.17"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertEquals((long)4L, (long)m_lLldpLocalGroup.getLldpLocChassisidSubType().intValue());
        Assert.assertEquals((Object)"0022830957c0", (Object)m_lLldpLocalGroup.getLldpLocChassisid());
        Assert.assertEquals((Object)"delaware", (Object)m_lLldpLocalGroup.getLldpLocSysname());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.155.69.42", port=161, resource="classpath:linkd/nms1055/phoenix-mx80_10.155.69.42.txt")})
    public void testPhoenixLldpLocalBaseCollection() throws Exception {
        String name = "lldpLocGroup";
        LldpLocalGroup m_lLldpLocalGroup = new LldpLocalGroup(InetAddressUtils.addr((String)"10.155.69.42"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lLldpLocalGroup};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"10.155.69.42"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertEquals((long)4L, (long)m_lLldpLocalGroup.getLldpLocChassisidSubType().intValue());
        Assert.assertEquals((Object)"80711fc414c0", (Object)m_lLldpLocalGroup.getLldpLocChassisid());
        Assert.assertEquals((Object)"phoenix-mx80", (Object)m_lLldpLocalGroup.getLldpLocSysname());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.155.69.43", port=161, resource="classpath:linkd/nms1055/Austin_10.155.69.43.txt")})
    public void testAustinLldpLocalBaseCollection() throws Exception {
        String name = "lldpLocGroup";
        LldpLocalGroup m_lLldpLocalGroup = new LldpLocalGroup(InetAddressUtils.addr((String)"10.155.69.43"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lLldpLocalGroup};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"10.155.69.43"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertEquals((long)4L, (long)m_lLldpLocalGroup.getLldpLocChassisidSubType().intValue());
        Assert.assertEquals((Object)"80711fc413c0", (Object)m_lLldpLocalGroup.getLldpLocChassisid());
        Assert.assertEquals((Object)"Austin", (Object)m_lLldpLocalGroup.getLldpLocSysname());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.155.69.12", port=161, resource="classpath:linkd/nms1055/sanjose-mx240_10.155.69.12.txt")})
    public void testSanjoseLlldpLocalBaseCollection() throws Exception {
        String name = "lldpLocGroup";
        LldpLocalGroup m_lLldpLocalGroup = new LldpLocalGroup(InetAddressUtils.addr((String)"10.155.69.12"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lLldpLocalGroup};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"10.155.69.12"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertEquals((long)4L, (long)m_lLldpLocalGroup.getLldpLocChassisidSubType().intValue());
        Assert.assertEquals((Object)"002283d857c0", (Object)m_lLldpLocalGroup.getLldpLocChassisid());
        Assert.assertEquals((Object)"sanjose-mx240", (Object)m_lLldpLocalGroup.getLldpLocSysname());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.155.69.107", port=161, resource="classpath:linkd/nms1055/Riovista-ce_10.155.69.107.txt")})
    public void testRiovistaLldpLocalBaseCollection() throws Exception {
        String name = "lldpLocGroup";
        LldpLocalGroup m_lLldpLocalGroup = new LldpLocalGroup(InetAddressUtils.addr((String)"10.155.69.107"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lLldpLocalGroup};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"10.155.69.107"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertEquals((long)4L, (long)m_lLldpLocalGroup.getLldpLocChassisidSubType().intValue());
        Assert.assertEquals((Object)"001f12373dc0", (Object)m_lLldpLocalGroup.getLldpLocChassisid());
        Assert.assertEquals((Object)"Riovista-ce", (Object)m_lLldpLocalGroup.getLldpLocSysname());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.155.69.16", port=161, resource="classpath:linkd/nms1055/penrose-mx480_10.155.69.16.txt")})
    public void testPenroseDot1dBaseCollection() throws Exception {
        String name = "dot1dbase";
        Dot1dBaseGroup m_lLldpLocalGroup = new Dot1dBaseGroup(InetAddressUtils.addr((String)"10.155.69.16"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lLldpLocalGroup};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"10.155.69.16"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            Assert.assertEquals((Object)false, (Object)true);
        }
        Assert.assertEquals((Object)"80711f8fafd0", (Object)m_lLldpLocalGroup.getBridgeAddress());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.155.69.17", port=161, resource="classpath:linkd/nms1055/delaware_10.155.69.17.txt")})
    public void testDelawareLldpLocTableCollection() throws Exception {
        String name = "lldpLocTable";
        LldpLocTable m_lldpRemTable = new LldpLocTable(InetAddressUtils.addr((String)"10.155.69.17"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lldpRemTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"10.155.69.17"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            Assert.assertEquals((Object)false, (Object)true);
        }
        Collection lldpTableEntryCollection = m_lldpRemTable.getEntries();
        Assert.assertEquals((long)5L, (long)lldpTableEntryCollection.size());
        for (LldpLocTableEntry lldpLocTableEntry : lldpTableEntryCollection) {
            this.checkRow(lldpLocTableEntry);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.155.69.17", port=161, resource="classpath:linkd/nms1055/delaware_10.155.69.17.txt")})
    public void testDelawareLldpRemTableCollection() throws Exception {
        String name = "lldpRemTable";
        LldpRemTable m_lldpRemTable = new LldpRemTable(InetAddressUtils.addr((String)"10.155.69.17"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lldpRemTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"10.155.69.17"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            Assert.assertEquals((Object)false, (Object)true);
        }
        Collection lldpTableEntryCollection = m_lldpRemTable.getEntries();
        Assert.assertEquals((long)4L, (long)lldpTableEntryCollection.size());
        for (LldpRemTableEntry lldpRemTableEntry : lldpTableEntryCollection) {
            this.checkRow(lldpRemTableEntry);
        }
    }

    private void checkRow(LldpRemTableEntry lldpRemTableEntry) {
        Integer lldpRemLocalPortNum = lldpRemTableEntry.getLldpRemLocalPortNum();
        String lldpRemSysname = lldpRemTableEntry.getLldpRemSysname();
        String lldpRemChassiid = lldpRemTableEntry.getLldpRemChassiid();
        Integer lldpRemChassisidSubtype = lldpRemTableEntry.getLldpRemChassisidSubtype();
        String lldpRemPortid = lldpRemTableEntry.getLldpRemPortid();
        Integer lldpRemPortidSubtype = lldpRemTableEntry.getLldpRemPortidSubtype();
        this.printLldpRemRow(lldpRemLocalPortNum, lldpRemSysname, lldpRemChassiid, lldpRemChassisidSubtype, lldpRemPortid, lldpRemPortidSubtype);
        Assert.assertEquals((long)4L, (long)lldpRemChassisidSubtype.intValue());
        Assert.assertEquals((long)7L, (long)lldpRemPortidSubtype.intValue());
        if (lldpRemLocalPortNum == 574) {
            Assert.assertEquals((Object)"penrose-mx480", (Object)lldpRemSysname);
            Assert.assertEquals((Object)"80711f8fafc0", (Object)lldpRemChassiid);
            Assert.assertEquals((Object)"510", (Object)lldpRemPortid);
        } else if (lldpRemLocalPortNum == 522) {
            Assert.assertEquals((Object)"penrose-mx480", (Object)lldpRemSysname);
            Assert.assertEquals((Object)"80711f8fafc0", (Object)lldpRemChassiid);
            Assert.assertEquals((Object)"525", (Object)lldpRemPortid);
        } else if (lldpRemLocalPortNum == 575) {
            Assert.assertEquals((Object)"Austin", (Object)lldpRemSysname);
            Assert.assertEquals((Object)"80711fc413c0", (Object)lldpRemChassiid);
            Assert.assertEquals((Object)"509", (Object)lldpRemPortid);
        } else if (lldpRemLocalPortNum == 540) {
            Assert.assertEquals((Object)"Riovista-ce", (Object)lldpRemSysname);
            Assert.assertEquals((Object)"001f12373dc0", (Object)lldpRemChassiid);
            Assert.assertEquals((Object)"503", (Object)lldpRemPortid);
        } else {
            Assert.assertEquals((Object)false, (Object)true);
        }
    }

    private void checkRow(LldpLocTableEntry lldpLocTableEntry) {
        Integer lldpLocPortNum = lldpLocTableEntry.getLldpLocPortNum();
        String lldpLocPortid = lldpLocTableEntry.getLldpLocPortid();
        Integer lldpLocPortidSubtype = lldpLocTableEntry.getLldpLocPortIdSubtype();
        this.printLldpLocRow(lldpLocPortNum, lldpLocPortidSubtype, lldpLocPortid);
        Assert.assertEquals((long)7L, (long)lldpLocPortidSubtype.intValue());
        if (lldpLocPortNum == 521) {
            Assert.assertEquals((Object)"521", (Object)lldpLocPortid);
        } else if (lldpLocPortNum == 522) {
            Assert.assertEquals((Object)"522", (Object)lldpLocPortid);
        } else if (lldpLocPortNum == 574) {
            Assert.assertEquals((Object)"574", (Object)lldpLocPortid);
        } else if (lldpLocPortNum == 575) {
            Assert.assertEquals((Object)"575", (Object)lldpLocPortid);
        } else if (lldpLocPortNum == 540) {
            Assert.assertEquals((Object)"540", (Object)lldpLocPortid);
        } else {
            Assert.assertEquals((Object)true, (Object)false);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.155.69.16", port=161, resource="classpath:linkd/nms1055/penrose-mx480_10.155.69.16.txt"), @JUnitSnmpAgent(host="10.155.69.17", port=161, resource="classpath:linkd/nms1055/delaware_10.155.69.17.txt"), @JUnitSnmpAgent(host="10.155.69.42", port=161, resource="classpath:linkd/nms1055/phoenix-mx80_10.155.69.42.txt"), @JUnitSnmpAgent(host="10.155.69.43", port=161, resource="classpath:linkd/nms1055/Austin_10.155.69.43.txt"), @JUnitSnmpAgent(host="10.155.69.12", port=161, resource="classpath:linkd/nms1055/sanjose-mx240_10.155.69.12.txt"), @JUnitSnmpAgent(host="10.155.69.107", port=161, resource="classpath:linkd/nms1055/Riovista-ce_10.155.69.107.txt")})
    public void testNetwork1055Links() throws Exception {
        this.m_nodeDao.save((Object)this.getPenrose());
        this.m_nodeDao.save((Object)this.getDelaware());
        this.m_nodeDao.save((Object)this.getPhoenix());
        this.m_nodeDao.save((Object)this.getAustin());
        this.m_nodeDao.save((Object)this.getSanjose());
        this.m_nodeDao.save((Object)this.getRiovista());
        this.m_nodeDao.flush();
        HibernateEventWriter queryManager = (HibernateEventWriter)this.m_linkd.getQueryManager();
        Assert.assertEquals((long)517L, (long)queryManager.getFromSysnameIfAlias("delaware", "test").getIfIndex().intValue());
        Assert.assertEquals((long)517L, (long)queryManager.getFromSysnameIfName("delaware", "ge-0/0/1").getIfIndex().intValue());
        Assert.assertEquals((long)585L, (long)queryManager.getFromSysnameMacAddress("delaware", "0022830951f5").getIfIndex().intValue());
        Assert.assertEquals((long)13L, (long)queryManager.getFromSysnameIpAddress("delaware", InetAddressUtils.addr((String)"10.155.69.17")).getIfIndex().intValue());
        Assert.assertEquals((long)574L, (long)queryManager.getFromSysnameIfAlias("delaware", "<To_Penrose>").getIfIndex().intValue());
        Package example1 = this.m_linkdConfig.getPackage("example1");
        Assert.assertEquals((Object)false, (Object)example1.hasForceIpRouteDiscoveryOnEthernet());
        example1.setForceIpRouteDiscoveryOnEthernet(true);
        OnmsNode penrose = this.m_nodeDao.findByForeignId("linkd", "penrose-mx480");
        OnmsNode delaware = this.m_nodeDao.findByForeignId("linkd", "delaware");
        OnmsNode phoenix = this.m_nodeDao.findByForeignId("linkd", "phoenix-mx80");
        OnmsNode austin = this.m_nodeDao.findByForeignId("linkd", "Austin");
        OnmsNode sanjose = this.m_nodeDao.findByForeignId("linkd", "sanjose-mx240");
        OnmsNode riovista = this.m_nodeDao.findByForeignId("linkd", "Riovista-ce");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(penrose.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(delaware.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(phoenix.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(austin.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(sanjose.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(riovista.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(penrose.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(delaware.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(phoenix.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(austin.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(sanjose.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(riovista.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_dataLinkInterfaceDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        Assert.assertEquals((long)22L, (long)this.m_dataLinkInterfaceDao.countAll());
        List links = this.m_dataLinkInterfaceDao.findAll();
        int start = this.getStartPoint(links);
        for (DataLinkInterface datalinkinterface : links) {
            Integer linkid = datalinkinterface.getId();
            if (linkid == start) {
                this.checkLink(penrose, phoenix, 644, 564, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.iproute, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 6) {
                this.checkLink(phoenix, penrose, 564, 644, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.ospf, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 1) {
                this.checkLink(penrose, delaware, 535, 598, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.iproute, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 5) {
                this.checkLink(delaware, penrose, 598, 535, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.ospf, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 2) {
                this.checkLink(phoenix, austin, 565, 554, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.iproute, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 7) {
                this.checkLink(austin, phoenix, 554, 565, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.ospf, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 3) {
                this.checkLink(sanjose, phoenix, 564, 566, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.iproute, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 8) {
                this.checkLink(sanjose, phoenix, 564, 566, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.ospf, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 4) {
                this.checkLink(sanjose, austin, 8562, 586, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.iproute, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 9) {
                this.checkLink(sanjose, austin, 8562, 586, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.ospf, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 10) {
                this.checkLink(delaware, penrose, 574, 510, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.lldp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 11) {
                this.checkLink(phoenix, penrose, 509, 511, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.lldp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 12) {
                this.checkLink(delaware, penrose, 522, 525, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.lldp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 13) {
                this.checkLink(riovista, penrose, 584, 515, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.lldp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 14) {
                this.checkLink(austin, delaware, 509, 575, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.lldp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 15) {
                this.checkLink(riovista, delaware, 503, 540, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.lldp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 16) {
                this.checkLink(sanjose, phoenix, 516, 515, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.lldp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 17) {
                this.checkLink(austin, phoenix, 508, 508, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.lldp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 18) {
                this.checkLink(sanjose, austin, 517, 515, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.lldp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 19) {
                this.checkLink(penrose, riovista, 515, 584, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.bridge, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 20) {
                this.checkLink(penrose, delaware, 2693, 658, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.bridge, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 21) {
                this.checkLink(delaware, riovista, 540, 503, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.bridge, (Object)datalinkinterface.getProtocol());
                continue;
            }
            this.checkLink(penrose, penrose, -1, -1, datalinkinterface);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.155.69.16", port=161, resource="classpath:linkd/nms1055/penrose-mx480_10.155.69.16.txt"), @JUnitSnmpAgent(host="10.155.69.17", port=161, resource="classpath:linkd/nms1055/delaware_10.155.69.17.txt")})
    public void testNetwork1055StpLinks() throws Exception {
        this.m_nodeDao.save((Object)this.getPenrose());
        this.m_nodeDao.save((Object)this.getDelaware());
        this.m_nodeDao.flush();
        Package example1 = this.m_linkdConfig.getPackage("example1");
        example1.setUseBridgeDiscovery(true);
        example1.setUseLldpDiscovery(false);
        example1.setUseCdpDiscovery(false);
        example1.setUseIpRouteDiscovery(false);
        example1.setUseOspfDiscovery(false);
        example1.setUseIsisDiscovery(false);
        example1.setSaveRouteTable(false);
        example1.setSaveStpInterfaceTable(false);
        example1.setSaveStpNodeTable(false);
        OnmsNode penrose = this.m_nodeDao.findByForeignId("linkd", "penrose-mx480");
        OnmsNode delaware = this.m_nodeDao.findByForeignId("linkd", "delaware");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(penrose.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(delaware.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(penrose.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(delaware.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_dataLinkInterfaceDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        Assert.assertEquals((long)1L, (long)this.m_dataLinkInterfaceDao.countAll());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.155.69.16", port=161, resource="classpath:linkd/nms1055/penrose-mx480_10.155.69.16.txt"), @JUnitSnmpAgent(host="10.155.69.17", port=161, resource="classpath:linkd/nms1055/delaware_10.155.69.17.txt"), @JUnitSnmpAgent(host="10.155.69.42", port=161, resource="classpath:linkd/nms1055/phoenix-mx80_10.155.69.42.txt"), @JUnitSnmpAgent(host="10.155.69.43", port=161, resource="classpath:linkd/nms1055/Austin_10.155.69.43.txt"), @JUnitSnmpAgent(host="10.155.69.12", port=161, resource="classpath:linkd/nms1055/sanjose-mx240_10.155.69.12.txt"), @JUnitSnmpAgent(host="10.155.69.107", port=161, resource="classpath:linkd/nms1055/Riovista-ce_10.155.69.107.txt")})
    public void testNetwork1055OspfLinks() throws Exception {
        this.m_nodeDao.save((Object)this.getPenrose());
        this.m_nodeDao.save((Object)this.getDelaware());
        this.m_nodeDao.save((Object)this.getPhoenix());
        this.m_nodeDao.save((Object)this.getAustin());
        this.m_nodeDao.save((Object)this.getSanjose());
        this.m_nodeDao.save((Object)this.getRiovista());
        this.m_nodeDao.flush();
        Package example1 = this.m_linkdConfig.getPackage("example1");
        example1.setUseBridgeDiscovery(false);
        example1.setUseLldpDiscovery(false);
        example1.setUseCdpDiscovery(false);
        example1.setUseIpRouteDiscovery(false);
        example1.setUseOspfDiscovery(true);
        example1.setUseIsisDiscovery(false);
        example1.setSaveRouteTable(false);
        example1.setSaveStpInterfaceTable(false);
        example1.setSaveStpNodeTable(false);
        this.m_linkdConfig.update();
        OnmsNode penrose = this.m_nodeDao.findByForeignId("linkd", "penrose-mx480");
        OnmsNode delaware = this.m_nodeDao.findByForeignId("linkd", "delaware");
        OnmsNode phoenix = this.m_nodeDao.findByForeignId("linkd", "phoenix-mx80");
        OnmsNode austin = this.m_nodeDao.findByForeignId("linkd", "Austin");
        OnmsNode sanjose = this.m_nodeDao.findByForeignId("linkd", "sanjose-mx240");
        OnmsNode riovista = this.m_nodeDao.findByForeignId("linkd", "Riovista-ce");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(penrose.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(delaware.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(phoenix.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(austin.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(sanjose.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(riovista.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(penrose.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(delaware.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(phoenix.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(austin.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(sanjose.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(riovista.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_dataLinkInterfaceDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        Assert.assertEquals((long)5L, (long)this.m_dataLinkInterfaceDao.countAll());
        List links = this.m_dataLinkInterfaceDao.findAll();
        int start = this.getStartPoint(links);
        for (DataLinkInterface datalinkinterface : links) {
            Integer linkid = datalinkinterface.getId();
            if (linkid == start) {
                this.checkLink(delaware, penrose, 598, 535, datalinkinterface);
                continue;
            }
            if (linkid == start + 1) {
                this.checkLink(phoenix, penrose, 564, 644, datalinkinterface);
                continue;
            }
            if (linkid == start + 2) {
                this.checkLink(austin, phoenix, 554, 565, datalinkinterface);
                continue;
            }
            if (linkid == start + 3) {
                this.checkLink(sanjose, phoenix, 564, 566, datalinkinterface);
                continue;
            }
            if (linkid == start + 4) {
                this.checkLink(sanjose, austin, 8562, 586, datalinkinterface);
                continue;
            }
            this.checkLink(penrose, penrose, -1, -1, datalinkinterface);
        }
    }
}

