/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgents;
import org.opennms.netmgt.config.linkd.Package;
import org.opennms.netmgt.linkd.CdpInterface;
import org.opennms.netmgt.linkd.LinkableNode;
import org.opennms.netmgt.linkd.Nms101NetworkBuilder;
import org.opennms.netmgt.linkd.RouterInterface;
import org.opennms.netmgt.linkd.SnmpCollection;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.springframework.transaction.annotation.Transactional;

public class Nms101Test
extends Nms101NetworkBuilder {
    @Before
    public void setUpForceDisvoeryOnEthernet() {
        for (Package pkg : Collections.list(this.m_linkdConfig.enumeratePackage())) {
            pkg.setForceIpRouteDiscoveryOnEthernet(true);
        }
    }

    @Test
    @Transactional
    public void testDefaultConfiguration() throws Exception {
        this.m_nodeDao.save((Object)this.getExampleCom());
        this.m_nodeDao.save((Object)this.getLaptop());
        this.m_nodeDao.save((Object)this.getCisco7200a());
        this.m_nodeDao.save((Object)this.getCisco7200b());
        this.m_nodeDao.save((Object)this.getCisco3700());
        this.m_nodeDao.save((Object)this.getCisco2691());
        this.m_nodeDao.save((Object)this.getCisco1700());
        this.m_nodeDao.save((Object)this.getCisco3600());
        this.m_nodeDao.flush();
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.useBridgeDiscovery());
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.useOspfDiscovery());
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.useIpRouteDiscovery());
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.useLldpDiscovery());
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.useCdpDiscovery());
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.useIsIsDiscovery());
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.saveRouteTable());
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.saveStpNodeTable());
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.saveStpInterfaceTable());
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.isVlanDiscoveryEnabled());
        Assert.assertEquals((Object)false, (Object)this.m_linkdConfig.isAutoDiscoveryEnabled());
        Assert.assertEquals((Object)false, (Object)this.m_linkdConfig.forceIpRouteDiscoveryOnEthernet());
        Assert.assertEquals((Object)false, (Object)this.m_linkdConfig.hasClassName(".1.3.6.1.4.1.2636.1.1.1.1.9"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.ThreeComVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.43.1.9.13.3.1"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.ThreeComVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.43.10.27.4.1.2.4"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.ThreeComVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.43.10.27.4.1.2.2"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.ThreeComVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.43.10.27.4.1.2.11"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.ThreeComVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.43.1.16.4.3.5"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.ThreeComVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.43.1.16.4.3.6"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.Dot1qStaticVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.43.1.8.43"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.Dot1qStaticVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.43.1.8.61"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.RapidCityVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.45.3.61.1"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.RapidCityVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.45.3.35.1"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.RapidCityVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.45.3.53.1"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.IntelVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.343.5.1.5"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.Dot1qStaticVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.11.2.3.7.11.1"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.Dot1qStaticVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.11.2.3.7.11.3"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.Dot1qStaticVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.11.2.3.7.11.7"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.Dot1qStaticVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.11.2.3.7.11.8"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.Dot1qStaticVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.11.2.3.7.11.11"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.Dot1qStaticVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.11.2.3.7.11.6"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.Dot1qStaticVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.11.2.3.7.11.50"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.CiscoVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.9.1.300"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.CiscoVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.9.1.122"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.CiscoVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.9.1.616"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.CiscoVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.9.5.42"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.CiscoVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.9.5.59"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.ExtremeNetworkVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.1916.2.11"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.ExtremeNetworkVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.1916.2.14"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.ExtremeNetworkVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.1916.2.63"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.IpCidrRouteTable", (Object)this.m_linkdConfig.getDefaultIpRouteClassName());
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.IpRouteTable", (Object)this.m_linkdConfig.getIpRouteClassName(".1.3.6.1.4.1.3224.1.51"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.IpRouteTable", (Object)this.m_linkdConfig.getIpRouteClassName(".1.3.6.1.4.1.9.1.569"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.IpRouteTable", (Object)this.m_linkdConfig.getIpRouteClassName(".1.3.6.1.4.1.9.5.42"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.IpRouteTable", (Object)this.m_linkdConfig.getIpRouteClassName(".1.3.6.1.4.1.8072.3.2.255"));
        OnmsNode laptop = this.m_nodeDao.findByForeignId("linkd", "laptop");
        OnmsNode cisco3600 = this.m_nodeDao.findByForeignId("linkd", "cisco3600");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(laptop.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco3600.getId().intValue()));
        SnmpCollection snmpCollLaptop = this.m_linkd.getSnmpCollection(laptop.getId().intValue(), laptop.getPrimaryInterface().getIpAddress(), laptop.getSysObjectId(), "example1");
        Assert.assertEquals((Object)true, (Object)snmpCollLaptop.getCollectBridge());
        Assert.assertEquals((Object)true, (Object)snmpCollLaptop.getCollectStp());
        Assert.assertEquals((Object)true, (Object)snmpCollLaptop.getCollectCdp());
        Assert.assertEquals((Object)true, (Object)snmpCollLaptop.getCollectIpRoute());
        Assert.assertEquals((Object)true, (Object)snmpCollLaptop.getCollectOspf());
        Assert.assertEquals((Object)true, (Object)snmpCollLaptop.getCollectLldp());
        Assert.assertEquals((Object)false, (Object)snmpCollLaptop.collectVlanTable());
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.IpRouteTable", (Object)snmpCollLaptop.getIpRouteClass());
        Assert.assertEquals((Object)"example1", (Object)snmpCollLaptop.getPackageName());
        Assert.assertEquals((Object)true, (Object)this.m_linkd.saveRouteTable("example1"));
        Assert.assertEquals((Object)true, (Object)this.m_linkd.saveStpNodeTable("example1"));
        Assert.assertEquals((Object)true, (Object)this.m_linkd.saveStpInterfaceTable("example1"));
        SnmpCollection snmpCollcisco3600 = this.m_linkd.getSnmpCollection(cisco3600.getId().intValue(), cisco3600.getPrimaryInterface().getIpAddress(), cisco3600.getSysObjectId(), "example1");
        Assert.assertEquals((Object)true, (Object)snmpCollcisco3600.getCollectBridge());
        Assert.assertEquals((Object)true, (Object)snmpCollcisco3600.getCollectStp());
        Assert.assertEquals((Object)true, (Object)snmpCollcisco3600.getCollectCdp());
        Assert.assertEquals((Object)true, (Object)snmpCollcisco3600.getCollectIpRoute());
        Assert.assertEquals((Object)true, (Object)snmpCollcisco3600.getCollectOspf());
        Assert.assertEquals((Object)true, (Object)snmpCollcisco3600.getCollectLldp());
        Assert.assertEquals((Object)true, (Object)snmpCollcisco3600.collectVlanTable());
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.CiscoVlanTable", (Object)snmpCollcisco3600.getVlanClass());
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.IpCidrRouteTable", (Object)snmpCollcisco3600.getIpRouteClass());
        Assert.assertEquals((Object)"example1", (Object)snmpCollcisco3600.getPackageName());
        Package example1 = this.m_linkdConfig.getPackage("example1");
        Assert.assertEquals((Object)true, (Object)example1.getForceIpRouteDiscoveryOnEthernet());
        Enumeration pkgs = this.m_linkdConfig.enumeratePackage();
        example1 = (Package)pkgs.nextElement();
        Assert.assertEquals((Object)"example1", (Object)example1.getName());
        Assert.assertEquals((Object)false, (Object)pkgs.hasMoreElements());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.1.5.1", port=161, resource="classpath:linkd/nms101/cisco1700b.properties"), @JUnitSnmpAgent(host="10.1.5.2", port=161, resource="classpath:linkd/nms101/cisco1700.properties")})
    public void testSimpleFakeConnection() throws Exception {
        this.m_nodeDao.save((Object)this.getCisco1700());
        this.m_nodeDao.save((Object)this.getCisco1700b());
        this.m_nodeDao.save((Object)this.getExampleCom());
        this.m_nodeDao.flush();
        OnmsNode cisco1700 = this.m_nodeDao.findByForeignId("linkd", "cisco1700");
        OnmsNode cisco1700b = this.m_nodeDao.findByForeignId("linkd", "cisco1700b");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco1700.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco1700b.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco1700.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco1700b.getId().intValue()));
        for (LinkableNode node : this.m_linkd.getLinkableNodesOnPackage("example1")) {
            int nodeid = node.getNodeId();
            this.printNode((OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeid)));
            for (RouterInterface route : node.getRouteInterfaces()) {
                this.printRouteInterface(nodeid, route);
            }
            for (CdpInterface cdp : node.getCdpInterfaces()) {
                this.printCdpInterface(nodeid, cdp);
            }
        }
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        List ifaces = this.m_dataLinkInterfaceDao.findAll();
        for (DataLinkInterface link : ifaces) {
            this.printLink(link);
        }
        Assert.assertEquals((String)"we should have found 1 data link", (long)1L, (long)ifaces.size());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.1.1.1", port=161, resource="classpath:linkd/nms101/cisco7200a.properties"), @JUnitSnmpAgent(host="10.1.2.2", port=161, resource="classpath:linkd/nms101/cisco7200b.properties")})
    public void testsimpleLinkCisco7200aCisco7200b() throws Exception {
        this.m_nodeDao.save((Object)this.getCisco7200a());
        this.m_nodeDao.save((Object)this.getCisco7200b());
        this.m_nodeDao.flush();
        OnmsNode cisco7200a = this.m_nodeDao.findByForeignId("linkd", "cisco7200ATM.befunk.com");
        OnmsNode cisco7200b = this.m_nodeDao.findByForeignId("linkd", "cisco7200");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco7200a.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco7200b.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco7200a.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco7200b.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        List ifaces = this.m_dataLinkInterfaceDao.findAll();
        for (DataLinkInterface link : ifaces) {
            if (link.getProtocol() == DataLinkInterface.DiscoveryProtocol.iproute) {
                this.checkLink(cisco7200a, cisco7200b, 2, 4, link);
                continue;
            }
            if (link.getProtocol() != DataLinkInterface.DiscoveryProtocol.cdp) continue;
            this.checkLink(cisco7200b, cisco7200a, 4, 2, link);
        }
        Assert.assertEquals((String)"we should have found 2 data links", (long)2L, (long)ifaces.size());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.1.1.1", port=161, resource="classpath:linkd/nms101/cisco7200a.properties"), @JUnitSnmpAgent(host="10.1.1.2", port=161, resource="classpath:linkd/nms101/laptop.properties")})
    public void testsimpleLinkCisco7200alaptop() throws Exception {
        this.m_nodeDao.save((Object)this.getCisco7200a());
        this.m_nodeDao.save((Object)this.getLaptop());
        this.m_nodeDao.flush();
        OnmsNode cisco7200a = this.m_nodeDao.findByForeignId("linkd", "cisco7200ATM.befunk.com");
        OnmsNode laptop = this.m_nodeDao.findByForeignId("linkd", "laptop");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco7200a.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(laptop.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco7200a.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(laptop.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        List ifaces = this.m_dataLinkInterfaceDao.findAll();
        for (DataLinkInterface link : ifaces) {
            this.printLink(link);
        }
        Assert.assertEquals((String)"we should have found 1 data links", (long)1L, (long)ifaces.size());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.1.3.2", port=161, resource="classpath:linkd/nms101/cisco3700.properties"), @JUnitSnmpAgent(host="10.1.6.2", port=161, resource="classpath:linkd/nms101/cisco3600.properties")})
    public void testsimpleLinkCisco3600aCisco3700() throws Exception {
        this.m_nodeDao.save((Object)this.getCisco3700());
        this.m_nodeDao.save((Object)this.getCisco3600());
        this.m_nodeDao.flush();
        OnmsNode cisco3600 = this.m_nodeDao.findByForeignId("linkd", "cisco3600");
        OnmsNode cisco3700 = this.m_nodeDao.findByForeignId("linkd", "cisco3700");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco3700.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco3600.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco3700.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco3600.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        List ifaces = this.m_dataLinkInterfaceDao.findAll();
        for (DataLinkInterface link : ifaces) {
            if (link.getProtocol() == DataLinkInterface.DiscoveryProtocol.iproute) {
                this.checkLink(cisco3600, cisco3700, 1, 3, link);
                continue;
            }
            if (link.getProtocol() != DataLinkInterface.DiscoveryProtocol.cdp) continue;
            this.checkLink(cisco3600, cisco3700, 1, 3, link);
        }
        Assert.assertEquals((String)"we should have found 2 data links", (long)2L, (long)ifaces.size());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.1.1.1", port=161, resource="classpath:linkd/nms101/cisco7200a.properties"), @JUnitSnmpAgent(host="10.1.1.2", port=161, resource="classpath:linkd/nms101/laptop.properties"), @JUnitSnmpAgent(host="10.1.2.2", port=161, resource="classpath:linkd/nms101/cisco7200b.properties"), @JUnitSnmpAgent(host="10.1.3.2", port=161, resource="classpath:linkd/nms101/cisco3700.properties"), @JUnitSnmpAgent(host="10.1.4.2", port=161, resource="classpath:linkd/nms101/cisco2691.properties"), @JUnitSnmpAgent(host="10.1.5.2", port=161, resource="classpath:linkd/nms101/cisco1700.properties"), @JUnitSnmpAgent(host="10.1.6.2", port=161, resource="classpath:linkd/nms101/cisco3600.properties")})
    public void testCiscoNetwork() throws Exception {
        this.m_nodeDao.save((Object)this.getExampleCom());
        this.m_nodeDao.save((Object)this.getLaptop());
        this.m_nodeDao.save((Object)this.getCisco7200a());
        this.m_nodeDao.save((Object)this.getCisco7200b());
        this.m_nodeDao.save((Object)this.getCisco3700());
        this.m_nodeDao.save((Object)this.getCisco2691());
        this.m_nodeDao.save((Object)this.getCisco1700());
        this.m_nodeDao.save((Object)this.getCisco3600());
        this.m_nodeDao.flush();
        OnmsNode laptop = this.m_nodeDao.findByForeignId("linkd", "laptop");
        OnmsNode cisco7200a = this.m_nodeDao.findByForeignId("linkd", "cisco7200ATM.befunk.com");
        OnmsNode cisco7200b = this.m_nodeDao.findByForeignId("linkd", "cisco7200");
        OnmsNode cisco3700 = this.m_nodeDao.findByForeignId("linkd", "cisco3700");
        OnmsNode cisco2691 = this.m_nodeDao.findByForeignId("linkd", "cisco2691");
        OnmsNode cisco1700 = this.m_nodeDao.findByForeignId("linkd", "cisco1700");
        OnmsNode cisco3600 = this.m_nodeDao.findByForeignId("linkd", "cisco3600");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(laptop.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco7200a.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco7200b.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco3700.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco2691.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco1700.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco3600.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(laptop.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco7200a.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco7200b.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco3700.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco2691.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco1700.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco3600.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        List links = this.m_dataLinkInterfaceDao.findAll();
        int start = this.getStartPoint(links);
        for (DataLinkInterface link : links) {
            int id = link.getId();
            if (id == start) {
                this.checkLink(laptop, cisco7200a, 10, 3, link);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.iproute, (Object)link.getProtocol());
                continue;
            }
            if (id == start + 1) {
                this.checkLink(cisco7200a, cisco7200b, 2, 4, link);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.iproute, (Object)link.getProtocol());
                continue;
            }
            if (id == start + 10) {
                this.checkLink(cisco7200b, cisco7200a, 4, 2, link);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.cdp, (Object)link.getProtocol());
                continue;
            }
            if (id == start + 2) {
                this.checkLink(cisco7200b, cisco2691, 1, 4, link);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.iproute, (Object)link.getProtocol());
                continue;
            }
            if (id == start + 8) {
                this.checkLink(cisco2691, cisco7200b, 4, 1, link);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.cdp, (Object)link.getProtocol());
                continue;
            }
            if (id == start + 3) {
                this.checkLink(cisco7200b, cisco3700, 2, 1, link);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.iproute, (Object)link.getProtocol());
                continue;
            }
            if (id == start + 9) {
                this.checkLink(cisco3700, cisco7200b, 1, 2, link);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.cdp, (Object)link.getProtocol());
                continue;
            }
            if (id == start + 4) {
                this.checkLink(cisco1700, cisco2691, 2, 2, link);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.iproute, (Object)link.getProtocol());
                continue;
            }
            if (id == start + 7) {
                this.checkLink(cisco1700, cisco2691, 2, 2, link);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.cdp, (Object)link.getProtocol());
                continue;
            }
            if (id == start + 6) {
                this.checkLink(cisco3600, cisco2691, 2, 1, link);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.cdp, (Object)link.getProtocol());
                continue;
            }
            if (id == start + 5) {
                this.checkLink(cisco3600, cisco3700, 1, 3, link);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.iproute, (Object)link.getProtocol());
                continue;
            }
            if (id == start + 11) {
                this.checkLink(cisco3600, cisco3700, 1, 3, link);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.cdp, (Object)link.getProtocol());
                continue;
            }
            Assert.assertEquals((Object)false, (Object)true);
        }
        Assert.assertEquals((String)"we should have found 12 data links", (long)12L, (long)links.size());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.1.1.1", port=161, resource="classpath:linkd/nms101/cisco7200a.properties"), @JUnitSnmpAgent(host="10.1.2.2", port=161, resource="classpath:linkd/nms101/cisco7200b.properties")})
    public void testsimpleCdpLinkCisco7200aCisco7200b() throws Exception {
        for (Package pkg : Collections.list(this.m_linkdConfig.enumeratePackage())) {
            pkg.setUseIpRouteDiscovery(false);
            pkg.setUseOspfDiscovery(false);
            pkg.setUseLldpDiscovery(false);
            pkg.setUseBridgeDiscovery(false);
            pkg.setSaveRouteTable(false);
            pkg.setSaveStpNodeTable(false);
            pkg.setSaveStpInterfaceTable(false);
            pkg.setEnableVlanDiscovery(false);
            pkg.setUseIsisDiscovery(false);
        }
        this.m_nodeDao.save((Object)this.getCisco7200a());
        this.m_nodeDao.save((Object)this.getCisco7200b());
        this.m_nodeDao.flush();
        OnmsNode cisco7200a = this.m_nodeDao.findByForeignId("linkd", "cisco7200ATM.befunk.com");
        OnmsNode cisco7200b = this.m_nodeDao.findByForeignId("linkd", "cisco7200");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco7200a.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco7200b.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco7200a.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco7200b.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        List ifaces = this.m_dataLinkInterfaceDao.findAll();
        for (DataLinkInterface link : ifaces) {
            this.printLink(link);
        }
        Assert.assertEquals((String)"we should have found 1 data links", (long)1L, (long)ifaces.size());
    }
}

