/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgents;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.config.linkd.Package;
import org.opennms.netmgt.linkd.LinkableNode;
import org.opennms.netmgt.linkd.Nms0001NetworkBuilder;
import org.opennms.netmgt.linkd.snmp.IsIsSystemObjectGroup;
import org.opennms.netmgt.linkd.snmp.IsisCircTable;
import org.opennms.netmgt.linkd.snmp.IsisCircTableEntry;
import org.opennms.netmgt.linkd.snmp.IsisISAdjTable;
import org.opennms.netmgt.linkd.snmp.IsisISAdjTableEntry;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsArpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpWalker;

public class Nms0001Test
extends Nms0001NetworkBuilder {
    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.168.239.51", port=161, resource="classpath:linkd/nms0001/froh-192.168.239.51-walk.txt"), @JUnitSnmpAgent(host="192.168.239.62", port=161, resource="classpath:linkd/nms0001/oedipus-192.168.239.62-walk.txt"), @JUnitSnmpAgent(host="192.168.239.54", port=161, resource="classpath:linkd/nms0001/siegfrie-192.168.239.54-walk.txt")})
    public void testIsisSysObjGroupCollection() throws Exception {
        String name = "isisSystemObjectGroup";
        IsIsSystemObjectGroup m_isisSystemObjectGroup = new IsIsSystemObjectGroup(InetAddressUtils.addr((String)"192.168.239.51"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_isisSystemObjectGroup};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"192.168.239.51"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertEquals((Object)IsIsSystemObjectGroup.IsisAdminState.ON, (Object)m_isisSystemObjectGroup.getIsisSysAdminState());
        Assert.assertEquals((Object)"000110088500", (Object)m_isisSystemObjectGroup.getIsisSysId());
        m_isisSystemObjectGroup = new IsIsSystemObjectGroup(InetAddressUtils.addr((String)"192.168.239.62"));
        tracker = new CollectionTracker[]{m_isisSystemObjectGroup};
        snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"192.168.239.62"));
        walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertEquals((Object)IsIsSystemObjectGroup.IsisAdminState.ON, (Object)m_isisSystemObjectGroup.getIsisSysAdminState());
        Assert.assertEquals((Object)"000110255062", (Object)m_isisSystemObjectGroup.getIsisSysId());
        m_isisSystemObjectGroup = new IsIsSystemObjectGroup(InetAddressUtils.addr((String)"192.168.239.54"));
        tracker = new CollectionTracker[]{m_isisSystemObjectGroup};
        snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"192.168.239.54"));
        walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertEquals((Object)IsIsSystemObjectGroup.IsisAdminState.ON, (Object)m_isisSystemObjectGroup.getIsisSysAdminState());
        Assert.assertEquals((Object)"000110255054", (Object)m_isisSystemObjectGroup.getIsisSysId());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.168.239.51", port=161, resource="classpath:linkd/nms0001/froh-192.168.239.51-walk.txt"), @JUnitSnmpAgent(host="192.168.239.62", port=161, resource="classpath:linkd/nms0001/oedipus-192.168.239.62-walk.txt"), @JUnitSnmpAgent(host="192.168.239.54", port=161, resource="classpath:linkd/nms0001/siegfrie-192.168.239.54-walk.txt")})
    public void testIsisISAdjTableCollection() throws Exception {
        String name = "isisISAdjTable";
        IsisISAdjTable m_isisISAdjTable = new IsisISAdjTable(InetAddressUtils.addr((String)"192.168.239.51"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_isisISAdjTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"192.168.239.51"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            Assert.assertEquals((Object)false, (Object)true);
        }
        Collection isisISAdjTableEntryCollection = m_isisISAdjTable.getEntries();
        Assert.assertEquals((long)2L, (long)isisISAdjTableEntryCollection.size());
        Iterator iter = isisISAdjTableEntryCollection.iterator();
        IsisISAdjTableEntry entry1 = (IsisISAdjTableEntry)iter.next();
        Assert.assertEquals((long)599L, (long)entry1.getIsisCircIndex().intValue());
        Assert.assertEquals((long)1L, (long)entry1.getIsisISAdjIndex().intValue());
        Assert.assertEquals((Object)IsisISAdjTableEntry.IsisISAdjState.UP, (Object)entry1.getIsIsAdjStatus());
        Assert.assertEquals((Object)"001f12accbf1", (Object)entry1.getIsIsAdjNeighSnpaAddress());
        Assert.assertEquals((Object)IsisISAdjTableEntry.IsisISAdjNeighSysType.l1_IntermediateSystem, (Object)entry1.getIsisISAdjNeighSysType());
        Assert.assertEquals((Object)"000110255062", (Object)entry1.getIsIsAdjNeighSysId());
        Assert.assertEquals((long)0L, (long)entry1.getIsisAdjNbrExtendedCircID().intValue());
        IsisISAdjTableEntry entry2 = (IsisISAdjTableEntry)iter.next();
        Assert.assertEquals((long)600L, (long)entry2.getIsisCircIndex().intValue());
        Assert.assertEquals((long)1L, (long)entry2.getIsisISAdjIndex().intValue());
        Assert.assertEquals((Object)IsisISAdjTableEntry.IsisISAdjState.UP, (Object)entry2.getIsIsAdjStatus());
        Assert.assertEquals((Object)"001f12acc3f2", (Object)entry2.getIsIsAdjNeighSnpaAddress());
        Assert.assertEquals((Object)IsisISAdjTableEntry.IsisISAdjNeighSysType.l1_IntermediateSystem, (Object)entry2.getIsisISAdjNeighSysType());
        Assert.assertEquals((Object)"000110255054", (Object)entry2.getIsIsAdjNeighSysId());
        Assert.assertEquals((long)0L, (long)entry2.getIsisAdjNbrExtendedCircID().intValue());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.168.239.51", port=161, resource="classpath:linkd/nms0001/froh-192.168.239.51-walk.txt"), @JUnitSnmpAgent(host="192.168.239.62", port=161, resource="classpath:linkd/nms0001/oedipus-192.168.239.62-walk.txt"), @JUnitSnmpAgent(host="192.168.239.54", port=161, resource="classpath:linkd/nms0001/siegfrie-192.168.239.54-walk.txt")})
    public void testIsisCircTableCollection() throws Exception {
        String name = "isisCircTable";
        IsisCircTable m_isisCircTable = new IsisCircTable(InetAddressUtils.addr((String)"192.168.239.51"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_isisCircTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"192.168.239.51"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            Assert.assertEquals((Object)false, (Object)true);
        }
        Collection isisCircTableEntryCollection = m_isisCircTable.getEntries();
        Assert.assertEquals((long)3L, (long)isisCircTableEntryCollection.size());
        Iterator iter = isisCircTableEntryCollection.iterator();
        IsisCircTableEntry entry1 = (IsisCircTableEntry)iter.next();
        Assert.assertEquals((long)16L, (long)entry1.getIsisCircIndex().intValue());
        Assert.assertEquals((long)16L, (long)entry1.getIsisCircIfIndex().intValue());
        IsisCircTableEntry entry2 = (IsisCircTableEntry)iter.next();
        Assert.assertEquals((long)599L, (long)entry2.getIsisCircIndex().intValue());
        Assert.assertEquals((long)599L, (long)entry2.getIsisCircIfIndex().intValue());
        IsisCircTableEntry entry3 = (IsisCircTableEntry)iter.next();
        Assert.assertEquals((long)600L, (long)entry3.getIsisCircIndex().intValue());
        Assert.assertEquals((long)600L, (long)entry3.getIsisCircIfIndex().intValue());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.168.239.51", port=161, resource="classpath:linkd/nms0001/froh-192.168.239.51-walk.txt"), @JUnitSnmpAgent(host="192.168.239.62", port=161, resource="classpath:linkd/nms0001/oedipus-192.168.239.62-walk.txt"), @JUnitSnmpAgent(host="192.168.239.54", port=161, resource="classpath:linkd/nms0001/siegfrie-192.168.239.54-walk.txt")})
    public void testIsIsLinks() throws Exception {
        this.m_nodeDao.save((Object)this.getFroh());
        this.m_nodeDao.save((Object)this.getOedipus());
        this.m_nodeDao.save((Object)this.getSiegFrie());
        this.m_nodeDao.flush();
        Package example1 = this.m_linkdConfig.getPackage("example1");
        example1.setUseBridgeDiscovery(false);
        example1.setUseIpRouteDiscovery(false);
        example1.setEnableVlanDiscovery(false);
        example1.setUseOspfDiscovery(false);
        example1.setUseLldpDiscovery(false);
        example1.setSaveStpInterfaceTable(false);
        example1.setSaveRouteTable(false);
        example1.setSaveStpNodeTable(false);
        OnmsNode froh = this.m_nodeDao.findByForeignId("linkd", "froh");
        OnmsNode oedipus = this.m_nodeDao.findByForeignId("linkd", "oedipus");
        OnmsNode siegfrie = this.m_nodeDao.findByForeignId("linkd", "siegfrie");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(froh.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(oedipus.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(siegfrie.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(froh.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(oedipus.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(siegfrie.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_dataLinkInterfaceDao.countAll());
        Collection nodes = this.m_linkd.getLinkableNodesOnPackage("example1");
        Assert.assertEquals((long)3L, (long)nodes.size());
        block5: for (LinkableNode node : nodes) {
            Assert.assertEquals((long)2L, (long)node.getIsisInterfaces().size());
            switch (node.getNodeId()) {
                case 1: {
                    Assert.assertEquals((Object)"000110088500", (Object)node.getIsisSysId());
                    continue block5;
                }
                case 2: {
                    Assert.assertEquals((Object)"000110255062", (Object)node.getIsisSysId());
                    continue block5;
                }
                case 3: {
                    Assert.assertEquals((Object)"000110255054", (Object)node.getIsisSysId());
                    continue block5;
                }
            }
            Assert.assertEquals((long)-1L, (long)node.getNodeId());
        }
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        Assert.assertEquals((long)3L, (long)this.m_dataLinkInterfaceDao.countAll());
        List datalinkinterfaces = this.m_dataLinkInterfaceDao.findAll();
        int start = this.getStartPoint(datalinkinterfaces);
        for (DataLinkInterface datalinkinterface : datalinkinterfaces) {
            Integer linkid = datalinkinterface.getId();
            if (linkid == start) {
                this.checkLink(froh, oedipus, 599, 578, datalinkinterface);
                continue;
            }
            if (linkid == start + 1) {
                this.checkLink(froh, siegfrie, 600, 552, datalinkinterface);
                continue;
            }
            if (linkid == start + 2) {
                this.checkLink(oedipus, siegfrie, 575, 533, datalinkinterface);
                continue;
            }
            this.checkLink(froh, froh, -1, -1, datalinkinterface);
        }
        DataLinkInterface iface = (DataLinkInterface)this.m_dataLinkInterfaceDao.findByNodeIdAndIfIndex(froh.getId(), Integer.valueOf(599)).iterator().next();
        iface.setNodeParentId(oedipus.getId());
        iface.setParentIfIndex(Integer.valueOf(578));
        iface.setStatus(OnmsArpInterface.StatusType.ACTIVE);
        iface.setLastPollTime(new Date());
        this.m_dataLinkInterfaceDao.saveOrUpdate((Object)iface);
        Assert.assertEquals((long)3L, (long)this.m_dataLinkInterfaceDao.countAll());
    }
}

