/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.config.LinkdConfig;
import org.opennms.netmgt.config.LinkdConfigFactory;
import org.opennms.netmgt.linkd.Linkd;
import org.opennms.netmgt.linkd.LinkdTestHelper;
import org.opennms.netmgt.model.NetworkBuilder;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.SnmpInterfaceBuilder;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/applicationContext-proxy-snmp.xml", "classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-linkd.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment(systemProperties={"org.opennms.provisiond.enableDiscovery=false"})
@JUnitTemporaryDatabase
public abstract class LinkdTestBuilder
extends LinkdTestHelper {
    private boolean firstTest = true;
    @Autowired
    protected Linkd m_linkd;
    @Autowired
    protected LinkdConfig m_linkdConfig;
    NetworkBuilder m_networkBuilder;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() throws Exception {
        if (this.firstTest) {
            this.setUpLogging();
        } else {
            this.setUpLinkdConfiguration();
        }
        this.firstTest = false;
    }

    public void setUpLogging() throws Exception {
        Properties p = new Properties();
        p.setProperty("log4j.logger.org.hibernate.SQL", "WARN");
        p.setProperty("log4j.logger.org.hibernate.cfg", "WARN");
        p.setProperty("log4j.logger.org.springframework", "WARN");
        p.setProperty("log4j.logger.com.mchange.v2.resourcepool", "WARN");
        MockLogAppender.setupLogging((Properties)p);
    }

    public void setUpLinkdConfiguration() throws Exception {
        ClassPathResource config = new ClassPathResource("etc/linkd-configuration.xml");
        this.m_linkdConfig = new LinkdConfigFactory(config.getInputStream());
        this.m_linkd.setLinkdConfig(this.m_linkdConfig);
    }

    @After
    public void tearDown() throws Exception {
        for (OnmsNode node : this.m_nodeDao.findAll()) {
            this.m_nodeDao.delete((Object)node);
        }
        this.m_nodeDao.flush();
    }

    NetworkBuilder getNetworkBuilder() {
        if (this.m_networkBuilder == null) {
            this.m_networkBuilder = new NetworkBuilder();
        }
        return this.m_networkBuilder;
    }

    OnmsNode getNode(String name, String sysoid, String primaryip, Map<InetAddress, Integer> ipinterfacemap, Map<Integer, String> ifindextoifnamemap, Map<Integer, String> ifindextomacmap, Map<Integer, String> ifindextoifdescrmap, Map<Integer, String> ifindextoifalias) {
        return this.getNode(name, sysoid, primaryip, ipinterfacemap, ifindextoifnamemap, ifindextomacmap, ifindextoifdescrmap, ifindextoifalias, new HashMap<Integer, InetAddress>());
    }

    OnmsNode getNode(String name, String sysoid, String primaryip, Map<InetAddress, Integer> ipinterfacemap, Map<Integer, String> ifindextoifnamemap, Map<Integer, String> ifindextomacmap, Map<Integer, String> ifindextoifdescrmap, Map<Integer, String> ifindextoifalias, Map<Integer, InetAddress> ifindextonetmaskmap) {
        NetworkBuilder nb = this.getNetworkBuilder();
        nb.addNode(name).setForeignSource("linkd").setForeignId(name).setSysObjectId(sysoid).setSysName(name).setType(OnmsNode.NodeType.ACTIVE);
        HashMap<Integer, SnmpInterfaceBuilder> ifindexsnmpbuildermap = new HashMap<Integer, SnmpInterfaceBuilder>();
        for (Integer ifIndex : ifindextoifnamemap.keySet()) {
            ifindexsnmpbuildermap.put(ifIndex, nb.addSnmpInterface(ifIndex.intValue()).setIfType(Integer.valueOf(6)).setIfName(ifindextoifnamemap.get(ifIndex)).setIfAlias(this.getSuitableString(ifindextoifalias, ifIndex)).setIfSpeed(100000000L).setNetMask(this.getMask(ifindextonetmaskmap, ifIndex)).setPhysAddr(this.getSuitableString(ifindextomacmap, ifIndex)).setIfDescr(this.getSuitableString(ifindextoifdescrmap, ifIndex)));
        }
        for (InetAddress ipaddr : ipinterfacemap.keySet()) {
            String isSnmpPrimary = "N";
            Integer ifIndex = ipinterfacemap.get(ipaddr);
            if (ipaddr.getHostAddress().equals(primaryip)) {
                isSnmpPrimary = "P";
            }
            if (ifIndex == null) {
                nb.addInterface(ipaddr.getHostAddress()).setIsSnmpPrimary(isSnmpPrimary).setIsManaged("M");
                continue;
            }
            nb.addInterface(ipaddr.getHostAddress(), ((SnmpInterfaceBuilder)ifindexsnmpbuildermap.get(ifIndex)).getSnmpInterface()).setIsSnmpPrimary(isSnmpPrimary).setIsManaged("M");
        }
        return nb.getCurrentNode();
    }

    private InetAddress getMask(Map<Integer, InetAddress> ifindextonetmaskmap, Integer ifIndex) {
        if (ifindextonetmaskmap.containsKey(ifIndex)) {
            return ifindextonetmaskmap.get(ifIndex);
        }
        return null;
    }

    private String getSuitableString(Map<Integer, String> ifindextomacmap, Integer ifIndex) {
        String value = "";
        if (ifindextomacmap.containsKey(ifIndex)) {
            value = ifindextomacmap.get(ifIndex);
        }
        return value;
    }

    protected OnmsNode getNodeWithoutSnmp(String name, String ipaddr) {
        NetworkBuilder nb = this.getNetworkBuilder();
        nb.addNode(name).setForeignSource("linkd").setForeignId(name).setType(OnmsNode.NodeType.ACTIVE);
        nb.addInterface(ipaddr).setIsSnmpPrimary("N").setIsManaged("M");
        return nb.getCurrentNode();
    }
}

