/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.linkd.DiscoveryLink;
import org.opennms.netmgt.linkd.OspfNbrInterface;

public class LinkdBaseTest {
    @Test
    public void testDiscoveryOspfGetSubNetAddress() throws Exception {
        DiscoveryLink discovery = new DiscoveryLink();
        OspfNbrInterface ospfinterface = new OspfNbrInterface(InetAddressUtils.addr((String)"192.168.9.1"));
        ospfinterface.setOspfNbrIpAddr(InetAddressUtils.addr((String)"192.168.15.45"));
        ospfinterface.setOspfNbrNetMask(InetAddressUtils.addr((String)"255.255.255.0"));
        Assert.assertEquals((Object)InetAddressUtils.addr((String)"192.168.15.0"), (Object)discovery.getSubnetAddress(ospfinterface));
        ospfinterface.setOspfNbrNetMask(InetAddressUtils.addr((String)"255.255.0.0"));
        Assert.assertEquals((Object)InetAddressUtils.addr((String)"192.168.0.0"), (Object)discovery.getSubnetAddress(ospfinterface));
        ospfinterface.setOspfNbrNetMask(InetAddressUtils.addr((String)"255.255.255.252"));
        Assert.assertEquals((Object)InetAddressUtils.addr((String)"192.168.15.44"), (Object)discovery.getSubnetAddress(ospfinterface));
        ospfinterface.setOspfNbrNetMask(InetAddressUtils.addr((String)"255.255.255.240"));
        Assert.assertEquals((Object)InetAddressUtils.addr((String)"192.168.15.32"), (Object)discovery.getSubnetAddress(ospfinterface));
    }

    @Test
    public void testBridgePortFromDesignatedBridgePort() {
        Assert.assertEquals((long)5826L, (long)(0x1FFF & Integer.parseInt("96c2", 16)));
        Assert.assertEquals((long)5781L, (long)(0x1FFF & Integer.parseInt("9695", 16)));
        Assert.assertEquals((long)4230L, (long)(0x1FFF & Integer.parseInt("9086", 16)));
        Assert.assertEquals((long)110L, (long)(0x1FFF & Integer.parseInt("806e", 16)));
    }
}

