/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd;

import java.net.InetSocketAddress;
import org.junit.Ignore;
import org.junit.Test;
import org.opennms.netmgt.mock.OpenNMSTestCase;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.utils.TcpEventProxy;

public class MemoryLeakTest {
    private static final long MINS = 28800000L;

    @Test
    @Ignore
    public void testMemory() throws Exception {
        TcpEventProxy proxy = new TcpEventProxy(new InetSocketAddress("127.0.0.1", OpenNMSTestCase.PROXY_PORT));
        double eventRate = 0.02;
        long start = System.currentTimeMillis();
        long count = 0L;
        while (System.currentTimeMillis() - start < 28800000L) {
            long now = Math.max(System.currentTimeMillis(), 1L);
            double actualRate = (double)count / (double)(now - start);
            if (actualRate < eventRate) {
                this.sendEvent((EventProxy)proxy, count);
                ++count;
            }
            Thread.sleep(30L);
            System.err.println(String.format("Expected Rate: %f Actual Rate: %f Events Sent: %d", eventRate, actualRate, count));
        }
    }

    private void sendEvent(EventProxy proxy, long count) throws Exception {
        EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/authentication/successfulLogin", "MemoryLeakTest");
        bldr.addParam("user", "brozow");
        proxy.send(bldr.getEvent());
        long free = Runtime.getRuntime().freeMemory();
        long max = Runtime.getRuntime().maxMemory();
        double pct = (double)free / (double)max;
        System.err.println("% Free Memory is " + pct);
        if (pct < 0.01) {
            throw new IllegalStateException("Memory Used up!");
        }
    }
}

