/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd;

import java.net.InetAddress;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.api.EventDao;
import org.opennms.netmgt.dao.api.ServiceTypeDao;
import org.opennms.netmgt.eventd.Eventd;
import org.opennms.netmgt.mock.MockEventUtil;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventIpcManager;
import org.opennms.netmgt.xml.event.AlarmData;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/applicationContext-eventDaemon.xml", "classpath:/META-INF/opennms/applicationContext-mockDao.xml", "classpath:/META-INF/opennms/applicationContext-mockEventd.xml"})
@JUnitConfigurationEnvironment
public class EventdTest
implements InitializingBean {
    private static final long SLEEP_TIME = 50L;
    @Autowired
    @Qualifier(value="eventIpcManagerImpl")
    private EventIpcManager m_eventdIpcMgr;
    @Autowired
    private Eventd m_eventd;
    @Autowired
    private EventDao m_eventDao;
    @Autowired
    private ServiceTypeDao m_serviceTypeDao;
    @Autowired
    private DatabasePopulator m_databasePopulator;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() {
        MockLogAppender.setupLogging();
        this.m_databasePopulator.populateDatabase();
        this.m_eventd.onStart();
    }

    @After
    public void tearDown() {
        this.m_eventd.onStop();
        this.m_databasePopulator.resetDatabase();
        MockLogAppender.assertNoWarningsOrGreater();
    }

    @Test
    public void testPersistEvent() throws Exception {
        CriteriaBuilder cb = new CriteriaBuilder(OnmsEvent.class);
        cb.eq("eventuei", (Object)"uei.opennms.org/nodes/nodeDown");
        Assert.assertEquals((long)0L, (long)this.m_eventDao.countMatching(cb.toCriteria()));
        OnmsNode node = this.m_databasePopulator.getNode1();
        Assert.assertNotNull((Object)node);
        this.sendNodeDownEvent(null, node);
        Thread.sleep(50L);
        List matching = this.m_eventDao.findMatching(cb.toCriteria());
        System.err.println("matching = " + matching);
        Assert.assertEquals((long)1L, (long)this.m_eventDao.countMatching(cb.toCriteria()));
        node = this.m_databasePopulator.getNode2();
        Assert.assertNotNull((Object)node);
        Event generatedEvent = this.sendNodeDownEvent(null, node);
        Thread.sleep(50L);
        Assert.assertEquals((long)2L, (long)this.m_eventDao.countMatching(cb.toCriteria()));
        Assert.assertNull((Object)generatedEvent.getInterfaceAddress());
        cb.isNull("ipaddr");
        Assert.assertEquals((String)("failed, found: " + this.m_eventDao.findMatching(cb.toCriteria())), (long)2L, (long)this.m_eventDao.countMatching(cb.toCriteria()));
    }

    @Test
    public void testPersistEventWithService() throws Exception {
        CriteriaBuilder cb = new CriteriaBuilder(OnmsEvent.class);
        cb.eq("eventuei", (Object)"uei.opennms.org/nodes/serviceUnresponsive");
        Assert.assertEquals((long)0L, (long)this.m_eventDao.countMatching(cb.toCriteria()));
        Assert.assertNotNull((Object)this.m_serviceTypeDao.findByName("ICMP"));
        OnmsNode node = this.m_databasePopulator.getNode1();
        Assert.assertNotNull((Object)node);
        OnmsIpInterface intf = node.getIpInterfaceByIpAddress("192.168.1.1");
        Assert.assertNotNull((Object)intf);
        System.err.println("services = " + intf.getMonitoredServices());
        OnmsMonitoredService svc = intf.getMonitoredServiceByServiceType("ICMP");
        Assert.assertNotNull((Object)svc);
        Assert.assertEquals((Object)"192.168.1.1", (Object)InetAddressUtils.str((InetAddress)svc.getIpAddress()));
        Integer serviceId = svc.getServiceId();
        this.sendServiceDownEvent(null, svc);
        Thread.sleep(50L);
        Assert.assertEquals((long)1L, (long)this.m_eventDao.countMatching(cb.toCriteria()));
        Assert.assertEquals((String)"service ID for event", (Object)serviceId, (Object)((OnmsEvent)this.m_eventDao.findMatching(cb.toCriteria()).get(0)).getServiceType().getId());
    }

    private Event sendNodeDownEvent(String reductionKey, OnmsNode node) {
        EventBuilder e = MockEventUtil.createNodeDownEventBuilder((String)"Test", (OnmsNode)node);
        if (reductionKey != null) {
            AlarmData data = new AlarmData();
            data.setAlarmType(Integer.valueOf(1));
            data.setReductionKey(reductionKey);
            e.setAlarmData(data);
        } else {
            e.setAlarmData(null);
        }
        e.setLogDest("logndisplay");
        e.setLogMessage("testing");
        Event event = e.getEvent();
        this.m_eventdIpcMgr.sendNow(event);
        return event;
    }

    private void sendServiceDownEvent(String reductionKey, OnmsMonitoredService svc) {
        EventBuilder e = MockEventUtil.createEventBuilder((String)"Test", (String)"uei.opennms.org/nodes/serviceUnresponsive", (int)svc.getNodeId(), (String)InetAddressUtils.str((InetAddress)svc.getIpAddress()), (String)svc.getServiceName(), (String)"Not responding");
        if (reductionKey != null) {
            AlarmData data = new AlarmData();
            data.setAlarmType(Integer.valueOf(1));
            data.setReductionKey(reductionKey);
            e.setAlarmData(data);
        } else {
            e.setAlarmData(null);
        }
        e.setLogDest("logndisplay");
        e.setLogMessage("testing");
        this.m_eventdIpcMgr.sendNow(e.getEvent());
    }
}

