/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.netmgt.config.api.EventConfDao;
import org.opennms.netmgt.eventd.EventExpander;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/applicationContext-eventDaemon.xml", "classpath:/META-INF/opennms/applicationContext-mockDao.xml", "classpath:/META-INF/opennms/applicationContext-mockEventd.xml"})
@JUnitConfigurationEnvironment
public class EventExpanderTest {
    @Autowired
    private EventConfDao m_eventConfDao;
    private EventExpander m_eventExpander;

    @Before
    public void setUp() {
        this.m_eventExpander = new EventExpander();
        this.m_eventExpander.setEventConfDao(this.m_eventConfDao);
        this.m_eventExpander.afterPropertiesSet();
    }

    @Test
    public void testEventExpander() {
        EventBuilder eb = new EventBuilder("uei.opennms.org/nodes/nodeDown", "EventExpanderTest");
        Event event = eb.getEvent();
        this.m_eventExpander.process(null, event);
        Assert.assertNotNull((Object)event.getDescr());
        Assert.assertTrue((boolean)event.getLogmsg().getContent().contains("is down"));
    }
}

