/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import org.apache.commons.io.IOUtils;
import org.opennms.core.test.ConfigurationTestUtils;
import org.opennms.netmgt.collectd.JUnitCollector;
import org.opennms.netmgt.config.DataCollectionConfigDao;
import org.opennms.netmgt.config.DataCollectionConfigFactory;
import org.opennms.netmgt.config.DatabaseSchemaConfigFactory;
import org.opennms.netmgt.config.DefaultDataCollectionConfigDao;
import org.opennms.netmgt.config.HttpCollectionConfigFactory;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.netmgt.rrd.jrobin.JRobinRrdStrategy;
import org.opennms.test.FileAnticipator;
import org.springframework.core.io.Resource;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;

public class JUnitCollectorExecutionListener
extends AbstractTestExecutionListener {
    private File m_snmpRrdDirectory;
    private FileAnticipator m_fileAnticipator;

    public void beforeTestMethod(TestContext testContext) throws Exception {
        this.m_fileAnticipator = new FileAnticipator();
        JUnitCollector config = JUnitCollectorExecutionListener.findCollectorAnnotation(testContext);
        if (config == null) {
            return;
        }
        RrdUtils.setStrategy((RrdStrategy)new JRobinRrdStrategy());
        InputStream is = ConfigurationTestUtils.getInputStreamForResource((Object)testContext.getTestInstance(), (String)config.schemaConfig());
        DatabaseSchemaConfigFactory.setInstance((DatabaseSchemaConfigFactory)new DatabaseSchemaConfigFactory(is));
        is.close();
        this.m_snmpRrdDirectory = this.m_fileAnticipator.tempDir("snmp");
        this.m_snmpRrdDirectory.mkdirs();
        testContext.setAttribute("fileAnticipator", (Object)this.m_fileAnticipator);
        testContext.setAttribute("rrdDirectory", (Object)this.m_snmpRrdDirectory);
        if ("http".equalsIgnoreCase(config.datacollectionType()) || "https".equalsIgnoreCase(config.datacollectionType())) {
            is = ConfigurationTestUtils.getInputStreamForResourceWithReplacements((Object)testContext.getTestInstance(), (String)config.datacollectionConfig(), (String[][])new String[][]{{"%rrdRepository%", this.m_snmpRrdDirectory.getAbsolutePath()}});
            HttpCollectionConfigFactory factory = new HttpCollectionConfigFactory(is);
            HttpCollectionConfigFactory.setInstance((HttpCollectionConfigFactory)factory);
            HttpCollectionConfigFactory.init();
        } else if ("snmp".equalsIgnoreCase(config.datacollectionType())) {
            Resource r = ConfigurationTestUtils.getSpringResourceForResourceWithReplacements((Object)testContext.getTestInstance(), (String)config.datacollectionConfig(), (String[][])new String[][]{{"%rrdRepository%", this.m_snmpRrdDirectory.getAbsolutePath()}});
            DefaultDataCollectionConfigDao dataCollectionDao = new DefaultDataCollectionConfigDao();
            dataCollectionDao.setConfigResource(r);
            dataCollectionDao.afterPropertiesSet();
            DataCollectionConfigFactory.setInstance((DataCollectionConfigDao)dataCollectionDao);
        } else {
            throw new UnsupportedOperationException("data collection type '" + config.datacollectionType() + "' not supported");
        }
        IOUtils.closeQuietly((InputStream)is);
    }

    public void afterTestMethod(TestContext testContext) throws Exception {
        boolean shouldIgnoreNonExistent;
        JUnitCollector config = JUnitCollectorExecutionListener.findCollectorAnnotation(testContext);
        if (config == null) {
            return;
        }
        boolean bl = shouldIgnoreNonExistent = testContext.getTestException() != null;
        if (config.anticipateFiles().length > 0 || config.anticipateRrds().length > 0) {
            Thread.sleep(1000L);
        }
        if (config.anticipateRrds().length > 0) {
            for (String rrdFile : config.anticipateRrds()) {
                this.m_fileAnticipator.expecting(this.m_snmpRrdDirectory, rrdFile + RrdUtils.getExtension());
                this.m_fileAnticipator.expecting(this.m_snmpRrdDirectory, rrdFile + ".meta");
            }
        }
        if (config.anticipateFiles().length > 0) {
            for (String file : config.anticipateFiles()) {
                this.m_fileAnticipator.expecting(this.m_snmpRrdDirectory, file);
            }
        }
        RuntimeException e = null;
        if (this.m_fileAnticipator.isInitialized()) {
            try {
                this.m_fileAnticipator.deleteExpected(shouldIgnoreNonExistent);
            }
            catch (Throwable t) {
                e = new RuntimeException(t);
            }
        }
        JUnitCollectorExecutionListener.deleteResursively(this.m_snmpRrdDirectory);
        this.m_fileAnticipator.tearDown();
        if (e != null) {
            throw e;
        }
    }

    private static void deleteResursively(File directory) {
        if (!directory.exists()) {
            return;
        }
        if (directory.isDirectory()) {
            for (File f : directory.listFiles()) {
                JUnitCollectorExecutionListener.deleteResursively(f);
            }
        }
        directory.delete();
    }

    private static JUnitCollector findCollectorAnnotation(TestContext testContext) {
        Method testMethod = testContext.getTestMethod();
        JUnitCollector config = testMethod.getAnnotation(JUnitCollector.class);
        if (config != null) {
            return config;
        }
        Class testClass = testContext.getTestClass();
        return testClass.getAnnotation(JUnitCollector.class);
    }
}

