/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import org.junit.Assert;
import org.opennms.netmgt.collectd.CollectionSpecification;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionException;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.ServiceCollector;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.persistence.rrd.GroupPersister;
import org.opennms.netmgt.collection.persistence.rrd.OneToOnePersister;
import org.opennms.netmgt.config.collectd.Filter;
import org.opennms.netmgt.config.collectd.Package;
import org.opennms.netmgt.config.collectd.Parameter;
import org.opennms.netmgt.config.collectd.Service;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.test.FileAnticipator;

public abstract class CollectorTestUtils {
    static CollectionSpecification createCollectionSpec(String svcName, ServiceCollector svcCollector, String collectionName) {
        Package pkg = new Package();
        Filter filter = new Filter();
        filter.setContent("IPADDR IPLIKE *.*.*.*");
        pkg.setFilter(filter);
        Service service = new Service();
        service.setName(svcName);
        Parameter collectionParm = new Parameter();
        collectionParm.setKey("collection");
        collectionParm.setValue(collectionName);
        service.addParameter(collectionParm);
        pkg.addService(service);
        CollectionSpecification spec = new CollectionSpecification(pkg, svcName, svcCollector);
        return spec;
    }

    public static void persistCollectionSet(CollectionSpecification spec, CollectionSet collectionSet) {
        RrdRepository repository = spec.getRrdRepository("default");
        System.err.println("repository = " + repository);
        ServiceParameters params = new ServiceParameters(spec.getReadOnlyPropertyMap());
        System.err.println("service parameters = " + params);
        Object persister = Boolean.getBoolean("org.opennms.rrd.storeByGroup") ? new GroupPersister(params, repository) : new OneToOnePersister(params, repository);
        System.err.println("persister = " + persister);
        collectionSet.visit((CollectionSetVisitor)persister);
    }

    public static void collectNTimes(CollectionSpecification spec, CollectionAgent agent, int numUpdates) throws InterruptedException, CollectionException {
        for (int i = 0; i < numUpdates; ++i) {
            CollectionSet collectionSet = spec.collect(agent);
            Assert.assertEquals((String)"collection status", (long)1L, (long)collectionSet.getStatus());
            CollectorTestUtils.persistCollectionSet(spec, collectionSet);
            System.err.println("COLLECTION " + i + " FINISHED");
            Thread.sleep(1010L);
        }
    }

    public static void failToCollectNTimes(CollectionSpecification spec, CollectionAgent agent, int numUpdates) throws InterruptedException, CollectionException {
        for (int i = 0; i < numUpdates; ++i) {
            CollectionSet collectionSet = spec.collect(agent);
            Assert.assertEquals((String)"collection status", (long)2L, (long)collectionSet.getStatus());
            CollectorTestUtils.persistCollectionSet(spec, collectionSet);
            System.err.println("COLLECTION " + i + " FINISHED");
            Thread.sleep(1010L);
        }
    }

    public static File anticipatePath(FileAnticipator fa, File rootDir, String ... pathElements) {
        File parent = rootDir;
        Assert.assertTrue((pathElements.length > 0 ? 1 : 0) != 0);
        for (String pathElement : pathElements) {
            parent = fa.expecting(parent, pathElement);
        }
        return parent;
    }

    public static String rrd(String file) {
        return file + RrdUtils.getExtension();
    }
}

