/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.opennms.netmgt.capsd.plugins.SnmpPlugin;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.mock.OpenNMSTestCase;
import org.opennms.netmgt.snmp.SnmpStrategy;
import org.opennms.netmgt.snmp.joesnmp.JoeSnmpStrategy;
import org.opennms.netmgt.snmp.mock.MockSnmpStrategy;
import org.opennms.netmgt.snmp.snmp4j.Snmp4JStrategy;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

@RunWith(value=Parameterized.class)
public class SnmpPluginTest
extends OpenNMSTestCase {
    private static final String STRATEGY_CLASS_PROPERTY_NAME = "org.opennms.snmp.strategyClass";
    private boolean m_runAssertions = false;
    private SnmpPlugin m_plugin = null;

    public SnmpPluginTest(Class<? extends SnmpStrategy> strategyClass) {
        System.setProperty(STRATEGY_CLASS_PROPERTY_NAME, strategyClass.getName());
    }

    @Parameterized.Parameters
    public static Collection<Object[]> params() {
        Object[][] retval = new Object[][]{{JoeSnmpStrategy.class}, {Snmp4JStrategy.class}, {MockSnmpStrategy.class}};
        return Arrays.asList(retval);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        Assert.assertNotNull((String)"The org.opennms.snmp.strategyClass must be set to run this test", (Object)System.getProperty(STRATEGY_CLASS_PROPERTY_NAME));
        super.setUp();
        if (this.m_plugin == null) {
            this.m_plugin = new SnmpPlugin();
        }
        m_runSupers = false;
    }

    @Test
    public void testIsForcedV1ProtocolSupported() throws UnknownHostException {
        InetAddress address = this.myLocalHost();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("forced version", "snmpv1");
        if (this.m_runAssertions) {
            Assert.assertTrue((String)"protocol is not supported", (boolean)this.m_plugin.isProtocolSupported(address, map));
        }
    }

    @Test
    public void testIsExpectedValue() throws UnknownHostException {
        InetAddress address = this.myLocalHost();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("vbvalue", "\\.1\\.3\\.6\\.1\\.4\\.1.*");
        if (this.m_runAssertions) {
            Assert.assertTrue((String)"protocol is not supported", (boolean)this.m_plugin.isProtocolSupported(address, map));
        }
    }

    @Test
    public final void testIsProtocolSupportedInetAddress() throws UnknownHostException {
        if (this.m_runAssertions) {
            Assert.assertTrue((String)"protocol is not supported", (boolean)this.m_plugin.isProtocolSupported(this.myLocalHost()));
        }
    }

    @Test
    public final void testIsV3ProtocolSupported() throws ValidationException, IOException, IOException, MarshalException {
        this.setVersion(3);
        ByteArrayResource rsrc = new ByteArrayResource(this.getSnmpConfig().getBytes());
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory((Resource)rsrc));
        if (this.m_runAssertions) {
            Assert.assertTrue((String)"protocol is not supported", (boolean)this.m_plugin.isProtocolSupported(this.myLocalHost()));
        }
    }

    @Test
    public final void testIsV3ForcedToV1Supported() throws ValidationException, IOException, IOException, MarshalException {
        this.setVersion(3);
        ByteArrayResource rsrc = new ByteArrayResource(this.getSnmpConfig().getBytes());
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory((Resource)rsrc));
        HashMap<String, String> qualifiers = new HashMap<String, String>();
        qualifiers.put("force version", "snmpv1");
        if (this.m_runAssertions) {
            Assert.assertTrue((String)"protocol is not supported", (boolean)this.m_plugin.isProtocolSupported(this.myLocalHost(), qualifiers));
        }
    }
}

