/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.utils;

import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.model.events.EventBuilder;

public final class XmlrpcUtil {
    public static void createAndSendXmlrpcNotificationEvent(long txNo, String sourceUei, String message, int status, String generator) {
        ThreadCategory log = ThreadCategory.getInstance((String)"XmlrpcUtil");
        if (log.isDebugEnabled()) {
            log.debug("createAndSendXmlrpcNotificationEvent:  txNo= " + txNo + "\n" + " uei = " + sourceUei + "\n" + " message = " + message + "\n" + " status = " + status);
        }
        String hostAddress = InetAddressUtils.getLocalHostAddressAsString();
        EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/capsd/xmlrpcNotification", generator);
        bldr.setHost(hostAddress);
        bldr.addParam("txno", txNo);
        bldr.addParam("sourceUei", sourceUei);
        bldr.addParam("eventMessage", message);
        bldr.addParam("eventStatus", status);
        try {
            EventIpcManagerFactory.getIpcManager().sendNow(bldr.getEvent());
            if (log.isDebugEnabled()) {
                log.debug("createdAndSendXmlrpcNotificationEvent: successfully sent XMLRPC notification event for txno: " + txNo + " / " + sourceUei + " " + status);
            }
        }
        catch (Throwable t) {
            log.warn("run: unexpected throwable exception caught during send to middleware", t);
            int failureFlag = 2;
            EventBuilder bldr2 = new EventBuilder("uei.opennms.org/internal/capsd/xmlrpcNotification", generator);
            bldr2.setHost(hostAddress);
            bldr2.addParam("txno", txNo);
            bldr2.addParam("sourceUei", sourceUei);
            bldr2.addParam("eventMessage", message);
            bldr2.addParam("eventStatus", failureFlag);
            try {
                EventIpcManagerFactory.getIpcManager().sendNow(bldr2.getEvent());
                if (log.isDebugEnabled()) {
                    log.debug("createdAndSendXmlrpcNotificationEvent: successfully sent XMLRPC notification event for txno: " + txNo + " / " + sourceUei + " " + failureFlag);
                }
            }
            catch (Throwable te) {
                log.warn("run: unexpected throwable exception caught during send to middleware", te);
            }
        }
    }
}

