/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.util.ArrayList;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.syslogd.SyslogdIPMgr;
import org.opennms.netmgt.xml.event.Event;

final class BroadcastEventProcessor
implements EventListener {
    BroadcastEventProcessor() {
        ArrayList<String> ueiList = new ArrayList<String>();
        ueiList.add("uei.opennms.org/nodes/nodeGainedInterface");
        ueiList.add("uei.opennms.org/nodes/interfaceDeleted");
        EventIpcManagerFactory.init();
        EventIpcManagerFactory.getIpcManager().addEventListener((EventListener)this, ueiList);
    }

    public void close() {
        EventIpcManagerFactory.getIpcManager().removeEventListener((EventListener)this);
    }

    public void onEvent(Event event) {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        String eventUei = event.getUei();
        if (eventUei == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Received event: " + eventUei);
        }
        if (eventUei.equals("uei.opennms.org/nodes/nodeGainedInterface")) {
            if (Long.toString(event.getNodeid()) != null && event.getInterface() != null) {
                SyslogdIPMgr.setNodeId(event.getInterface(), event.getNodeid());
            }
            if (log.isDebugEnabled()) {
                log.debug("Added " + event.getInterface() + " to known node list");
            }
        } else if (eventUei.equals("uei.opennms.org/nodes/interfaceDeleted")) {
            if (event.getInterface() != null) {
                SyslogdIPMgr.removeNodeId(event.getInterface());
            }
            if (log.isDebugEnabled()) {
                log.debug("Removed " + event.getInterface() + " from known node list");
            }
        } else if (eventUei.equals("uei.opennms.org/nodes/interfaceReparented")) {
            if (Long.toString(event.getNodeid()) != null && event.getInterface() != null) {
                SyslogdIPMgr.setNodeId(event.getInterface(), event.getNodeid());
            }
            if (log.isDebugEnabled()) {
                log.debug("Reparented " + event.getInterface() + " to known node list");
            }
        }
    }

    public String getName() {
        return "Syslogd:BroadcastEventProcessor";
    }
}

