/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.EventConstants;

public final class DbIpRouteInterfaceEntry {
    public static final char STATUS_ACTIVE = 'A';
    public static final char STATUS_NOT_POLLED = 'N';
    public static final char STATUS_DELETED = 'D';
    public static final char STATUS_UNKNOWN = 'K';
    public static final int ROUTE_TYPE_OTHER = 1;
    public static final int ROUTE_TYPE_INVALID = 2;
    public static final int ROUTE_TYPE_DIRECT = 3;
    public static final int ROUTE_TYPE_INDIRECT = 4;
    int m_nodeId;
    int m_routeifindex;
    int m_routemetric1;
    int m_routemetric2;
    int m_routemetric3;
    int m_routemetric4;
    int m_routemetric5;
    int m_routetype = 1;
    int m_routeproto;
    String m_routedest;
    String m_routemask;
    String m_routenexthop;
    char m_status = (char)75;
    Timestamp m_lastPollTime;
    private static final String SQL_LOAD_IPROUTEINTERFACE = "SELECT routeMask,routeNextHop,routeifindex,routemetric1,routemetric2,routemetric3,routemetric4,routemetric5,routetype,routeproto,status,lastpolltime FROM iprouteinterface WHERE nodeid = ? AND routeDest = ? ";
    private boolean m_fromDb;
    private int m_changed;
    private static final int CHANGED_MASK = 1;
    private static final int CHANGED_NXT_HOP = 2;
    private static final int CHANGED_IFINDEX = 4;
    private static final int CHANGED_METRIC1 = 8;
    private static final int CHANGED_METRIC2 = 16;
    private static final int CHANGED_METRIC3 = 32;
    private static final int CHANGED_METRIC4 = 64;
    private static final int CHANGED_METRIC5 = 128;
    private static final int CHANGED_TYPE = 256;
    private static final int CHANGED_PROTO = 512;
    private static final int CHANGED_STATUS = 1024;
    private static final int CHANGED_POLLTIME = 2048;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insert(Connection c) throws SQLException {
        if (this.m_fromDb) {
            throw new IllegalStateException("The IP route interface record already exists in the database");
        }
        StringBuffer names = new StringBuffer("INSERT INTO IpRouteInterface (nodeid,routeDest");
        StringBuffer values = new StringBuffer("?,?");
        values.append(",?");
        names.append(",routeMask");
        values.append(",?");
        names.append(",routeNextHop");
        values.append(",?");
        names.append(",routeifindex");
        values.append(",?");
        names.append(",routemetric1");
        values.append(",?");
        names.append(",routemetric2");
        values.append(",?");
        names.append(",routemetric3");
        values.append(",?");
        names.append(",routemetric4");
        values.append(",?");
        names.append(",routemetric5");
        values.append(",?");
        names.append(",routetype");
        values.append(",?");
        names.append(",routeproto");
        values.append(",?");
        names.append(",status");
        values.append(",?");
        names.append(",lastpolltime");
        names.append(") VALUES (").append(values).append(')');
        LogUtils.debugf((Object)this, (String)"IpRouteInterfaceEntry.insert: SQL insert statment = %s", (Object[])new Object[]{names.toString()});
        DBUtils d = new DBUtils(this.getClass());
        try {
            PreparedStatement stmt = c.prepareStatement(names.toString());
            d.watch((Object)stmt);
            int ndx = 1;
            stmt.setInt(ndx++, this.m_nodeId);
            stmt.setString(ndx++, this.m_routedest);
            stmt.setString(ndx++, this.m_routemask);
            stmt.setString(ndx++, this.m_routenexthop);
            stmt.setInt(ndx++, this.m_routeifindex);
            stmt.setInt(ndx++, this.m_routemetric1);
            stmt.setInt(ndx++, this.m_routemetric2);
            stmt.setInt(ndx++, this.m_routemetric3);
            stmt.setInt(ndx++, this.m_routemetric4);
            stmt.setInt(ndx++, this.m_routemetric5);
            stmt.setInt(ndx++, this.m_routetype);
            stmt.setInt(ndx++, this.m_routeproto);
            stmt.setString(ndx++, new String(new char[]{this.m_status}));
            stmt.setTimestamp(ndx++, this.m_lastPollTime);
            int rc = stmt.executeUpdate();
            LogUtils.debugf((Object)this, (String)"IpRouteInterfaceEntry.insert: row %d", (Object[])new Object[]{rc});
        }
        finally {
            d.cleanUp();
        }
        this.m_fromDb = true;
        this.m_changed = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Connection c) throws SQLException {
        if (!this.m_fromDb) {
            throw new IllegalStateException("The record does not exists in the database");
        }
        StringBuffer sqlText = new StringBuffer("UPDATE IpRouteInterface SET ");
        int comma = 32;
        if ((this.m_changed & 1) == 1) {
            sqlText.append((char)comma).append("routeMask = ?");
            comma = 44;
        }
        if ((this.m_changed & 2) == 2) {
            sqlText.append((char)comma).append("routeNextHop = ?");
            comma = 44;
        }
        if ((this.m_changed & 4) == 4) {
            sqlText.append((char)comma).append("routeifindex = ?");
            comma = 44;
        }
        if ((this.m_changed & 8) == 8) {
            sqlText.append((char)comma).append("routemetric1 = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x10) == 16) {
            sqlText.append((char)comma).append("routemetric2 = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x20) == 32) {
            sqlText.append((char)comma).append("routemetric3 = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x40) == 64) {
            sqlText.append((char)comma).append("routemetric4 = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x80) == 128) {
            sqlText.append((char)comma).append("routemetric5 = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x100) == 256) {
            sqlText.append((char)comma).append("routetype = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x200) == 512) {
            sqlText.append((char)comma).append("routeproto = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x400) == 1024) {
            sqlText.append((char)comma).append("status = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x800) == 2048) {
            sqlText.append((char)comma).append("lastpolltime = ?");
            comma = 44;
        }
        sqlText.append(" WHERE nodeid = ? AND routeDest = ? ");
        LogUtils.debugf((Object)this, (String)"IpRouteInterfaceEntry.update: SQL insert statment = %s", (Object[])new Object[]{sqlText.toString()});
        DBUtils d = new DBUtils(this.getClass());
        try {
            PreparedStatement stmt = c.prepareStatement(sqlText.toString());
            d.watch((Object)stmt);
            int ndx = 1;
            if ((this.m_changed & 1) == 1) {
                stmt.setString(ndx++, this.m_routemask);
            }
            if ((this.m_changed & 2) == 2) {
                stmt.setString(ndx++, this.m_routenexthop);
            }
            if ((this.m_changed & 4) == 4) {
                stmt.setInt(ndx++, this.m_routeifindex);
            }
            if ((this.m_changed & 8) == 8) {
                stmt.setInt(ndx++, this.m_routemetric1);
            }
            if ((this.m_changed & 0x10) == 16) {
                stmt.setInt(ndx++, this.m_routemetric2);
            }
            if ((this.m_changed & 0x20) == 32) {
                stmt.setInt(ndx++, this.m_routemetric3);
            }
            if ((this.m_changed & 0x40) == 64) {
                stmt.setInt(ndx++, this.m_routemetric4);
            }
            if ((this.m_changed & 0x80) == 128) {
                stmt.setInt(ndx++, this.m_routemetric5);
            }
            if ((this.m_changed & 0x100) == 256) {
                stmt.setInt(ndx++, this.m_routetype);
            }
            if ((this.m_changed & 0x200) == 512) {
                stmt.setInt(ndx++, this.m_routeproto);
            }
            if ((this.m_changed & 0x400) == 1024) {
                stmt.setString(ndx++, new String(new char[]{this.m_status}));
            }
            if ((this.m_changed & 0x800) == 2048) {
                stmt.setTimestamp(ndx++, this.m_lastPollTime);
            }
            stmt.setInt(ndx++, this.m_nodeId);
            stmt.setString(ndx++, this.m_routedest);
            int rc = stmt.executeUpdate();
            LogUtils.debugf((Object)this, (String)"IpRouteInterfaceEntry.update: row %d", (Object[])new Object[]{rc});
        }
        finally {
            d.cleanUp();
        }
        this.m_changed = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean load(Connection c) throws SQLException {
        if (!this.m_fromDb) {
            throw new IllegalStateException("The record does not exists in the database");
        }
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            String str;
            stmt = c.prepareStatement(SQL_LOAD_IPROUTEINTERFACE);
            d.watch((Object)stmt);
            stmt.setInt(1, this.m_nodeId);
            stmt.setString(2, this.m_routedest);
            ResultSet rset = stmt.executeQuery();
            d.watch((Object)rset);
            if (!rset.next()) {
                LogUtils.debugf((Object)this, (String)"IpRouteInterfaceEntry.load: no result found", (Object[])new Object[0]);
                boolean bl = false;
                return bl;
            }
            int ndx = 1;
            this.m_routemask = rset.getString(ndx++);
            if (rset.wasNull()) {
                this.m_routemask = null;
            }
            this.m_routenexthop = rset.getString(ndx++);
            if (rset.wasNull()) {
                this.m_routenexthop = null;
            }
            this.m_routeifindex = rset.getInt(ndx++);
            if (rset.wasNull()) {
                this.m_routeifindex = -1;
            }
            this.m_routemetric1 = rset.getInt(ndx++);
            if (rset.wasNull()) {
                this.m_routemetric1 = -1;
            }
            this.m_routemetric2 = rset.getInt(ndx++);
            if (rset.wasNull()) {
                this.m_routemetric2 = -1;
            }
            this.m_routemetric3 = rset.getInt(ndx++);
            if (rset.wasNull()) {
                this.m_routemetric3 = -1;
            }
            this.m_routemetric4 = rset.getInt(ndx++);
            if (rset.wasNull()) {
                this.m_routemetric4 = -1;
            }
            this.m_routemetric5 = rset.getInt(ndx++);
            if (rset.wasNull()) {
                this.m_routemetric5 = -1;
            }
            this.m_routetype = rset.getInt(ndx++);
            if (rset.wasNull()) {
                this.m_routetype = 1;
            }
            this.m_routeproto = rset.getInt(ndx++);
            if (rset.wasNull()) {
                this.m_routeproto = -1;
            }
            this.m_status = (str = rset.getString(ndx++)) != null && !rset.wasNull() ? str.charAt(0) : (char)75;
            this.m_lastPollTime = rset.getTimestamp(ndx++);
        }
        finally {
            d.cleanUp();
        }
        LogUtils.debugf((Object)this, (String)"IpRouteInterfaceEntry.load: result found", (Object[])new Object[0]);
        this.m_changed = 0;
        return true;
    }

    DbIpRouteInterfaceEntry(int nodeId, String routedest, boolean exists) {
        this.m_nodeId = nodeId;
        this.m_fromDb = exists;
        this.m_routeifindex = -1;
        this.m_routemetric1 = -1;
        this.m_routemetric2 = -1;
        this.m_routemetric3 = -1;
        this.m_routemetric4 = -1;
        this.m_routemetric5 = -1;
        this.m_routetype = 1;
        this.m_routeproto = -1;
        this.m_routenexthop = null;
        this.m_routedest = routedest;
        this.m_routemask = null;
    }

    static DbIpRouteInterfaceEntry create(int nodeid, String routedest) {
        return new DbIpRouteInterfaceEntry(nodeid, routedest, false);
    }

    protected int get_nodeId() {
        return this.m_nodeId;
    }

    protected String get_routedest() {
        return this.m_routedest;
    }

    protected String get_routemask() {
        return this.m_routemask;
    }

    protected void set_routemask(String routemask) {
        this.m_routemask = routemask;
        this.m_changed |= 1;
    }

    protected boolean hasRouteMaskChanged() {
        return (this.m_changed & 1) == 1;
    }

    boolean updateRouteMask(String routemask) {
        if (this.m_routemask == null || !this.m_routemask.equals(routemask)) {
            this.set_routemask(routemask);
            return true;
        }
        return false;
    }

    protected String get_routenexthop() {
        return this.m_routenexthop;
    }

    protected void set_routenexthop(String routenexthop) {
        this.m_routenexthop = routenexthop;
        this.m_changed |= 2;
    }

    protected boolean hasRouteNextHopChanged() {
        return (this.m_changed & 2) == 2;
    }

    boolean updateRouteNextHop(String routenexthop) {
        if (this.m_routenexthop == null || !this.m_routenexthop.equals(routenexthop)) {
            this.set_routenexthop(routenexthop);
            return true;
        }
        return false;
    }

    protected int get_ifindex() {
        return this.m_routeifindex;
    }

    protected void set_ifindex(int ifindex) {
        this.m_routeifindex = ifindex;
        this.m_changed |= 4;
    }

    protected boolean hasIfIndexChanged() {
        return (this.m_changed & 4) == 4;
    }

    boolean updateIfIndex(int ifindex) {
        if (ifindex != this.m_routeifindex) {
            this.set_ifindex(ifindex);
            return true;
        }
        return false;
    }

    protected int get_routemetric1() {
        return this.m_routemetric1;
    }

    protected void set_routemetric1(int routemetric) {
        this.m_routemetric1 = routemetric;
        this.m_changed |= 8;
    }

    protected boolean hasRouteMetric1Changed() {
        return (this.m_changed & 8) == 8;
    }

    boolean updateRouteMetric1(int routemetric) {
        if (routemetric != this.m_routemetric1) {
            this.set_routemetric1(routemetric);
            return true;
        }
        return false;
    }

    protected int get_routemetric2() {
        return this.m_routemetric2;
    }

    protected void set_routemetric2(int routemetric) {
        this.m_routemetric2 = routemetric;
        this.m_changed |= 0x10;
    }

    protected boolean hasRouteMetric2Changed() {
        return (this.m_changed & 0x10) == 16;
    }

    boolean updateRouteMetric2(int routemetric) {
        if (routemetric != this.m_routemetric2) {
            this.set_routemetric2(routemetric);
            return true;
        }
        return false;
    }

    protected int get_routemetric3() {
        return this.m_routemetric3;
    }

    protected void set_routemetric3(int routemetric) {
        this.m_routemetric3 = routemetric;
        this.m_changed |= 0x20;
    }

    protected boolean hasRouteMetric3Changed() {
        return (this.m_changed & 0x20) == 32;
    }

    boolean updateRouteMetric3(int routemetric) {
        if (routemetric != this.m_routemetric3) {
            this.set_routemetric3(routemetric);
            return true;
        }
        return false;
    }

    protected int get_routemetric4() {
        return this.m_routemetric4;
    }

    protected void set_routemetric4(int routemetric) {
        this.m_routemetric4 = routemetric;
        this.m_changed |= 0x40;
    }

    protected boolean hasRouteMetric4Changed() {
        return (this.m_changed & 0x40) == 64;
    }

    boolean updateRouteMetric4(int routemetric) {
        if (routemetric != this.m_routemetric4) {
            this.set_routemetric4(routemetric);
            return true;
        }
        return false;
    }

    protected int get_routemetric5() {
        return this.m_routemetric5;
    }

    protected void set_routemetric5(int routemetric) {
        this.m_routemetric5 = routemetric;
        this.m_changed |= 0x80;
    }

    protected boolean hasRouteMetric5Changed() {
        return (this.m_changed & 0x80) == 128;
    }

    boolean updateRouteMetric5(int routemetric) {
        if (routemetric != this.m_routemetric5) {
            this.set_routemetric5(routemetric);
            return true;
        }
        return false;
    }

    protected int get_routetype() {
        return this.m_routetype;
    }

    protected void set_routetype(int routetype) {
        if (routetype == 1 || routetype == 2 || routetype == 3 || routetype == 4) {
            this.m_routetype = routetype;
        }
        this.m_changed |= 0x100;
    }

    protected boolean hasRouteTypeChanged() {
        return (this.m_changed & 0x100) == 256;
    }

    boolean updateRouteType(int routetype) {
        if (routetype != this.m_routetype) {
            this.set_routetype(routetype);
            return true;
        }
        return false;
    }

    protected int get_routeproto() {
        return this.m_routeproto;
    }

    protected void set_routeproto(int routeproto) {
        this.m_routeproto = routeproto;
        this.m_changed |= 0x200;
    }

    protected boolean hasRouteProtoChanged() {
        return (this.m_changed & 0x200) == 512;
    }

    boolean updateRouteProto(int routeproto) {
        if (routeproto != this.m_routeproto) {
            this.set_routeproto(routeproto);
            return true;
        }
        return false;
    }

    protected char get_status() {
        return this.m_status;
    }

    protected void set_status(char status) {
        if (status == 'A' || status == 'N' || status == 'D') {
            this.m_status = status;
        }
        this.m_changed |= 0x400;
    }

    protected boolean hasStatusChanged() {
        return (this.m_changed & 0x400) == 1024;
    }

    boolean updateStatus(char status) {
        if (status != this.m_status) {
            this.set_status(status);
            return true;
        }
        return false;
    }

    protected Timestamp get_lastpolltime() {
        return this.m_lastPollTime;
    }

    String getLastPollTimeString() {
        String result = null;
        if (this.m_lastPollTime != null) {
            result = this.m_lastPollTime.toString();
        }
        return result;
    }

    protected void set_lastpolltime(String time) throws ParseException {
        if (time == null) {
            this.m_lastPollTime = null;
        } else {
            Date tmpDate = EventConstants.parseToDate((String)time);
            this.m_lastPollTime = new Timestamp(tmpDate.getTime());
        }
        this.m_changed |= 0x800;
    }

    protected void set_lastpolltime(Date time) {
        this.m_lastPollTime = new Timestamp(time.getTime());
        this.m_changed |= 0x800;
    }

    protected void set_lastpolltime(Timestamp time) {
        this.m_lastPollTime = time;
        this.m_changed |= 0x800;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void store() throws SQLException {
        if (this.m_changed != 0 || !this.m_fromDb) {
            Connection db = null;
            try {
                db = DataSourceFactory.getInstance().getConnection();
                this.store(db);
                if (!db.getAutoCommit()) {
                    db.commit();
                }
            }
            finally {
                try {
                    if (db != null) {
                        db.close();
                    }
                }
                catch (SQLException e) {
                    LogUtils.warnf((Object)this, (Throwable)e, (String)"Exception closing JDBC connection", (Object[])new Object[0]);
                }
            }
        }
    }

    void store(Connection db) throws SQLException {
        if (this.m_changed != 0 || !this.m_fromDb) {
            if (this.m_fromDb) {
                this.update(db);
            } else {
                this.insert(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DbIpRouteInterfaceEntry get(int nid, String routedest) throws SQLException {
        Connection db = null;
        try {
            db = DataSourceFactory.getInstance().getConnection();
            DbIpRouteInterfaceEntry dbIpRouteInterfaceEntry = DbIpRouteInterfaceEntry.get(db, nid, routedest);
            return dbIpRouteInterfaceEntry;
        }
        finally {
            try {
                if (db != null) {
                    db.close();
                }
            }
            catch (SQLException e) {
                LogUtils.warnf(DbIpRouteInterfaceEntry.class, (Throwable)e, (String)"Exception closing JDBC connection", (Object[])new Object[0]);
            }
        }
    }

    static DbIpRouteInterfaceEntry get(Connection db, int nid, String routedest) throws SQLException {
        DbIpRouteInterfaceEntry entry = new DbIpRouteInterfaceEntry(nid, routedest, true);
        if (!entry.load(db)) {
            entry = null;
        }
        return entry;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("db", this.m_fromDb).append("nodeId", this.m_nodeId).append("routeDestination", (Object)this.m_routedest).append("routeMask", (Object)this.m_routemask).append("routeNextHop", (Object)this.m_routenexthop).append("ifIndex", this.m_routeifindex).append("routeMetric1", this.m_routemetric1).append("routeMetric2", this.m_routemetric2).append("routeMetric3", this.m_routemetric3).append("routeMetric4", this.m_routemetric4).append("routeMetric5", this.m_routemetric5).append("routeType", this.m_routetype).append("routeProtocol", this.m_routeproto).append("status", this.m_status).append("lastPollTime", (Object)this.m_lastPollTime).toString();
    }
}

