/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.discovery;

import java.net.InetAddress;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.icmp.EchoPacket;
import org.opennms.netmgt.icmp.PingResponseCallback;
import org.opennms.netmgt.model.events.EventBuilder;

public class DiscoveryPingResponseCallback
implements PingResponseCallback {
    static final String EVENT_SOURCE_VALUE = "OpenNMS.Discovery";

    public void handleResponse(InetAddress address, EchoPacket response) {
        EventBuilder eb = new EventBuilder("uei.opennms.org/internal/discovery/newSuspect", EVENT_SOURCE_VALUE);
        eb.setInterface(address);
        eb.setHost(InetAddressUtils.getLocalHostName());
        eb.addParam("RTT", response.getReceivedTimeNanos() - response.getSentTimeNanos());
        try {
            EventIpcManagerFactory.getIpcManager().sendNow(eb.getEvent());
            if (this.log().isDebugEnabled()) {
                this.log().debug("Sent event: uei.opennms.org/internal/discovery/newSuspect");
            }
        }
        catch (Throwable t) {
            this.log().warn("run: unexpected throwable exception caught during send to middleware", t);
        }
    }

    public void handleTimeout(InetAddress address, EchoPacket request) {
        this.log().debug("request timed out: " + address);
    }

    public void handleError(InetAddress address, EchoPacket request, Throwable t) {
        this.log().debug("an error occurred pinging " + address, t);
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

