/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.CapsdProtocolInfo;
import org.opennms.netmgt.capsd.Plugin;
import org.opennms.netmgt.config.CapsdConfig;
import org.opennms.netmgt.config.capsd.Property;
import org.opennms.netmgt.config.capsd.ProtocolConfiguration;
import org.opennms.netmgt.config.capsd.ProtocolPlugin;
import org.opennms.netmgt.config.capsd.Range;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class PluginManager
implements InitializingBean {
    private CapsdConfig m_capsdConfig;
    private Map<String, Plugin> m_pluginsByProtocol = new TreeMap<String, Plugin>();
    private Map<String, Plugin> m_pluginsByClass = new TreeMap<String, Plugin>();

    private void instantiatePlugins() throws ValidationException {
        List plugins = this.getCapsdConfig().getProtocolPlugins();
        for (ProtocolPlugin plugin : plugins) {
            try {
                if (this.m_pluginsByClass.containsKey(plugin.getClassName())) {
                    Plugin oplugin = this.m_pluginsByClass.get(plugin.getClassName());
                    this.m_pluginsByProtocol.put(plugin.getProtocol(), oplugin);
                    continue;
                }
                Class<?> cplugin = Class.forName(plugin.getClassName());
                Object oplugin = cplugin.newInstance();
                if (!(oplugin instanceof Plugin)) {
                    throw new ValidationException("CapsdConfigFactory: successfully loaded plugin class for protocol " + plugin.getProtocol() + ", class-name = " + plugin.getClassName() + ", however the class is not an instance of " + Plugin.class.getName());
                }
                Plugin p = (Plugin)oplugin;
                this.m_pluginsByClass.put(plugin.getClassName(), p);
                this.m_pluginsByProtocol.put(plugin.getProtocol(), p);
            }
            catch (Throwable t) {
                String message = "CapsdConfigFactory: failed to load plugin for protocol " + plugin.getProtocol() + ", class-name = " + plugin.getClassName() + ", exception = " + t;
                this.log().error(message, t);
                throw new ValidationException(message, t);
            }
        }
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public CapsdProtocolInfo[] getProtocolSpecification(InetAddress address) {
        ArrayList<CapsdProtocolInfo> lprotos = new ArrayList<CapsdProtocolInfo>(this.getCapsdConfig().getConfiguration().getProtocolPluginCount());
        List plugins = this.getCapsdConfig().getProtocolPlugins();
        block0: for (ProtocolPlugin plugin : plugins) {
            boolean found = false;
            for (ProtocolConfiguration pluginConf : this.getCapsdConfig().getProtocolConfigurations(plugin)) {
                List saddrs = this.getCapsdConfig().getSpecifics(pluginConf);
                Iterator saddrIter = saddrs.iterator();
                while (saddrIter.hasNext() && !found) {
                    String saddr = (String)saddrIter.next();
                    InetAddress taddr = InetAddressUtils.addr((String)saddr);
                    if (taddr == null || !taddr.equals(address)) continue;
                    found = true;
                }
                List ranges = this.getCapsdConfig().getRanges(pluginConf);
                Iterator rangeIter = ranges.iterator();
                while (rangeIter.hasNext() && !found) {
                    Range rng = (Range)rangeIter.next();
                    InetAddress start = null;
                    start = InetAddressUtils.addr((String)rng.getBegin());
                    if (start == null) {
                        this.log().warn("CapsdConfigFactory: failed to convert address " + rng.getBegin() + " to InetAddress");
                        continue;
                    }
                    InetAddress stop = null;
                    stop = InetAddressUtils.addr((String)rng.getEnd());
                    if (stop == null) {
                        this.log().warn("CapsdConfigFactory: failed to convert address " + rng.getEnd() + " to InetAddress");
                        continue;
                    }
                    if (!InetAddressUtils.isInetAddressInRange((byte[])address.getAddress(), (byte[])start.getAddress(), (byte[])stop.getAddress())) continue;
                    found = true;
                }
                if (!found) continue;
                String scan = null;
                scan = pluginConf.getScan();
                if (scan != null) {
                    if (scan.equals("enable")) {
                        lprotos.add(new CapsdProtocolInfo(plugin.getProtocol(), this.m_pluginsByProtocol.get(plugin.getProtocol()), null, CapsdProtocolInfo.Action.AUTO_SET));
                        continue block0;
                    }
                    if (scan.equals("off")) {
                        continue block0;
                    }
                } else {
                    scan = plugin.getScan();
                    if (scan != null && scan.equals("off")) continue block0;
                }
                TreeMap<String, Object> params = new TreeMap<String, Object>();
                PluginManager.addProperties(this.getCapsdConfig().getPluginProperties(plugin), params);
                PluginManager.addProperties(this.getCapsdConfig().getProtocolConfigurationProperties(pluginConf), params);
                lprotos.add(new CapsdProtocolInfo(plugin.getProtocol(), this.m_pluginsByProtocol.get(plugin.getProtocol()), params, CapsdProtocolInfo.Action.SCAN));
            }
            if (found || "off".equals(plugin.getScan())) continue;
            TreeMap<String, Object> params = new TreeMap<String, Object>();
            PluginManager.addProperties(this.getCapsdConfig().getPluginProperties(plugin), params);
            lprotos.add(new CapsdProtocolInfo(plugin.getProtocol(), this.m_pluginsByProtocol.get(plugin.getProtocol()), params, CapsdProtocolInfo.Action.SCAN));
        }
        CapsdProtocolInfo[] result = new CapsdProtocolInfo[lprotos.size()];
        return lprotos.toArray(result);
    }

    private static void addProperties(List<Property> properties, Map<String, Object> params) {
        for (Property property : properties) {
            params.put(property.getKey(), property.getValue());
        }
    }

    public CapsdConfig getCapsdConfig() {
        return this.m_capsdConfig;
    }

    public void setCapsdConfig(CapsdConfig capsdConfig) {
        this.m_capsdConfig = capsdConfig;
    }

    public void afterPropertiesSet() throws ValidationException {
        Assert.state((this.m_capsdConfig != null ? 1 : 0) != 0, (String)"property capsdConfig must be set to a non-null value");
        this.instantiatePlugins();
    }
}

