/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.AbstractCollectionSetVisitor;
import org.opennms.netmgt.config.collector.CollectionAttribute;
import org.opennms.netmgt.config.collector.CollectionResource;
import org.opennms.netmgt.config.collector.CollectionSet;
import org.opennms.netmgt.config.collector.ServiceParameters;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.threshd.CollectorThresholdingSet;
import org.opennms.netmgt.threshd.ThresholdGroup;
import org.opennms.netmgt.threshd.ThresholdingEventProxy;
import org.opennms.netmgt.threshd.ThresholdingEventProxyFactory;
import org.opennms.netmgt.xml.event.Event;

public class ThresholdingVisitor
extends AbstractCollectionSetVisitor {
    final CollectorThresholdingSet m_thresholdingSet;
    final Map<String, CollectionAttribute> m_attributesMap = new HashMap<String, CollectionAttribute>();
    private Date m_collectionTimestamp;

    public static ThresholdingVisitor create(int nodeId, String hostAddress, String serviceName, RrdRepository repo, ServiceParameters svcParams) {
        ThreadCategory log = ThreadCategory.getInstance(ThresholdingVisitor.class);
        String enabled = ParameterMap.getKeyedString((Map)svcParams.getParameters(), (String)"thresholding-enabled", null);
        if (enabled != null && !"true".equals(enabled)) {
            log.info("create: Thresholds processing is not enabled. Check thresholding-enabled param on collectd package");
            return null;
        }
        CollectorThresholdingSet thresholdingSet = new CollectorThresholdingSet(nodeId, hostAddress, serviceName, repo, svcParams);
        if (!thresholdingSet.hasThresholds()) {
            log.warn("create: the ipaddress/service " + hostAddress + "/" + serviceName + " on node " + nodeId + " has no configured thresholds.");
        }
        return new ThresholdingVisitor(thresholdingSet);
    }

    protected ThresholdingVisitor(CollectorThresholdingSet thresholdingSet) {
        this.m_thresholdingSet = thresholdingSet;
        this.m_collectionTimestamp = new Date();
    }

    public boolean hasThresholds() {
        return this.m_thresholdingSet.hasThresholds();
    }

    List<ThresholdGroup> getThresholdGroups() {
        return Collections.unmodifiableList(this.m_thresholdingSet.m_thresholdGroups);
    }

    List<String> getScheduledOutages() {
        return Collections.unmodifiableList(this.m_thresholdingSet.m_scheduledOutages);
    }

    @Override
    public void visitCollectionSet(CollectionSet set) {
        this.m_collectionTimestamp = set.getCollectionTimestamp();
    }

    public void reload() {
        this.m_thresholdingSet.reinitialize();
    }

    public void reloadScheduledOutages() {
        this.m_thresholdingSet.updateScheduledOutages();
    }

    public boolean isNodeInOutage() {
        return this.m_thresholdingSet.isNodeInOutage();
    }

    @Override
    public void visitResource(CollectionResource resource) {
        this.m_attributesMap.clear();
    }

    @Override
    public void visitAttribute(CollectionAttribute attribute) {
        if (this.m_thresholdingSet.hasThresholds(attribute)) {
            String name = attribute.getName();
            this.m_attributesMap.put(name, attribute);
            if (this.log().isDebugEnabled()) {
                String value = attribute.getNumericValue();
                if (value == null) {
                    value = attribute.getStringValue();
                }
                this.log().debug("visitAttribute: storing value " + value + " for attribute named " + name);
            }
        }
    }

    @Override
    public void completeResource(CollectionResource resource) {
        List<Event> eventList = this.m_thresholdingSet.applyThresholds(resource, this.m_attributesMap, this.m_collectionTimestamp);
        ThresholdingEventProxy proxy = ThresholdingEventProxyFactory.getFactory().getProxy();
        proxy.add(eventList);
        proxy.sendAllEvents();
    }

    public Date getCollectionTimestamp() {
        return this.m_collectionTimestamp;
    }

    public String toString() {
        return "ThresholdingVisitor for " + this.m_thresholdingSet;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

