/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.opennms.core.concurrent.WaterfallCallable;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.syslogd.HideMessage;
import org.opennms.netmgt.config.syslogd.UeiList;
import org.opennms.netmgt.syslogd.ConvertToEvent;
import org.opennms.netmgt.syslogd.MessageDiscardedException;
import org.opennms.netmgt.syslogd.SyslogProcessor;

public class SyslogConnection
implements WaterfallCallable {
    private final DatagramPacket _packet;
    private final String _matchPattern;
    private final int _hostGroup;
    private final int _messageGroup;
    private final String _discardUei;
    private final UeiList _ueiList;
    private final HideMessage _hideMessages;

    public SyslogConnection(DatagramPacket packet, String matchPattern, int hostGroup, int messageGroup, UeiList ueiList, HideMessage hideMessages, String discardUei) {
        this._packet = SyslogConnection.copyPacket(packet);
        this._matchPattern = matchPattern;
        this._hostGroup = hostGroup;
        this._messageGroup = messageGroup;
        this._discardUei = discardUei;
        this._ueiList = ueiList;
        this._hideMessages = hideMessages;
    }

    public SyslogProcessor call() {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        ConvertToEvent re = null;
        try {
            re = ConvertToEvent.make(this._packet, this._matchPattern, this._hostGroup, this._messageGroup, this._ueiList, this._hideMessages, this._discardUei);
            log.debug("Sending received packet to the SyslogProcessor queue");
            return new SyslogProcessor(re);
        }
        catch (UnsupportedEncodingException e1) {
            log.debug("Failure to convert package", (Throwable)e1);
        }
        catch (MessageDiscardedException e) {
            log.debug("Message discarded, returning without enqueueing event.", (Throwable)e);
        }
        return null;
    }

    private static DatagramPacket copyPacket(DatagramPacket packet) {
        byte[] message = new byte[packet.getLength()];
        System.arraycopy(packet.getData(), 0, message, 0, packet.getLength());
        InetAddress addr = null;
        try {
            addr = InetAddress.getByAddress(packet.getAddress().getHostName(), packet.getAddress().getAddress());
            DatagramPacket retPacket = new DatagramPacket(message, packet.getOffset(), packet.getLength(), addr, packet.getPort());
            return retPacket;
        }
        catch (UnknownHostException e) {
            ThreadCategory.getInstance(SyslogConnection.class).warn("unable to clone InetAddress object for " + packet.getAddress());
            return null;
        }
    }
}

