/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import org.apache.log4j.Level;
import org.opennms.core.utils.ExecRunner;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;

@Distributable(value={DistributionContext.DAEMON})
@Deprecated
public final class GpMonitor
extends AbstractServiceMonitor {
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        NetworkInterface iface = svc.getNetInterface();
        ThreadCategory log = ThreadCategory.getInstance(((Object)((Object)this)).getClass());
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_INET currently supported");
        }
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        String hoption = ParameterMap.getKeyedString(parameters, (String)"hoption", (String)"--hostname");
        String toption = ParameterMap.getKeyedString(parameters, (String)"toption", (String)"--timeout");
        String args = ParameterMap.getKeyedString(parameters, (String)"args", null);
        String script = ParameterMap.getKeyedString(parameters, (String)"script", null);
        if (script == null) {
            throw new RuntimeException("GpMonitor: required parameter 'script' is not present in supplied properties.");
        }
        String strBannerMatch = (String)parameters.get("banner");
        String scriptoutput = "";
        String scripterror = "";
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        String hostAddress = InetAddressUtils.str((InetAddress)ipv4Addr);
        if (log.isDebugEnabled()) {
            log.debug("poll: address = " + hostAddress + ", script = " + script + ", arguments = " + args + ", " + tracker);
        }
        PollStatus serviceStatus = PollStatus.unavailable();
        tracker.reset();
        while (tracker.shouldRetry() && !serviceStatus.isAvailable()) {
            try {
                tracker.startAttempt();
                int exitStatus = 100;
                int timeoutInSeconds = (int)tracker.getTimeoutInSeconds();
                ExecRunner er = new ExecRunner();
                er.setMaxRunTimeSecs(timeoutInSeconds);
                exitStatus = args == null ? er.exec(script + " " + hoption + " " + hostAddress + " " + toption + " " + timeoutInSeconds) : er.exec(script + " " + hoption + " " + hostAddress + " " + toption + " " + timeoutInSeconds + " " + args);
                double responseTime = tracker.elapsedTimeInMillis();
                if (exitStatus != 0) {
                    scriptoutput = er.getOutString();
                    serviceStatus = this.logDown(Level.DEBUG, script + " failed with exit code " + exitStatus + ". Standard out: " + scriptoutput);
                }
                if (er.isMaxRunTimeExceeded()) {
                    serviceStatus = this.logDown(Level.DEBUG, script + " failed. Timeout exceeded");
                } else if (exitStatus == 0) {
                    scriptoutput = er.getOutString();
                    scripterror = er.getErrString();
                    if (!scriptoutput.equals("")) {
                        log.debug(script + " output  = " + scriptoutput);
                    } else {
                        log.debug(script + " returned no output");
                    }
                    if (!scripterror.equals("")) {
                        log.debug(script + " error = " + scripterror);
                    }
                    serviceStatus = strBannerMatch == null || strBannerMatch.equals("*") ? PollStatus.available((Double)responseTime) : (scriptoutput.indexOf(strBannerMatch) > -1 ? PollStatus.available((Double)responseTime) : PollStatus.unavailable((String)(script + "banner not contained in output banner='" + strBannerMatch + "' output='" + scriptoutput + "'")));
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                serviceStatus = this.logDown(Level.DEBUG, script + " ArrayIndexOutOfBoundsException", e);
            }
            catch (IOException e) {
                serviceStatus = this.logDown(Level.DEBUG, "IOException occurred. Check for proper operation of " + script, e);
            }
            catch (Throwable e) {
                serviceStatus = this.logDown(Level.DEBUG, script + "Exception occurred", e);
            }
            tracker.nextAttempt();
        }
        log.debug("poll: GP - serviceStatus= " + serviceStatus + "  " + hostAddress);
        return serviceStatus;
    }
}

