/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.EventConstants;

public class DbVlanEntry {
    public static final char STATUS_ACTIVE = 'A';
    public static final char STATUS_NOT_POLLED = 'N';
    public static final char STATUS_DELETED = 'D';
    public static final char STATUS_UNKNOWN = 'K';
    public static final int VLAN_TYPE_UNKNOWN = 0;
    public static final int VLAN_TYPE_ETHERNET = 1;
    public static final int VLAN_TYPE_FDDI = 2;
    public static final int VLAN_TYPE_TOKEN_RING = 3;
    public static final int VLAN_TYPE_FDDINET = 4;
    public static final int VLAN_TYPE_TRNET = 5;
    public static final int VLAN_TYPE_DEPRECATED = 6;
    public static final int VLAN_STATUS_UNKNOWN = 0;
    public static final int VLAN_STATUS_OPERATIONAL = 1;
    public static final int VLAN_STATUS_SUSPENDED = 2;
    public static final int VLAN_STATUS_MTU_TOO_BIG_FOR_DEVICE = 3;
    public static final int VLAN_STATUS_MTU_TOO_BIG_FOR_TRUNK = 4;
    int m_nodeId;
    int m_vlanId;
    String m_vlanname;
    int m_vlantype = 0;
    int m_vlanstatus = 0;
    char m_status = (char)75;
    Timestamp m_lastPollTime;
    private static final String SQL_LOAD_STPNODE = "SELECT vlanname,vlantype,vlanstatus,status,lastPollTime FROM vlan WHERE nodeid = ? AND vlanid = ? ";
    private boolean m_fromDb;
    private int m_changed;
    private static final int CHANGED_VLANNAME = 1;
    private static final int CHANGED_VLANTYPE = 2;
    private static final int CHANGED_VLANSTATUS = 4;
    private static final int CHANGED_STATUS = 8;
    private static final int CHANGED_POLLTIME = 16;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insert(Connection c) throws SQLException {
        if (this.m_fromDb) {
            throw new IllegalStateException("The VLAN record already exists in the database");
        }
        StringBuffer names = new StringBuffer("INSERT INTO vlan (nodeid,vlanid");
        StringBuffer values = new StringBuffer("?,?");
        values.append(",?");
        names.append(",vlanname");
        values.append(",?");
        names.append(",vlantype");
        values.append(",?");
        names.append(",vlanstatus");
        values.append(",?");
        names.append(",status");
        values.append(",?");
        names.append(",lastpolltime");
        names.append(") VALUES (").append(values).append(')');
        LogUtils.debugf((Object)this, (String)"DbVlanEntry.insert: SQL insert statment = %s", (Object[])new Object[]{names.toString()});
        DBUtils d = new DBUtils(this.getClass());
        try {
            PreparedStatement stmt = c.prepareStatement(names.toString());
            d.watch((Object)stmt);
            int ndx = 1;
            stmt.setInt(ndx++, this.m_nodeId);
            stmt.setInt(ndx++, this.m_vlanId);
            stmt.setString(ndx++, this.m_vlanname);
            stmt.setInt(ndx++, this.m_vlantype);
            stmt.setInt(ndx++, this.m_vlanstatus);
            stmt.setString(ndx++, new String(new char[]{this.m_status}));
            stmt.setTimestamp(ndx++, this.m_lastPollTime);
            int rc = stmt.executeUpdate();
            LogUtils.debugf((Object)this, (String)"DbVlanEntry.insert: row %d", (Object[])new Object[]{rc});
        }
        finally {
            d.cleanUp();
        }
        this.m_fromDb = true;
        this.m_changed = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Connection c) throws SQLException {
        if (!this.m_fromDb) {
            throw new IllegalStateException("The record does not exists in the database");
        }
        StringBuffer sqlText = new StringBuffer("UPDATE vlan SET ");
        int comma = 32;
        if ((this.m_changed & 1) == 1) {
            sqlText.append((char)comma).append("vlanname = ?");
            comma = 44;
        }
        if ((this.m_changed & 2) == 2) {
            sqlText.append((char)comma).append("vlantype = ?");
            comma = 44;
        }
        if ((this.m_changed & 4) == 4) {
            sqlText.append((char)comma).append("vlanstatus = ?");
            comma = 44;
        }
        if ((this.m_changed & 8) == 8) {
            sqlText.append((char)comma).append("status = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x10) == 16) {
            sqlText.append((char)comma).append("lastpolltime = ?");
            comma = 44;
        }
        sqlText.append(" WHERE nodeid = ? AND vlanid = ? ");
        LogUtils.debugf((Object)this, (String)"DbVlanEntry.update: SQL insert statment = %s", (Object[])new Object[]{sqlText.toString()});
        DBUtils d = new DBUtils(this.getClass());
        try {
            PreparedStatement stmt = c.prepareStatement(sqlText.toString());
            d.watch((Object)stmt);
            int ndx = 1;
            if ((this.m_changed & 1) == 1) {
                stmt.setString(ndx++, this.m_vlanname);
            }
            if ((this.m_changed & 2) == 2) {
                stmt.setInt(ndx++, this.m_vlantype);
            }
            if ((this.m_changed & 4) == 4) {
                stmt.setInt(ndx++, this.m_vlanstatus);
            }
            if ((this.m_changed & 8) == 8) {
                stmt.setString(ndx++, new String(new char[]{this.m_status}));
            }
            if ((this.m_changed & 0x10) == 16) {
                stmt.setTimestamp(ndx++, this.m_lastPollTime);
            }
            stmt.setInt(ndx++, this.m_nodeId);
            stmt.setInt(ndx++, this.m_vlanId);
            int rc = stmt.executeUpdate();
            LogUtils.debugf((Object)this, (String)"DbVlanEntry.update: row %d", (Object[])new Object[]{rc});
            stmt.close();
        }
        finally {
            d.cleanUp();
        }
        this.m_changed = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean load(Connection c) throws SQLException {
        if (!this.m_fromDb) {
            throw new IllegalStateException("The record does not exists in the database");
        }
        DBUtils d = new DBUtils(this.getClass());
        PreparedStatement stmt = null;
        try {
            String str;
            stmt = c.prepareStatement(SQL_LOAD_STPNODE);
            d.watch((Object)stmt);
            stmt.setInt(1, this.m_nodeId);
            stmt.setInt(2, this.m_vlanId);
            ResultSet rset = stmt.executeQuery();
            d.watch((Object)rset);
            if (!rset.next()) {
                LogUtils.debugf((Object)this, (String)"DbVlanEntry.load: no result found", (Object[])new Object[0]);
                boolean bl = false;
                return bl;
            }
            int ndx = 1;
            this.m_vlanname = rset.getString(ndx++);
            this.m_vlantype = rset.getInt(ndx++);
            if (rset.wasNull()) {
                this.m_vlantype = 0;
            }
            this.m_vlanstatus = rset.getInt(ndx++);
            if (rset.wasNull()) {
                this.m_vlanstatus = -1;
            }
            this.m_status = (str = rset.getString(ndx++)) != null && !rset.wasNull() ? str.charAt(0) : (char)75;
            this.m_lastPollTime = rset.getTimestamp(ndx++);
            rset.close();
            stmt.close();
        }
        finally {
            d.cleanUp();
        }
        LogUtils.debugf((Object)this, (String)"DbVlanEntry.load: result found", (Object[])new Object[0]);
        this.m_changed = 0;
        return true;
    }

    DbVlanEntry(int nodeId, int vlanid, boolean exists) {
        this.m_nodeId = nodeId;
        this.m_vlanId = vlanid;
        this.m_fromDb = exists;
        this.m_vlantype = -1;
        this.m_vlanstatus = -1;
        this.m_vlanname = "default";
    }

    static DbVlanEntry create(int nodeId, int vlanid) {
        return new DbVlanEntry(nodeId, vlanid, false);
    }

    protected int get_nodeId() {
        return this.m_nodeId;
    }

    protected int getVlanId() {
        return this.m_vlanId;
    }

    protected String getVlanName() {
        return this.m_vlanname;
    }

    protected void setVlanName(String vlanname) {
        this.m_vlanname = vlanname;
        this.m_changed |= 1;
    }

    protected boolean hasBaseVlanNameChanged() {
        return (this.m_changed & 1) == 1;
    }

    boolean updateVlanName(String vlanname) {
        if (this.m_vlanname == null || !this.m_vlanname.equals(vlanname)) {
            this.setVlanName(vlanname);
            return true;
        }
        return false;
    }

    protected int getVlanType() {
        return this.m_vlantype;
    }

    protected void setVlanType(int vlantype) {
        this.m_vlantype = vlantype;
        this.m_changed |= 2;
    }

    protected boolean hasBaseTypeChanged() {
        return (this.m_changed & 2) == 2;
    }

    boolean updateVlanType(int vlantype) {
        if (vlantype != this.m_vlantype) {
            this.setVlanType(vlantype);
            return true;
        }
        return false;
    }

    protected int getVlanStatus() {
        return this.m_vlanstatus;
    }

    protected void setVlanStatus(int vlanstatus) {
        this.m_vlanstatus = vlanstatus;
        this.m_changed |= 4;
    }

    protected boolean hasBaseStatusChanged() {
        return (this.m_changed & 4) == 4;
    }

    boolean updateVlanStatus(int vlanstatus) {
        if (vlanstatus != this.m_vlanstatus) {
            this.setVlanStatus(vlanstatus);
            return true;
        }
        return false;
    }

    protected char get_status() {
        return this.m_status;
    }

    protected void set_status(char status) {
        if (status == 'A' || status == 'N' || status == 'D') {
            this.m_status = status;
        }
        this.m_changed |= 8;
    }

    protected boolean hasStatusChanged() {
        return (this.m_changed & 8) == 8;
    }

    boolean updateStatus(char status) {
        if (status != this.m_status) {
            this.set_status(status);
            return true;
        }
        return false;
    }

    protected Timestamp get_lastpolltime() {
        return this.m_lastPollTime;
    }

    String getLastPollTimeString() {
        String result = null;
        if (this.m_lastPollTime != null) {
            result = this.m_lastPollTime.toString();
        }
        return result;
    }

    protected void set_lastpolltime(String time) throws ParseException {
        if (time == null) {
            this.m_lastPollTime = null;
        } else {
            Date tmpDate = EventConstants.parseToDate((String)time);
            this.m_lastPollTime = new Timestamp(tmpDate.getTime());
        }
        this.m_changed |= 0x10;
    }

    protected void set_lastpolltime(Date time) {
        this.m_lastPollTime = new Timestamp(time.getTime());
        this.m_changed |= 0x10;
    }

    protected void set_lastpolltime(Timestamp time) {
        this.m_lastPollTime = time;
        this.m_changed |= 0x10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void store() throws SQLException {
        if (this.m_changed != 0 || !this.m_fromDb) {
            Connection db = null;
            try {
                db = DataSourceFactory.getInstance().getConnection();
                this.store(db);
                if (!db.getAutoCommit()) {
                    db.commit();
                }
            }
            finally {
                try {
                    if (db != null) {
                        db.close();
                    }
                }
                catch (SQLException e) {
                    LogUtils.warnf((Object)this, (Throwable)e, (String)"Exception closing JDBC connection", (Object[])new Object[0]);
                }
            }
        }
    }

    void store(Connection db) throws SQLException {
        if (this.m_changed != 0 || !this.m_fromDb) {
            if (this.m_fromDb) {
                this.update(db);
            } else {
                this.insert(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DbVlanEntry get(int nid, int basevlan) throws SQLException {
        Connection db = null;
        try {
            db = DataSourceFactory.getInstance().getConnection();
            DbVlanEntry dbVlanEntry = DbVlanEntry.get(db, nid, basevlan);
            return dbVlanEntry;
        }
        finally {
            try {
                if (db != null) {
                    db.close();
                }
            }
            catch (SQLException e) {
                LogUtils.warnf(DbVlanEntry.class, (Throwable)e, (String)"Exception closing JDBC connection", (Object[])new Object[0]);
            }
        }
    }

    static DbVlanEntry get(Connection db, int nid, int basevlan) throws SQLException {
        DbVlanEntry entry = new DbVlanEntry(nid, basevlan, true);
        if (!entry.load(db)) {
            entry = null;
        }
        return entry;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("db", this.m_fromDb).append("nodeId", this.m_nodeId).append("vlanId", this.m_vlanId).append("vlanName", (Object)this.m_vlanname).append("vlanType", this.m_vlantype).append("vlanStatus", this.m_vlanstatus).append("status", this.m_status).append("lastPollTime", (Object)this.m_lastPollTime).toString();
    }
}

