/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd;

import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.EventUtils;
import org.opennms.netmgt.config.EventConfDao;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventIpcManager;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.xml.event.Event;
import org.springframework.util.Assert;

public class BroadcastEventProcessor
implements EventListener {
    private final EventIpcManager m_eventIpcManager;
    private final EventConfDao m_eventConfDao;

    public BroadcastEventProcessor(EventIpcManager eventIpcManager, EventConfDao eventConfDao) {
        Assert.notNull((Object)eventIpcManager, (String)"argument eventIpcManager must not be null");
        Assert.notNull((Object)eventConfDao, (String)"argument eventConfDao must not be null");
        this.m_eventIpcManager = eventIpcManager;
        this.m_eventConfDao = eventConfDao;
        this.addEventListener();
    }

    private void addEventListener() {
        this.m_eventIpcManager.addEventListener((EventListener)this, "uei.opennms.org/internal/eventsConfigChange");
        this.m_eventIpcManager.addEventListener((EventListener)this, "uei.opennms.org/internal/reloadDaemonConfig");
    }

    public synchronized void close() {
        this.m_eventIpcManager.removeEventListener((EventListener)this);
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public String getName() {
        return "Eventd:BroadcastEventProcessor";
    }

    public void onEvent(Event event) {
        this.log().debug("onEvent: received event, UEI = " + event.getUei());
        EventBuilder ebldr = null;
        if (this.isReloadConfigEvent(event)) {
            this.log().info("onEvent: Reloading events configuration in response to event with UEI " + event.getUei());
            try {
                this.m_eventConfDao.reload();
                ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigSuccessful", this.getName());
                ebldr.addParam("daemonName", "Eventd");
            }
            catch (Throwable e) {
                this.log().error("onEvent: Could not reload events config: " + e, e);
                ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigSuccessful", this.getName());
                ebldr.addParam("daemonName", "Eventd");
                ebldr.addParam("reason", e.getLocalizedMessage().substring(0, 128));
            }
            if (ebldr != null) {
                this.m_eventIpcManager.sendNow(ebldr.getEvent());
            }
        }
    }

    private boolean isReloadConfigEvent(Event event) {
        boolean isTarget = false;
        if ("uei.opennms.org/internal/reloadDaemonConfig".equals(event.getUei())) {
            if ("Eventd".equalsIgnoreCase(EventUtils.getParm(event, "daemonName"))) {
                isTarget = true;
            }
        } else if ("uei.opennms.org/internal/eventsConfigChange".equals(event.getUei())) {
            isTarget = true;
        }
        return isTarget;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

