/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionException;
import org.opennms.netmgt.collectd.CollectionTimedOut;
import org.opennms.netmgt.collectd.CollectionWarning;
import org.opennms.netmgt.collectd.IfAliasResourceType;
import org.opennms.netmgt.collectd.IfNumberTracker;
import org.opennms.netmgt.collectd.IfResourceType;
import org.opennms.netmgt.collectd.NodeInfo;
import org.opennms.netmgt.collectd.NodeResourceType;
import org.opennms.netmgt.collectd.OnmsSnmpCollection;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.ResourceVisitor;
import org.opennms.netmgt.collectd.SnmpAttributeType;
import org.opennms.netmgt.collectd.SnmpIfCollector;
import org.opennms.netmgt.collectd.SnmpNodeCollector;
import org.opennms.netmgt.collectd.SysUpTimeTracker;
import org.opennms.netmgt.config.collector.AttributeDefinition;
import org.opennms.netmgt.config.collector.CollectionResource;
import org.opennms.netmgt.config.collector.CollectionSet;
import org.opennms.netmgt.config.collector.CollectionSetVisitor;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.Collectable;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpWalker;

public class SnmpCollectionSet
implements Collectable,
CollectionSet {
    private final CollectionAgent m_agent;
    private final OnmsSnmpCollection m_snmpCollection;
    private SnmpIfCollector m_ifCollector;
    private IfNumberTracker m_ifNumber;
    private SysUpTimeTracker m_sysUpTime;
    private SnmpNodeCollector m_nodeCollector;
    private int m_status = 2;
    private boolean m_ignorePersist;
    private Date m_timestamp;

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("CollectionAgent: ");
        buffer.append(this.m_agent);
        buffer.append("\n");
        buffer.append("OnmsSnmpCollection: ");
        buffer.append(this.m_snmpCollection);
        buffer.append("\n");
        buffer.append("SnmpIfCollector: ");
        buffer.append((Object)this.m_ifCollector);
        buffer.append("\n");
        buffer.append("IfNumberTracker: ");
        buffer.append((Object)this.m_ifNumber);
        buffer.append("\n");
        buffer.append("SysUpTimeTracker: ");
        buffer.append((Object)this.m_sysUpTime);
        buffer.append("\n");
        buffer.append("SnmpNodeCollector: ");
        buffer.append((Object)this.m_nodeCollector);
        buffer.append("\n");
        return buffer.toString();
    }

    public SnmpCollectionSet(CollectionAgent agent, OnmsSnmpCollection snmpCollection) {
        this.m_agent = agent;
        this.m_snmpCollection = snmpCollection;
    }

    public SnmpIfCollector getIfCollector() {
        if (this.m_ifCollector == null) {
            this.m_ifCollector = this.createIfCollector();
        }
        return this.m_ifCollector;
    }

    public IfNumberTracker getIfNumber() {
        if (this.m_ifNumber == null) {
            this.m_ifNumber = this.createIfNumberTracker();
        }
        return this.m_ifNumber;
    }

    public SysUpTimeTracker getSysUpTime() {
        if (this.m_sysUpTime == null) {
            this.m_sysUpTime = this.createSysUpTimeTracker();
        }
        return this.m_sysUpTime;
    }

    public SnmpNodeCollector getNodeCollector() {
        if (this.m_nodeCollector == null) {
            this.m_nodeCollector = this.createNodeCollector();
        }
        return this.m_nodeCollector;
    }

    private SnmpNodeCollector createNodeCollector() {
        SnmpNodeCollector nodeCollector = null;
        if (!this.getAttributeList().isEmpty()) {
            nodeCollector = new SnmpNodeCollector(this.m_agent.getInetAddress(), this.getAttributeList(), this);
        }
        return nodeCollector;
    }

    private IfNumberTracker createIfNumberTracker() {
        IfNumberTracker ifNumber = null;
        if (this.hasInterfaceDataToCollect()) {
            ifNumber = new IfNumberTracker();
        }
        return ifNumber;
    }

    private SysUpTimeTracker createSysUpTimeTracker() {
        SysUpTimeTracker sysUpTime = null;
        if (this.hasInterfaceDataToCollect()) {
            sysUpTime = new SysUpTimeTracker();
        }
        return sysUpTime;
    }

    private SnmpIfCollector createIfCollector() {
        SnmpIfCollector ifCollector = null;
        if (this.hasInterfaceDataToCollect() || this.hasGenericIndexResourceDataToCollect()) {
            ifCollector = new SnmpIfCollector(this.m_agent.getInetAddress(), this.getCombinedIndexedAttributes(), this);
        }
        return ifCollector;
    }

    public NodeInfo getNodeInfo() {
        return this.getNodeResourceType().getNodeInfo();
    }

    boolean hasDataToCollect() {
        return this.getNodeResourceType().hasDataToCollect() || this.getIfResourceType().hasDataToCollect() || this.hasGenericIndexResourceDataToCollect();
    }

    boolean hasInterfaceDataToCollect() {
        return this.getIfResourceType().hasDataToCollect();
    }

    boolean hasGenericIndexResourceDataToCollect() {
        return !this.getGenericIndexResourceTypes().isEmpty();
    }

    public CollectionAgent getCollectionAgent() {
        return this.m_agent;
    }

    ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    Collection<SnmpAttributeType> getAttributeList() {
        return this.m_snmpCollection.getNodeResourceType(this.m_agent).getAttributeTypes();
    }

    List<SnmpAttributeType> getCombinedIndexedAttributes() {
        LinkedList<SnmpAttributeType> attributes = new LinkedList<SnmpAttributeType>();
        attributes.addAll(this.getIfResourceType().getAttributeTypes());
        attributes.addAll(this.getIfAliasResourceType().getAttributeTypes());
        attributes.addAll(this.getGenericIndexAttributeTypes());
        return attributes;
    }

    protected Collection<SnmpAttributeType> getGenericIndexAttributeTypes() {
        LinkedList<SnmpAttributeType> attributeTypes = new LinkedList<SnmpAttributeType>();
        Collection<ResourceType> resourceTypes = this.getGenericIndexResourceTypes();
        for (ResourceType resourceType : resourceTypes) {
            attributeTypes.addAll(resourceType.getAttributeTypes());
        }
        return attributeTypes;
    }

    private Collection<ResourceType> getGenericIndexResourceTypes() {
        return this.m_snmpCollection.getGenericIndexResourceTypes(this.m_agent);
    }

    public CollectionTracker getCollectionTracker() {
        return new AggregateTracker(SnmpAttributeType.getCollectionTrackers(this.getAttributeTypes()));
    }

    private Collection<SnmpAttributeType> getAttributeTypes() {
        return this.m_snmpCollection.getAttributeTypes(this.m_agent);
    }

    public Collection<? extends CollectionResource> getResources() {
        return this.m_snmpCollection.getResources(this.m_agent);
    }

    public void visit(CollectionSetVisitor visitor) {
        visitor.visitCollectionSet((CollectionSet)this);
        for (CollectionResource collectionResource : this.getResources()) {
            collectionResource.visit(visitor);
        }
        visitor.completeCollectionSet((CollectionSet)this);
    }

    CollectionTracker getTracker() {
        ArrayList<Object> trackers = new ArrayList<Object>(4);
        if (this.getIfNumber() != null) {
            trackers.add((Object)this.getIfNumber());
        }
        if (this.getSysUpTime() != null) {
            trackers.add((Object)this.getSysUpTime());
        }
        if (this.getNodeCollector() != null) {
            trackers.add((Object)this.getNodeCollector());
        }
        if (this.getIfCollector() != null) {
            trackers.add((Object)this.getIfCollector());
        }
        return new AggregateTracker(trackers);
    }

    protected SnmpWalker createWalker() {
        CollectionAgent agent = this.getCollectionAgent();
        return SnmpUtils.createWalker((SnmpAgentConfig)this.getAgentConfig(), (String)("SnmpCollectors for " + agent.getHostAddress()), (CollectionTracker)this.getTracker());
    }

    private void logStartedWalker() {
        if (this.log().isDebugEnabled()) {
            this.log().debug("collect: successfully instantiated SnmpNodeCollector() for " + this.getCollectionAgent().getHostAddress());
        }
    }

    private void logFinishedWalker() {
        this.log().info("collect: node SNMP query for address " + this.getCollectionAgent().getHostAddress() + " complete.");
    }

    void verifySuccessfulWalk(SnmpWalker walker) throws CollectionException {
        if (!walker.failed()) {
            return;
        }
        if (walker.timedOut()) {
            throw new CollectionTimedOut(walker.getErrorMessage());
        }
        String message = "collection failed for " + this.getCollectionAgent().getHostAddress() + " due to: " + walker.getErrorMessage();
        throw new CollectionWarning(message, walker.getErrorThrowable());
    }

    void collect() throws CollectionException {
        try {
            SnmpWalker walker = this.createWalker();
            walker.start();
            this.logStartedWalker();
            walker.waitFor();
            this.logFinishedWalker();
            this.verifySuccessfulWalk(walker);
            this.m_status = 1;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CollectionWarning("collect: Collection of node SNMP data for interface " + this.getCollectionAgent().getHostAddress() + " interrupted: " + e, e);
        }
    }

    boolean checkDisableForceRescan(String disabledString) {
        Map parameters = this.m_snmpCollection.getServiceParameters().getParameters();
        String src = ParameterMap.getKeyedString((Map)parameters, (String)"disableForceRescan", null);
        return src != null && (src.toLowerCase().equals("all") || src.toLowerCase().equals(disabledString));
    }

    void checkForNewInterfaces(RescanNeeded rescanNeeded) {
        if (!this.hasInterfaceDataToCollect()) {
            return;
        }
        if (this.checkDisableForceRescan("ifnumber")) {
            this.log().info("checkForNewInterfaces: check rescan is disabled for node " + this.m_agent.getNodeId());
            return;
        }
        this.logIfCounts();
        if (this.getIfNumber().isChanged(this.getCollectionAgent().getSavedIfCount())) {
            this.log().info("Sending rescan event because the number of interfaces on primary SNMP interface " + this.getCollectionAgent().getHostAddress() + " has changed, generating 'ForceRescan' event.");
            rescanNeeded.rescanIndicated();
        }
        this.getCollectionAgent().setSavedIfCount(this.getIfNumber().getIntValue());
    }

    void checkForSystemRestart(RescanNeeded rescanNeeded) {
        if (!this.hasInterfaceDataToCollect()) {
            return;
        }
        if (this.checkDisableForceRescan("sysuptime")) {
            this.log().info("checkForSystemRestart: check rescan is disabled for node " + this.m_agent.getNodeId());
            return;
        }
        this.logSysUpTime();
        this.m_ignorePersist = false;
        if (this.getSysUpTime().isChanged(this.getCollectionAgent().getSavedSysUpTime())) {
            this.log().info("Sending rescan event because sysUpTime has changed on primary SNMP interface " + this.getCollectionAgent().getHostAddress() + ", generating 'ForceRescan' event.");
            rescanNeeded.rescanIndicated();
            this.m_ignorePersist = true;
            this.getCollectionAgent().setSavedSysUpTime(-1L);
        } else {
            this.getCollectionAgent().setSavedSysUpTime(this.getSysUpTime().getLongValue());
        }
    }

    private void logIfCounts() {
        if (this.log().isDebugEnabled()) {
            CollectionAgent agent = this.getCollectionAgent();
            this.log().debug("collect: nodeId: " + agent.getNodeId() + " interface: " + agent.getHostAddress() + " ifCount: " + this.getIfNumber().getIntValue() + " savedIfCount: " + agent.getSavedIfCount());
        }
    }

    private void logSysUpTime() {
        if (this.log().isDebugEnabled()) {
            CollectionAgent agent = this.getCollectionAgent();
            this.log().debug("collect: nodeId: " + agent.getNodeId() + " interface: " + agent.getHostAddress() + " sysUpTime: " + this.getSysUpTime().getLongValue() + " savedSysUpTime: " + agent.getSavedSysUpTime());
        }
    }

    public boolean rescanNeeded() {
        final RescanNeeded rescanNeeded = new RescanNeeded();
        this.visit(new ResourceVisitor(){

            @Override
            public void visitResource(CollectionResource resource) {
                SnmpCollectionSet.this.log().debug("rescanNeeded: Visiting resource " + resource);
                if (resource.rescanNeeded()) {
                    SnmpCollectionSet.this.log().debug("Sending rescan event for " + SnmpCollectionSet.this.getCollectionAgent() + " because resource " + resource + " indicated it was needed");
                    rescanNeeded.rescanIndicated();
                }
            }
        });
        this.checkForNewInterfaces(rescanNeeded);
        this.checkForSystemRestart(rescanNeeded);
        return rescanNeeded.rescanIsNeeded();
    }

    public SnmpAgentConfig getAgentConfig() {
        SnmpAgentConfig agentConfig = this.getCollectionAgent().getAgentConfig();
        agentConfig.setPort(this.m_snmpCollection.getSnmpPort(agentConfig.getPort()));
        agentConfig.setRetries(this.m_snmpCollection.getSnmpRetries(agentConfig.getRetries()));
        agentConfig.setTimeout(this.m_snmpCollection.getSnmpTimeout(agentConfig.getTimeout()));
        agentConfig.setReadCommunity(this.m_snmpCollection.getSnmpReadCommunity(agentConfig.getReadCommunity()));
        agentConfig.setWriteCommunity(this.m_snmpCollection.getSnmpWriteCommunity(agentConfig.getWriteCommunity()));
        agentConfig.setProxyFor(this.m_snmpCollection.getSnmpProxyFor(agentConfig.getProxyFor()));
        agentConfig.setVersion(this.m_snmpCollection.getSnmpVersion(agentConfig.getVersion()));
        agentConfig.setMaxVarsPerPdu(this.m_snmpCollection.getSnmpMaxVarsPerPdu(agentConfig.getMaxVarsPerPdu()));
        agentConfig.setMaxRepetitions(this.m_snmpCollection.getSnmpMaxRepetitions(agentConfig.getMaxRepetitions()));
        agentConfig.setMaxRequestSize(this.m_snmpCollection.getSnmpMaxRequestSize(agentConfig.getMaxRequestSize()));
        agentConfig.setSecurityName(this.m_snmpCollection.getSnmpSecurityName(agentConfig.getSecurityName()));
        agentConfig.setAuthPassPhrase(this.m_snmpCollection.getSnmpAuthPassPhrase(agentConfig.getAuthPassPhrase()));
        agentConfig.setAuthProtocol(this.m_snmpCollection.getSnmpAuthProtocol(agentConfig.getAuthProtocol()));
        agentConfig.setPrivPassPhrase(this.m_snmpCollection.getSnmpPrivPassPhrase(agentConfig.getPrivPassPhrase()));
        agentConfig.setPrivProtocol(this.m_snmpCollection.getSnmpPrivProtocol(agentConfig.getPrivProtocol()));
        return agentConfig;
    }

    public void notifyIfNotFound(AttributeDefinition attrType, SnmpResult res) {
        this.log().info("Unable to locate resource for agent " + this.getCollectionAgent() + " with instance id " + res.getInstance() + " while collecting attribute " + attrType);
    }

    private NodeResourceType getNodeResourceType() {
        return this.m_snmpCollection.getNodeResourceType(this.getCollectionAgent());
    }

    private IfResourceType getIfResourceType() {
        return this.m_snmpCollection.getIfResourceType(this.getCollectionAgent());
    }

    private IfAliasResourceType getIfAliasResourceType() {
        return this.m_snmpCollection.getIfAliasResourceType(this.getCollectionAgent());
    }

    public int getStatus() {
        return this.m_status;
    }

    public boolean ignorePersist() {
        return this.m_ignorePersist;
    }

    public Date getCollectionTimestamp() {
        return this.m_timestamp;
    }

    public void setCollectionTimestamp(Date m_timestamp) {
        this.m_timestamp = m_timestamp;
    }

    public static class RescanNeeded {
        boolean rescanNeeded = false;

        public void rescanIndicated() {
            this.rescanNeeded = true;
        }

        public boolean rescanIsNeeded() {
            return this.rescanNeeded;
        }
    }
}

