/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import jcifs.netbios.NbtAddress;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.AbstractPlugin;

public final class SmbPlugin
extends AbstractPlugin {
    private static final String PROTOCOL_NAME = "SMB";

    private boolean isSmb(InetAddress host) {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        boolean isAServer = false;
        try {
            log.debug("host.getHostAddress(): " + InetAddressUtils.str((InetAddress)host));
            NbtAddress nbtAddr = NbtAddress.getByName((String)InetAddressUtils.str((InetAddress)host));
            log.debug("nbtAddr.getHostName(): " + nbtAddr.getHostName());
            if (nbtAddr.getHostName().equals(InetAddressUtils.str((InetAddress)host))) {
                if (log.isDebugEnabled()) {
                    log.debug("SmbPlugin: failed to retrieve SMB name for " + InetAddressUtils.str((InetAddress)host));
                }
            } else {
                isAServer = true;
            }
        }
        catch (UnknownHostException e) {
            if (log.isDebugEnabled()) {
                log.debug("SmbPlugin: UnknownHostException: " + e.getMessage());
            }
        }
        catch (Throwable t) {
            log.error("SmbPlugin: An undeclared throwable exception was caught checking host " + InetAddressUtils.str((InetAddress)host), t);
        }
        return isAServer;
    }

    @Override
    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address) {
        return this.isSmb(address);
    }

    @Override
    public boolean isProtocolSupported(InetAddress address, Map<String, Object> qualifiers) {
        return this.isSmb(address);
    }
}

