/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.opennms.netmgt.trapd.TrapdIpMgr;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.util.Assert;

public class JdbcTrapdIpMgr
implements TrapdIpMgr,
InitializingBean {
    private DataSource m_dataSource;
    private final String IP_LOAD_SQL = "SELECT ipAddr, nodeid FROM ipInterface";
    private Map<String, Long> m_knownips = new HashMap<String, Long>();

    @Override
    public synchronized void dataSourceSync() {
        this.m_knownips.clear();
        new JdbcTemplate(this.m_dataSource).query("SELECT ipAddr, nodeid FROM ipInterface", new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                JdbcTrapdIpMgr.this.m_knownips.put(rs.getString(1), rs.getLong(2));
            }
        });
    }

    @Override
    public synchronized long getNodeId(String addr) {
        if (addr == null) {
            return -1L;
        }
        return JdbcTrapdIpMgr.longValue(this.m_knownips.get(addr));
    }

    @Override
    public synchronized long setNodeId(String addr, long nodeid) {
        if (addr == null || nodeid == -1L) {
            return -1L;
        }
        return JdbcTrapdIpMgr.longValue(this.m_knownips.put(addr, nodeid));
    }

    @Override
    public synchronized long removeNodeId(String addr) {
        if (addr == null) {
            return -1L;
        }
        return JdbcTrapdIpMgr.longValue(this.m_knownips.remove(addr));
    }

    @Override
    public synchronized void clearKnownIpsMap() {
        this.m_knownips.clear();
    }

    private static long longValue(Long result) {
        return result == null ? -1L : result;
    }

    public DataSource getDataSource() {
        return this.m_dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_dataSource != null ? 1 : 0) != 0, (String)"property dataSource must be set");
    }
}

