/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.tl1d;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.concurrent.BlockingQueue;
import org.jfree.util.Log;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.tl1d.Tl1Element;
import org.opennms.netmgt.tl1d.Tl1AutonomousMessage;
import org.opennms.netmgt.tl1d.Tl1AutonomousMessageProcessor;
import org.opennms.netmgt.tl1d.Tl1Client;

public class Tl1ClientImpl
implements Tl1Client {
    String m_host;
    int m_port;
    private volatile boolean m_started = false;
    private Socket m_tl1Socket;
    private Thread m_socketReader;
    private BlockingQueue<Tl1AutonomousMessage> m_tl1Queue;
    private BufferedReader m_reader;
    private TimeoutSleeper m_sleeper;
    private ThreadCategory m_log;
    private Tl1AutonomousMessageProcessor m_messageProcessor;
    private long m_reconnectionDelay;
    private int m_reconnectAttempts = 0;

    public Tl1ClientImpl() {
    }

    public Tl1ClientImpl(BlockingQueue<Tl1AutonomousMessage> queue, Tl1Element element, ThreadCategory log) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.m_host = element.getHost();
        this.m_port = element.getPort();
        this.m_tl1Queue = queue;
        this.m_messageProcessor = (Tl1AutonomousMessageProcessor)Class.forName(element.getTl1MessageParser()).newInstance();
        this.m_reconnectionDelay = element.getReconnectDelay();
        this.m_log = log;
    }

    @Override
    public void start() {
        this.log().info("start: TL1 client: " + this.m_host + ":" + String.valueOf(this.m_port));
        this.log().info("start:Connection delay = " + this.m_reconnectionDelay);
        this.setStarted(true);
        this.m_socketReader = new Thread("TL1-Socket-Reader"){

            @Override
            public void run() {
                Tl1ClientImpl.this.readMessages();
            }
        };
        this.m_socketReader.start();
        this.log().info("Started TL1 client: " + this.m_host + ":" + String.valueOf(this.m_port));
    }

    @Override
    public void stop() {
        this.log().info("Stopping TL1 client: " + this.m_host + ":" + String.valueOf(this.m_port));
        this.setStarted(false);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Log.error((Object)("stop: " + e), (Exception)e);
        }
    }

    private BufferedReader getReader() throws InterruptedException {
        if (this.m_reader == null) {
            this.m_reader = this.createReader();
        }
        return this.m_reader;
    }

    private BufferedReader createReader() throws InterruptedException {
        while (this.isStarted()) {
            try {
                this.m_tl1Socket = new Socket(this.m_host, this.m_port);
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.m_tl1Socket.getInputStream()));
                this.resetTimeout();
                return reader;
            }
            catch (IOException e) {
                this.log().error("TL1 Connection Failed to " + this.m_host + ":" + this.m_port);
                this.log().debug(e.getMessage());
                this.waitUntilNextConnectTime();
            }
        }
        return null;
    }

    private void resetTimeout() {
        this.log().debug("resetTimeout: Resetting timeout Thread");
        this.m_reconnectAttempts = 0;
        this.m_sleeper = null;
    }

    private void waitUntilNextConnectTime() throws InterruptedException {
        this.log().debug("waitUntilNextConnectTime: current connection attempts: " + this.m_reconnectAttempts);
        if (this.isStarted()) {
            if (this.m_sleeper == null) {
                this.m_sleeper = new TimeoutSleeper();
            }
            ++this.m_reconnectAttempts;
            long waitTime = this.computeWait();
            this.log().info("waitUntilNextConnectTime: Waiting " + waitTime + " ms......");
            this.m_sleeper.sleep(waitTime);
        }
    }

    private long computeWait() {
        long waitTime = this.m_reconnectionDelay;
        if (this.m_reconnectAttempts > 5) {
            waitTime = this.m_reconnectionDelay * 5L;
        } else if (this.m_reconnectAttempts > 10) {
            waitTime = this.m_reconnectionDelay * 10L;
        }
        return waitTime;
    }

    private void readMessages() {
        StringBuilder rawMessageBuilder = new StringBuilder();
        this.log().info("readMessages: Begin reading off socket...");
        while (this.isStarted()) {
            try {
                int ch;
                this.log().debug("readMessages: reading line from TL1 socket...");
                BufferedReader reader = null;
                try {
                    reader = this.getReader();
                }
                catch (InterruptedException e) {
                    this.log().warn("readMessages: interrupted.");
                    return;
                }
                if (reader == null) continue;
                while ((ch = reader.read()) != -1 && this.isStarted()) {
                    rawMessageBuilder.append((char)ch);
                    if ((char)ch != ';') continue;
                    this.createAndQueueTl1Message(rawMessageBuilder);
                    rawMessageBuilder.setLength(0);
                }
                rawMessageBuilder = null;
                this.log().warn("readMessages: resetting socket reader to client: " + this.m_host + ":" + this.m_port);
                this.resetReader(null);
            }
            catch (IOException e) {
                this.resetReader(e);
            }
        }
        this.log().info("TL1 client stopped for: " + this.m_host + ":" + String.valueOf(this.m_port));
    }

    private ThreadCategory log() {
        return this.m_log;
    }

    private void createAndQueueTl1Message(StringBuilder rawMessageBuilder) {
        this.log().debug("readMessages: offering message to queue: " + rawMessageBuilder.toString());
        Tl1AutonomousMessage message = this.detectMessageType(rawMessageBuilder);
        if (message != null) {
            this.m_tl1Queue.offer(message);
            this.log().debug("readMessages: successfully offered to queue.");
        } else {
            this.log().debug("readMessages: message was null, not offered to queue.");
        }
    }

    private Tl1AutonomousMessage detectMessageType(StringBuilder rawMessage) {
        if (this.isAutonomousMessage(rawMessage)) {
            return this.m_messageProcessor.process(rawMessage.toString(), 4);
        }
        return null;
    }

    private boolean isAutonomousMessage(StringBuilder rawMessage) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetReader(IOException ex) {
        if (ex != null) {
            this.log().error("resetReader: connection failure.", (Throwable)ex);
        }
        try {
            this.m_reader.close();
        }
        catch (IOException e) {
            this.log().warn("resetReader: " + e, (Throwable)e);
        }
        finally {
            this.m_reader = null;
        }
        try {
            this.m_tl1Socket.close();
        }
        catch (IOException e) {
            this.log().warn("resetReader: " + e, (Throwable)e);
            this.m_tl1Socket = null;
        }
    }

    @Override
    public String getHost() {
        return this.m_host;
    }

    @Override
    public void setHost(String host) {
        this.m_host = host;
    }

    @Override
    public int getPort() {
        return this.m_port;
    }

    @Override
    public void setPort(int port) {
        this.m_port = port;
    }

    @Override
    public long getReconnectionDelay() {
        return this.m_reconnectionDelay;
    }

    @Override
    public void setReconnectionDelay(long reconnectionDelay) {
        this.m_reconnectionDelay = reconnectionDelay;
    }

    @Override
    public BlockingQueue<Tl1AutonomousMessage> getTl1Queue() {
        return this.m_tl1Queue;
    }

    @Override
    public void setTl1Queue(BlockingQueue<Tl1AutonomousMessage> tl1Queue) {
        this.m_tl1Queue = tl1Queue;
    }

    @Override
    public Tl1AutonomousMessageProcessor getMessageProcessor() {
        return this.m_messageProcessor;
    }

    @Override
    public void setMessageProcessor(Tl1AutonomousMessageProcessor messageProcessor) {
        this.m_messageProcessor = messageProcessor;
    }

    public void setStarted(boolean started) {
        this.m_started = started;
    }

    public boolean isStarted() {
        return this.m_started;
    }

    @Override
    public void setLog(ThreadCategory log) {
        this.m_log = log;
    }

    public String toString() {
        return "Tl1Client: class: " + this.getClass() + "; host: " + this.m_host + "; port: " + this.m_port;
    }

    private class TimeoutSleeper {
        private TimeoutSleeper() {
        }

        public void sleep(long sleepTime) throws InterruptedException {
            Thread.sleep(sleepTime);
        }
    }
}

