/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.jexl2.ExpressionImpl;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.MapContext;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.config.threshd.Basethresholddef;
import org.opennms.netmgt.config.threshd.Expression;
import org.opennms.netmgt.threshd.BaseThresholdDefConfigWrapper;
import org.opennms.netmgt.threshd.ThresholdExpressionException;

public class ExpressionConfigWrapper
extends BaseThresholdDefConfigWrapper {
    private final Expression m_expression;
    private final Collection<String> m_datasources;

    public ExpressionConfigWrapper(Expression expression) throws ThresholdExpressionException {
        super((Basethresholddef)expression);
        this.m_expression = expression;
        JexlEngine expressionParser = new JexlEngine();
        this.m_datasources = new ArrayList<String>();
        try {
            ExpressionImpl e = (ExpressionImpl)expressionParser.createExpression(this.m_expression.getExpression());
            LogUtils.tracef((Object)this, (String)"List of Variables on the Expression: %s", (Object[])new Object[]{e.getVariables()});
            for (List list : e.getVariables()) {
                if (((String)list.get(0)).equalsIgnoreCase("math")) continue;
                if (((String)list.get(0)).equalsIgnoreCase("datasources")) {
                    this.m_datasources.add(((String)list.get(1)).intern());
                    continue;
                }
                this.m_datasources.add(((String)list.get(0)).intern());
            }
        }
        catch (Throwable e) {
            throw new ThresholdExpressionException("Could not parse threshold expression:" + e.getMessage(), e);
        }
        LogUtils.tracef((Object)this, (String)"Threshold Variables: %s", (Object[])new Object[]{this.m_datasources});
    }

    @Override
    public String getDatasourceExpression() {
        return this.m_expression.getExpression();
    }

    @Override
    public Collection<String> getRequiredDatasources() {
        return this.m_datasources;
    }

    @Override
    public double evaluate(Map<String, Double> values) throws ThresholdExpressionException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.putAll(values);
        context.put("datasources", new HashMap<String, Double>(values));
        context.put("math", new MathBinding());
        double result = Double.NaN;
        try {
            Object resultObject = new JexlEngine().createExpression(this.m_expression.getExpression()).evaluate((JexlContext)new MapContext(context));
            result = Double.parseDouble(resultObject.toString());
        }
        catch (Throwable e) {
            throw new ThresholdExpressionException("Error while evaluating expression " + this.m_expression.getExpression() + ": " + e.getMessage(), e);
        }
        return result;
    }

    public static class MathBinding {
        public double abs(double a) {
            return Math.abs(a);
        }

        public float abs(float a) {
            return Math.abs(a);
        }

        public int abs(int a) {
            return Math.abs(a);
        }

        public long abs(long a) {
            return Math.abs(a);
        }

        public double acos(double a) {
            return Math.acos(a);
        }

        public double asin(double a) {
            return Math.asin(a);
        }

        public double atan(double a) {
            return Math.atan(a);
        }

        public double atan2(double a, double b) {
            return Math.atan2(a, b);
        }

        public double cbrt(double a) {
            return Math.cbrt(a);
        }

        public double ceil(double a) {
            return Math.ceil(a);
        }

        public double cos(double a) {
            return Math.cos(a);
        }

        public double cosh(double a) {
            return Math.cosh(a);
        }

        public double exp(double a) {
            return Math.exp(a);
        }

        public double expm1(double a) {
            return Math.expm1(a);
        }

        public double floor(double a) {
            return Math.floor(a);
        }

        public double hypot(double a, double b) {
            return Math.hypot(a, b);
        }

        public double IEEEremainder(double a, double b) {
            return Math.IEEEremainder(a, b);
        }

        public double log(double a) {
            return Math.log(a);
        }

        public double log10(double a) {
            return Math.log10(a);
        }

        public double log1p(double a) {
            return Math.log1p(a);
        }

        public double max(double a, double b) {
            return Math.max(a, b);
        }

        public float max(float a, float b) {
            return Math.max(a, b);
        }

        public int max(int a, int b) {
            return Math.max(a, b);
        }

        public long max(long a, long b) {
            return Math.max(a, b);
        }

        public double min(double a, double b) {
            return Math.min(a, b);
        }

        public float min(float a, float b) {
            return Math.min(a, b);
        }

        public int min(int a, int b) {
            return Math.min(a, b);
        }

        public long min(long a, long b) {
            return Math.min(a, b);
        }

        public double pow(double a, double b) {
            return Math.pow(a, b);
        }

        public double random() {
            return Math.random();
        }

        public double rint(double a) {
            return Math.rint(a);
        }

        public long round(double a) {
            return Math.round(a);
        }

        public int round(float a) {
            return Math.round(a);
        }

        public double signum(double a) {
            return Math.signum(a);
        }

        public float signum(float a) {
            return Math.signum(a);
        }

        public double sin(double a) {
            return Math.sin(a);
        }

        public double sinh(double a) {
            return Math.sinh(a);
        }

        public double sqrt(double a) {
            return Math.sqrt(a);
        }

        public double tan(double a) {
            return Math.tan(a);
        }

        public double tanh(double a) {
            return Math.tanh(a);
        }

        public double toDegrees(double a) {
            return Math.toDegrees(a);
        }

        public double toRadians(double a) {
            return Math.toRadians(a);
        }

        public double ulp(double a) {
            return Math.ulp(a);
        }

        public float ulp(float a) {
            return Math.ulp(a);
        }
    }
}

