/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.SQLException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.config.SyslogdConfigFactory;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.dao.EventDao;
import org.opennms.netmgt.syslogd.BroadcastEventProcessor;
import org.opennms.netmgt.syslogd.SyslogHandler;
import org.opennms.netmgt.syslogd.SyslogdIPMgr;

public class Syslogd
extends AbstractServiceDaemon {
    static final String LOG4J_CATEGORY = "OpenNMS.Syslogd";
    private static final Syslogd m_singleton = new Syslogd();
    private SyslogHandler m_udpEventReceiver;
    private EventDao m_eventDao;

    public static synchronized Syslogd getSingleton() {
        return m_singleton;
    }

    public Syslogd() {
        super(LOG4J_CATEGORY);
    }

    protected void onInit() {
        try {
            this.log().debug("start: Initializing the syslogd config factory");
            SyslogdConfigFactory.init();
        }
        catch (MarshalException e) {
            this.log().error("Failed to load configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ValidationException e) {
            this.log().error("Failed to load configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (IOException e) {
            this.log().error("Failed to load configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        try {
            SyslogdIPMgr.dataSourceSync();
        }
        catch (SQLException e) {
            this.log().error("Failed to load known IP address list", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        SyslogHandler.setSyslogConfig(SyslogdConfigFactory.getInstance());
        this.log().debug("Starting SyslogProcessor");
        this.m_udpEventReceiver = new SyslogHandler();
    }

    protected void onStart() {
        this.m_udpEventReceiver.start();
        try {
            new BroadcastEventProcessor();
        }
        catch (Throwable ex) {
            this.log().error("Failed to setup event reader", ex);
            throw new UndeclaredThrowableException(ex);
        }
    }

    protected void onStop() {
        this.log().debug("exit: closing communication paths.");
        try {
            this.log().debug("stop: Closing SYSLOGD message session.");
            this.log().debug("stop: Syslog message session closed.");
        }
        catch (IllegalStateException e) {
            this.log().debug("stop: The Syslog session was already closed");
        }
        this.log().debug("stop: Stopping queue processor.");
        this.m_udpEventReceiver.stop();
        this.log().debug("Stopped the Syslog UDP Receiver");
    }

    public static Syslogd getInstance() {
        return m_singleton;
    }

    public EventDao getEventDao() {
        return this.m_eventDao;
    }

    public void setEventDao(EventDao eventDao) {
        this.m_eventDao = eventDao;
    }
}

