/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.IOUtils;
import org.opennms.core.utils.Argument;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.notifd.NotificationStrategy;
import org.opennms.netmgt.notifd.Notifd;

public class BSFNotificationStrategy
implements NotificationStrategy {
    private List<Argument> m_arguments;
    private Map<String, String> m_notifParams = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send(List<Argument> arguments) {
        this.m_arguments = arguments;
        String fileName = this.getFileName();
        String lang = this.getLangClass();
        String engine = this.getBsfEngine();
        String[] extensions = this.getFileExtensions();
        LogUtils.infof((Object)this, (String)"Loading notification script from file '%s'", (Object[])new Object[]{fileName});
        File scriptFile = new File(fileName);
        BSFManager bsfManager = new BSFManager();
        int returnCode = -1;
        try {
            if (lang == null) {
                lang = BSFManager.getLangFromFilename((String)fileName);
            }
            HashMap results = new HashMap();
            bsfManager.declareBean("results", results, HashMap.class);
            this.declareBeans(bsfManager);
            if (engine != null && lang != null && extensions != null && extensions.length > 0) {
                BSFManager.registerScriptingEngine((String)lang, (String)engine, (String[])extensions);
            }
            if (scriptFile.exists() && scriptFile.canRead()) {
                String code = IOUtils.getStringFromReader((Reader)new InputStreamReader((InputStream)new FileInputStream(scriptFile), "UTF-8"));
                this.checkAberrantScriptBehaviors(code);
                bsfManager.exec(lang, "BSFNotificationStrategy", 0, 0, (Object)code);
                if ("OK".equals(results.get("status"))) {
                    LogUtils.infof((Object)this, (String)"Execution succeeded and successful status passed back for script '%s'", (Object[])new Object[]{scriptFile});
                    returnCode = 0;
                } else {
                    LogUtils.warnf((Object)this, (String)"Execution succeeded for script '%s', but script did not indicate successful notification by putting an entry into the 'results' bean with key 'status' and value 'OK'", (Object[])new Object[]{scriptFile});
                    returnCode = -1;
                }
            } else {
                LogUtils.warnf((Object)this, (String)"Cannot locate or read BSF script file '%s'. Returning failure indication.", (Object[])new Object[]{fileName});
                returnCode = -1;
            }
        }
        catch (BSFException e) {
            LogUtils.warnf((Object)this, (Throwable)e, (String)"Execution of script '%s' failed with BSFException: %s", (Object[])new Object[]{scriptFile, e.getMessage()});
            returnCode = -1;
        }
        catch (FileNotFoundException e) {
            LogUtils.warnf((Object)this, (String)"Could not find BSF script file '%s'.", (Object[])new Object[]{fileName});
            returnCode = -1;
        }
        catch (IOException e) {
            LogUtils.warnf((Object)this, (Throwable)e, (String)"Execution of script '%s' failed with IOException: %s", (Object[])new Object[]{scriptFile, e.getMessage()});
            returnCode = -1;
        }
        catch (Throwable e) {
            LogUtils.warnf((Object)this, (Throwable)e, (String)"Execution of script '%s' failed with unexpected throwable: %s", (Object[])new Object[]{scriptFile, e.getMessage()});
            returnCode = -1;
        }
        finally {
            bsfManager.terminate();
        }
        return returnCode;
    }

    private void declareBeans(BSFManager bsfManager) throws BSFException {
        Integer nodeId;
        NodeDao nodeDao = Notifd.getInstance().getNodeDao();
        try {
            nodeId = Integer.valueOf(this.m_notifParams.get("-nodeid"));
        }
        catch (NumberFormatException nfe) {
            nodeId = null;
        }
        OnmsNode node = null;
        OnmsAssetRecord assets = null;
        ArrayList<String> categories = new ArrayList<String>();
        String nodeLabel = null;
        String foreignSource = null;
        String foreignId = null;
        if (nodeId != null) {
            node = (OnmsNode)nodeDao.get((Serializable)nodeId);
            nodeLabel = node.getLabel();
            assets = node.getAssetRecord();
            for (OnmsCategory cat : node.getCategories()) {
                categories.add(cat.getName());
            }
            foreignSource = node.getForeignSource();
            foreignId = node.getForeignId();
        }
        bsfManager.declareBean("bsf_notif_strategy", (Object)this, BSFNotificationStrategy.class);
        this.retrieveParams();
        bsfManager.declareBean("notif_params", this.m_notifParams, Map.class);
        bsfManager.declareBean("node_label", (Object)nodeLabel, String.class);
        bsfManager.declareBean("foreign_source", (Object)foreignSource, String.class);
        bsfManager.declareBean("foreign_id", (Object)foreignId, String.class);
        bsfManager.declareBean("node_assets", (Object)assets, OnmsAssetRecord.class);
        bsfManager.declareBean("node_categories", categories, List.class);
        bsfManager.declareBean("node", (Object)node, OnmsNode.class);
        for (Argument arg : this.m_arguments) {
            if ("-tm".equals(arg.getSwitch())) {
                bsfManager.declareBean("text_message", (Object)arg.getValue(), String.class);
            }
            if ("-nm".equals(arg.getSwitch())) {
                bsfManager.declareBean("numeric_message", (Object)arg.getValue(), String.class);
            }
            if ("-nodeid".equals(arg.getSwitch())) {
                bsfManager.declareBean("node_id", (Object)arg.getValue(), String.class);
            }
            if ("-interface".equals(arg.getSwitch())) {
                bsfManager.declareBean("ip_addr", (Object)arg.getValue(), String.class);
            }
            if ("-service".equals(arg.getSwitch())) {
                bsfManager.declareBean("svc_name", (Object)arg.getValue(), String.class);
            }
            if ("-subject".equals(arg.getSwitch())) {
                bsfManager.declareBean("subject", (Object)arg.getValue(), String.class);
            }
            if ("-email".equals(arg.getSwitch())) {
                bsfManager.declareBean("email", (Object)arg.getValue(), String.class);
            }
            if ("-pemail".equals(arg.getSwitch())) {
                bsfManager.declareBean("pager_email", (Object)arg.getValue(), String.class);
            }
            if ("-xmpp".equals(arg.getSwitch())) {
                bsfManager.declareBean("xmpp_address", (Object)arg.getValue(), String.class);
            }
            if ("-tp".equals(arg.getSwitch())) {
                bsfManager.declareBean("text_pin", (Object)arg.getValue(), String.class);
            }
            if ("-np".equals(arg.getSwitch())) {
                bsfManager.declareBean("numeric_pin", (Object)arg.getValue(), String.class);
            }
            if ("-wphone".equals(arg.getSwitch())) {
                bsfManager.declareBean("work_phone", (Object)arg.getValue(), String.class);
            }
            if ("-hphone".equals(arg.getSwitch())) {
                bsfManager.declareBean("home_phone", (Object)arg.getValue(), String.class);
            }
            if ("-mphone".equals(arg.getSwitch())) {
                bsfManager.declareBean("mobile_phone", (Object)arg.getValue(), String.class);
            }
            if ("-tuipin".equals(arg.getSwitch())) {
                bsfManager.declareBean("phone_pin", (Object)arg.getValue(), String.class);
            }
            if (!"-ublog".equals(arg.getSwitch())) continue;
            bsfManager.declareBean("microblog_username", (Object)arg.getValue(), String.class);
        }
    }

    private String getSwitchValue(String argSwitch) {
        String value = null;
        for (Argument arg : this.m_arguments) {
            if (!arg.getSwitch().equals(argSwitch)) continue;
            value = arg.getValue();
        }
        if (value != null && value.equals("")) {
            value = null;
        }
        return value;
    }

    private String getSwitchSubstitution(String argSwitch) {
        String value = null;
        for (Argument arg : this.m_arguments) {
            if (!arg.getSwitch().equals(argSwitch)) continue;
            value = arg.getSubstitution();
        }
        if (value != null && value.equals("")) {
            value = null;
        }
        return value;
    }

    private void checkAberrantScriptBehaviors(String script) {
        if (script.matches("(?s)\\.exec\\s*\\(")) {
            // empty if block
        }
    }

    private String getFileName() {
        return this.getSwitchSubstitution("file-name");
    }

    private String getLangClass() {
        return this.getSwitchSubstitution("lang-class");
    }

    private String getBsfEngine() {
        return this.getSwitchSubstitution("bsf-engine");
    }

    private String[] getFileExtensions() {
        String exts = this.getSwitchSubstitution("file-extensions");
        if (exts == null) {
            return null;
        }
        return exts.split(",");
    }

    private void retrieveParams() {
        for (Argument arg : this.m_arguments) {
            this.m_notifParams.put(arg.getSwitch(), arg.getValue());
        }
    }

    public void log(String level, String format, Object ... args) {
        if ("TRACE".equals(level)) {
            LogUtils.tracef((Object)this, (String)format, (Object[])args);
        }
        if ("DEBUG".equals(level)) {
            LogUtils.debugf((Object)this, (String)format, (Object[])args);
        }
        if ("INFO".equals(level)) {
            LogUtils.infof((Object)this, (String)format, (Object[])args);
        }
        if ("WARN".equals(level)) {
            LogUtils.warnf((Object)this, (String)format, (Object[])args);
        }
        if ("ERROR".equals(level)) {
            LogUtils.errorf((Object)this, (String)format, (Object[])args);
        }
        if ("FATAL".equals(level)) {
            LogUtils.errorf((Object)this, (String)format, (Object[])args);
        }
    }
}

