/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vacuumd;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.sql.DataSource;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.netmgt.config.VacuumdConfigFactory;
import org.opennms.netmgt.config.vacuumd.Action;
import org.opennms.netmgt.config.vacuumd.Automation;
import org.opennms.netmgt.config.vacuumd.Statement;
import org.opennms.netmgt.config.vacuumd.Trigger;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventIpcManager;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.scheduler.LegacyScheduler;
import org.opennms.netmgt.scheduler.Schedule;
import org.opennms.netmgt.scheduler.Scheduler;
import org.opennms.netmgt.vacuumd.AutomationInterval;
import org.opennms.netmgt.vacuumd.AutomationProcessor;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;

public class Vacuumd
extends AbstractServiceDaemon
implements Runnable,
EventListener {
    private static volatile Vacuumd m_singleton;
    private volatile Thread m_thread;
    private volatile long m_startTime;
    private volatile boolean m_stopped = false;
    private volatile LegacyScheduler m_scheduler;
    private volatile EventIpcManager m_eventMgr;

    public static synchronized Vacuumd getSingleton() {
        if (m_singleton == null) {
            m_singleton = new Vacuumd();
        }
        return m_singleton;
    }

    public Vacuumd() {
        super("OpenNMS.Vacuumd");
    }

    protected void onInit() {
        try {
            this.log().info("Loading the configuration file.");
            VacuumdConfigFactory.init();
            this.getEventManager().addEventListener((EventListener)this, "uei.opennms.org/internal/reloadVacuumdConfig");
            this.initializeDataSources();
        }
        catch (Throwable ex) {
            this.log().error("Failed to load outage configuration", ex);
            throw new UndeclaredThrowableException(ex);
        }
        this.log().info("Vacuumd initialization complete");
        this.createScheduler();
        this.scheduleAutomations();
    }

    private void initializeDataSources() throws MarshalException, ValidationException, IOException, ClassNotFoundException, PropertyVetoException, SQLException {
        for (Trigger trigger : this.getVacuumdConfig().getTriggers()) {
            DataSourceFactory.init((String)trigger.getDataSource());
        }
        for (Action action : this.getVacuumdConfig().getActions()) {
            DataSourceFactory.init((String)action.getDataSource());
        }
    }

    protected void onStart() {
        this.m_startTime = System.currentTimeMillis();
        this.m_thread = new Thread((Runnable)this, "Vacuumd-Thread");
        this.m_thread.start();
        this.m_scheduler.start();
    }

    protected void onStop() {
        this.m_stopped = true;
        this.m_scheduler.stop();
    }

    protected void onPause() {
        this.m_scheduler.pause();
        this.m_stopped = true;
    }

    protected void onResume() {
        this.m_thread = new Thread((Runnable)this, "Vacuumd-Thread");
        this.m_thread.start();
        this.m_scheduler.resume();
    }

    @Override
    public void run() {
        this.log().info("Vacuumd scheduling started");
        long now = System.currentTimeMillis();
        long period = this.getVacuumdConfig().getPeriod();
        this.log().info("Vacuumd sleeping until time to execute statements period = " + period);
        long waitTime = 500L;
        while (!this.m_stopped) {
            try {
                now = this.waitPeriod(now, period, waitTime);
                this.log().info("Vacuumd beginning to execute statements");
                this.executeStatements();
                this.m_startTime = System.currentTimeMillis();
            }
            catch (Throwable e) {
                this.log().error("Unexpected exception: ", e);
            }
        }
    }

    protected void executeStatements() {
        if (!this.m_stopped) {
            List statements = this.getVacuumdConfig().getStatements();
            for (Statement statement : statements) {
                this.runUpdate(statement.getContent(), statement.getTransactional());
            }
        }
    }

    private long waitPeriod(long now, long period, long waitTime) {
        int count = 0;
        while (!this.m_stopped && now - this.m_startTime < period) {
            try {
                if (count % 100 == 0) {
                    this.log().debug("Vacuumd: " + (period - now + this.m_startTime) + "ms remaining to execution.");
                }
                Thread.sleep(waitTime);
                now = System.currentTimeMillis();
                ++count;
            }
            catch (InterruptedException e) {}
        }
        return now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runUpdate(String sql, boolean transactional) {
        this.log().info("Vacuumd executing statement: " + sql);
        Connection dbConn = null;
        boolean commitRequired = false;
        boolean autoCommitFlag = !transactional;
        try {
            dbConn = this.getDataSourceFactory().getConnection();
            dbConn.setAutoCommit(autoCommitFlag);
            PreparedStatement stmt = dbConn.prepareStatement(sql);
            int count = stmt.executeUpdate();
            stmt.close();
            if (this.log().isDebugEnabled()) {
                this.log().debug("Vacuumd: Ran update " + sql + ": this affected " + count + " rows");
            }
            commitRequired = transactional;
            return;
        }
        catch (SQLException ex) {
            this.log().error("Vacuumd:  Database error execuating statement  " + sql, (Throwable)ex);
            return;
        }
        finally {
            block39: {
                if (dbConn == null) break block39;
                try {
                    if (commitRequired) {
                        dbConn.commit();
                    } else if (transactional) {
                        dbConn.rollback();
                    }
                    if (dbConn == null) break block39;
                }
                catch (SQLException ex) {
                    if (dbConn == null) break block39;
                    try {
                        dbConn.close();
                    }
                    catch (Throwable e) {}
                    break block39;
                    catch (Throwable throwable) {
                        if (dbConn == null) throw throwable;
                        try {
                            dbConn.close();
                            throw throwable;
                        }
                        catch (Throwable e) {}
                    }
                }
                try {
                    dbConn.close();
                }
                catch (Throwable e) {}
            }
        }
    }

    private void createScheduler() {
        try {
            this.log().debug("init: Creating Vacuumd scheduler");
            this.m_scheduler = new LegacyScheduler("Vacuumd", 2);
        }
        catch (RuntimeException e) {
            this.log().fatal("init: Failed to create Vacuumd scheduler: " + e, (Throwable)e);
            throw e;
        }
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    private void scheduleAutomations() {
        for (Automation auto : this.getVacuumdConfig().getAutomations()) {
            this.scheduleAutomation(auto);
        }
    }

    private void scheduleAutomation(Automation auto) {
        if (auto.getActive()) {
            AutomationProcessor ap = new AutomationProcessor(auto);
            Schedule s = new Schedule(ap, new AutomationInterval(auto.getInterval()), this.m_scheduler);
            ap.setSchedule(s);
            s.schedule();
        }
    }

    public EventIpcManager getEventManager() {
        return this.m_eventMgr;
    }

    public void setEventManager(EventIpcManager eventMgr) {
        this.m_eventMgr = eventMgr;
    }

    public void onEvent(Event event) {
        if (this.isReloadConfigEvent(event)) {
            this.handleReloadConifgEvent();
        }
    }

    private void handleReloadConifgEvent() {
        this.log().info("onEvent: reloading configuration...");
        EventBuilder ebldr = null;
        try {
            this.log().debug("onEvent: Number of elements in schedule:" + this.m_scheduler.getScheduled() + "; calling stop on scheduler...");
            this.stop();
            ExecutorService runner = this.m_scheduler.getRunner();
            while (!runner.isShutdown() || this.m_scheduler.getStatus() != 4) {
                this.log().debug("onEvent: waiting for scheduler to stop. Current status of scheduler: " + this.m_scheduler.getStatus() + "; Current status of runner: " + (runner.isTerminated() ? "TERMINATED" : (runner.isShutdown() ? "SHUTDOWN" : "RUNNING")));
                Thread.sleep(500L);
            }
            this.log().debug("onEvent: Current status of scheduler: " + this.m_scheduler.getStatus() + "; Current status of runner: " + (runner.isTerminated() ? "TERMINATED" : (runner.isShutdown() ? "SHUTDOWN" : "RUNNING")));
            this.log().debug("onEvent: Number of elements in schedule:" + this.m_scheduler.getScheduled());
            this.log().debug("onEvent: reloading vacuumd configuration.");
            VacuumdConfigFactory.reload();
            this.log().debug("onEvent: creating new schedule and rescheduling automations.");
            this.init();
            this.log().debug("onEvent: restarting vacuumd and scheduler.");
            this.start();
            this.log().debug("onEvent: Number of elements in schedule:" + this.m_scheduler.getScheduled());
            ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigSuccessful", this.getName());
            ebldr.addParam("daemonName", "Vacuumd");
        }
        catch (MarshalException e) {
            this.log().error("onEvent: problem marshaling vacuumd configuration: " + (Object)((Object)e), (Throwable)e);
            ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", this.getName());
            ebldr.addParam("daemonName", "Vacuumd");
            ebldr.addParam("reason", e.getLocalizedMessage().substring(0, 128));
        }
        catch (ValidationException e) {
            this.log().error("onEvent: problem validating vacuumd configuration: " + (Object)((Object)e), (Throwable)e);
            ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", this.getName());
            ebldr.addParam("daemonName", "Vacuumd");
            ebldr.addParam("reason", e.getLocalizedMessage().substring(0, 128));
        }
        catch (IOException e) {
            this.log().error("onEvent: IO problem reading vacuumd configuration: " + e, (Throwable)e);
            ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", this.getName());
            ebldr.addParam("daemonName", "Vacuumd");
            ebldr.addParam("reason", e.getLocalizedMessage().substring(0, 128));
        }
        catch (InterruptedException e) {
            this.log().error("onEvent: Problem interrupting current Vacuumd Thread: " + e, (Throwable)e);
            ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", this.getName());
            ebldr.addParam("daemonName", "Vacuumd");
            ebldr.addParam("reason", e.getLocalizedMessage().substring(0, 128));
        }
        this.log().info("onEvent: completed configuration reload.");
        if (ebldr != null) {
            this.m_eventMgr.sendNow(ebldr.getEvent());
        }
    }

    private boolean isReloadConfigEvent(Event event) {
        boolean isTarget = false;
        if ("uei.opennms.org/internal/reloadDaemonConfig".equals(event.getUei())) {
            List parmCollection = event.getParmCollection();
            for (Parm parm : parmCollection) {
                if (!"daemonName".equals(parm.getParmName()) || !"Vacuumd".equalsIgnoreCase(parm.getValue().getContent())) continue;
                isTarget = true;
                break;
            }
        } else if ("uei.opennms.org/internal/reloadVacuumdConfig".equals(event.getUei())) {
            isTarget = true;
        }
        return isTarget;
    }

    private VacuumdConfigFactory getVacuumdConfig() {
        return VacuumdConfigFactory.getInstance();
    }

    private DataSource getDataSourceFactory() {
        return DataSourceFactory.getInstance();
    }
}

