/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketd;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.EventUtils;
import org.opennms.netmgt.capsd.InsufficientInformationException;
import org.opennms.netmgt.daemon.SpringServiceDaemon;
import org.opennms.netmgt.model.events.EventIpcManager;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.ticketd.TicketerServiceLayer;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.springframework.util.Assert;

public class TroubleTicketer
implements SpringServiceDaemon,
EventListener {
    private volatile boolean m_initialized = false;
    private volatile EventIpcManager m_eventIpcManager;
    private volatile TicketerServiceLayer m_ticketerServiceLayer;

    public void setEventIpcManager(EventIpcManager eventIpcManager) {
        this.m_eventIpcManager = eventIpcManager;
    }

    public void setTicketerServiceLayer(TicketerServiceLayer ticketerServiceLayer) {
        this.m_ticketerServiceLayer = ticketerServiceLayer;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((!this.m_initialized ? 1 : 0) != 0, (String)"shouldn't be calling afterProperties set more than once");
        Assert.state((this.m_eventIpcManager != null ? 1 : 0) != 0, (String)"property eventIpcManager must be set to a non-null value");
        Assert.state((this.m_ticketerServiceLayer != null ? 1 : 0) != 0, (String)"property ticketerServiceLayer must be set to a non-null value");
        String[] ueis = new String[]{"uei.opennms.org/troubleTicket/cancel", "uei.opennms.org/troubleTicket/close", "uei.opennms.org/troubleTicket/create", "uei.opennms.org/troubleTicket/update", "uei.opennms.org/internal/reloadDaemonConfig"};
        this.m_eventIpcManager.addEventListener((EventListener)this, Arrays.asList(ueis));
        this.m_initialized = true;
    }

    public void start() throws Exception {
    }

    public void destroy() throws Exception {
    }

    public String getName() {
        return "OpenNMS.TroubleTicketer";
    }

    public void onEvent(Event e) {
        try {
            if ("uei.opennms.org/troubleTicket/cancel".equals(e.getUei())) {
                this.handleCancelTicket(e);
            } else if ("uei.opennms.org/troubleTicket/close".equals(e.getUei())) {
                this.handleCloseTicket(e);
            } else if ("uei.opennms.org/troubleTicket/create".equals(e.getUei())) {
                this.handleCreateTicket(e);
            } else if ("uei.opennms.org/troubleTicket/update".equals(e.getUei())) {
                this.handleUpdateTicket(e);
            } else if (this.isReloadConfigEvent(e)) {
                this.handleTicketerReload(e);
            }
        }
        catch (InsufficientInformationException ex) {
            this.log().warn("Unable to create trouble ticket due to lack of information: " + ex.getMessage());
        }
        catch (Throwable t) {
            this.log().error("Error occurred during trouble ticket processing!", t);
        }
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private void handleCloseTicket(Event e) throws InsufficientInformationException {
        EventUtils.requireParm(e, "alarmId");
        EventUtils.requireParm(e, "alarmUei");
        EventUtils.requireParm(e, "user");
        EventUtils.requireParm(e, "troubleTicket");
        int alarmId = EventUtils.getIntParm(e, "alarmId");
        String ticketId = EventUtils.getParm(e, "troubleTicket");
        this.m_ticketerServiceLayer.closeTicketForAlarm(alarmId, ticketId);
    }

    private void handleUpdateTicket(Event e) throws InsufficientInformationException {
        EventUtils.requireParm(e, "alarmId");
        EventUtils.requireParm(e, "alarmUei");
        EventUtils.requireParm(e, "user");
        EventUtils.requireParm(e, "troubleTicket");
        int alarmId = EventUtils.getIntParm(e, "alarmId");
        String ticketId = EventUtils.getParm(e, "troubleTicket");
        this.m_ticketerServiceLayer.updateTicketForAlarm(alarmId, ticketId);
    }

    private void handleCreateTicket(Event e) throws InsufficientInformationException {
        EventUtils.requireParm(e, "alarmId");
        EventUtils.requireParm(e, "alarmUei");
        EventUtils.requireParm(e, "user");
        int alarmId = EventUtils.getIntParm(e, "alarmId");
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (Parm parm : e.getParmCollection()) {
            attributes.put(parm.getParmName(), parm.getValue().getContent());
        }
        this.m_ticketerServiceLayer.createTicketForAlarm(alarmId, attributes);
    }

    private void handleCancelTicket(Event e) throws InsufficientInformationException {
        EventUtils.requireParm(e, "alarmId");
        EventUtils.requireParm(e, "alarmUei");
        EventUtils.requireParm(e, "user");
        EventUtils.requireParm(e, "troubleTicket");
        int alarmId = EventUtils.getIntParm(e, "alarmId");
        String ticketId = EventUtils.getParm(e, "troubleTicket");
        this.m_ticketerServiceLayer.cancelTicketForAlarm(alarmId, ticketId);
    }

    private boolean isReloadConfigEvent(Event event) {
        boolean isTarget = false;
        if ("uei.opennms.org/internal/reloadDaemonConfig".equals(event.getUei())) {
            List parmCollection = event.getParmCollection();
            for (Parm parm : parmCollection) {
                if (!"daemonName".equals(parm.getParmName()) || !"Ticketd".equalsIgnoreCase(parm.getValue().getContent())) continue;
                isTarget = true;
                break;
            }
        }
        return isTarget;
    }

    private void handleTicketerReload(Event e) {
        this.m_ticketerServiceLayer.reloadTicketer();
    }
}

