/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.collectd.AliasedResource;
import org.opennms.netmgt.collectd.IfInfo;
import org.opennms.netmgt.config.collector.CollectionAttribute;
import org.opennms.netmgt.config.collector.CollectionResource;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.threshd.CollectionResourceWrapper;
import org.opennms.netmgt.threshd.ThresholdEntity;
import org.opennms.netmgt.threshd.ThresholdingSet;
import org.opennms.netmgt.xml.event.Event;

public class CollectorThresholdingSet
extends ThresholdingSet {
    boolean storeByIfAlias = false;
    boolean storeByForeignSource = false;

    public CollectorThresholdingSet(int nodeId, String hostAddress, String serviceName, RrdRepository repository, Map<String, Object> roProps) {
        super(nodeId, hostAddress, serviceName, repository);
        String storeByIfAliasString = ParameterMap.getKeyedString(roProps, (String)"storeByIfAlias", null);
        this.storeByIfAlias = storeByIfAliasString != null && storeByIfAliasString.toLowerCase().equals("true");
        this.storeByForeignSource = CollectorThresholdingSet.isStoreByForeignSource();
        CollectorThresholdingSet.log().debug("storeByForeignSource = " + this.storeByForeignSource);
    }

    public static boolean isStoreByForeignSource() {
        return Boolean.getBoolean("org.opennms.rrd.storeByForeignSource");
    }

    public boolean hasThresholds(CollectionAttribute attribute) {
        CollectionResource resource = attribute.getResource();
        if (!this.isCollectionEnabled(attribute.getResource())) {
            return false;
        }
        if (resource instanceof AliasedResource && !this.storeByIfAlias) {
            return false;
        }
        return this.hasThresholds(resource.getResourceTypeName(), attribute.getName());
    }

    public List<Event> applyThresholds(CollectionResource resource, Map<String, CollectionAttribute> attributesMap, Date collectionTimestamp) {
        if (!this.isCollectionEnabled(resource)) {
            CollectorThresholdingSet.log().debug("applyThresholds: Ignoring resource " + resource + " because data collection is disabled for this resource.");
            return new LinkedList<Event>();
        }
        CollectionResourceWrapper resourceWrapper = new CollectionResourceWrapper(collectionTimestamp, this.m_nodeId, this.m_hostAddress, this.m_serviceName, this.m_repository, resource, attributesMap);
        return this.applyThresholds(resourceWrapper, attributesMap);
    }

    @Override
    protected boolean passedThresholdFilters(CollectionResourceWrapper resource, ThresholdEntity thresholdEntity) {
        if (resource.isAnInterfaceResource() && !resource.isValidInterfaceResource()) {
            CollectorThresholdingSet.log().info("passedThresholdFilters: Could not get data interface information for '" + resource.getIfLabel() + "' or this interface has an invalid ifIndex.  Not evaluating threshold.");
            return false;
        }
        return super.passedThresholdFilters(resource, thresholdEntity);
    }

    protected boolean isCollectionEnabled(CollectionResource resource) {
        if (resource instanceof IfInfo) {
            return ((IfInfo)resource).isScheduledForCollection();
        }
        return true;
    }
}

