/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.AliasedResource;
import org.opennms.netmgt.collectd.IfInfo;
import org.opennms.netmgt.config.collector.CollectionAttribute;
import org.opennms.netmgt.config.collector.CollectionResource;
import org.opennms.netmgt.dao.support.ResourceTypeUtils;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.poller.LatencyCollectionResource;
import org.opennms.netmgt.threshd.JdbcIfInfoGetter;

public class CollectionResourceWrapper {
    private final int m_nodeId;
    private final String m_hostAddress;
    private final String m_serviceName;
    private String m_dsLabel;
    private String m_iflabel;
    private String m_ifindex;
    private final RrdRepository m_repository;
    private final CollectionResource m_resource;
    private final Map<String, CollectionAttribute> m_attributes;
    static final ConcurrentHashMap<String, CacheEntry> s_cache = new ConcurrentHashMap();
    private final Map<String, Double> m_localCache = new HashMap<String, Double>();
    private Map<String, String> m_ifInfo;
    private final Date m_collectionTimestamp;

    public CollectionResourceWrapper(Date collectionTimestamp, int nodeId, String hostAddress, String serviceName, RrdRepository repository, CollectionResource resource, Map<String, CollectionAttribute> attributes) {
        if (collectionTimestamp == null) {
            throw new IllegalArgumentException(String.format("%s: Null collection timestamp when thresholding service %s on node %d (%s)", this.getClass().getSimpleName(), serviceName, nodeId, hostAddress));
        }
        this.m_collectionTimestamp = collectionTimestamp;
        this.m_nodeId = nodeId;
        this.m_hostAddress = hostAddress;
        this.m_serviceName = serviceName;
        this.m_repository = repository;
        this.m_resource = resource;
        this.m_attributes = attributes;
        if (this.isAnInterfaceResource()) {
            if (resource instanceof AliasedResource) {
                this.m_iflabel = ((AliasedResource)resource).getLabel();
                this.m_ifInfo = ((AliasedResource)resource).getIfInfo().getAttributesMap();
                this.m_ifInfo.put("domain", ((AliasedResource)resource).getDomain());
            }
            if (resource instanceof IfInfo) {
                this.m_iflabel = ((IfInfo)resource).getLabel();
                this.m_ifInfo = ((IfInfo)resource).getAttributesMap();
            }
            if (resource instanceof LatencyCollectionResource) {
                JdbcIfInfoGetter ifInfoGetter = new JdbcIfInfoGetter();
                String ipAddress = ((LatencyCollectionResource)resource).getIpAddress();
                this.m_iflabel = ifInfoGetter.getIfLabel(this.getNodeId(), ipAddress);
                if (this.m_iflabel != null) {
                    this.m_ifInfo = ifInfoGetter.getIfInfoForNodeAndLabel(this.getNodeId(), this.m_iflabel);
                } else {
                    this.log().info("Can't find ifLabel for latency resource " + resource.getInstance() + " on node " + this.getNodeId());
                }
            }
            if (this.m_ifInfo != null) {
                this.m_ifindex = this.m_ifInfo.get("snmpifindex");
            } else {
                this.log().info("Can't find ifInfo for " + resource);
            }
        }
    }

    public int getNodeId() {
        return this.m_nodeId;
    }

    public String getHostAddress() {
        return this.m_hostAddress;
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    public RrdRepository getRepository() {
        return this.m_repository;
    }

    public String getDsLabel() {
        return this.m_dsLabel;
    }

    public void setDsLabel(String dsLabel) {
        this.m_dsLabel = dsLabel;
    }

    public String getInstance() {
        return this.m_resource != null ? this.m_resource.getInstance() : null;
    }

    public String getInstanceLabel() {
        return this.m_resource != null ? this.m_resource.getLabel() : null;
    }

    public String getResourceTypeName() {
        return this.m_resource != null ? this.m_resource.getResourceTypeName() : null;
    }

    public String getResourceId() {
        String[] parts;
        String resourceType = this.getResourceTypeName();
        String resourceLabel = this.getInstanceLabel();
        if ("node".equals(resourceType)) {
            resourceType = "nodeSnmp";
            resourceLabel = "";
        }
        if ("if".equals(resourceType)) {
            resourceType = "interfaceSnmp";
        }
        String parentResourceTypeName = "node";
        String parentResourceName = Integer.toString(this.getNodeId());
        if (this.m_resource != null && this.m_resource.getParent() != null && this.m_resource.getParent().startsWith("fs") && (parts = this.m_resource.getParent().split(File.separator)).length == 3) {
            parentResourceTypeName = "nodeSource";
            parentResourceName = parts[1] + ":" + parts[2];
        }
        return OnmsResource.createResourceId((String[])new String[]{parentResourceTypeName, parentResourceName, resourceType, resourceLabel});
    }

    public String getIfLabel() {
        return this.m_iflabel;
    }

    public String getIfIndex() {
        return this.m_ifindex;
    }

    protected String getIfInfoValue(String attribute) {
        if (this.m_ifInfo != null) {
            return this.m_ifInfo.get(attribute);
        }
        return null;
    }

    public boolean isAnInterfaceResource() {
        return this.getResourceTypeName() != null && this.getResourceTypeName().equals("if");
    }

    public boolean isValidInterfaceResource() {
        if (this.m_ifInfo == null) {
            return false;
        }
        try {
            if (null == this.m_ifindex) {
                return false;
            }
            if (Integer.parseInt(this.m_ifindex) < 0) {
                return false;
            }
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    public Double getAttributeValue(String ds) {
        String value;
        if (this.isAnInterfaceResource() && ("snmpifspeed".equalsIgnoreCase(ds) || "snmpiftype".equalsIgnoreCase(ds)) && (value = this.getIfInfoValue(ds)) != null) {
            try {
                return Double.parseDouble(value);
            }
            catch (Exception e) {
                return Double.NaN;
            }
        }
        if (this.m_attributes == null || this.m_attributes.get(ds) == null) {
            this.log().info("getAttributeValue: can't find attribute called " + ds + " on " + this.m_resource);
            return null;
        }
        String numValue = this.m_attributes.get(ds).getNumericValue();
        if (numValue == null) {
            this.log().info("getAttributeValue: can't find numeric value for " + ds + " on " + this.m_resource);
            return null;
        }
        String id = "node[" + this.m_nodeId + "].resourceType[" + this.m_resource.getResourceTypeName() + "].instance[" + this.m_resource.getLabel() + "].metric[" + ds + "]";
        Double current = null;
        try {
            current = Double.parseDouble(numValue);
        }
        catch (NumberFormatException e) {
            this.log().error(id + " does not have a numeric value: " + numValue);
            return null;
        }
        if (!this.m_attributes.get(ds).getType().toLowerCase().startsWith("counter")) {
            if (this.log().isDebugEnabled()) {
                this.log().debug("getAttributeValue: id=" + id + ", value= " + current);
            }
            return current;
        }
        return this.getCounterValue(id, current);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Double getCounterValue(String id, Double current) {
        Map<String, Double> map = this.m_localCache;
        synchronized (map) {
            Double value;
            if (!this.m_localCache.containsKey(id)) {
                CacheEntry last = s_cache.put(id, new CacheEntry(this.m_collectionTimestamp, current));
                if (this.log().isDebugEnabled()) {
                    this.log().debug("getCounterValue: id=" + id + ", last=" + (last == null ? last : last.value + "@" + last.timestamp) + ", current=" + current);
                }
                if (last == null) {
                    this.m_localCache.put(id, Double.NaN);
                    this.log().info("getCounterValue: unknown last value for " + id + ", ignoring current");
                } else {
                    long interval;
                    Double delta = current - last.value;
                    if (delta < 0.0) {
                        double newDelta = delta;
                        if ((newDelta += Math.pow(2.0, 32.0)) < 0.0) {
                            newDelta += Math.pow(2.0, 64.0) - Math.pow(2.0, 32.0);
                        }
                        this.log().info("getCounterValue: " + id + "(counter) wrapped counter adjusted last=" + last.value + "@" + last.timestamp + ", current=" + current + ", olddelta=" + delta + ", newdelta=" + newDelta);
                        delta = newDelta;
                    }
                    if ((interval = (this.m_collectionTimestamp.getTime() - last.timestamp.getTime()) / 1000L) > 0L) {
                        this.log().debug("getCounterValue: id=" + id + ", value=" + delta / (double)interval + ", delta=" + delta + ", interval=" + interval);
                        this.m_localCache.put(id, delta / (double)interval);
                    } else {
                        this.log().info("getCounterValue: invalid zero-length rate interval for " + id + ", returning rate of zero");
                        this.m_localCache.put(id, 0.0);
                        s_cache.put(id, last);
                    }
                }
            }
            if ((value = this.m_localCache.get(id)) == null) {
                this.log().error("getCounterValue: value was not calculated correctly for " + id + ", using NaN");
                this.m_localCache.put(id, Double.NaN);
                return Double.NaN;
            }
            return value;
        }
    }

    public String getFieldValue(String ds) {
        if (ds == null || "".equals(ds)) {
            return null;
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug("getLabelValue: Getting Value for " + this.m_resource.getResourceTypeName() + "::" + ds);
        }
        if ("nodeid".equalsIgnoreCase(ds)) {
            return Integer.toString(this.m_nodeId);
        }
        if ("ipaddress".equalsIgnoreCase(ds)) {
            return this.m_hostAddress;
        }
        if ("iflabel".equalsIgnoreCase(ds)) {
            return this.getIfLabel();
        }
        if ("id".equalsIgnoreCase(ds)) {
            try {
                File resourceDirectory = this.m_resource.getResourceDir(this.m_repository);
                return resourceDirectory.getName();
            }
            catch (FileNotFoundException e) {
                this.log().debug("getLabelValue: cannot find resource directory: " + e.getMessage(), (Throwable)e);
            }
        }
        try {
            String retval = null;
            if (this.isAnInterfaceResource() && (retval = this.getIfInfoValue(ds)) != null) {
                return retval;
            }
            File resourceDirectory = this.m_resource.getResourceDir(this.m_repository);
            retval = ResourceTypeUtils.getStringProperty((File)resourceDirectory, (String)ds);
            if (retval != null) {
                return retval;
            }
        }
        catch (FileNotFoundException e) {
            this.log().debug("getFieldValue: Can't find resource directory: " + e.getMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            this.log().info("getFieldValue: Can't get value for attribute " + ds + " for resource " + this.m_resource + ". " + e, e);
        }
        this.log().debug("getFieldValue: The field " + ds + " is not a string property. Trying to parse it as numeric metric.");
        Double d = this.getAttributeValue(ds);
        if (d != null) {
            return d.toString();
        }
        return null;
    }

    public String toString() {
        return this.m_resource.toString();
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    static class CacheEntry {
        final Date timestamp;
        final Double value;

        public CacheEntry(Date timestamp, Double value) {
            if (timestamp == null) {
                throw new IllegalArgumentException("Illegal null timestamp in cache value");
            }
            if (value == null) {
                throw new IllegalArgumentException("Illegal null value in cache value");
            }
            this.timestamp = timestamp;
            this.value = value;
        }
    }
}

