/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.statsd;

import java.text.ParseException;
import java.util.List;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.daemon.SpringServiceDaemon;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.ResourceDao;
import org.opennms.netmgt.dao.RrdDao;
import org.opennms.netmgt.filter.FilterDao;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventForwarder;
import org.opennms.netmgt.model.events.annotations.EventHandler;
import org.opennms.netmgt.model.events.annotations.EventListener;
import org.opennms.netmgt.statsd.ReportDefinition;
import org.opennms.netmgt.statsd.ReportDefinitionBuilder;
import org.opennms.netmgt.statsd.ReportInstance;
import org.opennms.netmgt.statsd.ReportPersister;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.springframework.scheduling.quartz.CronTriggerBean;
import org.springframework.scheduling.quartz.MethodInvokingJobDetailFactoryBean;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

@EventListener(name="OpenNMS:Statsd")
public class Statsd
implements SpringServiceDaemon {
    private NodeDao m_nodeDao;
    private ResourceDao m_resourceDao;
    private RrdDao m_rrdDao;
    private FilterDao m_filterDao;
    private TransactionTemplate m_transactionTemplate;
    private ReportPersister m_reportPersister;
    private Scheduler m_scheduler;
    private ReportDefinitionBuilder m_reportDefinitionBuilder;
    private volatile EventForwarder m_eventForwarder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(uei="uei.opennms.org/internal/reloadDaemonConfig")
    public void handleReloadConfigEvent(Event e) {
        if (this.isReloadConfigEventTarget(e)) {
            this.log().info("handleReloadConfigEvent: reloading configuration...");
            EventBuilder ebldr = null;
            this.log().debug("handleReloadConfigEvent: acquiring lock...");
            Scheduler scheduler = this.m_scheduler;
            synchronized (scheduler) {
                try {
                    this.log().debug("handleReloadConfigEvent: lock acquired, unscheduling current reports...");
                    this.unscheduleReports();
                    this.m_reportDefinitionBuilder.reload();
                    this.log().debug("handleReloadConfigEvent: config remarshaled, unscheduling current reports...");
                    this.log().debug("handleReloadConfigEvent: reports unscheduled, rescheduling...");
                    this.start();
                    this.log().debug("handleRelodConfigEvent: reports rescheduled.");
                    ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigSuccessful", "Statsd");
                    ebldr.addParam("daemonName", "Statsd");
                }
                catch (Throwable exception) {
                    this.log().error("handleReloadConfigurationEvent: Error reloading configuration:" + exception, exception);
                    ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", "Statsd");
                    ebldr.addParam("daemonName", "Statsd");
                    ebldr.addParam("reason", exception.getLocalizedMessage().substring(1, 128));
                }
                if (ebldr != null) {
                    this.getEventForwarder().sendNow(ebldr.getEvent());
                }
            }
            this.log().debug("handleReloadConfigEvent: lock released.");
        }
    }

    private boolean isReloadConfigEventTarget(Event event) {
        boolean isTarget = false;
        List parmCollection = event.getParmCollection();
        for (Parm parm : parmCollection) {
            if (!"daemonName".equals(parm.getParmName()) || !"Statsd".equalsIgnoreCase(parm.getValue().getContent())) continue;
            isTarget = true;
            break;
        }
        this.log().debug("isReloadConfigEventTarget: Statsd was target of reload event: " + isTarget);
        return isTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        this.log().debug("start: acquiring lock...");
        Scheduler scheduler = this.m_scheduler;
        synchronized (scheduler) {
            this.log().info("start: lock acquired (may have reentered), scheduling Reports...");
            for (ReportDefinition reportDef : this.m_reportDefinitionBuilder.buildReportDefinitions()) {
                this.log().debug("start: scheduling Report: " + reportDef + "...");
                this.scheduleReport(reportDef);
            }
            this.log().info("start: " + this.m_scheduler.getJobNames("DEFAULT").length + " jobs scheduled.");
        }
        this.log().debug("start: lock released (unless reentrant).");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        this.log().debug("start: acquiring lock...");
        Scheduler scheduler = this.m_scheduler;
        synchronized (scheduler) {
            this.m_scheduler.shutdown();
        }
        this.log().debug("start: lock released (unless reentrant).");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unscheduleReports() throws Exception {
        Scheduler scheduler = this.m_scheduler;
        synchronized (scheduler) {
            for (ReportDefinition reportDef : this.m_reportDefinitionBuilder.buildReportDefinitions()) {
                this.m_scheduler.deleteJob(reportDef.getDescription(), "DEFAULT");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleReport(ReportDefinition reportDef) throws ClassNotFoundException, NoSuchMethodException, ParseException, SchedulerException, Exception {
        Scheduler scheduler = this.m_scheduler;
        synchronized (scheduler) {
            MethodInvokingJobDetailFactoryBean jobFactory = new MethodInvokingJobDetailFactoryBean();
            jobFactory.setTargetObject((Object)this);
            jobFactory.setTargetMethod("runReport");
            jobFactory.setArguments(new Object[]{reportDef});
            jobFactory.setConcurrent(false);
            jobFactory.setBeanName(reportDef.getDescription());
            jobFactory.afterPropertiesSet();
            JobDetail jobDetail = (JobDetail)jobFactory.getObject();
            CronTriggerBean cronReportTrigger = new CronTriggerBean();
            cronReportTrigger.setBeanName(reportDef.getDescription());
            cronReportTrigger.setJobDetail(jobDetail);
            cronReportTrigger.setCronExpression(reportDef.getCronExpression());
            cronReportTrigger.afterPropertiesSet();
            this.m_scheduler.scheduleJob(cronReportTrigger.getJobDetail(), (Trigger)cronReportTrigger);
            this.log().debug("Schedule report " + cronReportTrigger);
        }
    }

    public void runReport(ReportDefinition reportDef) throws Throwable {
        ReportInstance report;
        try {
            report = reportDef.createReport(this.m_nodeDao, this.m_resourceDao, this.m_rrdDao, this.m_filterDao);
        }
        catch (Throwable t) {
            this.log().error("Could not create a report instance for report definition " + reportDef + ": " + t, t);
            throw t;
        }
        this.getTransactionTemplate().execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus status) {
                Statsd.this.log().debug("Starting report " + report);
                report.walk();
                Statsd.this.log().debug("Completed report " + report);
                Statsd.this.m_reportPersister.persist(report);
                Statsd.this.log().debug("Report " + report + " persisted");
            }
        });
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_nodeDao != null ? 1 : 0) != 0, (String)"property nodeDao must be set to a non-null value");
        Assert.state((this.m_resourceDao != null ? 1 : 0) != 0, (String)"property resourceDao must be set to a non-null value");
        Assert.state((this.m_rrdDao != null ? 1 : 0) != 0, (String)"property rrdDao must be set to a non-null value");
        Assert.state((this.m_filterDao != null ? 1 : 0) != 0, (String)"property filterDao must be set to a non-null value");
        Assert.state((this.m_transactionTemplate != null ? 1 : 0) != 0, (String)"property transactionTemplate must be set to a non-null value");
        Assert.state((this.m_reportPersister != null ? 1 : 0) != 0, (String)"property reportPersister must be set to a non-null value");
        Assert.state((this.m_scheduler != null ? 1 : 0) != 0, (String)"property scheduler must be set to a non-null value");
        Assert.state((this.m_reportDefinitionBuilder != null ? 1 : 0) != 0, (String)"property reportDefinitionBuilder must be set to a non-null value");
        Assert.state((this.m_eventForwarder != null ? 1 : 0) != 0, (String)"eventForwarder property must be set to a non-null value");
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public ResourceDao getResourceDao() {
        return this.m_resourceDao;
    }

    public void setResourceDao(ResourceDao resourceDao) {
        this.m_resourceDao = resourceDao;
    }

    public RrdDao getRrdDao() {
        return this.m_rrdDao;
    }

    public void setRrdDao(RrdDao rrdDao) {
        this.m_rrdDao = rrdDao;
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.m_transactionTemplate;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.m_transactionTemplate = transactionTemplate;
    }

    public ReportPersister getReportPersister() {
        return this.m_reportPersister;
    }

    public void setReportPersister(ReportPersister reportPersister) {
        this.m_reportPersister = reportPersister;
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    public ReportDefinitionBuilder getReportDefinitionBuilder() {
        return this.m_reportDefinitionBuilder;
    }

    public void setReportDefinitionBuilder(ReportDefinitionBuilder reportDefinitionBuilder) {
        this.m_reportDefinitionBuilder = reportDefinitionBuilder;
    }

    public FilterDao getFilterDao() {
        return this.m_filterDao;
    }

    public void setFilterDao(FilterDao filterDao) {
        this.m_filterDao = filterDao;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.m_eventForwarder = eventForwarder;
    }

    public EventForwarder getEventForwarder() {
        return this.m_eventForwarder;
    }
}

