/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.net.InetAddress;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.linkd.snmp.Dot1dBaseGroup;
import org.opennms.netmgt.linkd.snmp.Dot1dBasePortTable;
import org.opennms.netmgt.linkd.snmp.Dot1dStpGroup;
import org.opennms.netmgt.linkd.snmp.Dot1dStpPortTable;
import org.opennms.netmgt.linkd.snmp.Dot1dTpFdbTable;
import org.opennms.netmgt.linkd.snmp.QBridgeDot1dTpFdbTable;
import org.opennms.netmgt.scheduler.ReadyRunnable;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpWalker;

final class SnmpVlanCollection
implements ReadyRunnable {
    private final SnmpAgentConfig m_agentConfig;
    private final InetAddress m_address;
    private Dot1dBaseGroup m_dot1dBase;
    private Dot1dBasePortTable m_dot1dBaseTable;
    private Dot1dStpGroup m_dot1dStp;
    private Dot1dStpPortTable m_dot1dStpTable;
    private Dot1dTpFdbTable m_dot1dTpFdbTable;
    private QBridgeDot1dTpFdbTable m_dot1qTpFdbTable;
    private boolean m_collectStp = true;
    private boolean m_collectBridge = true;

    SnmpVlanCollection(SnmpAgentConfig agentConfig) {
        this.m_agentConfig = agentConfig;
        this.m_address = this.m_agentConfig.getEffectiveAddress();
        this.m_dot1dBase = null;
        this.m_dot1dBaseTable = null;
        this.m_dot1dStp = null;
        this.m_dot1dStpTable = null;
        this.m_dot1dTpFdbTable = null;
    }

    SnmpVlanCollection(SnmpAgentConfig agentConfig, boolean collectStp, boolean collectBridge) {
        this.m_agentConfig = agentConfig;
        this.m_address = this.m_agentConfig.getEffectiveAddress();
        this.m_dot1dBase = null;
        this.m_dot1dBaseTable = null;
        this.m_dot1dStp = null;
        this.m_dot1dStpTable = null;
        this.m_dot1dTpFdbTable = null;
        this.m_collectStp = collectStp;
        this.m_collectBridge = collectBridge;
    }

    boolean failed() {
        return !this.hasDot1dBase() && !this.hasDot1dBasePortTable() && !this.hasDot1dStp() && !this.hasDot1dStpPortTable() && !this.hasDot1dTpFdbTable();
    }

    boolean someCollectionFailed() {
        return !this.hasDot1dBase() || !this.hasDot1dBasePortTable() || !this.hasDot1dStp() || !this.hasDot1dStpPortTable() || !this.hasDot1dTpFdbTable();
    }

    boolean hasDot1dBase() {
        return this.m_dot1dBase != null && !this.m_dot1dBase.failed();
    }

    Dot1dBaseGroup getDot1dBase() {
        return this.m_dot1dBase;
    }

    boolean hasDot1dBasePortTable() {
        return this.m_dot1dBaseTable != null && !this.m_dot1dBaseTable.failed();
    }

    Dot1dBasePortTable getDot1dBasePortTable() {
        return this.m_dot1dBaseTable;
    }

    boolean hasDot1dStp() {
        return this.m_dot1dStp != null && !this.m_dot1dStp.failed();
    }

    Dot1dStpGroup getDot1dStp() {
        return this.m_dot1dStp;
    }

    boolean hasDot1dStpPortTable() {
        return this.m_dot1dStpTable != null && !this.m_dot1dStpTable.failed();
    }

    Dot1dStpPortTable getDot1dStpPortTable() {
        return this.m_dot1dStpTable;
    }

    boolean hasDot1dTpFdbTable() {
        return this.m_dot1dTpFdbTable != null && !this.m_dot1dTpFdbTable.failed();
    }

    Dot1dTpFdbTable getDot1dFdbTable() {
        return this.m_dot1dTpFdbTable;
    }

    boolean hasQBridgeDot1dTpFdbTable() {
        return this.m_dot1qTpFdbTable != null && !this.m_dot1qTpFdbTable.failed();
    }

    QBridgeDot1dTpFdbTable getQBridgeDot1dFdbTable() {
        return this.m_dot1qTpFdbTable;
    }

    InetAddress getTarget() {
        return this.m_address;
    }

    @Override
    public void run() {
        this.m_dot1dBase = new Dot1dBaseGroup(this.m_address);
        this.m_dot1dBaseTable = new Dot1dBasePortTable(this.m_address);
        this.m_dot1dStp = new Dot1dStpGroup(this.m_address);
        this.m_dot1dStpTable = new Dot1dStpPortTable(this.m_address);
        this.m_dot1dTpFdbTable = new Dot1dTpFdbTable(this.m_address);
        SnmpWalker walker = null;
        if (this.m_collectBridge && this.m_collectStp) {
            walker = SnmpUtils.createWalker((SnmpAgentConfig)this.m_agentConfig, (String)"dot1dBase/dot1dBaseTable/dot1dStp/dot1dStpTable/dot1dTpFdbTable ", (CollectionTracker[])new CollectionTracker[]{this.m_dot1dBase, this.m_dot1dBaseTable, this.m_dot1dStp, this.m_dot1dStpTable, this.m_dot1dTpFdbTable});
        } else if (this.m_collectBridge) {
            walker = SnmpUtils.createWalker((SnmpAgentConfig)this.m_agentConfig, (String)"dot1dTpFdbTable ", (CollectionTracker[])new CollectionTracker[]{this.m_dot1dTpFdbTable});
        } else if (this.m_collectStp) {
            walker = SnmpUtils.createWalker((SnmpAgentConfig)this.m_agentConfig, (String)"dot1dBase/dot1dStp/dot1dBaseTable/dot1dStpTable ", (CollectionTracker[])new CollectionTracker[]{this.m_dot1dBase, this.m_dot1dStp, this.m_dot1dBaseTable, this.m_dot1dStpTable});
        } else {
            LogUtils.infof((Object)this, (String)"run: no info to collect return", (Object[])new Object[0]);
            return;
        }
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            this.m_dot1dBase = null;
            this.m_dot1dBaseTable = null;
            this.m_dot1dStp = null;
            this.m_dot1dStpTable = null;
            this.m_dot1dTpFdbTable = null;
            LogUtils.warnf((Object)this, (Throwable)e, (String)"SnmpVlanCollection.run: collection interrupted, exiting", (Object[])new Object[0]);
            return;
        }
        String hostAddress = InetAddressUtils.str((InetAddress)this.m_address);
        if (!this.hasDot1dBase()) {
            LogUtils.infof((Object)this, (String)"run: failed to collect Dot1dBase for %s Community: %s", (Object[])new Object[]{hostAddress, this.m_agentConfig.getReadCommunity()});
        }
        if (!this.hasDot1dBasePortTable()) {
            LogUtils.infof((Object)this, (String)"run: failed to collect Dot1dBasePortTable for %s Community: %s", (Object[])new Object[]{hostAddress, this.m_agentConfig.getReadCommunity()});
        }
        if (!this.hasDot1dStp()) {
            LogUtils.infof((Object)this, (String)"run: failed to collect Dot1dStp for %s Community: %s", (Object[])new Object[]{hostAddress, this.m_agentConfig.getReadCommunity()});
        }
        if (!this.hasDot1dStpPortTable()) {
            LogUtils.infof((Object)this, (String)"run: failed to collect Dot1dStpPortTable for %s Community: %s", (Object[])new Object[]{hostAddress, this.m_agentConfig.getReadCommunity()});
        }
        if (!this.hasDot1dTpFdbTable()) {
            LogUtils.infof((Object)this, (String)"run: failed to collect Dot1dTpFdbTable for %s Community: %s", (Object[])new Object[]{hostAddress, this.m_agentConfig.getReadCommunity()});
        }
        if (this.m_dot1dTpFdbTable.isEmpty() && this.m_collectBridge) {
            LogUtils.infof((Object)this, (String)"run: Trying to collect QbridgeDot1dTpFdbTable for %s Community: %s", (Object[])new Object[]{hostAddress, this.m_agentConfig.getReadCommunity()});
            this.m_dot1qTpFdbTable = new QBridgeDot1dTpFdbTable(this.m_address);
            walker = SnmpUtils.createWalker((SnmpAgentConfig)this.m_agentConfig, (String)"qBridgedot1dTpFdbTable ", (CollectionTracker[])new CollectionTracker[]{this.m_dot1qTpFdbTable});
            walker.start();
            try {
                walker.waitFor();
            }
            catch (InterruptedException e) {
                this.m_dot1qTpFdbTable = null;
                LogUtils.warnf((Object)this, (Throwable)e, (String)"SnmpVlanCollection.run: collection interrupted", (Object[])new Object[0]);
            }
            if (!this.hasQBridgeDot1dTpFdbTable()) {
                LogUtils.infof((Object)this, (String)"run: failed to collect QBridgeDot1dTpFdbTable for %s Community: %s", (Object[])new Object[]{hostAddress, this.m_agentConfig.getReadCommunity()});
            }
        }
    }

    @Override
    public boolean isReady() {
        return true;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("agentConfig", (Object)this.m_agentConfig).append("address", (Object)this.m_address).append("dot1dBase", (Object)this.m_dot1dBase).append("dot1dBaseTable", (Object)this.m_dot1dBaseTable).append("dot1dStp", (Object)this.m_dot1dStp).append("dot1dStpTable", (Object)this.m_dot1dStpTable).append("dot1dTpFdbTable", (Object)this.m_dot1dTpFdbTable).append("dot1qTpFdbTable", (Object)this.m_dot1qTpFdbTable).toString();
    }
}

