/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.linkd.CdpInterface;
import org.opennms.netmgt.linkd.LldpRemInterface;
import org.opennms.netmgt.linkd.OspfNbrInterface;
import org.opennms.netmgt.linkd.RouterInterface;
import org.opennms.netmgt.model.OnmsStpInterface;
import org.opennms.netmgt.model.OnmsVlan;
import org.springframework.util.Assert;

public class LinkableNode {
    private final int m_nodeId;
    private final InetAddress m_snmpprimaryaddr;
    private final String m_sysoid;
    private String m_lldpSysname;
    private String m_lldpChassisId;
    private Integer m_lldpChassisIdSubtype;
    private InetAddress m_ospfRouterId;
    private List<CdpInterface> m_cdpinterfaces = new ArrayList<CdpInterface>();
    private List<LldpRemInterface> m_lldpreminterfaces = new ArrayList<LldpRemInterface>();
    private boolean m_hascdpinterfaces = false;
    private List<RouterInterface> m_routeinterfaces = new ArrayList<RouterInterface>();
    private List<OspfNbrInterface> m_ospfinterfaces = new ArrayList<OspfNbrInterface>();
    private boolean m_hasrouteinterfaces = false;
    private boolean m_isBridgeNode = false;
    private List<Integer> m_backBoneBridgePorts = new ArrayList<Integer>();
    private List<OnmsVlan> m_vlans = new ArrayList<OnmsVlan>();
    private List<String> m_bridgeIdentifiers = new ArrayList<String>();
    private Map<String, List<OnmsStpInterface>> m_bridgeStpInterfaces = new HashMap<String, List<OnmsStpInterface>>();
    private Map<String, String> m_vlanBridgeIdentifiers = new HashMap<String, String>();
    private Map<Integer, Set<String>> m_portMacs = new HashMap<Integer, Set<String>>();
    private Map<String, String> m_macsVlan = new HashMap<String, String>();
    private Map<String, String> m_vlanStpRoot = new HashMap<String, String>();
    private Map<Integer, Integer> m_bridgePortIfindex = new HashMap<Integer, Integer>();

    public InetAddress getOspfRouterId() {
        return this.m_ospfRouterId;
    }

    public void setOspfRouterId(InetAddress ospfRouterId) {
        this.m_ospfRouterId = ospfRouterId;
    }

    public void setLldpSysname(String lldpSysname) {
        this.m_lldpSysname = lldpSysname;
    }

    public void setLldpChassisId(String lldpChassisId) {
        this.m_lldpChassisId = lldpChassisId;
    }

    public void setLldpChassisIdSubtype(Integer lldpChassisIdSubtype) {
        this.m_lldpChassisIdSubtype = lldpChassisIdSubtype;
    }

    public String getLldpSysname() {
        return this.m_lldpSysname;
    }

    public String getLldpChassisId() {
        return this.m_lldpChassisId;
    }

    public Integer getLldpChassisIdSubtype() {
        return this.m_lldpChassisIdSubtype;
    }

    public LinkableNode(int nodeId, InetAddress snmpPrimaryAddr, String sysoid) {
        this.m_nodeId = nodeId;
        this.m_snmpprimaryaddr = snmpPrimaryAddr;
        this.m_sysoid = sysoid;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("nodeId", this.m_nodeId).append("snmpPrimaryAddr", (Object)InetAddressUtils.str((InetAddress)this.m_snmpprimaryaddr)).append("sysOid", (Object)this.m_sysoid).toString();
    }

    public int getNodeId() {
        return this.m_nodeId;
    }

    public InetAddress getSnmpPrimaryIpAddr() {
        return this.m_snmpprimaryaddr;
    }

    public List<LldpRemInterface> getLldpRemInterfaces() {
        return this.m_lldpreminterfaces;
    }

    public void setLldpRemInterfaces(List<LldpRemInterface> lldpreminterfaces) {
        this.m_lldpreminterfaces = lldpreminterfaces;
    }

    public List<OspfNbrInterface> getOspfinterfaces() {
        return this.m_ospfinterfaces;
    }

    public void setOspfinterfaces(List<OspfNbrInterface> ospfinterfaces) {
        this.m_ospfinterfaces = ospfinterfaces;
    }

    public List<CdpInterface> getCdpInterfaces() {
        return this.m_cdpinterfaces;
    }

    public void setCdpInterfaces(List<CdpInterface> cdpinterfaces) {
        if (cdpinterfaces == null || cdpinterfaces.isEmpty()) {
            return;
        }
        this.m_hascdpinterfaces = true;
        this.m_cdpinterfaces = cdpinterfaces;
    }

    public boolean hasCdpInterfaces() {
        return this.m_hascdpinterfaces;
    }

    public List<RouterInterface> getRouteInterfaces() {
        return this.m_routeinterfaces;
    }

    public void setRouteInterfaces(List<RouterInterface> routeinterfaces) {
        if (routeinterfaces == null || routeinterfaces.isEmpty()) {
            return;
        }
        this.m_hasrouteinterfaces = true;
        this.m_routeinterfaces = routeinterfaces;
    }

    public boolean hasRouteInterfaces() {
        return this.m_hasrouteinterfaces;
    }

    public boolean isBridgeNode() {
        return this.m_isBridgeNode;
    }

    public List<Integer> getBackBoneBridgePorts() {
        return this.m_backBoneBridgePorts;
    }

    public void setBackBoneBridgePorts(List<Integer> backBoneBridgePorts) {
        this.m_backBoneBridgePorts = backBoneBridgePorts;
    }

    public boolean isBackBoneBridgePort(int bridgeport) {
        return this.m_backBoneBridgePorts.contains(bridgeport);
    }

    public void addBackBoneBridgePorts(int bridgeport) {
        if (this.m_backBoneBridgePorts.contains(bridgeport)) {
            return;
        }
        this.m_backBoneBridgePorts.add(bridgeport);
    }

    public List<String> getBridgeIdentifiers() {
        return this.m_bridgeIdentifiers;
    }

    public void setBridgeIdentifiers(List<String> bridgeIdentifiers) {
        if (bridgeIdentifiers == null || bridgeIdentifiers.isEmpty()) {
            return;
        }
        this.m_bridgeIdentifiers = bridgeIdentifiers;
        this.m_isBridgeNode = true;
    }

    public void addBridgeIdentifier(String bridge, String vlan) {
        this.m_vlanBridgeIdentifiers.put(vlan, bridge);
        this.addBridgeIdentifier(bridge);
    }

    public boolean isBridgeIdentifier(String bridge) {
        return this.m_bridgeIdentifiers.contains(bridge);
    }

    public void addBridgeIdentifier(String bridge) {
        if (this.m_bridgeIdentifiers.contains(bridge)) {
            return;
        }
        this.m_bridgeIdentifiers.add(bridge);
        this.m_isBridgeNode = true;
    }

    public String getBridgeIdentifier(String vlan) {
        return this.m_vlanBridgeIdentifiers.get(vlan);
    }

    public void addMacAddress(int bridgeport, String macAddress, String vlan) {
        Set<String> macs = new HashSet<String>();
        if (this.m_portMacs.containsKey(bridgeport)) {
            macs = this.m_portMacs.get(bridgeport);
        }
        macs.add(macAddress);
        this.m_portMacs.put(bridgeport, macs);
        this.m_macsVlan.put(macAddress, vlan);
    }

    public boolean hasMacAddress(String macAddress) {
        for (Set<String> macs : this.m_portMacs.values()) {
            if (!macs.contains(macAddress)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMacAddresses() {
        return !this.m_portMacs.isEmpty();
    }

    public String getVlan(String macAddress) {
        return this.m_macsVlan.get(macAddress);
    }

    public Set<String> getMacAddressesOnBridgePort(int bridgeport) {
        return this.m_portMacs.get(bridgeport);
    }

    public boolean hasMacAddressesOnBridgePort(int bridgeport) {
        return this.m_portMacs.containsKey(bridgeport) && this.m_portMacs.get(bridgeport) != null;
    }

    public List<Integer> getBridgePortsFromMac(String macAddress) {
        ArrayList<Integer> ports = new ArrayList<Integer>();
        for (Integer intePort : this.m_portMacs.keySet()) {
            if (!this.m_portMacs.get(intePort).contains(macAddress)) continue;
            ports.add(intePort);
        }
        return ports;
    }

    public int getIfindex(int bridgeport) {
        if (this.m_bridgePortIfindex.containsKey(bridgeport)) {
            return this.m_bridgePortIfindex.get(bridgeport);
        }
        return -1;
    }

    public int getBridgePort(int ifindex) {
        for (Integer curBridgePort : this.m_bridgePortIfindex.keySet()) {
            Integer curIfIndex = this.m_bridgePortIfindex.get(curBridgePort);
            if (curIfIndex != ifindex) continue;
            return curBridgePort;
        }
        return -1;
    }

    void setIfIndexBridgePort(Integer ifindex, Integer bridgeport) {
        Assert.notNull((Object)ifindex);
        Assert.notNull((Object)bridgeport);
        this.m_bridgePortIfindex.put(bridgeport, ifindex);
    }

    public Map<Integer, Set<String>> getPortMacs() {
        return this.m_portMacs;
    }

    public void setPortMacs(Map<Integer, Set<String>> portMacs) {
        this.m_portMacs = portMacs;
    }

    public void setVlanStpRoot(String vlan, String stproot) {
        if (stproot != null) {
            this.m_vlanStpRoot.put(vlan, stproot);
        }
    }

    public boolean hasStpRoot(String vlan) {
        return this.m_vlanStpRoot.containsKey(vlan);
    }

    public String getStpRoot(String vlan) {
        if (this.m_vlanStpRoot.containsKey(vlan)) {
            return this.m_vlanStpRoot.get(vlan);
        }
        return null;
    }

    public Map<String, List<OnmsStpInterface>> getStpInterfaces() {
        return this.m_bridgeStpInterfaces;
    }

    public void setStpInterfaces(Map<String, List<OnmsStpInterface>> stpInterfaces) {
        this.m_bridgeStpInterfaces = stpInterfaces;
    }

    public void addStpInterface(OnmsStpInterface stpIface) {
        String vlanindex = stpIface.getVlan() == null ? "0" : stpIface.getVlan().toString();
        List<OnmsStpInterface> stpifs = new ArrayList<OnmsStpInterface>();
        if (this.m_bridgeStpInterfaces.containsKey(vlanindex)) {
            stpifs = this.m_bridgeStpInterfaces.get(vlanindex);
        }
        stpifs.add(stpIface);
        this.m_bridgeStpInterfaces.put(vlanindex, stpifs);
    }

    public String getSysoid() {
        return this.m_sysoid;
    }

    public List<OnmsVlan> getVlans() {
        return this.m_vlans;
    }

    public void setVlans(List<OnmsVlan> vlans) {
        this.m_vlans = vlans;
    }
}

