/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.net.InetAddress;
import java.util.LinkedHashSet;
import java.util.Set;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionAgentService;
import org.opennms.netmgt.collectd.CollectionInitializationException;
import org.opennms.netmgt.collectd.DefaultCollectionAgentService;
import org.opennms.netmgt.collectd.IfInfo;
import org.opennms.netmgt.collectd.IfResourceType;
import org.opennms.netmgt.collectd.SnmpIfData;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.poller.InetNetworkInterface;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.springframework.transaction.PlatformTransactionManager;

public class DefaultCollectionAgent
extends InetNetworkInterface
implements CollectionAgent {
    private static final long serialVersionUID = 6694654071513990997L;
    private int m_ifCount = -1;
    private long m_sysUpTime = -1L;
    private int m_nodeId = -1;
    private InetAddress m_inetAddress = null;
    private int m_ifIndex = -1;
    private PrimaryType m_isSnmpPrimary = null;
    private String m_sysObjId = null;
    private String m_foreignSource = null;
    private String m_foreignId = null;
    private CollectionAgentService m_agentService;
    private Set<SnmpIfData> m_snmpIfData;

    public static CollectionAgent create(Integer ifaceId, IpInterfaceDao ifaceDao, PlatformTransactionManager transMgr) {
        return new DefaultCollectionAgent(DefaultCollectionAgentService.create(ifaceId, ifaceDao, transMgr));
    }

    private DefaultCollectionAgent(CollectionAgentService agentService) {
        super(null);
        this.m_agentService = agentService;
        if (Boolean.getBoolean("org.opennms.netmgt.collectd.DefaultCollectionAgent.loadSnmpDataOnInit")) {
            this.getSnmpInterfaceData();
        }
    }

    public InetAddress getAddress() {
        return this.getInetAddress();
    }

    @Override
    public InetAddress getInetAddress() {
        if (this.m_inetAddress == null) {
            this.m_inetAddress = this.m_agentService.getInetAddress();
        }
        return this.m_inetAddress;
    }

    @Override
    public Boolean isStoreByForeignSource() {
        return Boolean.getBoolean("org.opennms.rrd.storeByForeignSource");
    }

    @Override
    public String getHostAddress() {
        return InetAddressUtils.str((InetAddress)this.getInetAddress());
    }

    @Override
    public void setSavedIfCount(int ifCount) {
        this.m_ifCount = ifCount;
    }

    @Override
    public int getSavedIfCount() {
        return this.m_ifCount;
    }

    @Override
    public int getNodeId() {
        if (this.m_nodeId == -1) {
            this.m_nodeId = this.m_agentService.getNodeId();
        }
        return this.m_nodeId;
    }

    @Override
    public String getForeignSource() {
        if (this.m_foreignSource == null) {
            this.m_foreignSource = this.m_agentService.getForeignSource();
        }
        return this.m_foreignSource;
    }

    @Override
    public String getForeignId() {
        if (this.m_foreignId == null) {
            this.m_foreignId = this.m_agentService.getForeignId();
        }
        return this.m_foreignId;
    }

    @Override
    public File getStorageDir() {
        File dir = new File(String.valueOf(this.getNodeId()));
        if (this.isStoreByForeignSource().booleanValue() && this.getForeignSource() != null && this.getForeignId() != null) {
            File fsDir = new File("fs", this.m_foreignSource);
            dir = new File(fsDir, this.m_foreignId);
        }
        LogUtils.debugf((Object)this, (String)" getStorageDir: isStoreByForeignSource = %s, foreignSource = %s, foreignId = %s, dir = %s", (Object[])new Object[]{this.isStoreByForeignSource(), this.m_foreignSource, this.m_foreignId, dir});
        return dir;
    }

    private int getIfIndex() {
        if (this.m_ifIndex == -1) {
            this.m_ifIndex = this.m_agentService.getIfIndex();
        }
        return this.m_ifIndex;
    }

    @Override
    public String getSysObjectId() {
        if (this.m_sysObjId == null) {
            this.m_sysObjId = this.m_agentService.getSysObjectId();
            this.m_sysObjId = this.m_sysObjId == null ? null : this.m_sysObjId.intern();
        }
        return this.m_sysObjId;
    }

    private PrimaryType getIsSnmpPrimary() {
        if (this.m_isSnmpPrimary == null) {
            this.m_isSnmpPrimary = this.m_agentService.getIsSnmpPrimary();
        }
        return this.m_isSnmpPrimary;
    }

    private void logCompletion() {
        LogUtils.debugf((Object)this, (String)"initialize: initialization completed: nodeid = %s, address = %s, primaryIfIndex = %s, isSnmpPrimary = %s, sysoid = %s", (Object[])new Object[]{this.getNodeId(), this.getHostAddress(), this.getIfIndex(), this.getIsSnmpPrimary(), this.getSysObjectId()});
    }

    private void validateSysObjId() throws CollectionInitializationException {
        if (this.getSysObjectId() == null) {
            throw new CollectionInitializationException("System Object ID for interface " + this.getHostAddress() + " does not exist in the database.");
        }
    }

    private void logCollectionParms() {
        LogUtils.debugf((Object)this, (String)"initialize: db retrieval info: nodeid = %s, address = %s, primaryIfIndex = %s, isSnmpPrimary = %s, sysoid = %s", (Object[])new Object[]{this.getNodeId(), this.getHostAddress(), this.getIfIndex(), this.getIsSnmpPrimary(), this.getSysObjectId()});
    }

    private void validateIsSnmpPrimary() throws CollectionInitializationException {
        if (!PrimaryType.PRIMARY.equals((Object)this.getIsSnmpPrimary())) {
            throw new CollectionInitializationException("Interface " + this.getHostAddress() + " is not the primary SNMP interface for nodeid " + this.getNodeId());
        }
    }

    private void validatePrimaryIfIndex() {
        if (this.getIfIndex() < 0) {
            LogUtils.debugf((Object)this, (String)"initialize: db retrieval info: node %s does not have a legitimate primaryIfIndex.  Assume node does not supply ipAddrTable and continue...", (Object[])new Object[]{this.getNodeId()});
        }
    }

    @Override
    public void validateAgent() throws CollectionInitializationException {
        this.logCollectionParms();
        this.validateIsSnmpPrimary();
        this.validatePrimaryIfIndex();
        this.validateSysObjId();
        this.logCompletion();
    }

    @Override
    public String toString() {
        return "Agent[nodeid = " + this.getNodeId() + " ipaddr= " + this.getHostAddress() + ']';
    }

    @Override
    public SnmpAgentConfig getAgentConfig() {
        return SnmpPeerFactory.getInstance().getAgentConfig(this.getInetAddress());
    }

    private Set<SnmpIfData> getSnmpInterfaceData() {
        if (this.m_snmpIfData == null) {
            this.m_snmpIfData = this.m_agentService.getSnmpInterfaceData();
        }
        return this.m_snmpIfData;
    }

    @Override
    public Set<IfInfo> getSnmpInterfaceInfo(IfResourceType type) {
        Set<SnmpIfData> snmpIfData = this.getSnmpInterfaceData();
        LinkedHashSet<IfInfo> ifInfos = new LinkedHashSet<IfInfo>(snmpIfData.size());
        for (SnmpIfData ifData : snmpIfData) {
            ifInfos.add(new IfInfo(type, this, ifData));
        }
        return ifInfos;
    }

    public String getSnmpInterfaceLabel(int ifIndex) {
        for (SnmpIfData ifData : this.getSnmpInterfaceData()) {
            if (ifData.getIfIndex() != ifIndex) continue;
            return ifData.getLabelForRRD();
        }
        return null;
    }

    @Override
    public long getSavedSysUpTime() {
        return this.m_sysUpTime;
    }

    @Override
    public void setSavedSysUpTime(long sysUpTime) {
        this.m_sysUpTime = sysUpTime;
    }
}

