/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.opennms.core.utils.InetAddressComparator;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.CapsdProtocolInfo;
import org.opennms.netmgt.capsd.IfSmbCollector;
import org.opennms.netmgt.capsd.IfSnmpCollector;
import org.opennms.netmgt.capsd.Plugin;
import org.opennms.netmgt.capsd.PluginManager;
import org.opennms.netmgt.capsd.snmp.IfTableEntry;
import org.opennms.netmgt.config.CapsdConfigFactory;

public final class IfCollector
implements Runnable {
    private PluginManager m_pluginManager;
    private final InetAddress m_target;
    private IfSmbCollector m_smbCollector;
    private IfSnmpCollector m_snmpCollector;
    private List<SupportedProtocol> m_protocols;
    private Map<InetAddress, List<SupportedProtocol>> m_subTargets;
    private List<Integer> m_nonIpInterfaces;
    private boolean m_doSnmpCollection;
    private Set<InetAddress> m_previouslyProbed;

    private void probe(InetAddress target, List<SupportedProtocol> supports) {
        String logAddr = InetAddressUtils.str((InetAddress)target);
        CapsdProtocolInfo[] plugins = this.m_pluginManager.getProtocolSpecification(target);
        for (int i = 0; i < plugins.length; ++i) {
            if (this.log().isDebugEnabled()) {
                this.log().debug(logAddr + " testing plugin " + plugins[i].getProtocol());
            }
            if (plugins[i].isAutoEnabled()) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug(logAddr + " protocol " + plugins[i].getProtocol() + " is auto enabled");
                }
                supports.add(new SupportedProtocol(plugins[i].getProtocol(), null));
                continue;
            }
            try {
                Plugin p = plugins[i].getPlugin();
                Map<String, Object> q = plugins[i].getParameters();
                boolean r = p.isProtocolSupported(target, q);
                if (this.log().isDebugEnabled()) {
                    this.log().debug(logAddr + " protocol " + plugins[i].getProtocol() + " supported? " + (r ? "true" : "false"));
                }
                if (r) {
                    supports.add(new SupportedProtocol(plugins[i].getProtocol(), q));
                }
            }
            catch (UndeclaredThrowableException utE) {
                Throwable t = utE.getUndeclaredThrowable();
                if (t instanceof NoRouteToHostException) {
                    if (CapsdConfigFactory.getInstance().getAbortProtocolScansFlag()) {
                        this.log().info("IfCollector: No route to host " + logAddr + ", aborting protocol scans.");
                        break;
                    }
                    this.log().info("IfCollector: No route to host " + logAddr + ", continuing protocol scans.");
                } else {
                    this.log().warn("IfCollector: Caught undeclared throwable exception when testing for protocol " + plugins[i].getProtocol() + " on host " + logAddr, (Throwable)utE);
                }
            }
            catch (Throwable t) {
                this.log().warn("IfCollector: Caught an exception when testing for protocol " + plugins[i].getProtocol() + " on host " + logAddr, t);
            }
            if (!this.log().isDebugEnabled()) continue;
            this.log().debug(logAddr + " plugin " + plugins[i].getProtocol() + " completed!");
        }
    }

    IfCollector(PluginManager pluginManager, InetAddress addr, boolean doSnmpCollection) {
        this(pluginManager, addr, doSnmpCollection, new HashSet<InetAddress>());
    }

    IfCollector(PluginManager pluginManager, InetAddress addr, boolean doSnmpCollection, Set<InetAddress> previouslyProbed) {
        this.m_pluginManager = pluginManager;
        this.m_target = addr;
        this.m_doSnmpCollection = doSnmpCollection;
        this.m_smbCollector = null;
        this.m_snmpCollector = null;
        this.m_protocols = new ArrayList<SupportedProtocol>(8);
        this.m_subTargets = null;
        this.m_nonIpInterfaces = null;
        this.m_previouslyProbed = previouslyProbed;
    }

    InetAddress getTarget() {
        return this.m_target;
    }

    List<SupportedProtocol> getSupportedProtocols() {
        return this.m_protocols;
    }

    boolean hasAdditionalTargets() {
        return this.m_subTargets != null && !this.m_subTargets.isEmpty();
    }

    Map<InetAddress, List<SupportedProtocol>> getAdditionalTargets() {
        return this.m_subTargets;
    }

    boolean hasNonIpInterfaces() {
        return this.m_nonIpInterfaces != null && !this.m_nonIpInterfaces.isEmpty();
    }

    List<Integer> getNonIpInterfaces() {
        return this.m_nonIpInterfaces;
    }

    boolean hasSmbCollection() {
        return this.m_smbCollector != null;
    }

    IfSmbCollector getSmbCollector() {
        return this.m_smbCollector;
    }

    boolean hasSnmpCollection() {
        return this.m_snmpCollector != null;
    }

    IfSnmpCollector getSnmpCollector() {
        return this.m_snmpCollector;
    }

    void deleteSnmpCollector() {
        this.m_snmpCollector = null;
    }

    @Override
    public void run() {
        if (this.log().isDebugEnabled()) {
            this.log().debug("IfCollector.run: run method invoked to collect information for address " + InetAddressUtils.str((InetAddress)this.m_target));
        }
        boolean isSnmp = false;
        boolean isSnmpV2 = false;
        boolean isSmb = false;
        boolean hasExchange = false;
        this.probe(this.m_target, this.m_protocols);
        this.m_previouslyProbed.add(this.m_target);
        for (SupportedProtocol proto : this.m_protocols) {
            if (proto.getProtocolName().equalsIgnoreCase("snmp")) {
                isSnmp = true;
                continue;
            }
            if (proto.getProtocolName().equalsIgnoreCase("smb")) {
                isSmb = true;
                continue;
            }
            if (!proto.getProtocolName().equalsIgnoreCase("msexchange")) continue;
            isSmb = true;
            hasExchange = true;
        }
        if (isSmb) {
            this.log().debug("IfCollector.run: starting SMB collection");
            try {
                this.m_smbCollector = new IfSmbCollector(this.m_target, hasExchange);
                this.m_smbCollector.run();
            }
            catch (Throwable t) {
                this.m_smbCollector = null;
                this.log().warn("IfCollector.run: Caught an exception when collecting SMB information from target " + InetAddressUtils.str((InetAddress)this.m_target), t);
            }
            this.log().debug("IfCollector.run: SMB collection completed");
        }
        if ((isSnmp || isSnmpV2) && this.m_doSnmpCollection) {
            this.log().debug("IfCollector.run: starting SNMP collection");
            try {
                this.m_snmpCollector = new IfSnmpCollector(this.m_target);
                this.m_snmpCollector.run();
                if (this.m_snmpCollector.hasIpAddrTable() && this.m_snmpCollector.hasIfTable()) {
                    this.m_subTargets = new TreeMap<InetAddress, List<SupportedProtocol>>((Comparator<InetAddress>)new InetAddressComparator());
                    this.m_nonIpInterfaces = new ArrayList<Integer>();
                    for (IfTableEntry ifEntry : this.m_snmpCollector.getIfTable()) {
                        Integer ifIndex = ifEntry.getIfIndex();
                        if (ifIndex == null) continue;
                        int index = ifIndex;
                        List<InetAddress> ipAddrs = this.m_snmpCollector.getIpAddrTable().getIpAddresses(index);
                        if (ipAddrs == null || ipAddrs.size() == 0) {
                            InetAddress nonIpAddr = null;
                            nonIpAddr = InetAddressUtils.addr((String)"0.0.0.0");
                            if (ipAddrs == null) {
                                ipAddrs = new ArrayList<InetAddress>();
                            }
                            ipAddrs.add(nonIpAddr);
                        }
                        for (InetAddress subtarget : ipAddrs) {
                            Integer ifType;
                            if (subtarget == null || subtarget.equals(this.m_target) || this.m_previouslyProbed.contains(subtarget) || (ifType = ifEntry.getIfType()) == null) continue;
                            if (subtarget.isLoopbackAddress()) {
                                if (!this.log().isDebugEnabled()) continue;
                                this.log().debug("ifCollector.run: Loopback interface: " + InetAddressUtils.str((InetAddress)subtarget) + ", skipping...");
                                continue;
                            }
                            if (InetAddressUtils.str((InetAddress)subtarget).equals("0.0.0.0")) {
                                this.m_nonIpInterfaces.add(ifIndex);
                                continue;
                            }
                            ArrayList<SupportedProtocol> probelist = new ArrayList<SupportedProtocol>();
                            if (this.log().isDebugEnabled()) {
                                this.log().debug("----------------------------------------------------------------------------------------");
                                this.log().debug("ifCollector.run: probing subtarget " + InetAddressUtils.str((InetAddress)subtarget));
                            }
                            this.probe(subtarget, probelist);
                            this.m_previouslyProbed.add(subtarget);
                            if (this.log().isDebugEnabled()) {
                                this.log().debug("ifCollector.run: adding subtarget " + InetAddressUtils.str((InetAddress)subtarget) + " # supported protocols: " + probelist.size());
                                this.log().debug("----------------------------------------------------------------------------------------");
                            }
                            this.m_subTargets.put(subtarget, probelist);
                        }
                    }
                } else if (this.m_snmpCollector.hasIpAddrTable()) {
                    this.m_subTargets = new TreeMap<InetAddress, List<SupportedProtocol>>((Comparator<InetAddress>)new InetAddressComparator());
                    List<InetAddress> ipAddrs = this.m_snmpCollector.getIpAddrTable().getIpAddresses();
                    for (InetAddress subtarget : ipAddrs) {
                        if (subtarget == null || subtarget.equals(this.m_target)) continue;
                        if (subtarget.isLoopbackAddress()) {
                            if (!this.log().isDebugEnabled()) continue;
                            this.log().debug("ifCollector.run: Loopback interface: " + InetAddressUtils.str((InetAddress)subtarget) + ", skipping...");
                            continue;
                        }
                        ArrayList<SupportedProtocol> probelist = new ArrayList<SupportedProtocol>();
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("----------------------------------------------------------------------------------------");
                            this.log().debug("ifCollector.run: probing subtarget " + InetAddressUtils.str((InetAddress)subtarget));
                        }
                        this.probe(subtarget, probelist);
                        this.m_previouslyProbed.add(subtarget);
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("ifCollector.run: adding subtarget " + InetAddressUtils.str((InetAddress)subtarget) + " # supported protocols: " + probelist.size());
                            this.log().debug("----------------------------------------------------------------------------------------");
                        }
                        this.m_subTargets.put(subtarget, probelist);
                    }
                }
            }
            catch (Throwable t) {
                this.m_snmpCollector = null;
                this.log().warn("IfCollector.run: Caught an exception when collecting SNMP information from target " + InetAddressUtils.str((InetAddress)this.m_target), t);
            }
            this.log().debug("IfCollector.run: SNMP collection completed");
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug("IfCollector.run: run method exiting after collecting information from address " + InetAddressUtils.str((InetAddress)this.m_target));
        }
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    static final class SupportedProtocol {
        private final String m_name;
        private final Map<String, Object> m_qualifiers;

        SupportedProtocol(String protoName, Map<String, Object> qualifiers) {
            this.m_name = protoName;
            this.m_qualifiers = qualifiers;
        }

        String getProtocolName() {
            return this.m_name;
        }

        Map<String, Object> getQualifiers() {
            return this.m_qualifiers;
        }
    }
}

