/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.net.InetAddress;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.snmp.SyntaxToEvent;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.TrapIdentity;
import org.opennms.netmgt.snmp.TrapProcessor;
import org.opennms.netmgt.trapd.TrapdIpMgr;
import org.opennms.netmgt.xml.event.Event;

public class EventCreator
implements TrapProcessor {
    private EventBuilder m_eventBuilder;
    private TrapdIpMgr m_trapdIpMgr;

    EventCreator(TrapdIpMgr trapdIpMgr) {
        this.m_trapdIpMgr = trapdIpMgr;
        this.m_eventBuilder = new EventBuilder(null, "trapd");
    }

    public void setCommunity(String community) {
        this.m_eventBuilder.setCommunity(community);
    }

    public void setTimeStamp(long timeStamp) {
        this.m_eventBuilder.setSnmpTimeStamp(timeStamp);
    }

    public void setVersion(String version) {
        this.m_eventBuilder.setSnmpVersion(version);
    }

    private void setGeneric(int generic) {
        this.m_eventBuilder.setGeneric(generic);
    }

    private void setSpecific(int specific) {
        this.m_eventBuilder.setSpecific(specific);
    }

    private void setEnterpriseId(String enterpriseId) {
        this.m_eventBuilder.setEnterpriseId(enterpriseId);
    }

    public void setAgentAddress(InetAddress agentAddress) {
        this.m_eventBuilder.setHost(InetAddressUtils.toIpAddrString((InetAddress)agentAddress));
    }

    public void processVarBind(SnmpObjId name, SnmpValue value) {
        this.m_eventBuilder.addParam(SyntaxToEvent.processSyntax((String)name.toString(), (SnmpValue)value));
        if (EventConstants.OID_SNMP_IFINDEX.isPrefixOf(name)) {
            this.m_eventBuilder.setIfIndex(value.toInt());
        }
    }

    public void setTrapAddress(InetAddress trapAddress) {
        this.m_eventBuilder.setSnmpHost(InetAddressUtils.str((InetAddress)trapAddress));
        this.m_eventBuilder.setInterface(trapAddress);
        long nodeId = this.m_trapdIpMgr.getNodeId(InetAddressUtils.str((InetAddress)trapAddress));
        if (nodeId != -1L) {
            this.m_eventBuilder.setNodeid(nodeId);
        }
    }

    public void setTrapIdentity(TrapIdentity trapIdentity) {
        this.setGeneric(trapIdentity.getGeneric());
        this.setSpecific(trapIdentity.getSpecific());
        this.setEnterpriseId(trapIdentity.getEnterpriseId().toString());
        if (this.log().isDebugEnabled()) {
            this.log().debug("setTrapIdentity: SNMP trap " + trapIdentity);
        }
    }

    Event getEvent() {
        return this.m_eventBuilder.getEvent();
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

