/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.syslogd.HideMessage;
import org.opennms.netmgt.config.syslogd.UeiList;
import org.opennms.netmgt.syslogd.SyslogConnection;

class SyslogReceiver
implements Runnable {
    private static final int SOCKET_TIMEOUT = 500;
    private static final String LOG4J_CATEGORY = "OpenNMS.Syslogd";
    private volatile boolean m_stop = false;
    private DatagramSocket m_dgSock;
    private Thread m_context;
    private String m_logPrefix;
    private String m_matchPattern;
    private int m_hostGroup;
    private int m_messageGroup;
    private String m_discardUei;
    private UeiList m_UeiList;
    private HideMessage m_HideMessages;

    SyslogReceiver(DatagramSocket sock, String matchPattern, int hostGroup, int messageGroup, UeiList ueiList, HideMessage hideMessages, String discardUei) {
        this.m_dgSock = sock;
        this.m_matchPattern = matchPattern;
        this.m_hostGroup = hostGroup;
        this.m_messageGroup = messageGroup;
        this.m_discardUei = discardUei;
        this.m_UeiList = ueiList;
        this.m_HideMessages = hideMessages;
        this.m_logPrefix = LOG4J_CATEGORY;
    }

    void stop() throws InterruptedException {
        this.m_stop = true;
        if (this.m_context != null) {
            ThreadCategory log = ThreadCategory.getInstance(this.getClass());
            log.debug("Stopping and joining thread context " + this.m_context.getName());
            this.m_context.interrupt();
            this.m_context.join();
            log.debug("Thread context stopped and joined");
        }
    }

    boolean isAlive() {
        return this.m_context != null && this.m_context.isAlive();
    }

    @Override
    public void run() {
        this.m_context = Thread.currentThread();
        ThreadCategory.setPrefix((String)this.m_logPrefix);
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        if (this.m_stop) {
            log.debug("Stop flag set before thread started, exiting");
            return;
        }
        log.debug("Thread context started");
        int length = 65535;
        byte[] buffer = new byte[65535];
        try {
            log.debug("Setting socket timeout to 500ms");
            this.m_dgSock.setSoTimeout(500);
        }
        catch (SocketException e) {
            log.warn("An I/O error occured while trying to set the socket timeout", (Throwable)e);
        }
        try {
            log.debug("Setting receive buffer size to 65535");
            this.m_dgSock.setReceiveBufferSize(65535);
        }
        catch (SocketException e) {
            log.info("Failed to set the receive buffer to 65535", (Throwable)e);
        }
        boolean ioInterrupted = false;
        while (!this.m_stop) {
            if (this.m_context.isInterrupted()) {
                log.debug("Thread context interrupted");
                break;
            }
            try {
                if (!ioInterrupted) {
                    log.debug("Waiting on a datagram to arrive");
                }
                DatagramPacket pkt = new DatagramPacket(buffer, 65535);
                this.m_dgSock.receive(pkt);
                Thread worker = new Thread((Runnable)new SyslogConnection(pkt, this.m_matchPattern, this.m_hostGroup, this.m_messageGroup, this.m_UeiList, this.m_HideMessages, this.m_discardUei), SyslogConnection.class.getSimpleName());
                worker.start();
                ioInterrupted = false;
            }
            catch (SocketTimeoutException e) {
                ioInterrupted = true;
            }
            catch (InterruptedIOException e) {
                ioInterrupted = true;
            }
            catch (IOException e) {
                log.error("An I/O exception occured on the datagram receipt port, exiting", (Throwable)e);
                break;
            }
        }
        log.debug("Thread context exiting");
    }

    protected void setLogPrefix(String prefix) {
        this.m_logPrefix = prefix;
    }
}

