/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.syslogd.SyslogFacility;
import org.opennms.netmgt.syslogd.SyslogMessage;
import org.opennms.netmgt.syslogd.SyslogParser;
import org.opennms.netmgt.syslogd.SyslogParserException;
import org.opennms.netmgt.syslogd.SyslogSeverity;

public class SyslogNGParser
extends SyslogParser {
    private static final Pattern m_syslogNGPattern = Pattern.compile("^<(\\d{1,3})>(?:(\\S*?)(?::? )?)((?:\\d\\d\\d\\d-\\d\\d-\\d\\d)|(?:\\S\\S\\S\\s+\\d{1,2}\\s+\\d\\d:\\d\\d:\\d\\d)) (\\S+) (?:(\\S+?)(?:\\[(\\d+)\\])?:\\s+){0,1}(\\S.*?)$", 8);

    protected SyslogNGParser(String text) {
        super(text);
    }

    public static SyslogParser getParser(String text) {
        return new SyslogNGParser(text);
    }

    @Override
    protected Pattern getPattern() {
        return m_syslogNGPattern;
    }

    @Override
    public SyslogMessage parse() throws SyslogParserException {
        Date date;
        if (!this.find()) {
            if (this.traceEnabled()) {
                LogUtils.tracef((Object)this, (String)"'%s' did not match '%s'", (Object[])new Object[]{m_syslogNGPattern, this.getText()});
            }
            return null;
        }
        Matcher matcher = this.getMatcher();
        SyslogMessage message = new SyslogMessage();
        try {
            int priorityField = Integer.parseInt(matcher.group(1));
            message.setFacility(SyslogFacility.getFacilityForCode(priorityField));
            message.setSeverity(SyslogSeverity.getSeverityForCode(priorityField));
        }
        catch (NumberFormatException e) {
            LogUtils.debugf((Object)this, (Throwable)e, (String)"Unable to parse priority field '%s'", (Object[])new Object[]{matcher.group(1)});
        }
        if (matcher.group(2) != null && !matcher.group(2).isEmpty()) {
            message.setMessageID(matcher.group(2));
        }
        if ((date = this.parseDate(matcher.group(3))) == null) {
            date = new Date();
        }
        message.setDate(date);
        message.setHostName(matcher.group(4));
        message.setProcessName(matcher.group(5));
        if (matcher.group(6) != null) {
            try {
                Integer pid = Integer.parseInt(matcher.group(6));
                message.setProcessId(pid);
            }
            catch (NumberFormatException nfe) {
                LogUtils.debugf((Object)this, (Throwable)nfe, (String)"Unable to parse '%s' as a process ID.", (Object[])new Object[]{matcher.group(6)});
            }
        }
        message.setMessage(matcher.group(7).trim());
        return message;
    }
}

